/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.biopax.paxtools.impl.ModelImpl;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXFactory;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.util.IllegalBioPAXArgumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BioPAXFactoryImpl
implements BioPAXFactory {
    private MethodMapHelper helper = new MethodMapHelper(this.getClass().getMethods());

    @Override
    public <T extends BioPAXElement> T reflectivelyCreate(Class<T> c) {
        Method method = (Method)this.helper.methodsByClass.get(c);
        if (method == null) {
            throw new IllegalBioPAXArgumentException("No creation methods for class" + c);
        }
        return (T)this.invokeCreation(method);
    }

    @Override
    public boolean canInstantiate(String name) {
        return this.helper.methodsByName.get(name) != null;
    }

    @Override
    public BioPAXElement reflectivelyCreate(String name) {
        Method method = (Method)this.helper.methodsByName.get(name);
        if (method == null) {
            throw new IllegalBioPAXArgumentException("No creation methods for name: " + name);
        }
        return this.invokeCreation(method);
    }

    private BioPAXElement invokeCreation(Method method) {
        try {
            return (BioPAXElement)method.invoke((Object)this, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new IllegalBioPAXArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalBioPAXArgumentException(e);
        }
    }

    @Override
    public Model createModel() {
        return new ModelImpl(this);
    }

    private class MethodMapHelper {
        private HashMap<Class<? extends BioPAXElement>, Method> methodsByClass = new HashMap();
        private HashMap<String, Method> methodsByName = new HashMap();

        public MethodMapHelper(Method[] methods) {
            for (Method method : methods) {
                if (!method.getName().startsWith("create")) continue;
                Class<?> clazz = method.getReturnType();
                this.methodsByClass.put(clazz, method);
                String s = clazz.getName();
                this.methodsByName.put(s.substring(s.lastIndexOf(46) + 1), method);
            }
        }
    }
}

