/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.Traverser;
import org.biopax.paxtools.controller.Visitor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Merger
implements Visitor {
    private static Log log = LogFactory.getLog(Merger.class);
    private Traverser traverser;
    private BioPAXElement existingBpe;
    private Model target;
    private HashMap<Integer, List<BioPAXElement>> equivalenceMap = new HashMap();
    private EditorMap map;
    private BioPAXElement currentElement;
    private HashSet<BioPAXElement> mergedElements = new HashSet();
    private HashSet<BioPAXElement> addedElements = new HashSet();

    public Merger(EditorMap map) {
        this.map = map;
        this.traverser = new Traverser(map, this);
    }

    @Override
    public void visit(BioPAXElement bpe, Model model, PropertyEditor editor) {
        if (bpe != null && !model.contains(bpe) && model.contains(bpe)) {
            if (editor.isMultipleCardinality()) {
                editor.removePropertyFromBean(bpe, this.currentElement);
            }
            editor.setPropertyToBean(this.currentElement, this.getIdentical(bpe));
        }
    }

    public HashSet<BioPAXElement> getMergedElements() {
        return this.mergedElements;
    }

    public HashSet<BioPAXElement> getAddedElements() {
        return this.addedElements;
    }

    public void merge(Model target, Model ... sources) {
        this.mergedElements.clear();
        this.addedElements.clear();
        Set<BioPAXElement> targetElements = target.getObjects();
        for (BioPAXElement t_bpe : targetElements) {
            this.addIntoEquivalanceMap(t_bpe);
        }
        for (Model source : sources) {
            Set<BioPAXElement> sourceElements = source.getObjects();
            for (BioPAXElement bpe : sourceElements) {
                this.insert(target, bpe);
            }
        }
    }

    private void insert(Model target, BioPAXElement bpe) {
        if (!target.contains(bpe)) {
            if (target.contains(bpe)) {
                BioPAXElement equivalent = this.getIdentical(bpe);
                log.info((Object)(bpe + " is eq to " + equivalent));
                this.updateObjectFields(bpe, equivalent);
                this.mergedElements.add(equivalent);
            } else {
                if (target.getIdMap().get(bpe.getRDFId()) == null) {
                    target.add(bpe);
                }
                this.addIntoEquivalanceMap(bpe);
                this.currentElement = bpe;
                this.traverser.traverse(bpe, target);
                this.addedElements.add(bpe);
            }
        }
    }

    private BioPAXElement getIdentical(BioPAXElement bpe) {
        int key = bpe.hashCode();
        List<BioPAXElement> list = this.equivalenceMap.get(key);
        if (list != null) {
            for (BioPAXElement other : list) {
                if (!other.equals(bpe)) continue;
                return other;
            }
        }
        return null;
    }

    private void updateObjectFields(BioPAXElement update, BioPAXElement existing) {
        Set<PropertyEditor> editors = this.map.getEditorsOf(update);
        for (PropertyEditor editor : editors) {
            this.updateObjectFieldsForEditor(editor, update, existing);
        }
        if (!update.getRDFId().equals(existing.getRDFId())) {
            // empty if block
        }
    }

    private void updateObjectFieldsForEditor(PropertyEditor editor, BioPAXElement update, BioPAXElement existing) {
        if (editor.isMultipleCardinality()) {
            for (Object updateValue : (Set)editor.getValueFromBean(update)) {
                this.updateField(editor, updateValue, existing);
            }
        } else {
            Object existingValue = editor.getValueFromBean(existing);
            Object updateValue = editor.getValueFromBean(update);
            if (editor.isUnknown(existingValue)) {
                if (!editor.isUnknown(updateValue)) {
                    this.updateField(editor, updateValue, existing);
                }
            } else if (!existingValue.equals(updateValue)) {
                log.warn((Object)("Mismatch in single cardinality field:" + existingValue + ":" + updateValue));
                log.warn((Object)"Using existing value");
            }
        }
    }

    private void updateField(PropertyEditor editor, Object updateValue, BioPAXElement existing) {
        if (updateValue instanceof BioPAXElement) {
            BioPAXElement bpe = (BioPAXElement)updateValue;
            BioPAXElement ibpe = this.target.getIdMap().get(bpe.getRDFId());
            if (ibpe != null) {
                updateValue = ibpe;
            }
        }
        editor.setPropertyToBean(existing, updateValue);
    }

    private void addIntoEquivalanceMap(BioPAXElement bpe) {
        int key = bpe.hashCode();
        List<BioPAXElement> list = this.equivalenceMap.get(key);
        if (list == null) {
            list = new ArrayList<BioPAXElement>();
            this.equivalenceMap.put(key, list);
        }
        list.add(bpe);
    }
}

