/*
 * Decompiled with CFR 0.152.
 */
package org.castor.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Configuration {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$castor$util$Configuration == null ? (class$org$castor$util$Configuration = Configuration.class$("org.castor.util.Configuration")) : class$org$castor$util$Configuration));
    private static final String FILEPATH = "/org/exolab/castor/";
    private static final String FILENAME = "castor.properties";
    private static Configuration _config = null;
    private Properties _props = new Properties();
    static /* synthetic */ Class class$org$castor$util$Configuration;

    public static Configuration getInstance() {
        if (_config == null) {
            _config = new Configuration();
        }
        return _config;
    }

    public static void disposeConfiguration() {
        _config = null;
    }

    public Configuration() {
        this.loadDefaultProperties();
    }

    public Configuration(String filename) {
        this.loadProperties(filename);
    }

    public void loadDefaultProperties() {
        boolean found = false;
        try {
            this._props.load(this.getClass().getResourceAsStream("/org/exolab/castor/castor.properties"));
            found = true;
        }
        catch (Exception ex) {
            LOG.warn((Object)"Non-critical error during Castor configuration load:", (Throwable)ex);
        }
        try {
            File file;
            String javaHome = System.getProperty("java.home");
            if (javaHome != null && (file = new File(new File(javaHome, "lib"), FILENAME)).exists()) {
                this._props.load(new FileInputStream(file));
                found = true;
            }
        }
        catch (SecurityException ex) {
            LOG.warn((Object)"Security policy prevented access to Castor configuration:", (Throwable)ex);
        }
        catch (Exception ex) {
            LOG.warn((Object)"Non-critical error during Castor configuration load:", (Throwable)ex);
        }
        if (!found) {
            String msg = "Could not obtain the default configuration file 'castor.properties' from the Castor JAR.";
            LOG.error((Object)msg);
            throw new RuntimeException(msg);
        }
        try {
            URL url = this.getClass().getResource("/castor.properties");
            if (url != null) {
                this._props.load(url.openStream());
                return;
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)"Non-critical error during Castor configuration load:", (Throwable)ex);
        }
        try {
            File file = new File(FILENAME);
            if (file.exists() && file.canRead()) {
                this._props.load(new FileInputStream(file));
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)"Non-critical error during Castor configuration load:", (Throwable)ex);
        }
    }

    public void loadProperties(String filename) {
        URL url = null;
        try {
            try {
                url = new URL(filename);
            }
            catch (MalformedURLException ex) {
                url = this.getClass().getClassLoader().getResource(filename);
            }
            if (url == null) {
                String msg = "Could not obtain the configuration file '" + filename + "' from the Castor JAR.";
                LOG.error((Object)msg);
                throw new RuntimeException(msg);
            }
            this._props.load(url.openStream());
        }
        catch (IOException ex) {
            String msg = "Could not read the configuration file '" + url.toExternalForm() + "' from the Castor JAR.";
            LOG.error((Object)msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
    }

    public Properties getProperties() {
        return this._props;
    }

    public String getProperty(String name, String defaultValue) {
        String value = this._props.getProperty(name);
        return value == null ? defaultValue : value;
    }

    public String[] getProperty(String name) {
        String value = this._props.getProperty(name);
        if (value == null) {
            return new String[0];
        }
        String[] array = value.split(",");
        for (int i = 0; i < array.length; ++i) {
            array[i] = array[i].trim();
        }
        return array;
    }

    public int getProperty(String name, int defaultValue) {
        String value = this._props.getProperty(name);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public boolean getProperty(String name, boolean defaultValue) {
        String value = this._props.getProperty(name);
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        return defaultValue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

