/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.controller.EnumeratedPropertyEditor;
import org.biopax.paxtools.controller.ObjectPropertyEditor;
import org.biopax.paxtools.controller.PrimitivePropertyEditor;
import org.biopax.paxtools.controller.StringPropertyEditor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.util.IllegalBioPAXArgumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyEditor {
    protected static Log log = LogFactory.getLog(PropertyEditor.class);
    protected Method setMethod;
    protected Method getMethod;
    protected Method addMethod;
    protected Method removeMethod;
    protected Class<? extends BioPAXElement> domain;
    protected Class range = Object.class;
    protected String property;
    protected boolean multipleCardinality;
    private Map<Class, Integer> maxCardinalities = new HashMap<Class, Integer>();

    public static PropertyEditor createPropertyEditor(Class<? extends BioPAXElement> domain, String property) {
        PropertyEditor editor = null;
        try {
            Method getMethod = PropertyEditor.detectGetMethod(domain, property);
            boolean multipleCardinality = PropertyEditor.isMultipleCardinality(getMethod);
            Class range = PropertyEditor.detectRange(getMethod, multipleCardinality);
            editor = range.isPrimitive() ? new PrimitivePropertyEditor(property, getMethod, domain, range, multipleCardinality) : (range.isEnum() ? new EnumeratedPropertyEditor(property, getMethod, domain, range, multipleCardinality) : (range.equals(String.class) ? new StringPropertyEditor(property, getMethod, domain, range, multipleCardinality) : new ObjectPropertyEditor(property, getMethod, domain, range, multipleCardinality)));
        }
        catch (NoSuchMethodException e) {
            log.warn((Object)("Failed creating the controller for " + property + " on " + domain));
        }
        return editor;
    }

    private static Method detectGetMethod(Class beanClass, String property) throws NoSuchMethodException {
        String javaMethodName = PropertyEditor.getJavaName(property);
        log.trace((Object)("javaMethodName = " + javaMethodName));
        return beanClass.getMethod("get" + javaMethodName, new Class[0]);
    }

    private static String getJavaName(String owlName) {
        String s = owlName.replaceAll("-", "_");
        s = s.substring(0, 1).toUpperCase() + s.substring(1);
        return s;
    }

    private static boolean isMultipleCardinality(Method getMethod) {
        return Set.class.isAssignableFrom(getMethod.getReturnType());
    }

    private static Class detectRange(Method getMethod, boolean multipleCardinality) {
        Class<Number> range = getMethod.getReturnType();
        if (multipleCardinality) {
            range = Object.class;
            Type genericReturnType = getMethod.getGenericReturnType();
            if (genericReturnType instanceof ParameterizedType) {
                range = (Class<Double>)((ParameterizedType)genericReturnType).getActualTypeArguments()[0];
                if (range == Double.class) {
                    range = Double.TYPE;
                }
                if (range == Float.class) {
                    range = Float.TYPE;
                }
                if (range == Integer.class) {
                    range = Integer.TYPE;
                }
            }
            log.trace(range);
        }
        return range;
    }

    public PropertyEditor(String property, Method getMethod, Class<? extends BioPAXElement> domain, Class range, boolean multipleCardinality) {
        this.multipleCardinality = multipleCardinality;
        this.range = range;
        this.getMethod = getMethod;
        this.domain = domain;
        this.property = property;
        try {
            this.detectMethods();
        }
        catch (NoSuchMethodException e) {
            log.error((Object)"Failed at reflection, no remove method!");
        }
    }

    private void detectMethods() throws NoSuchMethodException {
        if (this.multipleCardinality) {
            String javaName = PropertyEditor.getJavaName(this.property);
            this.setMethod = this.domain.getMethod("set" + javaName, Set.class);
            this.addMethod = this.domain.getMethod("add" + javaName, this.range);
            this.removeMethod = this.domain.getMethod("remove" + javaName, this.range);
        } else {
            this.setMethod = this.domain.getMethod("set" + PropertyEditor.getJavaName(this.property), this.range);
        }
    }

    public Method getAddMethod() {
        return this.addMethod;
    }

    public Class<? extends BioPAXElement> getDomain() {
        return this.domain;
    }

    public Method getGetMethod() {
        return this.getMethod;
    }

    public String getProperty() {
        return this.property;
    }

    public Class getRange() {
        return this.range;
    }

    public Method getRemoveMethod() {
        return this.removeMethod;
    }

    public Method getSetMethod() {
        return this.setMethod;
    }

    public boolean isMultipleCardinality() {
        return this.multipleCardinality;
    }

    public void addMaxCardinalityRestriction(Class domain, int max) {
        assert (this.domain.isAssignableFrom(domain));
        if (this.multipleCardinality) {
            this.maxCardinalities.put(domain, max);
        } else if (max == 1) {
            log.info((Object)"unnecessary use of cardinality restriction. Maybe you want to use functional instead?");
        } else if (max == 0) {
            this.maxCardinalities.put(domain, max);
        } else assert (false);
    }

    public Integer getMaxCardinality(Class restrictedDomain) {
        return this.maxCardinalities.get(restrictedDomain);
    }

    protected boolean isInstanceOfAtLeastOne(Set<Class> classes, Object value) {
        boolean check = false;
        for (Class aClass : classes) {
            if (!aClass.isInstance(value)) continue;
            check = true;
            break;
        }
        return check;
    }

    public boolean isUnknown(Object value) {
        return value == null;
    }

    public void removePropertyFromBean(Object value, Object bean) {
        this.invokeMethod(this.removeMethod, bean, value);
    }

    protected void invokeMethod(Method method, Object bean, Object value) {
        assert (bean != null);
        try {
            method.invoke((Object)this.domain.cast(bean), value);
        }
        catch (ClassCastException exception) {
            String message = "Failed to set property : " + this.property;
            if (!this.domain.isAssignableFrom(bean.getClass())) {
                message = message + "\nInvalid domain bean: " + bean + "" + "\n" + this.domain + " is not assignable from " + bean.getClass();
            }
            if (!this.range.isAssignableFrom(value.getClass())) {
                message = message + "\nInvalid range value: " + value + "" + "\n" + this.range + " is not assignable from " + value.getClass();
            }
            log.error((Object)message);
        }
        catch (InvocationTargetException e) {
            String message = "Failed to set property : " + this.property;
            message = message + "\n Method: " + method + " on " + this.domain + " with value " + this.range;
            log.error((Object)message, e.getCause());
        }
        catch (IllegalAccessException e) {
            String message = "Failed to set property : " + this.property;
            message = message + "\n Method: " + method + " on " + this.domain + " with value " + this.range;
            log.error((Object)message, e.getCause());
        }
    }

    public void setPropertyToBean(Object bean, Object value) {
        if (log.isTraceEnabled()) {
            log.trace((Object)(this.setMethod + "|" + bean + "|" + value));
        }
        if (value != null) {
            this.checkRestrictions(bean, value);
            this.invokeMethod(this.getPrimarySetMethod(), bean, value);
        }
    }

    protected void checkRestrictions(Object bean, Object value) {
        Integer max = this.maxCardinalities.get(value.getClass());
        if (max != null) {
            if (max == 0) {
                throw new IllegalBioPAXArgumentException("Cardinality 0 restriction violated");
            }
            assert (this.multipleCardinality);
            Set values = (Set)this.getValueFromBean(bean);
            if (values.size() >= max) {
                throw new IllegalBioPAXArgumentException("Cardinality " + max + " restriction violated");
            }
        }
    }

    public Object getValueFromBean(Object bean) {
        try {
            return this.getMethod.invoke(bean, new Object[0]);
        }
        catch (IllegalAccessException e) {
            log.error((Object)("Could not invoke get method " + this.getMethod + " for " + bean));
            throw new IllegalBioPAXArgumentException(e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)("Could not invoke get method " + this.getMethod + " for " + bean));
            throw new IllegalBioPAXArgumentException(e);
        }
    }

    public Method getPrimarySetMethod() {
        return this.multipleCardinality ? this.addMethod : this.setMethod;
    }
}

