/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.util;

import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.exolab.castor.util.CmdLineOption;
import org.exolab.castor.util.Messages;

public class CommandLineOptions {
    Vector flags = new Vector();
    Hashtable optionInfo = new Hashtable();
    PrintWriter errorWriter = new PrintWriter(System.out);

    public void addFlag(String flag) {
        this.addFlag(flag, null, null);
    }

    public void addFlag(String flag, String comment) {
        this.addFlag(flag, null, comment, false);
    }

    public void addFlag(String flag, String usageText, String comment) {
        this.addFlag(flag, usageText, comment, false);
    }

    public void addFlag(String flag, String usageText, String comment, boolean optional) {
        if (flag == null) {
            return;
        }
        this.flags.addElement(flag);
        CmdLineOption opt = new CmdLineOption(flag);
        opt.setComment(comment);
        opt.setUsageText(usageText);
        opt.setOptional(optional);
        this.optionInfo.put(flag, opt);
    }

    public Properties getOptions(String[] args) {
        Properties options = new Properties();
        String flag = null;
        block0: for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if (flag != null) {
                    options.put(flag, args[i]);
                    options.put(new Integer(i), args[i]);
                }
                if (this.flags.contains(flag = args[i].substring(1))) continue;
                for (int idx = 1; idx <= flag.length(); ++idx) {
                    if (this.flags.contains(flag.substring(0, idx))) {
                        if (idx >= flag.length()) continue;
                        options.put(flag.substring(0, idx), flag.substring(idx));
                        continue block0;
                    }
                    if (idx != flag.length()) continue;
                    this.errorWriter.println(Messages.format("misc.invalidCLIOption", "-" + flag));
                    this.printUsage(this.errorWriter);
                }
                continue;
            }
            if (flag != null) {
                options.put(flag, args[i]);
            }
            options.put(new Integer(i), args[i]);
            flag = null;
        }
        if (flag != null) {
            options.put(flag, "no value");
        }
        return options;
    }

    public void setComment(String flag, String comment) {
        if (flag == null) {
            return;
        }
        CmdLineOption opt = (CmdLineOption)this.optionInfo.get(flag);
        if (opt != null) {
            opt.setComment(comment);
        }
    }

    public void setOptional(String flag, boolean optional) {
        if (flag == null) {
            return;
        }
        CmdLineOption opt = (CmdLineOption)this.optionInfo.get(flag);
        if (opt != null) {
            opt.setOptional(optional);
        }
    }

    public void setUsageInfo(String flag, String usage) {
        if (flag == null) {
            return;
        }
        CmdLineOption opt = (CmdLineOption)this.optionInfo.get(flag);
        if (opt != null) {
            opt.setUsageText(usage);
        }
    }

    public void printUsage(PrintWriter pw) {
        pw.println();
        pw.print(Messages.message("misc.CLIUsage"));
        for (int i = 0; i < this.flags.size(); ++i) {
            String flag = (String)this.flags.elementAt(i);
            CmdLineOption opt = (CmdLineOption)this.optionInfo.get(flag);
            if (opt.getOptional()) {
                pw.print(" [-");
            } else {
                pw.print(" -");
            }
            pw.print(flag);
            String usage = opt.getUsageText();
            if (usage != null) {
                pw.print(' ');
                pw.print(usage);
            }
            if (!opt.getOptional()) continue;
            pw.print(']');
        }
        pw.println();
        pw.flush();
    }

    public void printHelp(PrintWriter pw) {
        this.printUsage(pw);
        pw.println();
        if (this.flags.size() > 0) {
            pw.println("Flag               Description");
            pw.println("----------------------------------------------");
        }
        for (int i = 0; i < this.flags.size(); ++i) {
            String flag = (String)this.flags.elementAt(i);
            CmdLineOption opt = (CmdLineOption)this.optionInfo.get(flag);
            pw.print('-');
            pw.print(flag);
            pw.print(' ');
            for (int spaces = 17 - flag.length(); spaces > 0; --spaces) {
                pw.print(' ');
            }
            pw.print(opt.getComment());
            pw.println();
        }
        pw.println();
        pw.flush();
    }
}

