/*
 * Decompiled with CFR 0.152.
 */
package org.castor.jdo.engine;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.jdo.conf.DatabaseChoice;
import org.castor.jdo.conf.Driver;
import org.castor.jdo.conf.JdoConf;
import org.castor.jdo.conf.Param;
import org.castor.jdo.drivers.ConnectionProxy;
import org.castor.jdo.engine.AbstractConnectionFactory;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.util.Messages;

public final class DriverConnectionFactory
extends AbstractConnectionFactory {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$castor$jdo$engine$DriverConnectionFactory == null ? (class$org$castor$jdo$engine$DriverConnectionFactory = DriverConnectionFactory.class$("org.castor.jdo.engine.DriverConnectionFactory")) : class$org$castor$jdo$engine$DriverConnectionFactory));
    private String _url = null;
    private Properties _props;
    static /* synthetic */ Class class$org$castor$jdo$engine$DriverConnectionFactory;

    public DriverConnectionFactory(JdoConf jdoConf, int index, Mapping mapping) {
        super(jdoConf, index, mapping);
    }

    protected void initializeFactory() throws MappingException {
        DatabaseChoice dbChoice = this.getDatabase().getDatabaseChoice();
        String driverName = dbChoice.getDriver().getClassName();
        if (driverName != null) {
            try {
                Class.forName(dbChoice.getDriver().getClassName()).newInstance();
            }
            catch (InstantiationException e) {
                String msg = Messages.format("jdo.engine.classNotInstantiable", driverName);
                LOG.error((Object)msg, (Throwable)e);
                throw new MappingException(msg, e);
            }
            catch (IllegalAccessException e) {
                String msg = Messages.format("jdo.engine.classNotAccessable", driverName, "constructor");
                LOG.error((Object)msg, (Throwable)e);
                throw new MappingException(msg, e);
            }
            catch (ClassNotFoundException e) {
                String msg = "Can not load class " + driverName;
                LOG.error((Object)msg, (Throwable)e);
                throw new MappingException(msg, e);
            }
        }
        try {
            Driver driver = dbChoice.getDriver();
            if (DriverManager.getDriver(driver.getUrl()) == null) {
                String msg = Messages.format("jdo.missingDriver", driver.getUrl());
                LOG.error((Object)msg);
                throw new MappingException(msg);
            }
        }
        catch (SQLException ex) {
            throw new MappingException(ex);
        }
        this._url = dbChoice.getDriver().getUrl();
        this._props = new Properties();
        Enumeration params = dbChoice.getDriver().enumerateParam();
        while (params.hasMoreElements()) {
            Param param = (Param)params.nextElement();
            this._props.put(param.getName(), param.getValue());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Using driver: " + driverName));
        }
    }

    public Connection createConnection() throws SQLException {
        return ConnectionProxy.newConnectionProxy(DriverManager.getConnection(this._url, this._props), this.getClass().getName());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

