/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ook.web.ajax;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ajaxtags.helpers.AjaxXmlBuilder;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import uk.ac.ebi.ook.persistence.query.ServiceQueryHandler;
import uk.ac.ebi.ook.web.ajax.AjaxHandler;

public class TermNameAutocompleteAjaxServlet
implements AjaxHandler {
    private Logger logger = Logger.getLogger((Class)(class$uk$ac$ebi$ook$web$ajax$TermNameAutocompleteAjaxServlet == null ? (class$uk$ac$ebi$ook$web$ajax$TermNameAutocompleteAjaxServlet = TermNameAutocompleteAjaxServlet.class$("uk.ac.ebi.ook.web.ajax.TermNameAutocompleteAjaxServlet")) : class$uk$ac$ebi$ook$web$ajax$TermNameAutocompleteAjaxServlet));
    private static final String TERM_NAME_PARAMETER = "termname";
    private static final String ONTOLOGY_NAME_PARAMETER = "ontologyname";
    private static final String INCLUDE_OBSOLETE_PARAMETER = "obsolete";
    private static final String AND_MORE = "...and more";
    private static final String CLICK_HERE = "click to see the fuil list";
    private static final int AJAX_CUTOFF = 19;
    private static final Integer LUCENE_CUTOFF = new Integer(21);
    static /* synthetic */ Class class$uk$ac$ebi$ook$web$ajax$TermNameAutocompleteAjaxServlet;

    public String getXmlContent(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ServiceQueryHandler query = new ServiceQueryHandler();
        String termName = request.getParameter(TERM_NAME_PARAMETER);
        String ontName = request.getParameter(ONTOLOGY_NAME_PARAMETER);
        String inclObsoleteStr = request.getParameter(INCLUDE_OBSOLETE_PARAMETER);
        boolean inclObseleteBool = true;
        if (inclObsoleteStr != null) {
            inclObseleteBool = Boolean.valueOf(inclObsoleteStr);
        }
        this.logger.debug((Object)("Including obsolete terms: " + inclObseleteBool));
        if (ontName != null && (ontName.equals("null") || ontName.equals(""))) {
            ontName = null;
        }
        HashMap terms = new HashMap();
        AjaxXmlBuilder ajax = new AjaxXmlBuilder();
        if (termName != null && termName.trim().length() > 0) {
            terms = ontName != null ? query.getTermsByName(termName.trim(), ontName, inclObseleteBool, LUCENE_CUTOFF, true) : query.getPrefixedTermsByName(termName.trim(), inclObseleteBool, LUCENE_CUTOFF, true);
            ajax = this.buildAjaxReply(ajax, terms);
        }
        this.logger.debug((Object)ajax.toString());
        return ajax.toString();
    }

    private AjaxXmlBuilder buildAjaxReply(AjaxXmlBuilder ajax, Map terms) {
        TreeMap sorted = new TreeMap(new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = "" + (String)o1;
                String s2 = "" + (String)o2;
                if (s1.length() > s2.length()) {
                    return 1;
                }
                if (s1.length() < s2.length()) {
                    return -1;
                }
                return s1.compareTo(s2);
            }
        });
        sorted.putAll(terms);
        int counter = 1;
        Iterator i = sorted.keySet().iterator();
        while (i.hasNext()) {
            if (counter++ > 19) {
                ajax.addItem(AND_MORE, CLICK_HERE);
                break;
            }
            String termname = (String)i.next();
            String termId = (String)sorted.get(termname);
            ajax.addItem(StringEscapeUtils.escapeXml((String)termname), StringEscapeUtils.escapeXml((String)termId));
        }
        return ajax;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

