/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ook.persistence.query;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import uk.ac.ebi.ook.model.interfaces.Annotation;
import uk.ac.ebi.ook.model.interfaces.DbXref;
import uk.ac.ebi.ook.model.interfaces.Term;
import uk.ac.ebi.ook.model.interfaces.TermSynonym;
import uk.ac.ebi.ook.persistence.lucene.IndexedTermQueryHandler;
import uk.ac.ebi.ook.persistence.query.OntologyQueryHandler;
import uk.ac.ebi.ook.persistence.query.TermQueryHandler;
import uk.ac.ebi.ook.web.model.DataHolder;
import uk.ac.ebi.proteomics.common.StringUtilities;
import uk.ac.ebi.proteomics.common.cache.Cacheable;
import uk.ac.ebi.proteomics.common.cache.CachedEntry;
import uk.ac.ebi.proteomics.common.cache.NeedsRefreshException;
import uk.ac.ebi.proteomics.common.cache.TimedLRUMapCache;

public class ServiceQueryHandler {
    private static Logger logger = Logger.getLogger((Class)(class$uk$ac$ebi$ook$persistence$query$ServiceQueryHandler == null ? (class$uk$ac$ebi$ook$persistence$query$ServiceQueryHandler = ServiceQueryHandler.class$("uk.ac.ebi.ook.persistence.query.ServiceQueryHandler")) : class$uk$ac$ebi$ook$persistence$query$ServiceQueryHandler));
    private static TimedLRUMapCache termCache = TimedLRUMapCache.getInstance();
    private static final String TERM_ID_KEY = "TERM_ID";
    private static final String TERM_NAME_KEY = "TERN_NAME";
    private static final String TERM_EXACT_NAME_KEY = "TERN_NAME_EXACT";
    private static final String PREFIX_TERM_NAME_KEY = "PF_TERN_NAME";
    private static final String ONTOLOGY_NAMES_KEY = "ONTOLOGY_NAMES_REPORT";
    private static final String TERM_CHILDREN_KEY = "TERM_CIHLDREN";
    private static final String TERM_OBSOLETE_KEY = "TERM_IS_OBSOLETE";
    private static final String ONTOLOGY_ROOT_TERMS_KEY = "ONTOLOGY_ROOT_TERM";
    private static final String TERM_METADATA_KEY = "TERM_METADATA";
    private static final String TERM_RELATION_LIST_KEY = "TERM_RELATION_LIST";
    private static final String TERM_RELATION_MAP_KEY = "TERM_RELATION_MAP";
    private static final String ONTOLOGY_CSV_KEY = "ONTOLOGY_TO_CSV_STRING";
    private static final String TERM_PARENT_KEY = "TERM_PARENT";
    private static final String TERM_XREF_KEY = "TERM_XREF";
    private static final String TERM_ANNOTATION_DATA_KEY = "TERN_ANNOTATION_DATA";
    private static final String ONTOLOGY_ALLTERMS_KEY = "ONTOLOGY_ALL_TERMS";
    private static final String ONTOLOGY_LOAD_DATE_KEY = "ONTOLOGY_LOAD_DATE";
    static /* synthetic */ Class class$uk$ac$ebi$ook$persistence$query$ServiceQueryHandler;

    public String getTermById(String termId, String ontologyName) throws RemoteException {
        String retval = termId;
        String key = termId + (ontologyName == null ? "null" : ontologyName) + TERM_ID_KEY;
        try {
            Cacheable tmpEntry = termCache.getFromCache((Object)key);
            retval = (String)tmpEntry.getValue();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Used cached entry:" + tmpEntry));
            }
        }
        catch (NeedsRefreshException nre) {
            TermQueryHandler tqh = new TermQueryHandler();
            Term trm = tqh.getTermById(termId, ontologyName);
            if (trm != null) {
                retval = trm.getName();
            }
            termCache.putInCache((Object)key, (Object)new CachedEntry((Object)retval));
        }
        return retval;
    }

    public HashMap getTermMetadata(String termId, String ontologyName) throws RemoteException {
        HashMap retval = new HashMap();
        String key = termId + (ontologyName == null ? "null" : ontologyName) + TERM_METADATA_KEY;
        Cacheable tmpEntry = null;
        try {
            tmpEntry = termCache.getFromCache((Object)key);
            retval = (HashMap)tmpEntry.getValue();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Used cached entry:" + tmpEntry));
            }
        }
        catch (NeedsRefreshException nre) {
            TermQueryHandler tqh = new TermQueryHandler();
            Term trm = tqh.getTermById(termId, ontologyName);
            if (trm != null) {
                retval.put("definition", trm.getDefinition());
                Collection annotations = tqh.getTermAnnotations(trm.getTermId());
                Iterator i = annotations.iterator();
                while (i.hasNext()) {
                    Annotation annotation = (Annotation)i.next();
                    retval.put(annotation.getAnnotationType(), annotation.getAnnotationCompleteValue());
                }
                Collection synonyms = trm.getSynonyms();
                if (synonyms != null && !synonyms.isEmpty()) {
                    String synType;
                    MultiHashMap tempMap = new MultiHashMap();
                    Iterator i2 = synonyms.iterator();
                    while (i2.hasNext()) {
                        TermSynonym ts = (TermSynonym)i2.next();
                        synType = ts.getSynonymType().getName();
                        if (!"synonym".equals(synType)) {
                            synType = synType + "_synonym";
                        }
                        tempMap.put((Object)synType, (Object)ts.getSynonym());
                    }
                    i2 = tempMap.keySet().iterator();
                    while (i2.hasNext()) {
                        synType = (String)i2.next();
                        Collection syns = (Collection)tempMap.get((Object)synType);
                        if (syns.size() > 1) {
                            int ndx = 1;
                            Iterator j = syns.iterator();
                            while (j.hasNext()) {
                                String aSyn = (String)j.next();
                                retval.put(synType + "_" + ndx++, aSyn);
                            }
                            continue;
                        }
                        if (syns.size() != 1) continue;
                        String aSyn = syns.toArray(new String[0])[0];
                        retval.put(synType, aSyn);
                    }
                }
            }
            termCache.putInCache((Object)key, (Object)new CachedEntry((Object)retval));
        }
        return retval;
    }

    public HashMap getTermXrefs(String termId, String ontologyName) throws RemoteException {
        HashMap retval = new HashMap();
        String key = termId + (ontologyName == null ? "null" : ontologyName) + TERM_XREF_KEY;
        Cacheable tmpEntry = null;
        try {
            tmpEntry = termCache.getFromCache((Object)key);
            retval = (HashMap)tmpEntry.getValue();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Used cached entry:" + tmpEntry));
            }
        }
        catch (NeedsRefreshException e) {
            TermQueryHandler tqh = new TermQueryHandler();
            Collection xrefs = tqh.getTermXrefs(termId, ontologyName);
            if (xrefs != null) {
                int analCount = -1;
                int anatCount = -1;
                int defCount = -1;
                int synCount = -1;
                int unkCount = -1;
                Iterator iterator = xrefs.iterator();
                while (iterator.hasNext()) {
                    int currentCount;
                    String type;
                    DbXref dbx = (DbXref)iterator.next();
                    switch (dbx.getXrefType()) {
                        case 3: {
                            type = "xref_analog";
                            currentCount = ++analCount;
                            break;
                        }
                        case 0: {
                            type = "xref_anatomical";
                            currentCount = ++anatCount;
                            break;
                        }
                        case 2: {
                            type = "xref_definition";
                            currentCount = ++defCount;
                            break;
                        }
                        case 1: {
                            type = "xref_related_synonym";
                            currentCount = ++synCount;
                            break;
                        }
                        default: {
                            type = "xref_unknown";
                            currentCount = ++unkCount;
                        }
                    }
                    String value = dbx.getDbName();
                    if (dbx.getAccession() != null) {
                        value = value + ":" + dbx.getAccession();
                    }
                    if (dbx.getDescription() != null) {
                        value = value + "\"" + dbx.getDescription() + "\"";
                    }
                    if (currentCount > 0) {
                        type = type + "_" + currentCount;
                    }
                    retval.put(type, value);
                }
            }
            termCache.putInCache((Object)key, (Object)new CachedEntry((Object)retval));
        }
        return retval;
    }

    public HashMap getTermsByName(String partialName, String ontologyName, boolean reverseKeyOrder) throws RemoteException {
        return this.getTermsByName(partialName, ontologyName, true, null, reverseKeyOrder);
    }

    public HashMap getTermsByName(String partialName, String ontologyName, boolean includeObsoleteTerms, Integer maxHits, boolean reverseKeyOrder) throws RemoteException {
        HashMap retval = new HashMap();
        String key = partialName + (ontologyName == null ? "null" : ontologyName) + (maxHits == null ? "null" : maxHits.toString()) + reverseKeyOrder + includeObsoleteTerms + TERM_NAME_KEY;
        Cacheable tmpEntry = null;
        try {
            tmpEntry = termCache.getFromCache((Object)key);
            retval = (HashMap)tmpEntry.getValue();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Used cached entry:" + tmpEntry));
            }
        }
        catch (NeedsRefreshException e) {
            IndexedTermQueryHandler itqh = new IndexedTermQueryHandler();
            retval.putAll(itqh.getTermsByName(partialName, ontologyName, includeObsoleteTerms, maxHits, reverseKeyOrder, false));
            termCache.putInCache((Object)key, (Object)new CachedEntry((Object)retval));
        }
        return retval;
    }

    public HashMap getTermsByExactName(String exactName, String ontologyName) throws RemoteException {
        HashMap retval = new HashMap();
        String key = exactName + (ontologyName == null ? "null" : ontologyName) + TERM_EXACT_NAME_KEY;
        Cacheable tmpEntry = null;
        try {
            tmpEntry = termCache.getFromCache((Object)key);
            retval = (HashMap)tmpEntry.getValue();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Used cached entry:" + tmpEntry));
            }
        }
        catch (NeedsRefreshException e) {
            TermQueryHandler tqh = new TermQueryHandler();
            retval = tqh.getTermsByName(exactName, ontologyName, true, false);
            termCache.putInCache((Object)key, (Object)new CachedEntry((Object)retval));
        }
        return retval;
    }

    public HashMap getPrefixedTermsByName(String partialName, boolean reverseKeyOrder) throws RemoteException {
        return this.getPrefixedTermsByName(partialName, true, null, reverseKeyOrder);
    }

    public HashMap getPrefixedTermsByName(String partialName, boolean includeObsoleteTerms, Integer maxHits, boolean reverseKeyOrder) throws RemoteException {
        HashMap retval = new HashMap();
        String key = partialName + (maxHits == null ? "null" : maxHits.toString()) + reverseKeyOrder + includeObsoleteTerms + PREFIX_TERM_NAME_KEY;
        Cacheable tmpEntry = null;
        try {
            tmpEntry = termCache.getFromCache((Object)key);
            retval = (HashMap)tmpEntry.getValue();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Used cached entry:" + tmpEntry));
            }
        }
        catch (NeedsRefreshException e) {
            IndexedTermQueryHandler itqh = new IndexedTermQueryHandler();
            retval.putAll(itqh.getTermsByName(partialName, null, includeObsoleteTerms, maxHits, reverseKeyOrder, true));
            termCache.putInCache((Object)key, (Object)new CachedEntry((Object)retval));
        }
        return retval;
    }

    public HashMap getOntologyNames() throws RemoteException {
        HashMap retval = new HashMap();
        String key = ONTOLOGY_NAMES_KEY;
        Cacheable tmpEntry = null;
        try {
            tmpEntry = termCache.getFromCache((Object)key);
            retval = (HashMap)tmpEntry.getValue();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Used cached entry:" + tmpEntry));
            }
        }
        catch (NeedsRefreshException e) {
            OntologyQueryHandler oqh = new OntologyQueryHandler();
            Collection coll = oqh.getOntologyReport(null);
            Iterator i = coll.iterator();
            while (i.hasNext()) {
                Object[] current = (Object[])i.next();
                retval.put(current[1], StringUtilities.checkNull((String)((String)current[2])));
            }
            termCache.putInCache((Object)key, (Object)new CachedEntry((Object)retval));
        }
        return retval;
    }

    public HashMap getRootTerms(String ontologyName) throws RemoteException {
        HashMap retval = new HashMap();
        String key = ONTOLOGY_ROOT_TERMS_KEY + ontologyName;
        Cacheable tmpEntry = null;
        try {
            tmpEntry = termCache.getFromCache((Object)key);
            retval = (HashMap)tmpEntry.getValue();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Used cached entry:" + tmpEntry));
            }
        }
        catch (NeedsRefreshException e) {
            TermQueryHandler tqh = new TermQueryHandler();
            Collection tmpTerms = tqh.getRootTerms(ontologyName);
            Iterator i = tmpTerms.iterator();
            while (i.hasNext()) {
                Term t = (Term)i.next();
                retval.put(t.getIdentifier(), t.getName());
            }
            termCache.putInCache((Object)key, (Object)new CachedEntry((Object)retval));
        }
        return retval;
    }

    public HashMap getTermChildren(String termId, String ontologyName, int distance, int[] relationTypes) throws RemoteException {
        HashMap retval = new HashMap();
        String key = termId + (ontologyName == null ? "null" : ontologyName) + distance;
        if (relationTypes != null) {
            for (int i = 0; i < relationTypes.length; ++i) {
                key = key + relationTypes[i];
            }
        }
        key = key + TERM_CHILDREN_KEY;
        Cacheable tmpEntry = null;
        try {
            tmpEntry = termCache.getFromCache((Object)key);
            retval = (HashMap)tmpEntry.getValue();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Used cached entry:" + tmpEntry));
            }
        }
        catch (NeedsRefreshException e) {
            TermQueryHandler tqh = new TermQueryHandler();
            Collection data = tqh.getTermChildren(termId, ontologyName, new Integer(distance), relationTypes);
            Iterator iterator = data.iterator();
            while (iterator.hasNext()) {
                Object[] values = (Object[])iterator.next();
                retval.put(values[0], values[1]);
            }
            termCache.putInCache((Object)key, (Object)new CachedEntry((Object)retval));
        }
        return retval;
    }

    public boolean isObsolete(String termId, String ontologyName) throws RemoteException {
        boolean retval = false;
        String key = termId + (ontologyName == null ? "null" : ontologyName) + TERM_OBSOLETE_KEY;
        Cacheable tmpEntry = null;
        try {
            tmpEntry = termCache.getFromCache((Object)key);
            retval = (Boolean)tmpEntry.getValue();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Used cached entry:" + tmpEntry));
            }
        }
        catch (NeedsRefreshException e) {
            TermQueryHandler tqh = new TermQueryHandler();
            Term trm = tqh.getTermById(termId, ontologyName);
            if (trm != null) {
                retval = trm.isObsolete();
            }
            termCache.putInCache((Object)key, (Object)new CachedEntry((Object)new Boolean(retval)));
        }
        return retval;
    }

    public HashMap getChildrenFromRoot(String rootTermId, String ontologyName, Vector childrenIds) {
        TermQueryHandler tqh = new TermQueryHandler();
        return (HashMap)tqh.getChildrenFromRootTerm(rootTermId, ontologyName, childrenIds);
    }

    public void clearCache() throws RemoteException {
        termCache.clearCache();
    }

    public String toCSVString(String ontologyName) {
        String retval = null;
        if (ontologyName != null) {
            String key = ontologyName + ONTOLOGY_CSV_KEY;
            Cacheable tmpEntry = null;
            try {
                tmpEntry = termCache.getFromCache((Object)key);
                retval = (String)tmpEntry.getValue();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Used cached entry:" + tmpEntry));
                }
            }
            catch (NeedsRefreshException e) {
                OntologyQueryHandler oqh = new OntologyQueryHandler();
                Collection tmp = oqh.getAllTermReportFromOntology(ontologyName);
                StringBuffer sb = new StringBuffer();
                sb.append("identifier,name,definition\n");
                Iterator iterator = tmp.iterator();
                while (iterator.hasNext()) {
                    Object[] objects = (Object[])iterator.next();
                    sb.append(StringEscapeUtils.unescapeXml((String)((String)objects[0])));
                    sb.append(",");
                    sb.append("\"");
                    sb.append(StringEscapeUtils.unescapeXml((String)((String)objects[1])));
                    sb.append("\",");
                    sb.append("\"");
                    sb.append(StringEscapeUtils.unescapeXml((String)((String)objects[2])));
                    sb.append("\"\n");
                }
                retval = sb.toString();
                termCache.putInCache((Object)key, (Object)new CachedEntry((Object)sb.toString()));
            }
        }
        return retval;
    }

    public List getRawTermRelations(String termId, String ontologyName) {
        List retval = new ArrayList();
        String key = termId + (ontologyName == null ? "null" : ontologyName) + TERM_RELATION_LIST_KEY;
        Cacheable tmpEntry = null;
        try {
            tmpEntry = termCache.getFromCache((Object)key);
            retval = (List)tmpEntry.getValue();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Used cached entry:" + tmpEntry));
            }
        }
        catch (NeedsRefreshException e) {
            TermQueryHandler tqh = new TermQueryHandler();
            retval.addAll(tqh.getTermRelationships(termId, ontologyName));
            termCache.putInCache((Object)key, (Object)new CachedEntry(retval));
        }
        return retval;
    }

    public HashMap getTermRelations(String termId, String ontologyName) throws RemoteException {
        HashMap retval = new HashMap();
        String key = termId + (ontologyName == null ? "null" : ontologyName) + TERM_RELATION_MAP_KEY;
        Cacheable tmpEntry = null;
        try {
            tmpEntry = termCache.getFromCache((Object)key);
            retval = (HashMap)tmpEntry.getValue();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Used cached entry:" + tmpEntry));
            }
        }
        catch (NeedsRefreshException e) {
            TermQueryHandler tqh = new TermQueryHandler();
            Collection rels = tqh.getTermRelationships(termId, ontologyName);
            Iterator i = rels.iterator();
            while (i.hasNext()) {
                Object[] values = (Object[])i.next();
                String childTermId = (String)values[0];
                String relType = (String)values[3];
                retval.put(childTermId, relType);
            }
            termCache.putInCache((Object)key, (Object)new CachedEntry((Object)retval));
        }
        return retval;
    }

    public HashMap getTermParents(String termId, String ontologyName) throws RemoteException {
        HashMap retval = new HashMap();
        String key = termId + (ontologyName == null ? "null" : ontologyName) + TERM_PARENT_KEY;
        Cacheable tmpEntry = null;
        try {
            tmpEntry = termCache.getFromCache((Object)key);
            retval = (HashMap)tmpEntry.getValue();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Used cached entry:" + tmpEntry));
            }
        }
        catch (NeedsRefreshException e) {
            TermQueryHandler tqh = new TermQueryHandler();
            Collection parentRels = tqh.getParentTermRelationships(termId, ontologyName);
            if (!parentRels.isEmpty()) {
                Iterator i = parentRels.iterator();
                while (i.hasNext()) {
                    Object[] values = (Object[])i.next();
                    String acc = (String)values[0];
                    String name = (String)values[1];
                    retval.put(acc, name);
                }
            }
            termCache.putInCache((Object)key, (Object)new CachedEntry((Object)retval));
        }
        return retval;
    }

    public DataHolder[] getTermsByAnnotationData(String ontologyName, String annotationType, String strValue, Double fromDblValue, Double toDblValue) throws RemoteException {
        DataHolder[] retval = new DataHolder[]{};
        try {
            StringBuffer key = new StringBuffer().append(ontologyName);
            if (strValue != null) {
                key.append(strValue);
            }
            if (fromDblValue != null) {
                key.append(fromDblValue);
            }
            if (toDblValue != null) {
                key.append(toDblValue);
            }
            key.append(TERM_ANNOTATION_DATA_KEY);
            Cacheable tmpEntry = null;
            try {
                tmpEntry = termCache.getFromCache((Object)key);
                retval = (DataHolder[])tmpEntry.getValue();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Used cached entry:" + tmpEntry));
                }
            }
            catch (NeedsRefreshException e) {
                TermQueryHandler tqh = new TermQueryHandler();
                Collection annotationData = tqh.getTermsByAnnotations(ontologyName, annotationType, strValue, fromDblValue, toDblValue);
                if (!annotationData.isEmpty()) {
                    retval = new DataHolder[annotationData.size()];
                    int ndx = 0;
                    Iterator i = annotationData.iterator();
                    while (i.hasNext()) {
                        Object[] values = (Object[])i.next();
                        DataHolder data = new DataHolder();
                        data.setTermId((String)values[0]);
                        data.setTermName((String)values[1]);
                        data.setAnnotationType((String)values[2]);
                        data.setAnnotationStringValue((String)values[3]);
                        data.setAnnotationNumberValue(new Double(values[4].toString()));
                        retval[ndx] = data;
                        ++ndx;
                    }
                }
                termCache.putInCache((Object)key, (Object)new CachedEntry((Object)retval));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return retval;
    }

    public HashMap getAllTermsFromOntology(String ontologyName) throws RemoteException {
        HashMap retval = new HashMap();
        String key = ontologyName + ONTOLOGY_ALLTERMS_KEY;
        Cacheable tmpEntry = null;
        try {
            tmpEntry = termCache.getFromCache((Object)key);
            retval = (HashMap)tmpEntry.getValue();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Used cached entry:" + tmpEntry));
            }
        }
        catch (NeedsRefreshException e) {
            OntologyQueryHandler oqh = new OntologyQueryHandler();
            Collection terms = oqh.getAllTermReportFromOntology(ontologyName);
            if (!terms.isEmpty()) {
                Iterator i = terms.iterator();
                while (i.hasNext()) {
                    Object[] values = (Object[])i.next();
                    String acc = (String)values[0];
                    String name = (String)values[1];
                    retval.put(acc, name);
                }
            }
            termCache.putInCache((Object)key, (Object)new CachedEntry((Object)retval));
        }
        return retval;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getOntologyLoadDate(String ontologyName) throws RemoteException {
        if (ontologyName == null || "".equals(ontologyName)) {
            throw new IllegalArgumentException("ontology name cannot be null");
        }
        String retval = null;
        String key = ontologyName + ONTOLOGY_LOAD_DATE_KEY;
        try {
            Cacheable tmpEntry = termCache.getFromCache((Object)key);
            retval = (String)tmpEntry.getValue();
            if (!logger.isDebugEnabled()) return retval;
            logger.debug((Object)("Used cached entry:" + tmpEntry));
            return retval;
        }
        catch (NeedsRefreshException nre) {
            OntologyQueryHandler oqh = new OntologyQueryHandler();
            Collection data = oqh.getOntologyReport(ontologyName, true);
            if (data != null && !data.isEmpty()) {
                if (data.size() != 1) throw new IllegalStateException("More than one fully-loaded ontologies are present for: " + ontologyName);
                Object[] values = (Object[])data.iterator().next();
                if (values[3] == null) throw new IllegalStateException("Loaded ontology with null load date: " + ontologyName);
                retval = values[3].toString();
            }
            termCache.putInCache((Object)key, (Object)new CachedEntry((Object)retval));
        }
        return retval;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

