/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ook.loader.impl;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.commons.collections.MultiMap;
import uk.ac.ebi.ook.config.ConfigurationManager;
import uk.ac.ebi.ook.loader.impl.AbstractLoader;
import uk.ac.ebi.ook.loader.lucene.OntologyIndexer;
import uk.ac.ebi.ook.loader.newt.NEWTParser;
import uk.ac.ebi.ook.loader.newt.NEWTUtilities;
import uk.ac.ebi.ook.loader.newt.SynHolder;
import uk.ac.ebi.ook.model.ojb.AnnotationBean;
import uk.ac.ebi.ook.model.ojb.LoadedOntologyBean;
import uk.ac.ebi.ook.model.ojb.LoaderRunBean;
import uk.ac.ebi.ook.model.ojb.TermBean;
import uk.ac.ebi.ook.model.ojb.TermRelationshipBean;
import uk.ac.ebi.ook.model.ojb.TermSynonymBean;
import uk.ac.ebi.ook.persistence.exceptions.PersistenceException;
import uk.ac.ebi.ook.persistence.query.OntologyQueryHandler;
import uk.ac.ebi.proteomics.common.CommonUtilities;
import uk.ac.ebi.proteomics.common.log.LoggerFactory;

public class NEWTOntologyLoader
extends AbstractLoader {
    private HashMap nodeStorage = null;
    private MultiMap nameStorage = null;
    private HashMap nameMapping = null;
    private HashMap annotationStorage = null;
    private long termCount = 0L;
    private long synCount = 0L;
    private long pathCount = 0L;
    static /* synthetic */ Class class$uk$ac$ebi$ook$loader$impl$NEWTOntologyLoader;

    protected void printUsage() {
        logger.fatal((Object)("java " + (class$uk$ac$ebi$ook$loader$impl$NEWTOntologyLoader == null ? (class$uk$ac$ebi$ook$loader$impl$NEWTOntologyLoader = NEWTOntologyLoader.class$("uk.ac.ebi.ook.loader.impl.NEWTOntologyLoader")) : class$uk$ac$ebi$ook$loader$impl$NEWTOntologyLoader).getName()));
        logger.fatal((Object)"\tnode.dat: Fully qualified path to the node.dat NEWT file");
        logger.fatal((Object)"\tname.dat: Fully qualified path to the name.dat NEWT file");
    }

    protected void configure() {
        logger = LoggerFactory.getLogger((Class)(class$uk$ac$ebi$ook$loader$impl$NEWTOntologyLoader == null ? (class$uk$ac$ebi$ook$loader$impl$NEWTOntologyLoader = NEWTOntologyLoader.class$("uk.ac.ebi.ook.loader.impl.NEWTOntologyLoader")) : class$uk$ac$ebi$ook$loader$impl$NEWTOntologyLoader), (URL)CommonUtilities.getResource((String)"ols-config.properties"));
        this.ONTOLOGY_DEFINITION = "NEWT is the taxonomy database maintained by the UniProt group. It integrates taxonomy data compiled in the NCBI database and data specific to the UniProt Knowledgebase.";
        this.FULL_NAME = "NEWT UniProt Taxonomy Database";
        this.SHORT_NAME = "NEWT";
    }

    public NEWTOntologyLoader() {
        this.configure();
    }

    protected void parse(Object params) throws IOException {
        String[] args = (String[])params;
        NEWTParser newt = new NEWTParser(args[0], args[1]);
        if (newt.parse()) {
            this.nameStorage = newt.getNames();
            this.nodeStorage = newt.getNodes();
            this.annotationStorage = newt.getAnnotations();
            this.nameMapping = new HashMap();
        }
        newt = null;
    }

    protected void process() {
        String tax_id;
        this.initializeCommonObjects();
        int ndx = 0;
        this.nameMapping = NEWTUtilities.createTermNameMapping(this.nameStorage);
        Iterator i = this.nodeStorage.keySet().iterator();
        while (i.hasNext()) {
            tax_id = (String)i.next();
            this.ontologyTerms.put(tax_id.trim(), this.createTerm(tax_id.trim()));
            if (ndx % 25000 == 0) {
                logger.warn((Object)("Processed Terms: " + ndx));
            }
            ++ndx;
        }
        this.nameMapping = null;
        this.nameStorage = null;
        ndx = 0;
        i = this.nodeStorage.keySet().iterator();
        while (i.hasNext()) {
            tax_id = (String)i.next();
            String parent_id = (String)this.nodeStorage.get(tax_id);
            if (parent_id != null) {
                this.ontologyTerms.put(parent_id.trim(), this.createTermRelations(tax_id.trim(), parent_id.trim()));
                if (ndx % 25000 == 0) {
                    logger.warn((Object)("Processed Relations: " + ndx));
                }
                ++ndx;
                continue;
            }
            ((TermBean)this.ontologyTerms.get(tax_id.trim())).setRootTerm(true);
            logger.warn((Object)("parent_id is null for tax_id: " + tax_id));
            logger.warn((Object)(tax_id + " set as root term"));
        }
        Iterator iterator = this.ontologyTerms.keySet().iterator();
        while (iterator.hasNext()) {
            TermBean bean = (TermBean)this.ontologyTerms.get(iterator.next());
            if (bean.getRelationships() != null && !bean.getRelationships().isEmpty()) {
                bean.setLeaf(false);
                continue;
            }
            bean.setLeaf(true);
        }
        this.ontBean.setTerms(this.ontologyTerms.values());
    }

    private TermBean createTerm(String tax_id) {
        ++this.termCount;
        TermBean retval = this.initializeTermBean("NEWT_HOLDER_NO_NAME", tax_id, null);
        TreeSet mappings = (TreeSet)this.nameMapping.get(tax_id);
        ArrayList<TermSynonymBean> syns = new ArrayList<TermSynonymBean>();
        if (mappings != null) {
            boolean first = true;
            Iterator i = mappings.iterator();
            while (i.hasNext()) {
                SynHolder syn = (SynHolder)i.next();
                if (first) {
                    retval.setName(syn.getSynValue());
                    first = false;
                    continue;
                }
                syns.add(this.createTermSynonym(syn.getSynType(), syn.getSynValue()));
            }
        }
        Iterator i = syns.iterator();
        while (i.hasNext()) {
            TermSynonymBean tsb = (TermSynonymBean)i.next();
            tsb.setParentTerm(retval);
        }
        retval.setSynonyms(syns);
        String rank = (String)this.annotationStorage.get(tax_id);
        if (rank != null) {
            AnnotationBean annot = new AnnotationBean();
            annot.setAnnotationType("taxonomy rank");
            annot.setAnnotationStringValue(rank);
            annot.setParentTerm(retval);
            retval.setAnnotations(Collections.singleton(annot));
        }
        retval.setObsolete(false);
        if ("NEWT_HOLDER_NO_NAME".equals(retval.getName())) {
            throw new IllegalStateException("term not properly initialized!: " + tax_id);
        }
        return retval;
    }

    private TermBean createTermRelations(String tax_id, String parent_id) {
        TermBean parentBean = (TermBean)this.ontologyTerms.get(parent_id);
        if (parentBean != null) {
            TermBean childBean = (TermBean)this.ontologyTerms.get(tax_id.trim());
            if (childBean != null) {
                ArrayList<TermRelationshipBean> relations = parentBean.getRelationships();
                if (relations == null) {
                    relations = new ArrayList<TermRelationshipBean>();
                }
                TermRelationshipBean trb = new TermRelationshipBean();
                trb.setSubjectTerm(childBean);
                trb.setObjectTerm(parentBean);
                trb.setPredicateTerm(this.IS_A);
                trb.setParentOntology(this.ontBean);
                relations.add(trb);
                parentBean.setRelationships(relations);
                ++this.pathCount;
            } else {
                logger.warn((Object)("Could not find parent_id >" + parent_id + "< for tax_id >" + tax_id + "<"));
            }
        } else {
            logger.warn((Object)("No term found for tax_id " + tax_id + ". Can't create relations!"));
        }
        return parentBean;
    }

    private TermSynonymBean createTermSynonym(int synType, String synValue) {
        ++this.synCount;
        TermSynonymBean retval = new TermSynonymBean();
        retval.setSynonym(synValue);
        switch (synType) {
            case -5: 
            case -4: 
            case 1: 
            case 99: {
                retval.setSynonymType(this.EXACT);
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 98: {
                retval.setSynonymType(this.RELATED);
                break;
            }
            default: {
                retval.setSynonymType(this.SYNONYM);
            }
        }
        return retval;
    }

    public void dumpStats() {
        logger.warn((Object)("term count: " + this.termCount));
        logger.warn((Object)("terms to load: " + this.ontBean.getTerms().size()));
        logger.warn((Object)("term synonym count: " + this.synCount));
        logger.warn((Object)("term path count: " + this.pathCount));
    }

    protected void load(boolean useFailover) throws PersistenceException {
        if (this.ontBean == null) {
            throw new IllegalStateException("Ontology Bean not initialized. Did you call process()?");
        }
        logger.warn((Object)"Getting main broker.");
        OntologyQueryHandler oqh = new OntologyQueryHandler();
        oqh.storeOntology(this.ontBean, true);
        logger.warn((Object)("Success! Loaded " + this.ontBean.getTerms().size() + " terms for " + this.ontBean.getShortOntologyName()));
        oqh.switchLoadedFlag(this.ontBean.getShortOntologyName());
        if (useFailover) {
            String dbAlias = ConfigurationManager.getProperty("failover.dbalias");
            if (dbAlias == null) {
                throw new PersistenceException("Failover dbalias not properly configured");
            }
            logger.warn((Object)"Getting secondary broker.");
            oqh = new OntologyQueryHandler(dbAlias);
            oqh.storeOntology(this.ontBean, true);
            logger.warn((Object)("Success! Loaded " + this.ontBean.getTerms().size() + " terms for " + this.ontBean.getShortOntologyName()));
            oqh.switchLoadedFlag(this.ontBean.getShortOntologyName());
        }
    }

    protected void unload(boolean useFailover) throws PersistenceException {
        if (this.ontBean == null) {
            throw new IllegalStateException("Ontology Bean not initialized. Did you call process() and load()?");
        }
        OntologyQueryHandler oqh = new OntologyQueryHandler();
        Collection loaded = oqh.getOntologyReport(this.ontBean.getShortOntologyName(), false);
        if (loaded != null && loaded.size() > 0) {
            logger.warn((Object)("Unloading " + loaded.size() + " old ontology(ies), this may take some time."));
            Iterator i = loaded.iterator();
            while (i.hasNext()) {
                Object[] objects = (Object[])i.next();
                boolean isOracle = Boolean.valueOf(ConfigurationManager.getProperty("ols.dbalias.is_oracle"));
                oqh.rawSQLDeleteOntology(((Number)objects[0]).longValue(), isOracle);
            }
        }
        if (useFailover) {
            String dbAlias = ConfigurationManager.getProperty("failover.dbalias");
            if (dbAlias == null) {
                throw new PersistenceException("Failover dbalias not properly configured");
            }
            oqh = new OntologyQueryHandler(dbAlias);
            loaded = oqh.getOntologyReport(this.ontBean.getShortOntologyName(), false);
            if (loaded != null && loaded.size() > 0) {
                logger.warn((Object)("Unloading " + loaded.size() + " old ontology(ies) from failover database."));
                Iterator i = loaded.iterator();
                while (i.hasNext()) {
                    Object[] objects = (Object[])i.next();
                    boolean isOracle = Boolean.valueOf(ConfigurationManager.getProperty("failover.dbalias.is_oracle"));
                    oqh.rawSQLDeleteOntology(((Number)objects[0]).longValue(), isOracle);
                }
            }
        }
    }

    public String getOntologyName() {
        String retval = null;
        if (this.ontBean != null) {
            retval = this.ontBean.getShortOntologyName();
        }
        return retval;
    }

    public int getOntologySize() {
        int retval = -1;
        if (this.ontBean != null && this.ontBean.getTerms() != null) {
            retval = this.ontBean.getTerms().size();
        }
        return retval;
    }

    public static void main(String[] args) {
        NEWTOntologyLoader newt = new NEWTOntologyLoader();
        if (args.length == 0) {
            newt.printUsage();
            System.exit(2);
        }
        try {
            newt.parse(args);
            newt.process();
            newt.dumpStats();
            boolean useFailover = Boolean.valueOf(ConfigurationManager.getProperty("failover.use"));
            newt.load(useFailover);
            newt.unload(useFailover);
            String indexPath = ConfigurationManager.getProperty("lucene.index.path");
            if (indexPath != null) {
                File path = new File(indexPath);
                OntologyIndexer.indexOntology(newt.getOntology(), path);
                OntologyIndexer.mergeAllIndexes(path);
            }
            LoaderRunBean runner = new LoaderRunBean();
            runner.setRunDate(new Date(System.currentTimeMillis()));
            runner.setLoadedOntologies(Collections.singleton(new LoadedOntologyBean(newt.getOntologyName(), newt.getOntologySize())));
            OntologyQueryHandler oqh = new OntologyQueryHandler();
            if (oqh.storeStats(runner)) {
                logger.warn((Object)"Loader run statistics persisted to the database.");
            }
            System.exit(0);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            System.exit(2);
        }
        catch (PersistenceException pe) {
            logger.error((Object)pe.getMessage(), (Throwable)pe);
            System.exit(2);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

