/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ook.loader.impl;

import java.io.IOException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.geneontology.oboedit.datamodel.Dbxref;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.Namespace;
import org.geneontology.oboedit.datamodel.OBOClass;
import org.geneontology.oboedit.datamodel.ObsoletableObject;
import org.geneontology.oboedit.datamodel.PropertyValue;
import org.geneontology.oboedit.datamodel.Synonym;
import uk.ac.ebi.ook.loader.interfaces.Loader;
import uk.ac.ebi.ook.loader.parser.AbstractParser;
import uk.ac.ebi.ook.model.interfaces.DbXref;
import uk.ac.ebi.ook.model.interfaces.Ontology;
import uk.ac.ebi.ook.model.interfaces.Term;
import uk.ac.ebi.ook.model.interfaces.TermRelationship;
import uk.ac.ebi.ook.model.ojb.AnnotationBean;
import uk.ac.ebi.ook.model.ojb.DbXrefBean;
import uk.ac.ebi.ook.model.ojb.OntologyBean;
import uk.ac.ebi.ook.model.ojb.TermBean;
import uk.ac.ebi.ook.model.ojb.TermPathBean;
import uk.ac.ebi.ook.model.ojb.TermRelationshipBean;
import uk.ac.ebi.ook.model.ojb.TermSynonymBean;
import uk.ac.ebi.ook.persistence.exceptions.PersistenceException;
import uk.ac.ebi.ook.persistence.query.OntologyQueryHandler;

public abstract class AbstractLoader
implements Loader {
    protected static Logger logger = Logger.getLogger((Class)(class$uk$ac$ebi$ook$loader$impl$AbstractLoader == null ? (class$uk$ac$ebi$ook$loader$impl$AbstractLoader = AbstractLoader.class$("uk.ac.ebi.ook.loader.impl.AbstractLoader")) : class$uk$ac$ebi$ook$loader$impl$AbstractLoader));
    protected HashMap ontologyTerms = new HashMap(5000);
    protected AbstractParser parser = null;
    protected String ONTOLOGY_DEFINITION;
    protected String FULL_NAME;
    protected String SHORT_NAME;
    protected String QUERY_URL = null;
    protected String SOURCE_URL = null;
    protected OntologyBean ontBean = null;
    protected TermBean IS_A = null;
    protected TermBean PART_OF = null;
    protected TermBean DEVELOPS_FROM = null;
    protected TermBean ALT_ID = null;
    protected TermBean EXACT = null;
    protected TermBean NARROW = null;
    protected TermBean BROAD = null;
    protected TermBean RELATED = null;
    protected TermBean SYNONYM = null;
    private final HashSet PART_OF_SET = new HashSet();
    private final HashSet IS_A_SET = new HashSet();
    private final HashSet DEV_FROM_SET = new HashSet();
    private HashMap unknown_relations = new HashMap();
    private TreeSet rootTerms = new TreeSet();
    protected static final boolean BATCH_MODE = true;
    static /* synthetic */ Class class$uk$ac$ebi$ook$loader$impl$AbstractLoader;

    protected abstract void configure();

    protected abstract void parse(Object var1) throws IOException;

    protected Collection getRootTerms() {
        HashSet<String> retval = new HashSet<String>();
        if (this.parser != null) {
            Collection roots = this.parser.getRootTerms();
            if (roots != null) {
                Iterator i = roots.iterator();
                while (i.hasNext()) {
                    OBOClass OBOClass2 = (OBOClass)i.next();
                    retval.add(this.safeTrim(OBOClass2.getID()));
                }
            }
        } else {
            throw new IllegalStateException("Parser has not been initialized. Did you run configure()?");
        }
        return retval;
    }

    protected void process() {
        Object obj;
        HashSet terms = new HashSet();
        if (this.parser == null) {
            throw new IllegalStateException("parser has not been initialized. Did you run configure()?");
        }
        Set toAdd = this.parser.getTerms();
        if (toAdd != null) {
            terms.addAll(toAdd);
        }
        if ((toAdd = this.parser.getObsoleteTerms()) != null) {
            terms.addAll(toAdd);
        }
        this.initializeCommonObjects();
        logger.warn((Object)("Total Terms to process: " + terms.size()));
        int count = 0;
        Iterator i = terms.iterator();
        while (i.hasNext()) {
            ++count;
            obj = i.next();
            if (obj instanceof OBOClass) {
                this.processTerm((OBOClass)obj);
                if (count % 1000 != 0) continue;
                logger.debug((Object)("Terms Processed: " + count));
                continue;
            }
            logger.warn((Object)("Ignored object: " + obj.toString()));
        }
        logger.warn((Object)"Processing done");
        logger.warn((Object)"Creating relationships");
        count = 0;
        i = terms.iterator();
        while (i.hasNext()) {
            ++count;
            obj = i.next();
            if (obj instanceof OBOClass) {
                this.processTermRelationships((OBOClass)obj);
                if (count % 1000 != 0) continue;
                logger.debug((Object)("Relationships Processed: " + count));
                continue;
            }
            logger.warn((Object)("Ignored object: " + obj.toString()));
        }
        logger.warn((Object)"Processing done");
        this.ontBean.setTerms(this.ontologyTerms.values());
    }

    protected void load() throws PersistenceException {
        if (this.ontBean == null) {
            throw new IllegalStateException("Ontology Bean not initialized. Did you call process()?");
        }
        logger.warn((Object)"Getting broker.");
        OntologyQueryHandler oqh = new OntologyQueryHandler();
        oqh.storeOntology(this.ontBean, true);
        logger.warn((Object)("Success! Loaded " + this.ontBean.getTerms().size() + " terms for " + this.ontBean.getShortOntologyName()));
        oqh.switchLoadedFlag(this.ontBean.getShortOntologyName());
    }

    protected void unload() throws PersistenceException {
        if (this.ontBean == null) {
            throw new IllegalStateException("Ontology Bean not initialized. Did you call process() and load()?");
        }
        OntologyQueryHandler oqh = new OntologyQueryHandler();
        Collection loaded = oqh.getOntologyReport(this.ontBean.getShortOntologyName(), false);
        if (loaded != null && loaded.size() > 0) {
            logger.warn((Object)("Unloading " + loaded.size() + " old ontology(ies), this may take some time."));
            Iterator i = loaded.iterator();
            while (i.hasNext()) {
                Object[] objects = (Object[])i.next();
                oqh.deleteOntology(((Number)objects[0]).longValue());
            }
        }
    }

    protected void initializeCommonObjects() {
        String version;
        if (this.parser != null) {
            version = this.parser.getSession().getCurrentHistory().getVersion();
            if (version == null) {
                java.util.Date tmp = this.parser.getSession().getCurrentHistory().getDate();
                version = tmp != null ? tmp.toString() : new java.util.Date().toString();
            }
        } else {
            version = new java.util.Date().toString();
        }
        this.ontBean = new OntologyBean();
        this.ontBean.setDefinition(this.ONTOLOGY_DEFINITION);
        this.ontBean.setFullOntologyName(this.FULL_NAME);
        this.ontBean.setLoadDate(new Date(GregorianCalendar.getInstance().getTime().getTime()));
        this.ontBean.setShortOntologyName(this.SHORT_NAME);
        this.ontBean.setVersion(version);
        this.ontBean.setFullyLoaded(false);
        this.ontBean.setQueryURL(this.QUERY_URL);
        this.ontBean.setSourceURL(this.SOURCE_URL);
        this.ontologyTerms.clear();
        this.IS_A_SET.clear();
        this.IS_A_SET.add("is_a");
        this.IS_A_SET.add("is_a".toUpperCase());
        this.IS_A_SET.add("isa");
        this.IS_A_SET.add("ISA");
        this.IS_A_SET.add("OBO_REL:is_a");
        this.PART_OF_SET.clear();
        this.PART_OF_SET.add("part_of");
        this.PART_OF_SET.add("part_of".toUpperCase());
        this.PART_OF_SET.add("partof");
        this.PART_OF_SET.add("PARTOF");
        this.PART_OF_SET.add("OBO_REL:part_of");
        this.PART_OF_SET.add("is_part_of");
        this.DEV_FROM_SET.clear();
        this.DEV_FROM_SET.add("develops_from");
        this.DEV_FROM_SET.add("develops_from".toUpperCase());
        this.DEV_FROM_SET.add("DERIVED/DEVELOPS_FROM");
        this.IS_A = this.initializeTermBean("is_a", "relation_type");
        this.ontologyTerms.put(this.IS_A.getIdentifier(), this.IS_A);
        this.PART_OF = this.initializeTermBean("part_of", "relation_type");
        this.ontologyTerms.put(this.PART_OF.getIdentifier(), this.PART_OF);
        this.DEVELOPS_FROM = this.initializeTermBean("develops_from", "relation_type");
        this.ontologyTerms.put(this.DEVELOPS_FROM.getIdentifier(), this.DEVELOPS_FROM);
        this.ALT_ID = this.initializeTermBean("alt_id", "synonym_type");
        this.ontologyTerms.put(this.ALT_ID.getIdentifier(), this.ALT_ID);
        this.EXACT = this.initializeTermBean("exact", "synonym_type");
        this.ontologyTerms.put(this.EXACT.getIdentifier(), this.EXACT);
        this.NARROW = this.initializeTermBean("narrow", "synonym_type");
        this.ontologyTerms.put(this.NARROW.getIdentifier(), this.NARROW);
        this.BROAD = this.initializeTermBean("broad", "synonym_type");
        this.ontologyTerms.put(this.BROAD.getIdentifier(), this.BROAD);
        this.RELATED = this.initializeTermBean("related", "synonym_type");
        this.ontologyTerms.put(this.RELATED.getIdentifier(), this.RELATED);
        this.SYNONYM = this.initializeTermBean("synonym", "synonym_type");
        this.ontologyTerms.put(this.SYNONYM.getIdentifier(), this.SYNONYM);
        this.rootTerms.clear();
        if (this.parser != null) {
            this.rootTerms.addAll(this.getRootTerms());
        }
    }

    private TermBean initializeTermBean(String name, String def) {
        if (name != null && !"".equals(name.trim())) {
            TermBean bean = new TermBean();
            bean.setName(name.trim());
            bean.setIdentifier(name.toUpperCase().trim());
            bean.setDefinition(this.safeTrim(def, true));
            bean.setParentOntology(this.ontBean);
            return bean;
        }
        throw new IllegalArgumentException("Can't have a non-null term name!");
    }

    protected TermBean initializeTermBean(String name, String accession, String def) {
        if (accession != null && !"".equals(accession.trim())) {
            TermBean bean = this.initializeTermBean(name, def);
            bean.setIdentifier(accession.trim());
            return bean;
        }
        throw new IllegalArgumentException("Can't have a non-null term name!");
    }

    private void processTerm(OBOClass obj) {
        if (obj.getID().startsWith("obo:")) {
            logger.debug((Object)("bogus term: " + obj.getID()));
            return;
        }
        TermBean trm = new TermBean();
        trm.setDefinition(this.safeTrim(obj.getDefinition(), true));
        trm.setIdentifier(this.safeTrim(obj.getID()));
        if (this.rootTerms.contains(this.safeTrim(obj.getID()))) {
            trm.setRootTerm(true);
            logger.warn((Object)(obj.getID() + " is a root term"));
        }
        trm.setName(this.safeTrim(obj.getName(), true));
        Namespace nspace = obj.getNamespace();
        if (nspace != null) {
            trm.setNamespace(this.safeTrim(nspace.getID(), true));
        }
        trm.setObsolete(obj.isObsolete());
        trm.setParentOntology(this.ontBean);
        trm.setSynonyms(this.processSynonyms(obj, trm));
        trm.setXrefs(this.processXrefs(obj, trm));
        trm.setAnnotations(this.processAnnotations(obj, trm));
        this.ontologyTerms.put(trm.getIdentifier(), trm);
    }

    private Collection processAnnotations(OBOClass obj, TermBean trm) {
        ArrayList<AnnotationBean> retval = new ArrayList<AnnotationBean>();
        String comment = this.safeTrim(obj.getComment(), true);
        if (comment != null) {
            AnnotationBean annot = new AnnotationBean();
            annot.setAnnotationType("comment");
            annot.setAnnotationStringValue(comment);
            annot.setParentTerm(trm);
            retval.add(annot);
        }
        Set considers = obj.getConsiderReplacements();
        Iterator i = considers.iterator();
        while (i.hasNext()) {
            ObsoletableObject obsolete = (ObsoletableObject)i.next();
            AnnotationBean annot = new AnnotationBean();
            annot.setAnnotationType("consider replacement");
            String val = obsolete.getID();
            if (obsolete.getName() != null) {
                val = val + ": " + obsolete.getName();
            }
            annot.setAnnotationStringValue(val);
            annot.setParentTerm(trm);
            retval.add(annot);
        }
        Set replacers = obj.getReplacedBy();
        Iterator i2 = replacers.iterator();
        while (i2.hasNext()) {
            ObsoletableObject replacedby = (ObsoletableObject)i2.next();
            AnnotationBean annot = new AnnotationBean();
            annot.setAnnotationType("replaced by");
            String val = replacedby.getID();
            if (replacedby.getName() != null) {
                val = val + ": " + replacedby.getName();
            }
            annot.setAnnotationStringValue(val);
            annot.setParentTerm(trm);
            retval.add(annot);
        }
        Set propVal = obj.getPropertyValues();
        Iterator i3 = propVal.iterator();
        while (i3.hasNext()) {
            PropertyValue pv = (PropertyValue)i3.next();
            AnnotationBean annot = new AnnotationBean();
            try {
                if (pv.getValue() == null) {
                    logger.warn((Object)("Error parsing property_value - Ignoring : " + pv.toString()));
                    continue;
                }
                int ndx = -1;
                String tmpStr = pv.getValue();
                ndx = tmpStr.indexOf(32);
                tmpStr = tmpStr.substring(0, ndx);
                logger.debug((Object)("Setting property type: " + tmpStr.trim()));
                annot.setAnnotationType(tmpStr.trim());
                tmpStr = pv.getValue();
                tmpStr = tmpStr.substring(ndx + 1);
                ndx = tmpStr.indexOf("xsd:");
                if (ndx > 0) {
                    tmpStr = tmpStr.substring(0, ndx);
                }
                logger.debug((Object)("Setting property value: " + tmpStr.trim()));
                annot.setAnnotationStringValue(tmpStr.trim());
                annot.setParentTerm(trm);
            }
            catch (RuntimeException re) {
                logger.warn((Object)("Error parsing property_value - Ignoring : " + pv.toString()));
                continue;
            }
            retval.add(annot);
        }
        return retval;
    }

    private Collection processXrefs(OBOClass obj, TermBean trm) {
        Dbxref xref;
        HashSet<DbXref> retval = new HashSet<DbXref>();
        Iterator i = obj.getDbxrefs().iterator();
        while (i.hasNext()) {
            xref = (Dbxref)i.next();
            retval.add(this.createDbXref(xref, trm, 3));
        }
        i = obj.getDefDbxrefs().iterator();
        while (i.hasNext()) {
            xref = (Dbxref)i.next();
            retval.add(this.createDbXref(xref, trm, 2));
        }
        i = obj.getSynonyms().iterator();
        while (i.hasNext()) {
            Synonym snm = (Synonym)i.next();
            Iterator j = snm.getDbxrefs().iterator();
            while (j.hasNext()) {
                Dbxref xref2 = (Dbxref)j.next();
                retval.add(this.createDbXref(xref2, trm, 1));
            }
        }
        return retval;
    }

    private DbXref createDbXref(Dbxref xref, TermBean trm, int xrefType) {
        DbXrefBean retval = new DbXrefBean();
        retval.setParentTerm(trm);
        retval.setDbName(this.safeTrim(xref.getDatabase(), true));
        if (xref.getID() != null && !xref.getID().trim().equals("none")) {
            retval.setAccession(this.safeTrim(xref.getID(), true));
        }
        if (xref.getDesc() != null && !xref.getDesc().trim().equals("none")) {
            retval.setDescription(this.safeTrim(xref.getDesc(), true));
        }
        retval.setXrefType(xrefType);
        return retval;
    }

    private void processTermRelationships(OBOClass obj) {
        if (obj.getID().startsWith("obo:")) {
            logger.debug((Object)("bogus term: " + obj.getID()));
            return;
        }
        TermBean trm = (TermBean)this.ontologyTerms.get(this.safeTrim(obj.getID()));
        trm.setRelationships(this.processRelationships(obj, trm));
        trm.setPaths(this.processPaths(obj, trm));
        if (trm.getRelationships() == null || trm.getRelationships() != null && trm.getRelationships().isEmpty()) {
            trm.setLeaf(true);
        } else {
            trm.setLeaf(false);
        }
        this.ontologyTerms.put(trm.getIdentifier(), trm);
    }

    private Collection processRelationships(OBOClass obj, TermBean trm) {
        HashSet<TermRelationshipBean> retval = new HashSet<TermRelationshipBean>();
        Set children = obj.getChildren();
        Iterator i = children.iterator();
        while (i.hasNext()) {
            Link lnk = (Link)i.next();
            Term childTrm = (Term)this.ontologyTerms.get(this.safeTrim(lnk.getChild().getID()));
            if (childTrm != null) {
                TermRelationshipBean trb = new TermRelationshipBean();
                trb.setSubjectTerm(childTrm);
                trb.setObjectTerm(trm);
                if (this.IS_A_SET.contains(lnk.getType().getID())) {
                    trb.setPredicateTerm(this.IS_A);
                } else if (this.PART_OF_SET.contains(lnk.getType().getID())) {
                    trb.setPredicateTerm(this.PART_OF);
                } else if (this.DEV_FROM_SET.contains(lnk.getType().getID())) {
                    trb.setPredicateTerm(this.DEVELOPS_FROM);
                } else {
                    TermBean otherRelation = this.getUnknownRelationTermBean(lnk.getType().getID());
                    if (otherRelation != null) {
                        trb.setPredicateTerm(otherRelation);
                    } else {
                        logger.warn((Object)("Unable to create unknown relation type: >" + lnk.getType().getID() + "<"));
                        continue;
                    }
                }
                trb.setParentOntology(this.ontBean);
                retval.add(trb);
                continue;
            }
            logger.debug((Object)("No object term found for link: " + lnk.toString()));
        }
        return retval;
    }

    private TermBean getUnknownRelationTermBean(String relationType) {
        TermBean retval = null;
        if (relationType != null && (retval = (TermBean)this.unknown_relations.get(relationType.trim().toUpperCase())) == null) {
            retval = this.initializeTermBean(relationType.trim(), "relation_type");
            logger.warn((Object)("Created unkonwn relation type: " + relationType));
            this.unknown_relations.put(relationType.trim().toUpperCase(), retval);
            this.ontologyTerms.put(retval.getIdentifier(), retval);
        }
        return retval;
    }

    private Collection processPaths(OBOClass obj, TermBean trm) {
        HashSet retval = new HashSet();
        HashMap paths = this.parser.computeChildPaths(1, this.IS_A_SET, (LinkedObject)obj);
        retval.addAll(this.createTermPathBeans(paths, 1, this.IS_A, trm));
        HashSet traversingSet = new HashSet();
        traversingSet.addAll(this.PART_OF_SET);
        traversingSet.addAll(this.IS_A_SET);
        paths = this.parser.computeChildPaths(1, traversingSet, (LinkedObject)obj);
        retval.addAll(this.createTermPathBeans(paths, 2, this.PART_OF, trm));
        traversingSet = new HashSet();
        traversingSet.addAll(this.DEV_FROM_SET);
        traversingSet.addAll(this.IS_A_SET);
        paths = this.parser.computeChildPaths(1, traversingSet, (LinkedObject)obj);
        retval.addAll(this.createTermPathBeans(paths, 3, this.DEVELOPS_FROM, trm));
        return retval;
    }

    private Collection createTermPathBeans(HashMap paths, int relationTypeId, TermBean relationBean, TermBean trm) {
        HashSet<TermPathBean> retval = new HashSet<TermPathBean>();
        Iterator i = paths.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            Integer value = (Integer)paths.get(key);
            Term objTrm = (Term)this.ontologyTerms.get(key);
            if (objTrm != null) {
                TermPathBean tpb = new TermPathBean();
                tpb.setDistance(value);
                tpb.setSubjectTerm(objTrm);
                tpb.setObjectTerm(trm);
                tpb.setPredicateTerm(relationBean);
                tpb.setRelationshipTypeId(new Long(relationTypeId));
                tpb.setParentOntology(this.ontBean);
                retval.add(tpb);
                continue;
            }
            logger.debug((Object)("No object term found for term path: " + trm.getIdentifier() + "->" + key));
        }
        return retval;
    }

    private Collection processSynonyms(OBOClass inTerm, TermBean outTerm) {
        HashSet<TermSynonymBean> retval = new HashSet<TermSynonymBean>();
        Set syns = inTerm.getSynonyms();
        Iterator i = syns.iterator();
        while (i.hasNext()) {
            Synonym aSyn = (Synonym)i.next();
            TermSynonymBean tsb = new TermSynonymBean();
            tsb.setParentTerm(outTerm);
            String synVal = this.safeTrim(aSyn.getText(), true);
            if (synVal != null) {
                tsb.setSynonym(synVal);
                switch (aSyn.getScope()) {
                    case 1: {
                        tsb.setSynonymType(this.EXACT);
                        break;
                    }
                    case 2: {
                        tsb.setSynonymType(this.NARROW);
                        break;
                    }
                    case 3: {
                        tsb.setSynonymType(this.BROAD);
                        break;
                    }
                    case 0: {
                        tsb.setSynonymType(this.RELATED);
                        break;
                    }
                    default: {
                        tsb.setSynonymType(this.SYNONYM);
                    }
                }
                retval.add(tsb);
                continue;
            }
            logger.info((Object)("Null Synonym value encountered for " + outTerm.getIdentifier()));
        }
        Set altIDs = inTerm.getSecondaryIDs();
        Iterator i2 = altIDs.iterator();
        while (i2.hasNext()) {
            String altID = (String)i2.next();
            TermSynonymBean tsb = new TermSynonymBean();
            tsb.setParentTerm(outTerm);
            tsb.setSynonym(this.safeTrim(altID));
            tsb.setSynonymType(this.ALT_ID);
            retval.add(tsb);
        }
        return retval;
    }

    protected void dumpOntology() {
        Collection roots = this.getRootTerms();
        Iterator i = roots.iterator();
        while (i.hasNext()) {
            String id = (String)i.next();
            logger.debug((Object)("Root term: " + id));
            this.dumpTerm((Term)this.ontologyTerms.get(id), "");
        }
    }

    protected void dumpOntologyStats() {
        int ts = 0;
        int tp = 0;
        int tr = 0;
        int ta = 0;
        Iterator i = this.ontologyTerms.values().iterator();
        while (i.hasNext()) {
            TermBean tb = (TermBean)i.next();
            if (tb.getSynonyms() != null) {
                ts += tb.getSynonyms().size();
            }
            if (tb.getPaths() != null) {
                tp += tb.getPaths().size();
            }
            if (tb.getRelationships() != null) {
                tr += tb.getRelationships().size();
            }
            if (tb.getAnnotations() == null) continue;
            ta += tb.getAnnotations().size();
        }
        logger.warn((Object)("Number of terms: " + this.ontologyTerms.size()));
        logger.warn((Object)("Number of synonyms: " + ts));
        logger.warn((Object)("Number of relationships: " + tr));
        logger.warn((Object)("Number of paths: " + tp));
        logger.warn((Object)("Number of annotations: " + ta));
    }

    protected void dumpTerm(Term term, String indent) {
        if (indent.length() > 15) {
            return;
        }
        if (term != null) {
            logger.debug((Object)(indent + "id: " + term.getIdentifier()));
            logger.debug((Object)(indent + "name: " + term.getName()));
            if (term.getSynonyms() != null) {
                logger.debug((Object)(indent + "nb syn: " + term.getSynonyms().size()));
            }
            if (term.getAnnotations() != null) {
                logger.debug((Object)(indent + "nb annot: " + term.getAnnotations().size()));
            }
            if (term.getRelationships() != null) {
                Iterator j = term.getRelationships().iterator();
                while (j.hasNext()) {
                    TermRelationship tr = (TermRelationship)j.next();
                    String relationStr = indent + tr.getSubjectTerm().getName() + " " + tr.getPredicateTerm().getName() + " " + tr.getObjectTerm().getName();
                    logger.debug((Object)relationStr);
                    this.dumpTerm(tr.getSubjectTerm(), indent + " ");
                }
            }
        }
    }

    protected String safeTrim(String inStr, boolean escapeXML) {
        if (inStr != null) {
            String tmp = inStr.trim();
            if (tmp.length() > 0) {
                if (escapeXML) {
                    return StringEscapeUtils.escapeXml((String)tmp);
                }
                return tmp;
            }
            return null;
        }
        return null;
    }

    protected String safeTrim(String inStr) {
        return this.safeTrim(inStr, false);
    }

    public Ontology getOntology() throws IOException {
        if (this.ontBean != null) {
            return this.ontBean;
        }
        throw new IllegalStateException("Ontology bean not properly initialized. Did you call the proper sequence of methods: configure(), parse(), process()?");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

