/*
 * Decompiled with CFR 0.152.
 */
package hidden.de.zeigermann.xml.simpleImporter;

import hidden.de.zeigermann.xml.simpleImporter.Item;
import hidden.de.zeigermann.xml.simpleImporter.SimpleImportHandler;
import hidden.de.zeigermann.xml.simpleImporter.SimpleImporterException;
import hidden.de.zeigermann.xml.simpleImporter.SimplePath;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class SimpleImporter {
    private boolean trimContent = true;
    private boolean makeCopy = false;
    private boolean zeroLengthIsNull = true;
    private boolean includeLeadingCDataIntoStartElementCallback = true;
    private boolean fullDebug = false;
    private boolean useQName = true;
    private boolean buildComplexPath = false;
    protected SAXParserFactory factory;
    protected List callbackHandlerList = new ArrayList();
    protected StringBuffer currentMixedPCData = null;
    protected boolean foundMixedPCData = false;
    protected StringBuffer firstPCData = null;
    protected boolean isFirstPCData = true;
    protected ParseElement currentElement = null;
    protected PathStack parseStack = new PathStack();
    protected String debugBuffer = null;

    public SimpleImporter() {
        this.factory = SAXParserFactory.newInstance();
    }

    public boolean getFoundMixedPCData() {
        return this.foundMixedPCData;
    }

    public boolean getUseQName() {
        return this.useQName;
    }

    public void setUseQName(boolean useQName) {
        this.useQName = useQName;
    }

    public boolean getBuildComplexPath() {
        return this.buildComplexPath;
    }

    public void setBuildComplexPath(boolean buildComplexPath) {
        this.buildComplexPath = buildComplexPath;
    }

    public void setFullDebugMode(boolean fullDebug) {
        this.fullDebug = fullDebug;
    }

    public boolean getFullDebugMode() {
        return this.fullDebug;
    }

    public String getParsedStreamForDebug() {
        if (!this.getFullDebugMode()) {
            return null;
        }
        return this.debugBuffer;
    }

    public boolean getIncludeLeadingCDataIntoStartElementCallback() {
        return this.includeLeadingCDataIntoStartElementCallback;
    }

    public void setIncludeLeadingCDataIntoStartElementCallback(boolean includeLeadingCDataIntoStartElementCallback) {
        this.includeLeadingCDataIntoStartElementCallback = includeLeadingCDataIntoStartElementCallback;
    }

    public boolean getTrimContent() {
        return this.trimContent;
    }

    public void setTrimContent(boolean trimContent) {
        this.trimContent = trimContent;
    }

    public boolean getZeroLengthIsNull() {
        return this.zeroLengthIsNull;
    }

    public void setZeroLengthIsNull(boolean zeroLengthIsNull) {
        this.zeroLengthIsNull = zeroLengthIsNull;
    }

    public boolean getMakeCopy() {
        return this.makeCopy;
    }

    public void setMakeCopy(boolean makeCopy) {
        this.makeCopy = makeCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSimpleImportHandler(SimpleImportHandler callbackHandler) {
        List list = this.callbackHandlerList;
        synchronized (list) {
            if (!this.callbackHandlerList.contains(callbackHandler)) {
                this.callbackHandlerList.add(callbackHandler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSimpleImportHandler(SimpleImportHandler callbackHandler) {
        List list = this.callbackHandlerList;
        synchronized (list) {
            this.callbackHandlerList.remove(callbackHandler);
        }
    }

    public synchronized void parseUrlOrFile(String urlOrFileName) throws ParserConfigurationException, SAXException, IOException, SimpleImporterException {
        IOException urlException = null;
        IOException fileException = null;
        InputStream in = null;
        try {
            URL url = new URL(urlOrFileName);
            URLConnection urlConnection = url.openConnection();
            in = urlConnection.getInputStream();
        }
        catch (MalformedURLException mue) {
            urlException = mue;
        }
        catch (IOException ioe) {
            urlException = ioe;
        }
        try {
            in = new FileInputStream(urlOrFileName);
        }
        catch (IOException ioe) {
            fileException = ioe;
        }
        if (in == null) {
            throw new SimpleImporterException("Could not parse " + urlOrFileName + ", is neither URL (" + urlException.getMessage() + ") nor file (" + fileException.getMessage() + ").");
        }
        this.parse(new InputSource(new BufferedInputStream(in)));
    }

    public synchronized void parse(InputSource is) throws ParserConfigurationException, SAXException, IOException {
        this.firstPCData = null;
        this.currentElement = null;
        this.factory.setNamespaceAware(!this.useQName || this.buildComplexPath);
        SAXParser parser = this.factory.newSAXParser();
        if (this.getFullDebugMode()) {
            InputSource preReadIn = this.bufferParserStream(is);
            parser.parse(preReadIn, (DefaultHandler)new SAXHandler());
        } else {
            parser.parse(is, (DefaultHandler)new SAXHandler());
        }
    }

    private InputSource bufferParserStream(InputSource is) throws IOException {
        String line;
        String encoding;
        StringBuffer buf = new StringBuffer();
        Reader reader = is.getCharacterStream() != null ? is.getCharacterStream() : ((encoding = is.getEncoding()) != null ? new InputStreamReader(is.getByteStream(), encoding) : new InputStreamReader(is.getByteStream()));
        BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        while ((line = bufferedReader.readLine()) != null) {
            buf.append(line).append('\n');
        }
        this.debugBuffer = buf.toString();
        return new InputSource(new StringReader(this.debugBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callBackStartElementWhenReady() {
        if (this.currentElement != null) {
            String content = this.getFirstPCData();
            SimplePath path = this.buildComplexPath ? new SimplePath(this.currentElement.path, this.currentElement.pathList.toArray(new Item[this.currentElement.pathList.size()])) : new SimplePath(this.currentElement.path);
            List list = this.callbackHandlerList;
            synchronized (list) {
                Iterator it = this.callbackHandlerList.iterator();
                while (it.hasNext()) {
                    SimpleImportHandler callbackHandler = (SimpleImportHandler)it.next();
                    if (this.getMakeCopy()) {
                        callbackHandler.startElement(new SimplePath(path), this.currentElement.name, new AttributesImpl(this.currentElement.attributes), content);
                        continue;
                    }
                    callbackHandler.startElement(path, this.currentElement.name, this.currentElement.attributes, content);
                }
            }
            this.firstPCData = null;
            this.currentElement = null;
        }
    }

    private void sendCharacters(String text) {
        if (text == null) {
            return;
        }
        if (this.isFirstPCData) {
            if (this.includeLeadingCDataIntoStartElementCallback) {
                this.addToFirstPCData(text);
            } else {
                this.sendCData(text);
            }
        } else {
            this.foundMixedPCData = true;
            this.sendCData(text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callBackCDATAWhenReady() {
        this.callBackStartElementWhenReady();
        if (this.currentMixedPCData == null) {
            return;
        }
        String text = this.currentMixedPCData.toString();
        if ((text = this.trimPCData(text)) == null) {
            return;
        }
        SimplePath path = this.buildComplexPath ? new SimplePath(this.parseStack.getPath(), this.parseStack.getPathList().toArray(new Item[this.parseStack.getPathList().size()])) : new SimplePath(this.parseStack.getPath());
        List list = this.callbackHandlerList;
        synchronized (list) {
            Iterator it = this.callbackHandlerList.iterator();
            while (it.hasNext()) {
                SimpleImportHandler callbackHandler = (SimpleImportHandler)it.next();
                if (this.getMakeCopy()) {
                    callbackHandler.cData(new SimplePath(path), text);
                    continue;
                }
                callbackHandler.cData(path, text);
            }
        }
        this.currentMixedPCData = null;
    }

    private void sendCData(String text) {
        if (this.currentMixedPCData == null) {
            this.currentMixedPCData = new StringBuffer(text.length());
        }
        this.currentMixedPCData.append(text);
    }

    private void addToFirstPCData(String text) {
        if (this.firstPCData == null) {
            this.firstPCData = new StringBuffer(text.length());
        }
        this.firstPCData.append(text);
    }

    private String getFirstPCData() {
        if (this.firstPCData == null) {
            return null;
        }
        String text = this.firstPCData.toString();
        return this.trimPCData(text);
    }

    private String trimPCData(String pcData) {
        if (pcData == null) {
            return null;
        }
        if (this.getTrimContent()) {
            pcData = pcData.trim();
        }
        if (pcData.length() == 0 && this.getZeroLengthIsNull()) {
            return null;
        }
        return pcData;
    }

    private final class PathStack {
        private List pathStack;

        public PathStack(int initialCapacity) {
            this.pathStack = new ArrayList(initialCapacity);
        }

        public PathStack() {
            this.pathStack = new ArrayList();
        }

        public String getPath() {
            StringBuffer path = new StringBuffer(100);
            path.append('/');
            Iterator it = this.pathStack.iterator();
            while (it.hasNext()) {
                Object element = it.next();
                String pathElement = SimpleImporter.this.buildComplexPath ? ((Item)element).getName() : (String)element;
                path.append(pathElement).append('/');
            }
            return path.toString();
        }

        public List getPathList() {
            return this.pathStack;
        }

        public String toString() {
            return this.getPath();
        }

        public void push(String namespaceURI, String name) {
            if (SimpleImporter.this.buildComplexPath) {
                this.pathStack.add(new Item(name, namespaceURI));
            } else {
                this.pathStack.add(name);
            }
        }

        public int size() {
            return this.pathStack.size();
        }

        public boolean empty() {
            return this.pathStack.size() <= 0;
        }

        public Object peek() {
            int size = this.pathStack.size();
            if (size > 0) {
                return this.pathStack.get(size - 1);
            }
            return null;
        }

        public Object pop() {
            int size = this.pathStack.size();
            if (size > 0) {
                Object o = this.pathStack.get(size - 1);
                this.pathStack.remove(size - 1);
                return o;
            }
            return null;
        }
    }

    private final class SAXHandler
    extends DefaultHandler {
        private SAXHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startDocument() {
            List list = SimpleImporter.this.callbackHandlerList;
            synchronized (list) {
                Iterator it = SimpleImporter.this.callbackHandlerList.iterator();
                while (it.hasNext()) {
                    SimpleImportHandler callbackHandler = (SimpleImportHandler)it.next();
                    callbackHandler.startDocument();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void endDocument() {
            SimpleImporter.this.callBackStartElementWhenReady();
            SimpleImporter.this.callBackCDATAWhenReady();
            List list = SimpleImporter.this.callbackHandlerList;
            synchronized (list) {
                Iterator it = SimpleImporter.this.callbackHandlerList.iterator();
                while (it.hasNext()) {
                    SimpleImportHandler callbackHandler = (SimpleImportHandler)it.next();
                    callbackHandler.endDocument();
                }
            }
        }

        public void characters(char[] ch, int start, int length) {
            if (length < 1) {
                return;
            }
            String text = new String(ch, start, length);
            SimpleImporter.this.sendCharacters(text);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void endElement(String namespaceURI, String localName, String qName) {
            SimpleImporter.this.callBackStartElementWhenReady();
            SimpleImporter.this.callBackCDATAWhenReady();
            String name = !SimpleImporter.this.useQName || qName == null || qName.length() == 0 ? localName : qName;
            SimplePath path = SimpleImporter.this.buildComplexPath ? new SimplePath(SimpleImporter.this.parseStack.getPath(), SimpleImporter.this.parseStack.getPathList().toArray(new Item[SimpleImporter.this.parseStack.getPathList().size()])) : new SimplePath(SimpleImporter.this.parseStack.getPath());
            List list = SimpleImporter.this.callbackHandlerList;
            synchronized (list) {
                Iterator it = SimpleImporter.this.callbackHandlerList.iterator();
                while (it.hasNext()) {
                    SimpleImportHandler callbackHandler = (SimpleImportHandler)it.next();
                    if (SimpleImporter.this.getMakeCopy()) {
                        callbackHandler.endElement(new SimplePath(path), name);
                        continue;
                    }
                    callbackHandler.endElement(path, name);
                }
            }
            if (SimpleImporter.this.parseStack.empty()) {
                throw new SimpleImporterException("Umatchted end tag: " + name);
            }
            Object top = SimpleImporter.this.parseStack.peek();
            String topName = SimpleImporter.this.buildComplexPath ? ((Item)top).getName() : (String)top;
            if (!name.equals(topName)) {
                throw new SimpleImporterException("End tag " + name + " does not match start tag " + top);
            }
            SimpleImporter.this.parseStack.pop();
            SimpleImporter.this.isFirstPCData = false;
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            SimpleImporter.this.callBackStartElementWhenReady();
            SimpleImporter.this.callBackCDATAWhenReady();
            String name = !SimpleImporter.this.useQName || qName == null || qName.length() == 0 ? localName : qName;
            SimpleImporter.this.parseStack.push(namespaceURI, name);
            AttributesImpl attributesCopy = new AttributesImpl(atts);
            SimpleImporter.this.currentElement = new ParseElement(name, SimpleImporter.this.parseStack.getPath(), SimpleImporter.this.parseStack.getPathList(), attributesCopy);
            SimpleImporter.this.isFirstPCData = true;
        }
    }

    private static final class ParseElement {
        public String name;
        public String path;
        public List pathList;
        public AttributesImpl attributes;

        public ParseElement(String name, String path, List pathList, AttributesImpl attributes) {
            this.name = name;
            this.path = path;
            this.attributes = attributes;
            this.pathList = pathList;
        }
    }
}

