/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.util;

import java.util.HashSet;
import org.exolab.castor.types.AnyNode;
import org.exolab.castor.xml.Namespaces;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class AnyNode2SAX2 {
    private AnyNode _node;
    private ContentHandler _handler;
    private HashSet _elements = new HashSet();
    private Namespaces _context;

    public AnyNode2SAX2() {
    }

    public AnyNode2SAX2(AnyNode node) {
        this();
        this._node = node;
        this._context = new Namespaces();
    }

    public AnyNode2SAX2(AnyNode node, Namespaces context) {
        this();
        this._node = node;
        this._context = context == null ? new Namespaces() : context;
    }

    public void setContentHandler(ContentHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("AnyNode2SAX2#setContentHandler 'null' value for handler");
        }
        this._handler = handler;
    }

    public static void fireEvents(AnyNode node, ContentHandler handler) throws SAXException {
        AnyNode2SAX2.fireEvents(node, handler, null);
    }

    public static void fireEvents(AnyNode node, ContentHandler handler, Namespaces context) throws SAXException {
        AnyNode2SAX2 eventProducer = new AnyNode2SAX2(node, context);
        eventProducer.setContentHandler(handler);
        eventProducer.start();
    }

    public void start() throws SAXException {
        if (this._node == null || this._handler == null) {
            return;
        }
        this.processAnyNode(this._node, this._handler);
    }

    private void processAnyNode(AnyNode node, ContentHandler handler) throws SAXException {
        String value;
        if (node == null || handler == null) {
            throw new IllegalArgumentException();
        }
        if (!this._elements.add(node)) {
            return;
        }
        if (node.getNodeType() == 1) {
            AnyNode tempNode;
            String name = node.getLocalName();
            String prefix = null;
            for (tempNode = node.getFirstNamespace(); tempNode != null; tempNode = tempNode.getNextSibling()) {
                String value2;
                prefix = tempNode.getNamespacePrefix();
                if (prefix == null) {
                    prefix = "";
                }
                if ((value2 = tempNode.getNamespaceURI()) == null) {
                    value2 = "";
                }
                handler.startPrefixMapping(prefix, value2);
                if (value2 == null || value2.length() <= 0) continue;
                this._context.addNamespace(prefix, value2);
            }
            AttributesImpl atts = new AttributesImpl();
            String xmlName = null;
            String value3 = null;
            String attUri = null;
            String attPrefix = null;
            for (tempNode = node.getFirstAttribute(); tempNode != null; tempNode = tempNode.getNextSibling()) {
                String localName = xmlName = tempNode.getLocalName();
                attUri = tempNode.getNamespaceURI();
                if (attUri != null) {
                    attPrefix = this._context.getNamespacePrefix(attUri);
                } else {
                    attUri = "";
                }
                if (attPrefix != null && attPrefix.length() > 0) {
                    xmlName = attPrefix + ':' + xmlName;
                }
                value3 = tempNode.getStringValue();
                atts.addAttribute(attUri, localName, xmlName, "CDATA", value3);
            }
            this._context = this._context.createNamespaces();
            String nsPrefix = node.getNamespacePrefix();
            String nsURI = node.getNamespaceURI();
            String qName = null;
            if (nsURI != null && nsURI.length() > 0) {
                String tempPrefix = this._context.getNamespacePrefix(nsURI);
                if (tempPrefix != null) {
                    nsPrefix = tempPrefix;
                } else {
                    this._context.addNamespace(nsPrefix, nsURI);
                }
            } else {
                nsURI = "";
            }
            if (nsPrefix != null) {
                int len = nsPrefix.length();
                if (len > 0) {
                    StringBuffer sb = new StringBuffer(len + name.length() + 1);
                    sb.append(nsPrefix);
                    sb.append(':');
                    sb.append(name);
                    qName = sb.toString();
                } else {
                    qName = name;
                }
            } else {
                qName = name;
            }
            try {
                handler.startElement(nsURI, name, qName, atts);
            }
            catch (SAXException sx) {
                throw new SAXException(sx);
            }
            for (tempNode = node.getFirstChild(); tempNode != null; tempNode = tempNode.getNextSibling()) {
                this.processAnyNode(tempNode, handler);
            }
            try {
                handler.endElement(nsURI, name, qName);
                this._context = this._context.getParent();
                for (tempNode = node.getFirstNamespace(); tempNode != null; tempNode = tempNode.getNextSibling()) {
                    prefix = tempNode.getNamespacePrefix();
                    if (prefix == null) {
                        prefix = "";
                    }
                    handler.endPrefixMapping(prefix);
                }
            }
            catch (SAXException sx) {
                throw new SAXException(sx);
            }
        }
        if (node.getNodeType() == 6 && (value = node.getStringValue()) != null && value.length() > 0) {
            char[] chars = value.toCharArray();
            try {
                handler.characters(chars, 0, chars.length);
            }
            catch (SAXException sx) {
                throw new SAXException(sx);
            }
        }
    }

    private void processTextNode(AnyNode node, ContentHandler handler) throws SAXException {
        if (node.getNodeType() != 6) {
            String err = "This node can not be handle by processTextNode.";
            throw new IllegalArgumentException(err);
        }
        String value = node.getStringValue();
        if (value != null && value.length() > 0) {
            char[] chars = value.toCharArray();
            try {
                handler.characters(chars, 0, chars.length);
            }
            catch (SAXException sx) {
                throw new SAXException(sx);
            }
        }
    }
}

