/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.jdo.DuplicateIdentityException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.QueryException;
import org.exolab.castor.jdo.engine.SQLColumnInfo;
import org.exolab.castor.jdo.engine.SQLEngine;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.spi.Complex;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.persist.spi.QueryExpression;
import org.exolab.castor.util.Messages;

public final class SQLStatementLookup {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$exolab$castor$jdo$engine$SQLStatementLookup == null ? (class$org$exolab$castor$jdo$engine$SQLStatementLookup = SQLStatementLookup.class$("org.exolab.castor.jdo.engine.SQLStatementLookup")) : class$org$exolab$castor$jdo$engine$SQLStatementLookup));
    private final SQLEngine _engine;
    private final PersistenceFactory _factory;
    private final String _type;
    private final String _mapTo;
    private String _statement;
    static /* synthetic */ Class class$org$exolab$castor$jdo$engine$SQLStatementLookup;

    public SQLStatementLookup(SQLEngine engine, PersistenceFactory factory) throws MappingException {
        this._engine = engine;
        this._factory = factory;
        this._type = engine.getDescriptor().getJavaClass().getName();
        this._mapTo = engine.getDescriptor().getTableName();
        this.buildStatement();
    }

    private void buildStatement() throws MappingException {
        try {
            SQLColumnInfo[] _ids = this._engine.getColumnInfoForIdentities();
            QueryExpression query = this._factory.getQueryExpression();
            for (int i = 0; i < _ids.length; ++i) {
                query.addParameter(this._mapTo, _ids[i].getName(), "=");
            }
            this._statement = query.getStatement(true);
        }
        catch (QueryException except) {
            LOG.warn((Object)"Problem building SQL", (Throwable)except);
            throw new MappingException(except);
        }
    }

    public Object executeStatement(Object conn, Object identity) throws PersistenceException {
        SQLColumnInfo[] ids = this._engine.getColumnInfoForIdentities();
        PreparedStatement stmt = null;
        try {
            stmt = ((Connection)conn).prepareStatement(this._statement);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.format("jdo.duplicateKeyCheck", this._statement));
            }
            int count = 1;
            if (identity instanceof Complex) {
                Complex id = (Complex)identity;
                if (id.size() != ids.length || ids.length <= 1) {
                    throw new PersistenceException("Size of complex field mismatched!");
                }
                for (int i = 0; i < ids.length; ++i) {
                    stmt.setObject(count++, ids[i].toSQL(id.get(i)));
                }
            } else {
                if (ids.length != 1) {
                    throw new PersistenceException("Complex field expected!");
                }
                stmt.setObject(count++, ids[0].toSQL(identity));
            }
            if (stmt.executeQuery().next()) {
                stmt.close();
                throw new DuplicateIdentityException(Messages.format("persist.duplicateIdentity", this._type, identity));
            }
        }
        catch (SQLException except2) {
            // empty catch block
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException except2) {
            LOG.warn((Object)"Problem closing JDBC statement", (Throwable)except2);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

