/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.jdo.engine.AbstractConnectionFactory;
import org.castor.jdo.engine.DatabaseRegistry;
import org.castor.jdo.util.ClassLoadingUtils;
import org.castor.persist.ProposedObject;
import org.castor.persist.TransactionContext;
import org.exolab.castor.jdo.CacheManager;
import org.exolab.castor.jdo.ClassNotPersistenceCapableException;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.DatabaseNotFoundException;
import org.exolab.castor.jdo.DuplicateIdentityException;
import org.exolab.castor.jdo.LockNotGrantedException;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.ObjectModifiedException;
import org.exolab.castor.jdo.ObjectNotFoundException;
import org.exolab.castor.jdo.ObjectNotPersistentException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.Query;
import org.exolab.castor.jdo.TransactionAbortedException;
import org.exolab.castor.jdo.TransactionNotInProgressException;
import org.exolab.castor.jdo.engine.OQLQueryImpl;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.PersistenceInfo;
import org.exolab.castor.persist.PersistenceInfoGroup;
import org.exolab.castor.persist.TxSynchronizable;
import org.exolab.castor.persist.spi.CallbackInterceptor;
import org.exolab.castor.persist.spi.InstanceFactory;
import org.exolab.castor.util.LocalConfiguration;
import org.exolab.castor.util.Messages;

public abstract class AbstractDatabaseImpl
implements Database {
    private static final String TxSynchronizableProperty = "org.exolab.castor.persist.TxSynchronizable";
    private static Log _log = LogFactory.getFactory().getInstance(class$org$exolab$castor$jdo$engine$AbstractDatabaseImpl == null ? (class$org$exolab$castor$jdo$engine$AbstractDatabaseImpl = AbstractDatabaseImpl.class$("org.exolab.castor.jdo.engine.AbstractDatabaseImpl")) : class$org$exolab$castor$jdo$engine$AbstractDatabaseImpl);
    protected PersistenceInfoGroup _scope;
    protected TransactionContext _ctx;
    private ArrayList _synchronizables;
    protected int _lockTimeout;
    protected CallbackInterceptor _callback;
    protected InstanceFactory _instanceFactory;
    protected String _dbName;
    protected boolean _autoStore;
    protected ClassLoader _classLoader;
    private CacheManager cacheManager;
    static /* synthetic */ Class class$org$exolab$castor$jdo$engine$AbstractDatabaseImpl;

    public AbstractDatabaseImpl(String dbName, int lockTimeout, CallbackInterceptor callback, InstanceFactory instanceFactory, ClassLoader classLoader, boolean autoStore) throws DatabaseNotFoundException {
        this._autoStore = autoStore;
        AbstractConnectionFactory factory = null;
        try {
            factory = DatabaseRegistry.getConnectionFactory(dbName);
        }
        catch (MappingException ex) {
            throw new DatabaseNotFoundException(Messages.format("jdo.dbNoMapping", dbName));
        }
        this._scope = new PersistenceInfoGroup(new LockEngine[]{factory.getEngine()});
        this._callback = callback;
        this._instanceFactory = instanceFactory;
        this._dbName = dbName;
        this._lockTimeout = lockTimeout;
        this._classLoader = classLoader;
        this.loadSynchronizables();
    }

    LockEngine getLockEngine() {
        return this._scope.getLockEngine();
    }

    public PersistenceInfoGroup getScope() {
        return this._scope;
    }

    public void setAutoStore(boolean autoStore) {
        this._autoStore = autoStore;
    }

    public boolean isAutoStore() {
        if (this._ctx != null) {
            return this._ctx.isAutoStore();
        }
        return this._autoStore;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public String getDatabaseName() {
        return this._dbName;
    }

    public abstract void close() throws PersistenceException;

    public boolean isClosed() {
        return this._scope == null;
    }

    public boolean isLocked(Class cls, Object identity) {
        if (this._scope == null) {
            throw new IllegalStateException(Messages.message("jdo.dbClosed"));
        }
        if (this.isActive()) {
            return this._ctx.isLocked(cls, identity, this._scope.getLockEngine());
        }
        return false;
    }

    public Object load(Class type, Object identity) throws ObjectNotFoundException, LockNotGrantedException, TransactionNotInProgressException, PersistenceException {
        return this.load(type, identity, null, null);
    }

    public Object load(Class type, Object identity, Object object) throws TransactionNotInProgressException, ObjectNotFoundException, LockNotGrantedException, PersistenceException {
        return this.load(type, identity, object, null);
    }

    public Object load(Class type, Object identity, AccessMode mode) throws TransactionNotInProgressException, ObjectNotFoundException, LockNotGrantedException, PersistenceException {
        return this.load(type, identity, null, mode);
    }

    private Object load(Class type, Object identity, Object object, AccessMode mode) throws TransactionNotInProgressException, ObjectNotFoundException, LockNotGrantedException, PersistenceException {
        TransactionContext tx = this.getTransaction();
        PersistenceInfo info = this._scope.getPersistenceInfo(type);
        ProposedObject proposedObject = new ProposedObject();
        return tx.load(info.engine, info.molder, identity, proposedObject, mode);
    }

    public void create(Object object) throws ClassNotPersistenceCapableException, DuplicateIdentityException, TransactionNotInProgressException, PersistenceException {
        TransactionContext tx = this.getTransaction();
        PersistenceInfo info = this._scope.getPersistenceInfo(object.getClass());
        tx.create(info.engine, info.molder, object, null);
    }

    public CacheManager getCacheManager() {
        if (this.cacheManager == null) {
            this.cacheManager = new CacheManager(this, this._ctx, this.getLockEngine());
        }
        return this.cacheManager;
    }

    public void update(Object object) throws ClassNotPersistenceCapableException, ObjectModifiedException, TransactionNotInProgressException, PersistenceException {
        TransactionContext tx = this.getTransaction();
        PersistenceInfo info = this._scope.getPersistenceInfo(object.getClass());
        tx.update(info.engine, info.molder, object, null);
    }

    public void remove(Object object) throws ObjectNotPersistentException, LockNotGrantedException, TransactionNotInProgressException, PersistenceException {
        TransactionContext tx = this.getTransaction();
        this._scope.getPersistenceInfo(object.getClass());
        tx.delete(object);
    }

    public boolean isPersistent(Object object) {
        if (this._scope == null) {
            throw new IllegalStateException(Messages.message("jdo.dbClosed"));
        }
        if (this.isActive()) {
            return this._ctx.isPersistent(object);
        }
        return false;
    }

    public Object getIdentity(Object object) throws ClassNotPersistenceCapableException {
        if (this._scope == null) {
            throw new IllegalStateException(Messages.message("jdo.dbClosed"));
        }
        PersistenceInfo info = this._scope.getPersistenceInfo(object.getClass());
        return info.molder.getActualIdentity(this._classLoader, object);
    }

    public void lock(Object object) throws LockNotGrantedException, ObjectNotPersistentException, TransactionNotInProgressException, PersistenceException {
        if (!this.isActive()) {
            throw new TransactionNotInProgressException(Messages.message("jdo.txNotInProgress"));
        }
        this._ctx.writeLock(object, this._lockTimeout);
    }

    public OQLQuery getOQLQuery() {
        return new OQLQueryImpl(this);
    }

    public OQLQuery getOQLQuery(String oql) throws PersistenceException {
        OQLQueryImpl oqlImpl = new OQLQueryImpl(this);
        oqlImpl.create(oql);
        return oqlImpl;
    }

    public Query getQuery() {
        return new OQLQueryImpl(this);
    }

    protected TransactionContext getTransaction() throws TransactionNotInProgressException {
        if (this._scope == null) {
            throw new TransactionNotInProgressException(Messages.message("jdo.dbClosed"));
        }
        if (this.isActive()) {
            return this._ctx;
        }
        throw new TransactionNotInProgressException(Messages.message("jdo.dbTxNotInProgress"));
    }

    public abstract void begin() throws PersistenceException;

    public abstract void commit() throws TransactionNotInProgressException, TransactionAbortedException;

    public abstract void rollback() throws TransactionNotInProgressException;

    public boolean isActive() {
        return this._ctx != null && this._ctx.isOpen();
    }

    public String toString() {
        return super.toString() + ":" + this._dbName;
    }

    public abstract Connection getJdbcConnection() throws PersistenceException;

    protected void loadSynchronizables() {
        if (this._synchronizables == null) {
            this._synchronizables = new ArrayList();
            String syncName = LocalConfiguration.getInstance().getProperty(TxSynchronizableProperty, "");
            StringTokenizer tokenizer = new StringTokenizer(syncName, ", ");
            while (tokenizer.hasMoreTokens()) {
                syncName = tokenizer.nextToken();
                try {
                    Class cls = null;
                    cls = ClassLoadingUtils.loadClass(this._classLoader, syncName);
                    TxSynchronizable sync = (TxSynchronizable)cls.newInstance();
                    if (sync == null) continue;
                    this._synchronizables.add(sync);
                }
                catch (Exception except) {
                    _log.warn((Object)Messages.format("jdo.missingTxSynchronizable", syncName));
                }
            }
            if (this._synchronizables.size() == 0) {
                this._synchronizables = null;
            }
        }
    }

    protected void registerSynchronizables() {
        if (this._synchronizables != null && this._synchronizables.size() > 0) {
            Iterator iter = this._synchronizables.iterator();
            while (iter.hasNext()) {
                this._ctx.addTxSynchronizable((TxSynchronizable)iter.next());
            }
        }
    }

    protected void unregisterSynchronizables() {
        if (this._synchronizables != null && this._synchronizables.size() > 0) {
            Iterator iter = this._synchronizables.iterator();
            while (iter.hasNext()) {
                this._ctx.removeTxSynchronizable((TxSynchronizable)iter.next());
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

