/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.dtx;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.HashMap;
import java.util.Properties;
import org.castor.jdo.conf.DataSource;
import org.castor.jdo.conf.Database;
import org.castor.jdo.conf.Driver;
import org.castor.jdo.conf.Mapping;
import org.castor.jdo.conf.Param;
import org.exolab.castor.dtx.DTXException;
import org.exolab.castor.dtx.DTXQuery;
import org.exolab.castor.mapping.xml.ClassMapping;
import org.exolab.castor.mapping.xml.MappingRoot;
import org.exolab.castor.persist.PersistenceFactoryRegistry;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.util.DTDResolver;
import org.exolab.castor.util.Logger;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.reader.SchemaReader;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;

public class DTXEngine {
    protected DocumentHandler _handler = null;
    protected String _databaseURL = null;
    protected PrintWriter _logWriter = Logger.getSystemLogger();
    protected Database _database = null;
    protected String _schemaURL = null;
    protected Schema _schema = null;
    protected HashMap _classMappings = null;
    protected Connection _conn = null;
    protected PersistenceFactory _factory = null;
    static /* synthetic */ Class class$org$castor$jdo$conf$Database;
    static /* synthetic */ Class class$org$exolab$castor$mapping$xml$MappingRoot;

    public DTXEngine() {
    }

    public DTXEngine(String databaseURL, String schemaURL) throws DTXException {
        this.setDatabase(databaseURL);
        this.setSchema(schemaURL);
    }

    public void setSchema(String schemaURL) throws DTXException {
        this._schemaURL = schemaURL;
        try {
            SchemaReader reader = new SchemaReader(new InputSource(new URL(schemaURL).openStream()));
            this._schema = reader.read();
        }
        catch (IOException iox) {
            throw new DTXException(iox);
        }
        catch (Exception e) {
            throw new DTXException(e);
        }
    }

    public void setDatabase(String databaseURL) throws DTXException {
        this._databaseURL = databaseURL;
        Unmarshaller unm = new Unmarshaller(class$org$castor$jdo$conf$Database == null ? (class$org$castor$jdo$conf$Database = DTXEngine.class$("org.castor.jdo.conf.Database")) : class$org$castor$jdo$conf$Database);
        unm.setEntityResolver(new DTDResolver());
        if (this._logWriter != null) {
            unm.setLogWriter(this._logWriter);
        }
        try {
            this._database = (Database)unm.unmarshal(new InputSource(new URL(databaseURL).openStream()));
        }
        catch (Exception except) {
            throw new DTXException(except);
        }
        this._factory = this._database.getEngine() == null ? PersistenceFactoryRegistry.getPersistenceFactory("generic") : PersistenceFactoryRegistry.getPersistenceFactory(this._database.getEngine());
        if (this._factory == null) {
            throw new DTXException("no engine");
        }
        this._classMappings = new HashMap();
        Unmarshaller munm = new Unmarshaller(class$org$exolab$castor$mapping$xml$MappingRoot == null ? (class$org$exolab$castor$mapping$xml$MappingRoot = DTXEngine.class$("org.exolab.castor.mapping.xml.MappingRoot")) : class$org$exolab$castor$mapping$xml$MappingRoot);
        if (this._logWriter != null) {
            munm.setLogWriter(this._logWriter);
        }
        Mapping[] mappings = this._database.getMapping();
        for (int i = 0; i < mappings.length; ++i) {
            try {
                URL mappingURL = new URL(new URL(databaseURL), mappings[i].getHref());
                MappingRoot mr = (MappingRoot)munm.unmarshal(new InputSource(mappingURL.openStream()));
                ClassMapping[] classMaps = mr.getClassMapping();
                for (int j = 0; j < classMaps.length; ++j) {
                    this._classMappings.put(classMaps[j].getName(), classMaps[j]);
                    if (this._logWriter == null) continue;
                    this._logWriter.println("Got class: " + classMaps[j].getName());
                }
                continue;
            }
            catch (Exception e) {
                throw new DTXException(e);
            }
        }
    }

    public void setLogWriter(PrintWriter logWriter) {
        this._logWriter = logWriter;
    }

    public void setDocumentHandler(DocumentHandler handler) {
        this._handler = handler;
    }

    public DTXQuery prepareQuery(String oql) throws DTXException {
        DTXQuery qry = new DTXQuery();
        qry.setEngine(this);
        qry.setHandler(this._handler);
        qry.setLogWriter(this._logWriter);
        qry.prepare(oql);
        return qry;
    }

    Database getDatabase() {
        return this._database;
    }

    Schema getSchema() {
        return this._schema;
    }

    PersistenceFactory getFactory() {
        return this._factory;
    }

    Connection getConnection() throws DTXException {
        if (this._conn == null) {
            DataSource datasource = this._database.getDatabaseChoice().getDataSource();
            Driver driver = this._database.getDatabaseChoice().getDriver();
            if (datasource != null) {
                throw new DTXException("dtx.DataSourceUnimplemented");
            }
            if (driver != null) {
                try {
                    String className = driver.getClassName();
                    Class.forName(className);
                    String jdbcUrl = driver.getUrl();
                    Param[] params = driver.getParam();
                    Properties props = new Properties();
                    for (int i = 0; i < params.length; ++i) {
                        Param p = params[i];
                        props.setProperty(p.getName(), p.getValue());
                    }
                    this._conn = DriverManager.getConnection(jdbcUrl, props);
                }
                catch (Exception e) {
                    throw new DTXException(e);
                }
            }
        }
        return this._conn;
    }

    ClassMapping getClassMapping(String className) {
        return (ClassMapping)this._classMappings.get(className);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

