/*
 * Decompiled with CFR 0.152.
 */
package org.castor.persist.proxy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.jdo.util.ClassLoadingUtils;
import org.exolab.castor.persist.FieldMolder;

public abstract class CollectionProxy {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$castor$persist$proxy$CollectionProxy == null ? (class$org$castor$persist$proxy$CollectionProxy = CollectionProxy.class$("org.castor.persist.proxy.CollectionProxy")) : class$org$castor$persist$proxy$CollectionProxy));
    static /* synthetic */ Class class$org$castor$persist$proxy$CollectionProxy;
    static /* synthetic */ Class class$java$util$Vector;
    static /* synthetic */ Class class$java$util$ArrayList;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$HashSet;
    static /* synthetic */ Class class$java$util$Hashtable;
    static /* synthetic */ Class class$java$util$HashMap;
    static /* synthetic */ Class class$java$util$Iterator;
    static /* synthetic */ Class class$java$util$Enumeration;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$SortedSet;

    public abstract Object getCollection();

    public abstract void add(Object var1, Object var2);

    public abstract void close();

    public static CollectionProxy create(FieldMolder fieldMolder, Object object, ClassLoader classLoader) {
        Class cls = fieldMolder.getCollectionType();
        if (cls == (class$java$util$Vector == null ? (class$java$util$Vector = CollectionProxy.class$("java.util.Vector")) : class$java$util$Vector)) {
            return new ColProxy(fieldMolder, object, classLoader, new Vector());
        }
        if (cls == (class$java$util$ArrayList == null ? (class$java$util$ArrayList = CollectionProxy.class$("java.util.ArrayList")) : class$java$util$ArrayList)) {
            return new ColProxy(fieldMolder, object, classLoader, new ArrayList());
        }
        if (cls == (class$java$util$Collection == null ? (class$java$util$Collection = CollectionProxy.class$("java.util.Collection")) : class$java$util$Collection)) {
            return new ColProxy(fieldMolder, object, classLoader, new ArrayList());
        }
        if (cls == (class$java$util$Set == null ? (class$java$util$Set = CollectionProxy.class$("java.util.Set")) : class$java$util$Set)) {
            return new ColProxy(fieldMolder, object, classLoader, new HashSet());
        }
        if (cls == (class$java$util$HashSet == null ? (class$java$util$HashSet = CollectionProxy.class$("java.util.HashSet")) : class$java$util$HashSet)) {
            return new ColProxy(fieldMolder, object, classLoader, new HashSet());
        }
        if (cls == (class$java$util$Hashtable == null ? (class$java$util$Hashtable = CollectionProxy.class$("java.util.Hashtable")) : class$java$util$Hashtable)) {
            return new MapProxy(fieldMolder, object, classLoader, new Hashtable());
        }
        if (cls == (class$java$util$HashMap == null ? (class$java$util$HashMap = CollectionProxy.class$("java.util.HashMap")) : class$java$util$HashMap)) {
            return new MapProxy(fieldMolder, object, classLoader, new HashMap());
        }
        if (cls == (class$java$util$Iterator == null ? (class$java$util$Iterator = CollectionProxy.class$("java.util.Iterator")) : class$java$util$Iterator)) {
            return new IteratorProxy(fieldMolder, object, classLoader, new ArrayList());
        }
        if (cls == (class$java$util$Enumeration == null ? (class$java$util$Enumeration = CollectionProxy.class$("java.util.Enumeration")) : class$java$util$Enumeration)) {
            return new EnumerationProxy(fieldMolder, object, classLoader, new ArrayList());
        }
        if (cls == (class$java$util$Map == null ? (class$java$util$Map = CollectionProxy.class$("java.util.Map")) : class$java$util$Map)) {
            return new MapProxy(fieldMolder, object, classLoader, new HashMap());
        }
        if (cls == (class$java$util$SortedSet == null ? (class$java$util$SortedSet = CollectionProxy.class$("java.util.SortedSet")) : class$java$util$SortedSet)) {
            String comparatorClassName = fieldMolder.getComparator();
            if (comparatorClassName != null) {
                Comparator comparator;
                try {
                    comparator = (Comparator)ClassLoadingUtils.loadClass(classLoader, comparatorClassName).newInstance();
                }
                catch (InstantiationException e) {
                    LOG.error((Object)("Problem instantiating instance of " + comparatorClassName));
                    throw new IllegalArgumentException("Problem instantiating instance of " + comparatorClassName);
                }
                catch (IllegalAccessException e) {
                    LOG.error((Object)("Problem accessing constructor of " + comparatorClassName));
                    throw new IllegalArgumentException("Problem accessing constructor of " + comparatorClassName);
                }
                catch (ClassNotFoundException e) {
                    LOG.error((Object)("Problem loading class for " + comparatorClassName));
                    throw new IllegalArgumentException("Problem instantiating instance of " + comparatorClassName);
                }
                return new ColProxy(fieldMolder, object, classLoader, new TreeSet(comparator));
            }
            return new ColProxy(fieldMolder, object, classLoader, new TreeSet());
        }
        throw new IllegalArgumentException("Collection Proxy doesn't exist for this type : " + cls);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class MapProxy
    extends CollectionProxy {
        private Map _map;
        private FieldMolder _fm;
        private Object _object;
        private ClassLoader _cl;

        private MapProxy(FieldMolder fm, Object object, ClassLoader cl, Map map) {
            this._cl = cl;
            this._map = map;
            this._fm = fm;
            this._object = object;
        }

        public Object getCollection() {
            return this._map;
        }

        public void add(Object key, Object value) {
            this._map.put(key, value);
        }

        public void close() {
            if (!this._fm.isAddable()) {
                this._fm.setValue(this._object, this._map, this._cl);
            }
        }
    }

    private static final class IteratorProxy
    extends CollectionProxy {
        private Collection _collection;
        private FieldMolder _fieldMolder;
        private Object _object;
        private ClassLoader _cl;

        private IteratorProxy(FieldMolder fm, Object object, ClassLoader cl, Collection col) {
            this._cl = cl;
            this._fieldMolder = fm;
            this._collection = col;
            this._object = object;
        }

        public Object getCollection() {
            return this._collection.iterator();
        }

        public void add(Object key, Object value) {
            if (!this._fieldMolder.isAddable()) {
                this._collection.add(value);
            } else {
                this._fieldMolder.addValue(this._object, value, this._cl);
            }
        }

        public void close() {
            if (!this._fieldMolder.isAddable()) {
                this._fieldMolder.setValue(this._object, this._collection.iterator(), this._cl);
            }
        }
    }

    private static final class EnumerationProxy
    extends CollectionProxy {
        private Collection _collection;
        private FieldMolder _fm;
        private Object _object;
        private ClassLoader _cl;

        private EnumerationProxy(FieldMolder fm, Object object, ClassLoader cl, Collection collection) {
            this._cl = cl;
            this._fm = fm;
            this._collection = collection;
            this._object = object;
        }

        public Object getCollection() {
            return Collections.enumeration(this._collection);
        }

        public void add(Object key, Object value) {
            if (!this._fm.isAddable()) {
                this._collection.add(value);
            } else {
                this._fm.addValue(this._object, value, this._cl);
            }
        }

        public void close() {
            if (!this._fm.isAddable()) {
                this._fm.setValue(this._object, Collections.enumeration(this._collection), this._cl);
            }
        }
    }

    private static final class ColProxy
    extends CollectionProxy {
        private Collection _col;
        private FieldMolder _fm;
        private Object _object;
        private ClassLoader _cl;

        private ColProxy(FieldMolder fm, Object object, ClassLoader cl, Collection col) {
            this._cl = cl;
            this._fm = fm;
            this._col = col;
            this._object = object;
        }

        public Object getCollection() {
            return this._col;
        }

        public void add(Object key, Object value) {
            if (!this._fm.isAddable()) {
                this._col.add(value);
            } else {
                this._fm.addValue(this._object, value, this._cl);
            }
        }

        public void close() {
            if (!this._fm.isAddable()) {
                this._fm.setValue(this._object, this._col, this._cl);
            }
        }
    }
}

