/*
 * Decompiled with CFR 0.152.
 */
package org.castor.jdo.drivers;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.jdo.drivers.CallableStatementProxy;
import org.castor.jdo.drivers.PreparedStatementProxy;
import org.exolab.castor.util.LocalConfiguration;

public final class ConnectionProxy
implements Connection {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$castor$jdo$drivers$ConnectionProxy == null ? (class$org$castor$jdo$drivers$ConnectionProxy = ConnectionProxy.class$("org.castor.jdo.drivers.ConnectionProxy")) : class$org$castor$jdo$drivers$ConnectionProxy));
    private static final String DEFAULT_CALLED_BY = "unknown";
    private static boolean _isConfigured = false;
    private static boolean _useProxies = false;
    private Connection _connection;
    private String _calledBy;
    static /* synthetic */ Class class$org$castor$jdo$drivers$ConnectionProxy;

    public static Connection newConnectionProxy(Connection connection) {
        return ConnectionProxy.newConnectionProxy(connection, DEFAULT_CALLED_BY);
    }

    public static Connection newConnectionProxy(Connection connection, String calledBy) {
        if (!_isConfigured) {
            String propertyValue = LocalConfiguration.getInstance().getProperty("org.exolab.castor.persist.useProxies", "true");
            _useProxies = Boolean.valueOf(propertyValue);
            _isConfigured = true;
        }
        if (!_useProxies) {
            return connection;
        }
        return new ConnectionProxy(connection, calledBy);
    }

    private ConnectionProxy(Connection connection, String calledBy) {
        this._connection = connection;
        this._calledBy = calledBy;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating instance of ConnectionProxy for calling class " + this._calledBy));
        }
    }

    public void clearWarnings() throws SQLException {
        this._connection.clearWarnings();
    }

    public void close() throws SQLException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Closing JDBC Connection instance.");
        }
        this._connection.close();
    }

    public void commit() throws SQLException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Committing JDBC Connection instance.");
        }
        this._connection.commit();
    }

    public Statement createStatement() throws SQLException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Creating JDBC Statement for Connection instance.");
        }
        return this._connection.createStatement();
    }

    public Statement createStatement(int arg0, int arg1) throws SQLException {
        return this._connection.createStatement(arg0, arg1);
    }

    public Statement createStatement(int arg0, int arg1, int arg2) throws SQLException {
        return this._connection.createStatement(arg0, arg1, arg2);
    }

    public boolean equals(Object arg0) {
        return this._connection.equals(arg0);
    }

    public boolean getAutoCommit() throws SQLException {
        return this._connection.getAutoCommit();
    }

    public String getCatalog() throws SQLException {
        return this._connection.getCatalog();
    }

    public int getHoldability() throws SQLException {
        return this._connection.getHoldability();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this._connection.getMetaData();
    }

    public int getTransactionIsolation() throws SQLException {
        return this._connection.getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        return this._connection.getTypeMap();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this._connection.getWarnings();
    }

    public int hashCode() {
        return this._connection.hashCode();
    }

    public boolean isClosed() throws SQLException {
        return this._connection.isClosed();
    }

    public boolean isReadOnly() throws SQLException {
        return this._connection.isReadOnly();
    }

    public String nativeSQL(String arg0) throws SQLException {
        return this._connection.nativeSQL(arg0);
    }

    public CallableStatement prepareCall(String arg0) throws SQLException {
        return CallableStatementProxy.newCallableStatementProxy(this._connection.prepareCall(arg0), arg0, this);
    }

    public CallableStatement prepareCall(String arg0, int arg1, int arg2) throws SQLException {
        return CallableStatementProxy.newCallableStatementProxy(this._connection.prepareCall(arg0, arg1, arg2), arg0, this);
    }

    public CallableStatement prepareCall(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        return CallableStatementProxy.newCallableStatementProxy(this._connection.prepareCall(arg0, arg1, arg2, arg3), arg0, this);
    }

    public PreparedStatement prepareStatement(String arg0) throws SQLException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating JDBC Statement for Connection instance with " + arg0));
        }
        return PreparedStatementProxy.newPreparedStatementProxy(this._connection.prepareStatement(arg0), arg0, this);
    }

    public PreparedStatement prepareStatement(String arg0, int arg1) throws SQLException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating JDBC Statement for Connection instance with " + arg0));
        }
        return PreparedStatementProxy.newPreparedStatementProxy(this._connection.prepareStatement(arg0, arg1), arg0, this);
    }

    public PreparedStatement prepareStatement(String arg0, int arg1, int arg2) throws SQLException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating JDBC Statement for Connection instance with " + arg0));
        }
        return PreparedStatementProxy.newPreparedStatementProxy(this._connection.prepareStatement(arg0, arg1, arg2), arg0, this);
    }

    public PreparedStatement prepareStatement(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating JDBC Statement for Connection instance with " + arg0));
        }
        return PreparedStatementProxy.newPreparedStatementProxy(this._connection.prepareStatement(arg0, arg1, arg2, arg3), arg0, this);
    }

    public PreparedStatement prepareStatement(String arg0, int[] arg1) throws SQLException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating JDBC Statement for Connection instance with " + arg0));
        }
        return PreparedStatementProxy.newPreparedStatementProxy(this._connection.prepareStatement(arg0, arg1), arg0, this);
    }

    public PreparedStatement prepareStatement(String arg0, String[] arg1) throws SQLException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating JDBC Statement for Connection instance with " + arg0));
        }
        return PreparedStatementProxy.newPreparedStatementProxy(this._connection.prepareStatement(arg0, arg1), arg0, this);
    }

    public void releaseSavepoint(Savepoint arg0) throws SQLException {
        this._connection.releaseSavepoint(arg0);
    }

    public void rollback() throws SQLException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Rolling back JDBC Connection instance.");
        }
        this._connection.rollback();
    }

    public void rollback(Savepoint arg0) throws SQLException {
        this._connection.rollback(arg0);
    }

    public void setAutoCommit(boolean arg0) throws SQLException {
        this._connection.setAutoCommit(arg0);
    }

    public void setCatalog(String arg0) throws SQLException {
        this._connection.setCatalog(arg0);
    }

    public void setHoldability(int arg0) throws SQLException {
        this._connection.setHoldability(arg0);
    }

    public void setReadOnly(boolean arg0) throws SQLException {
        this._connection.setReadOnly(arg0);
    }

    public Savepoint setSavepoint() throws SQLException {
        return this._connection.setSavepoint();
    }

    public Savepoint setSavepoint(String arg0) throws SQLException {
        return this._connection.setSavepoint(arg0);
    }

    public void setTransactionIsolation(int arg0) throws SQLException {
        this._connection.setTransactionIsolation(arg0);
    }

    public void setTypeMap(Map arg0) throws SQLException {
        this._connection.setTypeMap(arg0);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getName() + " created and called by " + this._calledBy);
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

