/*
 * Decompiled with CFR 0.152.
 */
package javax.management.timer;

import com.sun.jmx.trace.Trace;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TimerTask;
import java.util.Vector;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.timer.TimerAlarmClock;
import javax.management.timer.TimerAlarmClockNotification;
import javax.management.timer.TimerMBean;
import javax.management.timer.TimerNotification;

public class Timer
extends NotificationBroadcasterSupport
implements TimerMBean,
MBeanRegistration {
    public static final long ONE_SECOND = 1000L;
    public static final long ONE_MINUTE = 60000L;
    public static final long ONE_HOUR = 3600000L;
    public static final long ONE_DAY = 86400000L;
    public static final long ONE_WEEK = 604800000L;
    private static final String dbgTag = "Timer";
    private Hashtable timerTable = new Hashtable();
    private boolean sendPastNotifications = false;
    private transient boolean isActive = false;
    private transient long sequenceNumber = 0L;
    private static final int TIMER_NOTIF_INDEX = 0;
    private static final int TIMER_DATE_INDEX = 1;
    private static final int TIMER_PERIOD_INDEX = 2;
    private static final int TIMER_NB_OCCUR_INDEX = 3;
    private static final int ALARM_CLOCK_INDEX = 4;
    private static final int FIXED_RATE_INDEX = 5;
    private int counterID = 0;
    private java.util.Timer timer;

    boolean isTraceOn() {
        return Trace.isSelected(1, 8);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, 8, string, string2, string3);
    }

    void trace(String string, String string2) {
        this.trace(dbgTag, string, string2);
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, 8);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, 8, string, string2, string3);
    }

    void debug(String string, String string2) {
        this.debug(dbgTag, string, string2);
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        return objectName;
    }

    public void postRegister(Boolean bl) {
    }

    public void preDeregister() throws Exception {
        if (this.isTraceOn()) {
            this.trace("preDeregister", "stop the timer");
        }
        this.stop();
    }

    public void postDeregister() {
    }

    public synchronized void start() {
        if (this.isTraceOn()) {
            this.trace("start", "starting the timer");
        }
        if (!this.isActive) {
            this.timer = new java.util.Timer();
            Date date = new Date();
            this.sendPastNotifications(date, this.sendPastNotifications);
            Enumeration enumeration = this.timerTable.elements();
            while (enumeration.hasMoreElements()) {
                TimerAlarmClock timerAlarmClock;
                Object[] objectArray = (Object[])enumeration.nextElement();
                Date date2 = (Date)objectArray[1];
                boolean bl = (Boolean)objectArray[5];
                if (bl) {
                    timerAlarmClock = new TimerAlarmClock(this, date2);
                    objectArray[4] = timerAlarmClock;
                    this.timer.schedule((TimerTask)timerAlarmClock, timerAlarmClock.next);
                    continue;
                }
                timerAlarmClock = new TimerAlarmClock(this, date2.getTime() - date.getTime());
                objectArray[4] = timerAlarmClock;
                this.timer.schedule((TimerTask)timerAlarmClock, timerAlarmClock.timeout);
            }
            this.isActive = true;
            if (this.isTraceOn()) {
                this.trace("start", "timer started");
            }
        } else if (this.isTraceOn()) {
            this.trace("start", "the timer is already activated");
        }
    }

    public synchronized void stop() {
        if (this.isTraceOn()) {
            this.trace("stop", "stoping the timer");
        }
        if (this.isActive) {
            Enumeration enumeration = this.timerTable.elements();
            while (enumeration.hasMoreElements()) {
                Object[] objectArray = (Object[])enumeration.nextElement();
                TimerAlarmClock timerAlarmClock = (TimerAlarmClock)objectArray[4];
                if (timerAlarmClock == null) continue;
                timerAlarmClock.cancel();
                timerAlarmClock = null;
            }
            this.timer.cancel();
            this.isActive = false;
            if (this.isTraceOn()) {
                this.trace("stop", "timer stopped");
            }
        } else if (this.isTraceOn()) {
            this.trace("stop", "the timer is already deactivated");
        }
    }

    public synchronized Integer addNotification(String string, String string2, Object object, Date date, long l, long l2, boolean bl) throws IllegalArgumentException {
        if (date == null) {
            throw new IllegalArgumentException("Timer notification date cannot be null.");
        }
        if (l < 0L || l2 < 0L) {
            throw new IllegalArgumentException("Negative values for the periodicity");
        }
        Date date2 = new Date();
        if (date2.after(date)) {
            date.setTime(date2.getTime());
            if (this.isTraceOn()) {
                this.trace("addNotification", "update timer notification to add with:\n\tNotification date = " + date);
            }
        }
        Integer n = null;
        n = new Integer(++this.counterID);
        TimerNotification timerNotification = new TimerNotification(string, this, 0L, 0L, string2, n);
        timerNotification.setUserData(object);
        Object[] objectArray = new Object[6];
        TimerAlarmClock timerAlarmClock = bl ? new TimerAlarmClock(this, date) : new TimerAlarmClock(this, date.getTime() - date2.getTime());
        Date date3 = new Date(date.getTime());
        objectArray[0] = timerNotification;
        objectArray[1] = date3;
        objectArray[2] = new Long(l);
        objectArray[3] = new Long(l2);
        objectArray[4] = timerAlarmClock;
        objectArray[5] = new Boolean(bl);
        if (this.isTraceOn()) {
            this.trace("addNotification", "adding timer notification:\n\tNotification source = " + timerNotification.getSource() + "\n\tNotification type = " + timerNotification.getType() + "\n\tNotification ID = " + n + "\n\tNotification date = " + date3 + "\n\tNotification period = " + l + "\n\tNotification nb of occurences = " + l2 + "\n\tNotification executes at fixed rate = " + bl);
        }
        this.timerTable.put(n, objectArray);
        if (this.isActive) {
            if (bl) {
                this.timer.schedule((TimerTask)timerAlarmClock, timerAlarmClock.next);
            } else {
                this.timer.schedule((TimerTask)timerAlarmClock, timerAlarmClock.timeout);
            }
        }
        if (this.isTraceOn()) {
            this.trace("addNotification", "timer notification added");
        }
        return n;
    }

    public synchronized Integer addNotification(String string, String string2, Object object, Date date, long l, long l2) throws IllegalArgumentException {
        return this.addNotification(string, string2, object, date, l, l2, false);
    }

    public synchronized Integer addNotification(String string, String string2, Object object, Date date, long l) throws IllegalArgumentException {
        return this.addNotification(string, string2, object, date, l, 0L);
    }

    public synchronized Integer addNotification(String string, String string2, Object object, Date date) throws IllegalArgumentException {
        return this.addNotification(string, string2, object, date, 0L, 0L);
    }

    public synchronized void removeNotification(Integer n) throws InstanceNotFoundException {
        if (!this.timerTable.containsKey(n)) {
            throw new InstanceNotFoundException("Timer notification to remove not in the list of notifications");
        }
        Object[] objectArray = (Object[])this.timerTable.get(n);
        TimerAlarmClock timerAlarmClock = (TimerAlarmClock)objectArray[4];
        if (timerAlarmClock != null) {
            timerAlarmClock.cancel();
            timerAlarmClock = null;
        }
        if (this.isTraceOn()) {
            this.trace("removeNotification", "removing timer notification:\n\tNotification source = " + ((TimerNotification)objectArray[0]).getSource() + "\n\tNotification type = " + ((TimerNotification)objectArray[0]).getType() + "\n\tNotification ID = " + ((TimerNotification)objectArray[0]).getNotificationID() + "\n\tNotification date = " + objectArray[1] + "\n\tNotification period = " + objectArray[2] + "\n\tNotification nb of occurences = " + objectArray[3] + "\n\tNotification executes at fixed rate = " + objectArray[5]);
        }
        this.timerTable.remove(n);
        if (this.isTraceOn()) {
            this.trace("removeNotification", "timer notification removed");
        }
    }

    public synchronized void removeNotifications(String string) throws InstanceNotFoundException {
        Vector vector = this.getNotificationIDs(string);
        if (vector.isEmpty()) {
            throw new InstanceNotFoundException("Timer notifications to remove not in the list of notifications");
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            TimerNotification timerNotification = (TimerNotification)enumeration.nextElement();
            Integer n = timerNotification.getNotificationID();
            Object[] objectArray = (Object[])this.timerTable.get(n);
            this.timerTable.remove(n);
            TimerAlarmClock timerAlarmClock = (TimerAlarmClock)objectArray[4];
            if (timerAlarmClock == null) continue;
            timerAlarmClock.cancel();
        }
    }

    public synchronized void removeAllNotifications() {
        Enumeration enumeration = this.timerTable.elements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray = (Object[])enumeration.nextElement();
            TimerAlarmClock timerAlarmClock = (TimerAlarmClock)objectArray[4];
            timerAlarmClock.cancel();
            timerAlarmClock = null;
        }
        if (this.isTraceOn()) {
            this.trace("removeAllNotifications", "removing all timer notifications");
        }
        this.timerTable.clear();
        if (this.isTraceOn()) {
            this.trace("removeAllNotifications", "all timer notifications removed");
        }
        this.counterID = 0;
        if (this.isTraceOn()) {
            this.trace("removeAllNotifications", "timer notification counter ID resetted");
        }
    }

    public int getNbNotifications() {
        return this.timerTable.size();
    }

    public synchronized Vector getAllNotificationIDs() {
        Vector<Integer> vector = new Vector<Integer>();
        Enumeration enumeration = this.timerTable.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Integer)enumeration.nextElement());
        }
        return vector;
    }

    public synchronized Vector getNotificationIDs(String string) {
        Vector<TimerNotification> vector = new Vector<TimerNotification>();
        Enumeration enumeration = this.timerTable.elements();
        if (string == null) {
            while (enumeration.hasMoreElements()) {
                Object[] objectArray = (Object[])enumeration.nextElement();
                String string2 = ((TimerNotification)objectArray[0]).getType();
                if (string2 != null) continue;
                vector.addElement((TimerNotification)objectArray[0]);
            }
        } else {
            while (enumeration.hasMoreElements()) {
                Object[] objectArray = (Object[])enumeration.nextElement();
                String string3 = ((TimerNotification)objectArray[0]).getType();
                if (!string.equals(string3)) continue;
                vector.addElement((TimerNotification)objectArray[0]);
            }
        }
        return vector;
    }

    public String getNotificationType(Integer n) {
        Object[] objectArray = (Object[])this.timerTable.get(n);
        if (objectArray != null) {
            return ((TimerNotification)objectArray[0]).getType();
        }
        return null;
    }

    public String getNotificationMessage(Integer n) {
        Object[] objectArray = (Object[])this.timerTable.get(n);
        if (objectArray != null) {
            return ((TimerNotification)objectArray[0]).getMessage();
        }
        return null;
    }

    public Object getNotificationUserData(Integer n) {
        Object[] objectArray = (Object[])this.timerTable.get(n);
        if (objectArray != null) {
            return ((TimerNotification)objectArray[0]).getUserData();
        }
        return null;
    }

    public Date getDate(Integer n) {
        Object[] objectArray = (Object[])this.timerTable.get(n);
        if (objectArray != null) {
            Date date = (Date)objectArray[1];
            return new Date(date.getTime());
        }
        return null;
    }

    public Long getPeriod(Integer n) {
        Object[] objectArray = (Object[])this.timerTable.get(n);
        if (objectArray != null) {
            Long l = (Long)objectArray[2];
            return new Long(l);
        }
        return null;
    }

    public Long getNbOccurences(Integer n) {
        Object[] objectArray = (Object[])this.timerTable.get(n);
        if (objectArray != null) {
            Long l = (Long)objectArray[3];
            return new Long(l);
        }
        return null;
    }

    public Boolean getFixedRate(Integer n) {
        Object[] objectArray = (Object[])this.timerTable.get(n);
        if (objectArray != null) {
            Boolean bl = (Boolean)objectArray[5];
            return new Boolean(bl);
        }
        return null;
    }

    public boolean getSendPastNotifications() {
        return this.sendPastNotifications;
    }

    public void setSendPastNotifications(boolean bl) {
        this.sendPastNotifications = bl;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isEmpty() {
        return this.timerTable.isEmpty();
    }

    private synchronized void sendPastNotifications(Date date, boolean bl) {
        Enumeration enumeration = this.timerTable.elements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray = (Object[])enumeration.nextElement();
            TimerNotification timerNotification = (TimerNotification)objectArray[0];
            Integer n = timerNotification.getNotificationID();
            Date date2 = (Date)objectArray[1];
            while (date.after(date2) && this.timerTable.containsKey(n)) {
                if (bl) {
                    if (this.isTraceOn()) {
                        this.trace("sendPastNotifications", "sending past timer notification:\n\tNotification source = " + timerNotification.getSource() + "\n\tNotification type = " + timerNotification.getType() + "\n\tNotification ID = " + timerNotification.getNotificationID() + "\n\tNotification date = " + date2 + "\n\tNotification period = " + objectArray[2] + "\n\tNotification nb of occurences = " + objectArray[3] + "\n\tNotification executes at fixed rate = " + objectArray[5]);
                    }
                    this.sendNotification(date2, timerNotification);
                    if (this.isTraceOn()) {
                        this.trace("sendPastNotifications", "past timer notification sent");
                    }
                }
                this.updateTimerTable(timerNotification.getNotificationID());
            }
        }
    }

    private synchronized void updateTimerTable(Integer n) {
        Object[] objectArray = (Object[])this.timerTable.get(n);
        Date date = (Date)objectArray[1];
        Long l = (Long)objectArray[2];
        Long l2 = (Long)objectArray[3];
        Boolean bl = (Boolean)objectArray[5];
        TimerAlarmClock timerAlarmClock = (TimerAlarmClock)objectArray[4];
        if (l != 0L) {
            if (l2 == 0L || l2 > 1L) {
                date.setTime(date.getTime() + l);
                objectArray[3] = new Long(Math.max(0L, l2 - 1L));
                l2 = (Long)objectArray[3];
                if (this.isActive) {
                    if (bl.booleanValue()) {
                        timerAlarmClock = new TimerAlarmClock(this, date);
                        objectArray[4] = timerAlarmClock;
                        this.timer.schedule((TimerTask)timerAlarmClock, timerAlarmClock.next);
                    } else {
                        timerAlarmClock = new TimerAlarmClock(this, l);
                        objectArray[4] = timerAlarmClock;
                        this.timer.schedule((TimerTask)timerAlarmClock, timerAlarmClock.timeout);
                    }
                }
                if (this.isTraceOn()) {
                    TimerNotification timerNotification = (TimerNotification)objectArray[0];
                    this.trace("updateTimerTable", "update timer notification with:\n\tNotification source = " + timerNotification.getSource() + "\n\tNotification type = " + timerNotification.getType() + "\n\tNotification ID = " + n + "\n\tNotification date = " + date + "\n\tNotification period = " + l + "\n\tNotification nb of occurences = " + l2 + "\n\tNotification executes at fixed rate = " + bl);
                }
            } else {
                if (timerAlarmClock != null) {
                    timerAlarmClock.cancel();
                    timerAlarmClock = null;
                }
                this.timerTable.remove(n);
            }
        } else {
            if (timerAlarmClock != null) {
                timerAlarmClock.cancel();
                timerAlarmClock = null;
            }
            this.timerTable.remove(n);
        }
    }

    void notifyAlarmClock(TimerAlarmClockNotification timerAlarmClockNotification) {
        TimerNotification timerNotification = null;
        Date date = null;
        TimerAlarmClock timerAlarmClock = (TimerAlarmClock)timerAlarmClockNotification.getSource();
        Enumeration enumeration = this.timerTable.elements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray = (Object[])enumeration.nextElement();
            if (objectArray[4] != timerAlarmClock) continue;
            timerNotification = (TimerNotification)objectArray[0];
            date = (Date)objectArray[1];
            break;
        }
        this.sendNotification(date, timerNotification);
        this.updateTimerTable(timerNotification.getNotificationID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendNotification(Date date, TimerNotification timerNotification) {
        long l;
        if (this.isTraceOn()) {
            this.trace("sendNotification", "sending timer notification:\n\tNotification source = " + timerNotification.getSource() + "\n\tNotification type = " + timerNotification.getType() + "\n\tNotification ID = " + timerNotification.getNotificationID() + "\n\tNotification date = " + date);
        }
        Object object = this;
        synchronized (object) {
            ++this.sequenceNumber;
            l = this.sequenceNumber;
        }
        object = timerNotification;
        synchronized (object) {
            timerNotification.setTimeStamp(date.getTime());
            timerNotification.setSequenceNumber(l);
            this.sendNotification((TimerNotification)timerNotification.cloneTimerNotification());
        }
        if (this.isTraceOn()) {
            this.trace("sendNotification", "timer notification sent");
        }
    }
}

