/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.trace;

import com.sun.jmx.trace.TraceDestination;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TraceManager
implements TraceDestination {
    private static Level getLevel(int n) {
        switch (n) {
            case 2: {
                return Level.FINEST;
            }
            case 1: {
                return Level.FINER;
            }
            case 0: {
                return Level.SEVERE;
            }
        }
        return null;
    }

    private static Logger getLogger(int n) {
        switch (n) {
            case 1: {
                return Logger.getLogger("javax.management.mbeanserver");
            }
            case 2: {
                return Logger.getLogger("javax.management.mlet");
            }
            case 4: {
                return Logger.getLogger("javax.management.monitor");
            }
            case 8: {
                return Logger.getLogger("javax.management.timer");
            }
            case 16: {
                return Logger.getLogger("javax.management.misc");
            }
            case 32: {
                return Logger.getLogger("javax.management.notification");
            }
            case 64: {
                return Logger.getLogger("javax.management.relation");
            }
            case 128: {
                return Logger.getLogger("javax.management.modelmbean");
            }
        }
        return null;
    }

    public boolean isSelected(int n, int n2) {
        Level level;
        Logger logger = TraceManager.getLogger(n2);
        if (logger != null && (level = TraceManager.getLevel(n)) != null) {
            return logger.isLoggable(level);
        }
        return false;
    }

    public boolean send(int n, int n2, String string, String string2, String string3) {
        if (this.isSelected(n, n2)) {
            TraceManager.getLogger(n2).logp(TraceManager.getLevel(n), string, string2, string3);
            return true;
        }
        return false;
    }

    public boolean send(int n, int n2, String string, String string2, Throwable throwable) {
        if (this.isSelected(n, n2)) {
            TraceManager.getLogger(n2).log(TraceManager.getLevel(n), string + ": Exception occured in " + string2, throwable);
            return true;
        }
        return false;
    }

    public void reset() throws IOException {
    }

    void warning(String string, String string2) {
        Logger.getLogger(string).warning(string2);
    }

    void fine(String string, String string2) {
        Logger.getLogger(string).fine(string2);
    }
}

