/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.filemakers.xmlMaker.structure;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.PatternSyntaxException;
import psidev.psi.mi.filemakers.xmlMaker.mapping.DictionaryMapping;
import psidev.psi.mi.filemakers.xsd.Utils;

public class Dictionary {
    public int index;
    public HashMap dictionnary = new HashMap();
    public boolean caseSensitive;
    public String name;
    public BufferedReader input;
    public URL fileURL;
    public String separator;
    public String maxDefinitionLine;

    public void load(URL url, String separator) throws FileNotFoundException, PatternSyntaxException, IOException {
        this.fileURL = url;
        this.input = new BufferedReader(new InputStreamReader(this.fileURL.openStream()));
        Utils.lastVisitedDirectory = url.getPath();
        Utils.lastVisitedDictionaryDirectory = url.getPath();
        int maxDefinitionsNumber = 0;
        try {
            while (true) {
                String line;
                String[] values;
                if ((values = (String.valueOf(line = this.input.readLine().trim()) + " ").split(separator)).length > 0) {
                    String value = values[0].trim();
                    ArrayList<String> definitions = new ArrayList<String>();
                    int i = 1;
                    while (i < values.length) {
                        definitions.add(String.valueOf(values[i].trim()) + " ");
                        ++i;
                    }
                    if (definitions.size() > maxDefinitionsNumber) {
                        maxDefinitionsNumber = definitions.size();
                        this.maxDefinitionLine = line;
                    }
                    if (!this.caseSensitive) {
                        this.dictionnary.put(value.toLowerCase().trim(), definitions);
                    } else {
                        this.dictionnary.put(value.trim(), definitions);
                    }
                }
                this.name = Utils.relativizeURL(this.fileURL).getPath();
                this.separator = separator;
            }
        }
        catch (PatternSyntaxException ex) {
            return;
        }
        catch (Exception e) {
            return;
        }
    }

    public Dictionary() {
        this.caseSensitive = true;
    }

    public Dictionary(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public Dictionary(URL url, String separator, boolean caseSensitive) throws FileNotFoundException, IOException {
        this.caseSensitive = caseSensitive;
        this.fileURL = url;
        this.load(this.fileURL, separator);
    }

    public String getDefinition(String value, int definitionNumber) {
        try {
            if (this.caseSensitive) {
                return (String)((ArrayList)this.dictionnary.get(value)).get(definitionNumber - 1);
            }
            return (String)((ArrayList)this.dictionnary.get(value.toLowerCase())).get(definitionNumber - 1);
        }
        catch (NullPointerException e) {
            return null;
        }
        catch (IndexOutOfBoundsException e2) {
            return null;
        }
    }

    public String[] exampleList() {
        if (this.maxDefinitionLine == null) {
            String[] value = new String[]{};
            return value;
        }
        return this.maxDefinitionLine.split(this.separator);
    }

    public String exampleLine() {
        if (this.maxDefinitionLine == null) {
            return "";
        }
        return this.maxDefinitionLine;
    }

    public String toString() {
        return this.name;
    }

    public String getSeparator() {
        return this.separator;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public HashMap getDictionnary() {
        return this.dictionnary;
    }

    public void setDictionnary(HashMap dictionnary) {
        this.dictionnary = dictionnary;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getMaxDefinitionLine() {
        return this.maxDefinitionLine;
    }

    public void setMaxDefinitionLine(String maxDefinitionLine) {
        this.maxDefinitionLine = maxDefinitionLine;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public DictionaryMapping getMapping() {
        DictionaryMapping mapping = new DictionaryMapping();
        if (this.fileURL != null) {
            mapping.setFileURL(Utils.relativizeURL(this.fileURL).getPath());
        }
        mapping.setCaseSensitive(this.isCaseSensitive());
        mapping.setSeparator(this.separator);
        return mapping;
    }

    public URL getFileURL() {
        return this.fileURL;
    }

    public void setFileURL(URL fileURI) {
        this.fileURL = fileURI;
    }
}

