/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.filemakers.xmlMaker;

import java.beans.XMLDecoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import psidev.psi.mi.filemakers.xmlFlattener.XmlFlattener;
import psidev.psi.mi.filemakers.xmlMaker.mapping.DictionaryMapping;
import psidev.psi.mi.filemakers.xmlMaker.mapping.FlatFileMapping;
import psidev.psi.mi.filemakers.xmlMaker.mapping.Mapping;
import psidev.psi.mi.filemakers.xmlMaker.mapping.TreeMapping;
import psidev.psi.mi.filemakers.xmlMaker.structure.Dictionary;
import psidev.psi.mi.filemakers.xmlMaker.structure.FlatFile;
import psidev.psi.mi.filemakers.xmlMaker.structure.XsdTreeStructImpl;
import psidev.psi.mi.filemakers.xsd.FileMakersException;
import psidev.psi.mi.filemakers.xsd.SimpleMessageManager;
import psidev.psi.mi.filemakers.xsd.Utils;

public class XmlMaker {
    public XsdTreeStructImpl xsdTree = new XsdTreeStructImpl();

    private static void displayUsage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java -classpath classes/ -Djava.ext.dirs=libs " + XmlFlattener.class.getName() + " -mapping mapping.xml [-flatfiles flatfile1[,flatfile2]] [-dictionaries [dictionary1[,dictionary2]] [-o xmlDocument] [-log logfile]", options);
    }

    public void load(Mapping mapping) throws MalformedURLException, FileMakersException {
        this.xsdTree.flatFiles.flatFiles = new ArrayList();
        int i = 0;
        while (i < mapping.flatFiles.size()) {
            FlatFileMapping ffm = (FlatFileMapping)mapping.flatFiles.get(i);
            FlatFile f = new FlatFile();
            f.lineSeparator = ffm.lineSeparator;
            f.firstLineForTitles = ffm.fisrtLineForTitle;
            f.setSeparators(ffm.getSeparators());
            try {
                URL url = Utils.absolutizeURL(ffm.getFileURL());
                f.load(url);
            }
            catch (IOException ioe) {
                System.out.println("ERROR: unable to load flat file " + f.fileURL.getFile());
                throw new FileMakersException("unable to load flat file " + ffm.getFileURL());
            }
            this.xsdTree.flatFiles.addFlatFile(f);
            ++i;
        }
        this.xsdTree.dictionaries.dictionaries = new ArrayList();
        i = 0;
        while (i < mapping.dictionaries.size()) {
            DictionaryMapping dm = (DictionaryMapping)mapping.dictionaries.get(i);
            try {
                URL url = Utils.absolutizeURL(dm.getFileURL());
                Dictionary d1 = new Dictionary(url, dm.getSeparator(), dm.caseSensitive);
                this.xsdTree.dictionaries.dictionaries.add(d1);
            }
            catch (IOException ioe) {
                System.out.println("ERROR: unable to load dictionary file " + dm.getFileURL());
                throw new FileMakersException("unable to load dictionary file " + dm.getFileURL());
            }
            ++i;
        }
        TreeMapping treeMapping = mapping.getTree();
        File schema = new File(treeMapping.getSchemaURL());
        try {
            this.xsdTree.loadSchema(schema);
        }
        catch (IOException ioe) {
            System.out.println("ERROR: unable to load schema " + treeMapping.getSchemaURL());
            throw new FileMakersException("unable to load schema " + treeMapping.getSchemaURL());
        }
        this.xsdTree.loadMapping(treeMapping);
        this.xsdTree.check();
    }

    public XmlMaker() {
        this.xsdTree.setMessageManager(new SimpleMessageManager());
    }

    public static void main(String[] args) throws Exception {
        try {
            int j;
            String[] files;
            System.setProperty("java.awt.headless", "true");
            XmlMaker f = new XmlMaker();
            Option helpOpt = new Option("help", "print this message.");
            OptionBuilder.withArgName((String)"mapping");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"the mapping file, created by the GUI application");
            Option mappingOpt = OptionBuilder.create((String)"mapping");
            mappingOpt.setRequired(true);
            OptionBuilder.withArgName((String)"xml document");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"name of the log file");
            Option oOpt = OptionBuilder.create((String)"o");
            oOpt.setRequired(true);
            OptionBuilder.withArgName((String)"log");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"the mapping file, created by the GUI application");
            Option logOpt = OptionBuilder.create((String)"log");
            oOpt.setRequired(false);
            OptionBuilder.withArgName((String)"flat files");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"names of the flat files in the right order, separated by comma");
            Option flatfilesOpt = OptionBuilder.create((String)"flatfiles");
            oOpt.setRequired(false);
            OptionBuilder.withArgName((String)"dictionaries");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"names of the dictionary files in the right order, separated by comma");
            Option dictionariesOpt = OptionBuilder.create((String)"dictionaries");
            oOpt.setRequired(false);
            OptionBuilder.withArgName((String)"schema");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"the XML schema");
            Option schemaOpt = OptionBuilder.create((String)"schema");
            schemaOpt.setRequired(false);
            Options options = new Options();
            options.addOption(helpOpt);
            options.addOption(mappingOpt);
            options.addOption(oOpt);
            options.addOption(logOpt);
            options.addOption(flatfilesOpt);
            options.addOption(dictionariesOpt);
            options.addOption(schemaOpt);
            BasicParser parser = new BasicParser();
            CommandLine line = null;
            try {
                line = parser.parse(options, args, true);
            }
            catch (ParseException exp) {
                XmlMaker.displayUsage(options);
                System.err.println("Parsing failed.  Reason: " + exp.getMessage());
                System.exit(1);
            }
            if (line.hasOption("help")) {
                XmlMaker.displayUsage(options);
                System.exit(0);
            }
            String mappingFileName = line.getOptionValue("mapping");
            String flatFiles = line.getOptionValue("flatfiles");
            String dictionaries = line.getOptionValue("dictionaries");
            String schema = line.getOptionValue("schema");
            String xmlFile = line.getOptionValue("o");
            String logFile = line.getOptionValue("log");
            if (logFile == null) {
                logFile = String.valueOf(xmlFile) + ".log";
            }
            System.out.println("mapping = " + mappingFileName + ", output = " + xmlFile);
            if (mappingFileName == null || mappingFileName.length() == 0) {
                System.out.println("usage: java -classpath classes/ -Djava.ext.dirs=libs mint.filemakers.xmlFlattener.XmlMaker -mapping mapping.xml [-flatfiles flatfile1[,flatfile2]] [-dictionaries [dictionary1[,dictionary2]] [-o xmlDocument] [-log logfile]");
                System.out.println("Available parameters:");
                System.out.println("-mapping: the mapping file, created by the GUI application");
                System.out.println("-o: name of the XML document to write -log: name of the log file");
                System.out.println("-flatfiles: names of the flat files in the right order, separated by comma");
                System.out.println("-dictionaries: names of the dictionary files in the right order, separated by comma");
                return;
            }
            FileInputStream fin = new FileInputStream(mappingFileName);
            XMLDecoder xdec = new XMLDecoder(fin);
            Mapping mapping = (Mapping)xdec.readObject();
            if (flatFiles != null) {
                files = flatFiles.replaceAll("'", "").split(",");
                j = 0;
                while (j < files.length) {
                    ((FlatFileMapping)mapping.getFlatFiles().get((int)j)).fileURL = files[j];
                    System.out.println("flat file " + j + ": " + files[j]);
                    ++j;
                }
            }
            if (dictionaries != null) {
                files = dictionaries.replaceAll("'", "").split(",");
                j = 0;
                while (j < files.length) {
                    ((DictionaryMapping)mapping.getDictionaries().get(j)).setFileURL(files[j]);
                    System.out.println("dictionary " + j + ": " + files[j]);
                    ++j;
                }
            }
            if (schema != null) {
                mapping.getTree().setSchemaURL(schema.replaceAll("'", ""));
            }
            try {
                f.load(mapping);
            }
            catch (FileMakersException fme) {
                System.out.println("exit from program: unable to load the mapping");
                return;
            }
            f.xsdTree.print2(new File(xmlFile));
            System.out.println("done");
            return;
        }
        catch (Exception e) {
            System.out.println("usage: java -classpath classes/ -Djava.ext.dirs=libs mint.filemakers.xmlFlattener.XmlMaker -mapping mapping.xml [-flatfiles flatfile1[,flatfile2]] [-dictionaries [dictionary1[,dictionary2]] [-o xmlDocument] [-log logfile]");
            System.out.println("Available parameters:");
            System.out.println("-mapping: the mapping file, created by the GUI application");
            System.out.println("-o: name of the XML document to write -log: name of the log file");
            System.out.println("-flatfiles: names of the flat files in the right order, separated by comma");
            System.out.println("-dictionaries: names of the dictionary files in the right order, separated by comma");
            throw e;
        }
    }
}

