/*
 * Decompiled with CFR 0.152.
 */
package org.pathwaycommons.trans;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeMap;
import org.genemania.dw.tools.IdentifierMapperService;
import org.genemania.dw.util.DWUtil;
import org.genemania.dw.util.DefParams;
import org.genemania.dw.util.GenUtil;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.pathwaycommons.trans.BINDTags;
import org.pathwaycommons.trans.BINDToPSIMITransComplex;
import org.pathwaycommons.trans.CVMapEntry;
import org.pathwaycommons.trans.PSIMITags;
import org.pathwaycommons.trans.PSIMITrans;
import org.pathwaycommons.trans.util.XMLElementInfo;
import org.pathwaycommons.trans.util.XMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BINDToPSIMITrans
extends PSIMITrans {
    private boolean proteinAFlag;
    private boolean proteinBFlag;
    private int cntProteinA;
    private int cntProteinB;
    private boolean transComplexesFlag;
    private boolean mapIDsFlag;
    private boolean transProOnlyFlag;
    private boolean cleanDataFlag;
    private int cntTransInteraction;
    private int cntNonTransInteraction;
    private int cntTotalInteraction;
    private int cntBadInteraction;
    private String BINDInteractionID;
    protected static TreeMap<String, String> interactionsMap = new TreeMap();
    protected static TreeMap<String, String> badInteractionsMap = new TreeMap();
    protected ArrayList<String> BINDSpeciesList = new ArrayList();
    protected String fileName;
    protected BufferedWriter bw;
    protected String inputFilesPath;
    protected Namespace psins;
    protected int partID = 1;
    protected int interactionID = 1;
    protected int interactorID = 1;
    protected int expID = 1;
    protected int currentTaxID;
    protected boolean badInteractionData = false;

    protected BINDToPSIMITrans() {
    }

    protected BINDToPSIMITrans(String inputFilesPath) throws Exception {
        log = GenUtil.getDefaultLog();
        this.setInputPath(inputFilesPath);
        this.setMapIDsFlag(new Boolean(DefParams.getDefaultProp((String)"DefBINDMapIDs")));
        this.setTransComplexes(new Boolean(DefParams.getDefaultProp((String)"DefBINDTransComplexes")));
        this.setTransProOnly(new Boolean(DefParams.getDefaultProp((String)"DefBINDTransProOnly")));
        this.setCleanData(new Boolean(DefParams.getDefaultProp((String)"DefBINDCleanData")));
        XMLElementInfo.readFromFile();
        CVMapEntry.loadCVMappings(DefParams.getDefaultProp((String)"DefBINDPSIMICVFile"), "bind", "psimi");
    }

    private void setInputPath(String inputFilesPath) {
        this.inputFilesPath = inputFilesPath;
    }

    private void setMapIDsFlag(boolean mapIDsFlag) {
        this.mapIDsFlag = mapIDsFlag;
    }

    private void setTransComplexes(boolean transComplexes) {
        this.transComplexesFlag = transComplexes;
    }

    private void setTransProOnly(boolean transProOnly) {
        this.transProOnlyFlag = transProOnly;
    }

    private void setCleanData(boolean cleanDataFlag) {
        this.cleanDataFlag = cleanDataFlag;
    }

    public String getInputFilesPath() {
        return this.inputFilesPath;
    }

    public boolean isTransComplexes() {
        return this.transComplexesFlag;
    }

    public boolean isMapIDs() {
        return this.mapIDsFlag;
    }

    public boolean isTransProsOnly() {
        return this.transProOnlyFlag;
    }

    public boolean isCleanData() {
        return this.cleanDataFlag;
    }

    @Override
    public void translate() throws Exception {
        System.out.println("Translation type: BIND_TO_PSIMI25");
        System.out.println("Translating input: " + this.getInputFilesPath());
        File sourceFileOrDir = new File(this.getInputFilesPath());
        if (!this.isMapIDs()) {
            System.out.println("ID mapping service off.");
        }
        File badDataFile = new File(DefParams.getDefaultProp((String)"DefToolsPath"), "BAD_ENTRIES.txt");
        this.bw = new BufferedWriter(new FileWriter(badDataFile));
        if (sourceFileOrDir.isFile()) {
            this.fileName = sourceFileOrDir.getAbsolutePath();
            this.currentTaxID = Integer.parseInt(this.fileName.substring(this.fileName.indexOf("taxid") + "taxid".length(), this.fileName.indexOf(".")));
            this.addSpecies(this.currentTaxID);
            if (this.isMapIDs()) {
                IdentifierMapperService.flush((String[])new String[]{"Uniprot"}, (int[])new int[]{this.currentTaxID});
                IdentifierMapperService.init((String[])new String[]{"Uniprot"}, (int[])new int[]{this.currentTaxID});
            }
            Element rootElement = XMLUtil.readSchemaBasedXML(this.fileName);
            Element PSIRootElement = this.translateBIND(null, rootElement);
            String outputFileName = sourceFileOrDir.getName();
            if (outputFileName.contains(".xml")) {
                outputFileName = outputFileName.replace(".xml", "_PSIMI25.xml");
            }
            outputFileName = new File(new File(DefParams.getDefaultProp((String)"DefToolsPath")).getAbsolutePath(), outputFileName).getAbsolutePath();
            XMLUtil.dump(PSIRootElement, outputFileName);
            rootElement = null;
            PSIRootElement = null;
            System.gc();
        } else {
            String outputFileName;
            Object[] filesArr = sourceFileOrDir.listFiles();
            Arrays.sort(filesArr);
            Element PSIRootElement = null;
            for (int i = 0; i < filesArr.length; ++i) {
                int cnt = 1;
                if (!((File)filesArr[i]).getAbsolutePath().contains(".xml")) continue;
                this.fileName = ((File)filesArr[i]).getAbsolutePath();
                System.out.println("Processing file: " + cnt++ + " " + this.fileName);
                Element rootElement = XMLUtil.readSchemaBasedXML(this.fileName);
                int newTaxID = Integer.parseInt(this.fileName.substring(this.fileName.indexOf("taxid") + "taxid".length(), this.fileName.indexOf(".")));
                if (newTaxID != this.currentTaxID) {
                    if (this.isMapIDs()) {
                        IdentifierMapperService.flush((String[])new String[]{"Uniprot"}, (int[])new int[]{this.currentTaxID});
                    }
                    if (PSIRootElement != null) {
                        outputFileName = new File(new File(DefParams.getDefaultProp((String)"DefToolsPath")).getAbsolutePath(), "taxid" + this.currentTaxID + "_PSIMI25" + ".xml").getAbsolutePath();
                        XMLUtil.dump(PSIRootElement, outputFileName);
                        PSIRootElement = null;
                        outputFileName = null;
                        interactionsMap.clear();
                        badInteractionsMap.clear();
                    }
                    this.currentTaxID = newTaxID;
                    System.gc();
                }
                if (this.isMapIDs()) {
                    IdentifierMapperService.init((String[])new String[]{"Uniprot"}, (int[])new int[]{this.currentTaxID});
                }
                PSIRootElement = this.translateBIND(PSIRootElement, rootElement);
                rootElement = null;
                System.gc();
            }
            if (PSIRootElement != null) {
                outputFileName = new File(sourceFileOrDir.getAbsolutePath(), "taxid" + this.currentTaxID + "_PSIMI25" + ".xml").getAbsolutePath();
                XMLUtil.dump(PSIRootElement, outputFileName);
                PSIRootElement = null;
                System.gc();
            }
        }
        this.bw.flush();
        this.bw.close();
    }

    private Element translateBIND(Element entrySetE, Element BINDSubmitE) throws Exception {
        if (entrySetE == null) {
            entrySetE = this.setEntrySet();
        }
        this.translateAllInteractions(entrySetE, BINDSubmitE);
        return entrySetE;
    }

    private Element setEntrySet() {
        this.psins = Namespace.getNamespace((String)"net:sf:psidev:mi");
        Element entrySetE = new Element("entrySet", this.psins);
        entrySetE.setAttribute("schemaLocation", "net:sf:psidev:mi http://psidev.sourceforge.net/mi/rel25/src/MIF25.xsd", Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance"));
        entrySetE.setAttribute("level", "2");
        entrySetE.setAttribute("version", "5");
        return entrySetE;
    }

    private Element setEntry() throws JDOMException {
        Element entryE = new Element("entry", this.psins);
        Element sourceE = new Element("source", this.psins);
        this.setCVName(sourceE, "bind");
        Element bibRefE = new Element("bibref", this.psins);
        CVMapEntry CVMapper = CVMapEntry.getMappedEntry("pubmed");
        this.setXRef(bibRefE, "primaryRef", CVMapper.getPSIMITerm_SL(), CVMapper.getPSIMITermID(), "12519993", PSIMITags.getRefTypeAccn("source reference"), "source reference");
        sourceE.addContent((Content)bibRefE);
        entryE.addContent((Content)sourceE);
        return entryE;
    }

    protected void setNames(Element parent, String shortLabel, String fullName) {
        Element namesE = new Element("names", this.psins);
        if (shortLabel != null) {
            Element shortLabelE = new Element("shortLabel", this.psins);
            shortLabelE.addContent(shortLabel);
            namesE.addContent((Content)shortLabelE);
        } else {
            System.err.println("No short label provided: " + parent.getName());
        }
        if (fullName != null && !fullName.equals("NO_VALUE")) {
            Element fullNameE = new Element("fullName", this.psins);
            fullNameE.addContent(fullName);
            namesE.addContent((Content)fullNameE);
        }
        if (namesE.getChildren().size() > 0) {
            parent.addContent((Content)namesE);
        }
    }

    protected void setCVName(Element parent, String sourceTerm) {
        CVMapEntry CVMapped = CVMapEntry.getMappedEntry(sourceTerm);
        this.setNames(parent, CVMapped.getPSIMITerm_SL(), CVMapped.getPSIMITerm_FL());
    }

    protected void setCVRef(Element parent, String sourceTerm, String refType, String refElementName, String refValue) {
        CVMapEntry CVMapped = CVMapEntry.getMappedEntry(sourceTerm);
        this.setXRef(parent, refElementName, CVMapped.getPSIMITerm_SL(), CVMapped.getPSIMITermID(), refValue, PSIMITags.getRefTypeAccn(refType), refType);
    }

    protected void setXRef(Element parent, String refElementName, String DBName, String DBID) {
        this.setXRef(parent, refElementName, DBName, null, DBID, null, null);
    }

    protected void setXRef(Element parent, String refElementName, String DBName, String DBAccn, String DBID, String refTypeAccn, String refType) {
        Element xrefE = parent.getChild("xref", this.psins);
        if (xrefE == null) {
            xrefE = new Element("xref", this.psins);
            parent.addContent((Content)xrefE);
        }
        this.setRef(xrefE, refElementName, DBName, DBAccn, DBID, refTypeAccn, refType);
    }

    protected void setRef(Element parent, String name, String DBName, String DBAccn, String DBID, String refTypeAccn, String refType) {
        ArrayList tempList = new ArrayList();
        tempList.addAll(parent.getChildren());
        boolean found = false;
        for (int i = 0; i < tempList.size(); ++i) {
            if (!((Element)tempList.get(i)).getAttributeValue("db").equals(DBName) || !((Element)tempList.get(i)).getAttributeValue("id").equals(DBID)) continue;
            found = true;
            break;
        }
        if (!found) {
            Element refE = new Element(name, this.psins);
            refE.setAttribute("db", DBName);
            if (DBAccn != null) {
                refE.setAttribute("dbAc", DBAccn);
            }
            refE.setAttribute("id", DBID);
            if (refTypeAccn != null) {
                refE.setAttribute("refTypeAc", refTypeAccn);
            }
            if (refType != null) {
                refE.setAttribute("refType", refType);
            }
            parent.addContent((Content)refE);
        }
    }

    private void translateAllInteractions(Element entrySetE, Element BINDSubmitE) throws Exception {
        Element interactionListE;
        Element entryE = entrySetE.getChild("entry", this.psins);
        if (entryE == null) {
            entryE = this.setEntry();
            entrySetE.addContent((Content)entryE);
        }
        if ((interactionListE = entryE.getChild("interactionList", this.psins)) == null) {
            interactionListE = new Element("interactionList", this.psins);
            entryE.addContent((Content)interactionListE);
        }
        ArrayList<Element> bindIntList = XMLUtil.getElement("BIND-Interaction", BINDSubmitE, 1);
        for (int i = 0; i < bindIntList.size(); ++i) {
            this.translateInteraction(interactionListE, bindIntList.get(i));
        }
        System.out.println("For file: " + this.getInputFilesPath() + ": ");
        System.out.println("Total Interactions: " + this.cntTotalInteraction + " Translated: " + this.cntTransInteraction + " Skipped: " + this.cntNonTransInteraction + " Bad: " + this.cntBadInteraction + " Int A - Protein: " + this.cntProteinA + " Int B - Protein: " + this.cntProteinB);
        if (this.isTransComplexes()) {
            if (this.isTransProsOnly()) {
                System.err.println("No support for complexes with 'protein only' option");
                return;
            }
            BINDToPSIMITransComplex BINDComTrans = new BINDToPSIMITransComplex(this.inputFilesPath, this.fileName, this.psins, this.interactionID, this.interactorID, this.partID, this.expID, this.bw);
            BINDComTrans.translateAllComplexes(entryE, BINDSubmitE);
        }
        this.dumpBINDSpecies();
    }

    private void listAllInteractions() {
        System.out.println("Listing IDs for all interactions: BIND ID - PSI-MI ID");
        for (String intID : interactionsMap.keySet()) {
            System.out.println("Int: " + intID + " " + interactionsMap.get(intID));
        }
        System.out.println("Listing IDs for 'bad' interactions: BIND ID - PSI-MI ID");
        for (String intID : badInteractionsMap.keySet()) {
            System.out.println("Bad Int: " + intID + " " + badInteractionsMap.get(intID));
        }
    }

    private void translateInteraction(Element interactionListE, Element BINDInteractionE) throws JDOMException, IOException {
        Element interactionE = new Element("interaction", this.psins);
        ArrayList<Element> eList = XMLUtil.getElement("Interaction-id", BINDInteractionE, XMLUtil.getDepth("BIND-Interaction"));
        this.BINDInteractionID = null;
        if (XMLUtil.validateSingle("Interaction-id", eList) && XMLUtil.validateInt(eList.get(0))) {
            this.BINDInteractionID = eList.get(0).getTextTrim();
        }
        eList = XMLUtil.getElement("BIND-descr_simple-descr", BINDInteractionE, XMLUtil.getDepth("BIND-Interaction"));
        String shortLabel = "NO_VALUE";
        if (XMLUtil.validateSingle("BIND-descr_simple-descr", eList)) {
            shortLabel = this.getDefText(eList.get(0), "NO_VALUE");
        }
        if (!shortLabel.equals("NO_VALUE")) {
            this.setNames(interactionE, shortLabel, shortLabel);
        } else {
            this.setNames(interactionE, shortLabel, null);
            this.badInteractionData = true;
        }
        this.setCVRef(interactionE, "bind", "identity", "primaryRef", this.BINDInteractionID);
        Element expListE = new Element("experimentList", this.psins);
        interactionE.addContent((Content)expListE);
        this.translateExpDesc(expListE, BINDInteractionE, this.BINDInteractionID);
        Element partListE = new Element("participantList", this.psins);
        interactionE.addContent((Content)partListE);
        Element partE = new Element("participant", this.psins);
        partE.setAttribute("id", Integer.toString(this.partID++));
        partListE.addContent((Content)partE);
        Element interactorE = new Element("interactor", this.psins);
        partE.addContent((Content)interactorE);
        this.translateInteractor(interactorE, BINDInteractionE.getChild("BIND-Interaction_a"), this.interactorID++);
        partE = new Element("participant", this.psins);
        partE.setAttribute("id", Integer.toString(this.partID++));
        partListE.addContent((Content)partE);
        interactorE = new Element("interactor", this.psins);
        partE.addContent((Content)interactorE);
        this.translateInteractor(interactorE, BINDInteractionE.getChild("BIND-Interaction_b"), this.interactorID++);
        eList = XMLUtil.getElement("BIND-Rec-coll-descr_descr", BINDInteractionE, XMLUtil.getDepth("BIND-Interaction"));
        if (XMLUtil.validateSingle("BIND-Rec-coll-descr_descr", eList)) {
            String BINDDivision = BINDTags.checkBINDDiv(eList.get(0).getTextTrim());
            this.addAttribute(interactionE, "BIND Interaction Division", BINDDivision);
        }
        this.addInteraction(interactionListE, interactionE);
    }

    private void addInteraction(Element interactionListE, Element interactionE) throws IOException {
        interactionsMap.put(this.BINDInteractionID, String.valueOf(this.interactionID));
        interactionE.setAttribute("id", Integer.toString(this.interactionID++));
        if (!this.transProOnlyFlag || this.proteinAFlag && this.proteinBFlag) {
            ++this.cntTransInteraction;
            if (!this.badInteractionData) {
                interactionListE.addContent((Content)interactionE);
            } else {
                if (!this.cleanDataFlag) {
                    interactionListE.addContent((Content)interactionE);
                }
                this.badInteractionData = false;
                this.addAttribute(interactionE, "BAD Data File", this.fileName);
                XMLUtil.dump(interactionE, this.bw);
                this.bw.newLine();
                ++this.cntBadInteraction;
                badInteractionsMap.put(this.BINDInteractionID, interactionE.getAttributeValue("id"));
            }
        } else {
            ++this.cntNonTransInteraction;
            if (this.badInteractionData) {
                this.badInteractionData = false;
            }
        }
        ++this.cntTotalInteraction;
        if (this.proteinAFlag) {
            ++this.cntProteinA;
        }
        if (this.proteinBFlag) {
            ++this.cntProteinB;
        }
        this.proteinAFlag = false;
        this.proteinBFlag = false;
    }

    private void translateExpDesc(Element expListE, Element BINDInteractionE, String BINDInteractionID) throws JDOMException {
        ArrayList<Element> eList = XMLUtil.getElement("BIND-condition", BINDInteractionE, XMLUtil.getDepth("BIND-Interaction"));
        if (!XMLUtil.validateExists("BIND-condition", eList)) {
            Element expDescE = new Element("experimentDescription", this.psins);
            expDescE.setAttribute("id", Integer.toString(this.expID++));
            expListE.addContent((Content)expDescE);
            Element intDetMethodE = new Element("interactionDetectionMethod", this.psins);
            this.setNames(intDetMethodE, "unspecified method", "unspecified method");
            this.setXRef(intDetMethodE, "primaryRef", "psimi", "MI:0488", "MI:0686", null, null);
            this.translatePubMed(expDescE, BINDInteractionE.getChild("BIND-Interaction_source"));
            if (expDescE.getChildren("bibref", this.psins).size() == 0) {
                Element bibRefE = new Element("bibref", this.psins);
                CVMapEntry CVMapped = CVMapEntry.getMappedEntry("bind");
                this.setXRef(bibRefE, "primaryRef", CVMapped.getPSIMITerm_SL(), CVMapped.getPSIMITermID(), BINDInteractionID, null, null);
                expDescE.addContent((Content)bibRefE);
            }
            expDescE.addContent((Content)intDetMethodE);
        } else {
            for (int i = 0; i < eList.size(); ++i) {
                Element expDescE = new Element("experimentDescription", this.psins);
                expDescE.setAttribute("id", Integer.toString(this.expID++));
                expListE.addContent((Content)expDescE);
                Element intDetMethodE = new Element("interactionDetectionMethod", this.psins);
                this.translateDetectionMethod(expDescE, intDetMethodE, eList.get(i));
                if (intDetMethodE.getChildren().size() == 0) {
                    this.setNames(intDetMethodE, "unspecified method", "unspecified method");
                    this.setXRef(intDetMethodE, "primaryRef", "psimi", "MI:0488", "MI:0686", null, null);
                }
                this.translatePubMed(expDescE, eList.get(i));
                this.translatePubMed2(expDescE, eList.get(i));
                if (expDescE.getChildren("bibref", this.psins).size() == 0) {
                    Element bibRefE = new Element("bibref", this.psins);
                    CVMapEntry CVMapped = CVMapEntry.getMappedEntry("bind");
                    this.setXRef(bibRefE, "primaryRef", CVMapped.getPSIMITerm_SL(), CVMapped.getPSIMITermID(), BINDInteractionID, null, null);
                    expDescE.addContent((Content)bibRefE);
                }
                expDescE.addContent((Content)intDetMethodE);
            }
        }
    }

    private void translateDetectionMethod(Element expDescE, Element intDetMethodE, Element BINDConditionE) throws JDOMException {
        String shortLabel = null;
        String fullName = null;
        ArrayList<Element> tempList = XMLUtil.getElement("BIND-condition_descr", BINDConditionE, XMLUtil.getDepth("BIND-condition"));
        if (XMLUtil.validateSingle("BIND-condition_descr", tempList)) {
            fullName = this.getDefText(tempList.get(0), "NO_VALUE");
        }
        if (XMLUtil.validateSingle("BIND-experimental-system", tempList = XMLUtil.getElement("BIND-experimental-system", BINDConditionE, XMLUtil.getDepth("BIND-condition")))) {
            shortLabel = tempList.get(0).getAttributeValue("value");
            CVMapEntry CVMapped = CVMapEntry.getMappedEntry(shortLabel);
            if (CVMapped == null) {
                System.err.println("Error: Undetected BIND exp: " + shortLabel);
                this.setNames(intDetMethodE, shortLabel, shortLabel);
                this.setXRef(intDetMethodE, "primaryRef", "bind", "MI:0462", tempList.get(0).getTextTrim(), null, null);
            } else {
                this.setNames(intDetMethodE, CVMapped.getPSIMITerm_SL(), CVMapped.getPSIMITerm_FL());
                if (CVMapped.getPSIMITermID() != null) {
                    this.setXRef(intDetMethodE, "primaryRef", "psimi", "MI:0488", CVMapped.getPSIMITermID(), null, null);
                } else {
                    this.setXRef(intDetMethodE, "primaryRef", "bind", "MI:0462", CVMapped.getSourceID(), null, null);
                }
            }
        }
        this.setNames(expDescE, shortLabel, fullName);
    }

    protected void translatePubMed(Element PSIReferencedE, Element BINDReferencedE) throws JDOMException {
        ArrayList<Element> pubMedList = XMLUtil.getElement("PubMedId", BINDReferencedE, XMLUtil.getDepth(BINDReferencedE.getName()), true);
        this.translateReferences(pubMedList, PSIReferencedE);
    }

    protected void translatePubMed2(Element PSIReferencedE, Element BINDReferencedE) throws JDOMException {
        ArrayList<Element> pubMedList = XMLUtil.getElement("Pub_muid", BINDReferencedE, XMLUtil.getDepth(BINDReferencedE.getName()), true);
        this.translateReferences(pubMedList, PSIReferencedE);
    }

    protected void translateReferences(ArrayList<Element> pubMedList, Element PSIReferencedE) throws JDOMException {
        boolean addFlag = false;
        boolean firstTime = true;
        Element bibRefE = PSIReferencedE.getChild("bibref", this.psins);
        if (bibRefE == null) {
            bibRefE = new Element("bibref", this.psins);
            addFlag = true;
        } else {
            firstTime = false;
        }
        for (int j = 0; j < pubMedList.size(); ++j) {
            CVMapEntry CVMapper = CVMapEntry.getMappedEntry("pubmed");
            if (firstTime) {
                this.setXRef(bibRefE, "primaryRef", CVMapper.getPSIMITerm_SL(), CVMapper.getPSIMITermID(), this.getDefText(pubMedList.get(j), "NO_VALUE"), PSIMITags.getRefTypeAccn("source reference"), "source reference");
                firstTime = false;
                continue;
            }
            this.setXRef(bibRefE, "secondaryRef", CVMapper.getPSIMITerm_SL(), CVMapper.getPSIMITermID(), this.getDefText(pubMedList.get(j), "NO_VALUE"), PSIMITags.getRefTypeAccn("source reference"), "source reference");
        }
        if (bibRefE.getChildren().size() > 0 && addFlag) {
            PSIReferencedE.addContent((Content)bibRefE);
        }
    }

    protected void translateInteractor(Element interactorE, Element BINDInteractorE, int interactorID) throws JDOMException {
        interactorE.setAttribute("id", Integer.toString(interactorID));
        Element interactorTypeE = new Element("interactorType", this.psins);
        Element BINDInteractorTypeE = this.translateInteractorType(interactorTypeE, BINDInteractorE);
        String shortLabel = "NO_VALUE";
        String fullName = null;
        Element BINDNameE = null;
        ArrayList<Element> tempList = XMLUtil.getElement("BIND-object_short-label", BINDInteractorE, XMLUtil.getDepth(BINDInteractorE.getName()));
        if (XMLUtil.validateSingle("BIND-object_short-label", tempList)) {
            shortLabel = this.getDefText(tempList.get(0), "NO_VALUE");
            BINDNameE = tempList.get(0);
        }
        if (shortLabel.equals("NO_VALUE")) {
            this.badInteractionData = true;
        }
        if (XMLUtil.validateSingle("BIND-object_descr", tempList = XMLUtil.getElement("BIND-object_descr", BINDInteractorE, XMLUtil.getDepth(BINDInteractorE.getName())))) {
            fullName = this.getDefText(tempList.get(0), "NO_VALUE");
        }
        this.setNames(interactorE, shortLabel, fullName);
        tempList = XMLUtil.getElement("BIND-object_extref", BINDInteractorE, XMLUtil.getDepth(BINDInteractorE.getName()));
        Element BINDExtRefE = null;
        if (XMLUtil.validateSingle("BIND-object_extref", tempList)) {
            BINDExtRefE = tempList.get(0);
        }
        int interactorSpeciesID = -1;
        Element organismE = new Element("organism", this.psins);
        tempList = XMLUtil.getElement("Object-id_id", BINDInteractorE, XMLUtil.getDepth(BINDInteractorE.getName()), false);
        ArrayList<Element> orgNameList = XMLUtil.getElement("Org-ref_taxname", BINDInteractorE, XMLUtil.getDepth(BINDInteractorE.getName()));
        if (XMLUtil.validateSingle("Object-id_id", tempList) && XMLUtil.validateInt(tempList.get(0))) {
            organismE.setAttribute("ncbiTaxId", this.getDefText(tempList.get(0), "NO_VALUE"));
            interactorSpeciesID = Integer.parseInt(this.getDefText(tempList.get(0), "NO_VALUE"));
            if (XMLUtil.validateSingle("Org-ref_taxname", orgNameList)) {
                String orgName = this.getDefText(orgNameList.get(0), "NO_VALUE");
                if (!orgName.equals("NO_VALUE")) {
                    this.setNames(organismE, orgName, orgName);
                } else {
                    System.err.println("Bad org name: " + orgNameList.get(0).getTextTrim());
                }
            } else {
                System.err.println("Error: tax ID but no org name in BIND.");
            }
        } else {
            organismE.setAttribute("ncbiTaxId", "32644");
            this.setNames(organismE, "unidentified", "unidentified");
        }
        if (interactorSpeciesID == -1) {
            interactorSpeciesID = Integer.parseInt("32644");
        }
        this.addSpecies(interactorSpeciesID);
        this.translateInteractorID(interactorE, BINDInteractorE, BINDExtRefE, BINDNameE, BINDInteractorTypeE, interactorSpeciesID);
        interactorE.addContent((Content)interactorTypeE);
        if (organismE.getChildren().size() > 0) {
            interactorE.addContent((Content)organismE);
        }
    }

    private Element translateInteractorType(Element interactorTypeE, Element BINDInteractorE) throws JDOMException {
        ArrayList<Element> tempList = XMLUtil.getElement("BIND-object-type-id_protein", BINDInteractorE, XMLUtil.getDepth(BINDInteractorE.getName()));
        if (XMLUtil.validateSingle("BIND-object-type-id_protein", tempList)) {
            CVMapEntry CVMapper = CVMapEntry.getMappedEntry("BIND-object-type-id_protein");
            this.setNames(interactorTypeE, CVMapper.getPSIMITerm_SL(), CVMapper.getPSIMITerm_FL());
            this.setXRef(interactorTypeE, "primaryRef", "psimi", "MI:0488", CVMapper.getTargetID(), null, null);
            if (BINDInteractorE.getName().equals("BIND-Interaction_a")) {
                this.proteinAFlag = true;
            } else if (BINDInteractorE.getName().equals("BIND-Interaction_b")) {
                this.proteinBFlag = true;
            }
            return tempList.get(0);
        }
        if (!BINDInteractorE.getName().equals("BIND-mol-object") && XMLUtil.validateSingle("BIND-object-type-id_gene", tempList = XMLUtil.getElement("BIND-object-type-id_gene", BINDInteractorE, XMLUtil.getDepth(BINDInteractorE.getName())))) {
            CVMapEntry CVMapper = CVMapEntry.getMappedEntry("BIND-object-type-id_gene");
            this.setNames(interactorTypeE, CVMapper.getPSIMITerm_SL(), CVMapper.getPSIMITerm_FL());
            this.setXRef(interactorTypeE, "primaryRef", "psimi", "MI:0488", CVMapper.getTargetID(), null, null);
            return tempList.get(0);
        }
        tempList = XMLUtil.getElement("BIND-object-type-id_dna", BINDInteractorE, XMLUtil.getDepth(BINDInteractorE.getName()));
        if (XMLUtil.validateSingle("BIND-object-type-id_dna", tempList)) {
            CVMapEntry CVMapper = CVMapEntry.getMappedEntry("BIND-object-type-id_dna");
            this.setNames(interactorTypeE, CVMapper.getPSIMITerm_SL(), CVMapper.getPSIMITerm_FL());
            this.setXRef(interactorTypeE, "primaryRef", "psimi", "MI:0488", CVMapper.getTargetID(), null, null);
            return tempList.get(0);
        }
        tempList = XMLUtil.getElement("BIND-object-type-id_rna", BINDInteractorE, XMLUtil.getDepth(BINDInteractorE.getName()));
        if (XMLUtil.validateSingle("BIND-object-type-id_rna", tempList)) {
            CVMapEntry CVMapper = CVMapEntry.getMappedEntry("BIND-object-type-id_rna");
            this.setNames(interactorTypeE, CVMapper.getPSIMITerm_SL(), CVMapper.getPSIMITerm_FL());
            this.setXRef(interactorTypeE, "primaryRef", "psimi", "MI:0488", CVMapper.getTargetID(), null, null);
            return tempList.get(0);
        }
        tempList = XMLUtil.getElement("BIND-object-type-id_complex", BINDInteractorE, XMLUtil.getDepth(BINDInteractorE.getName()));
        if (XMLUtil.validateSingle("BIND-object-type-id_complex", tempList)) {
            CVMapEntry CVMapper = CVMapEntry.getMappedEntry("BIND-object-type-id_complex");
            this.setNames(interactorTypeE, CVMapper.getPSIMITerm_SL(), CVMapper.getPSIMITerm_FL());
            this.setXRef(interactorTypeE, "primaryRef", "psimi", "MI:0488", CVMapper.getTargetID(), null, null);
            return tempList.get(0);
        }
        tempList = XMLUtil.getElement("BIND-object-type-id_small-molecule", BINDInteractorE, XMLUtil.getDepth(BINDInteractorE.getName()));
        if (XMLUtil.validateSingle("BIND-object-type-id_small-molecule", tempList)) {
            CVMapEntry CVMapper = CVMapEntry.getMappedEntry("BIND-object-type-id_small-molecule");
            this.setNames(interactorTypeE, CVMapper.getPSIMITerm_SL(), CVMapper.getPSIMITerm_FL());
            this.setXRef(interactorTypeE, "primaryRef", "psimi", "MI:0488", CVMapper.getTargetID(), null, null);
            return tempList.get(0);
        }
        if (!BINDInteractorE.getName().equals("BIND-mol-object") && XMLUtil.validateSingle("BIND-object-type-id_not-specified", tempList = XMLUtil.getElement("BIND-object-type-id_not-specified", BINDInteractorE, XMLUtil.getDepth(BINDInteractorE.getName())))) {
            CVMapEntry CVMapper = CVMapEntry.getMappedEntry("BIND-object-type-id_not-specified");
            this.setNames(interactorTypeE, CVMapper.getPSIMITerm_SL(), CVMapper.getPSIMITerm_FL());
            this.setXRef(interactorTypeE, "primaryRef", "psimi", "MI:0488", CVMapper.getTargetID(), null, null);
            return tempList.get(0);
        }
        if (!BINDInteractorE.getName().equals("BIND-mol-object") && XMLUtil.validateSingle("BIND-object-type-id_photon", tempList = XMLUtil.getElement("BIND-object-type-id_photon", BINDInteractorE, XMLUtil.getDepth(BINDInteractorE.getName())))) {
            CVMapEntry CVMapper = CVMapEntry.getMappedEntry("BIND-object-type-id_photon");
            this.setNames(interactorTypeE, CVMapper.getPSIMITerm_SL(), CVMapper.getPSIMITerm_FL());
            this.setXRef(interactorTypeE, "primaryRef", "psimi", "MI:0488", CVMapper.getTargetID(), null, null);
            return tempList.get(0);
        }
        System.err.println("Unsupported interactant type for: " + BINDInteractorE.getName());
        return null;
    }

    private void translateInteractorID(Element interactorE, Element BINDInteractorE, Element BINDExtRefE, Element BINDNameE, Element BINDInteractorTypeE, int interactorSpeciesID) throws JDOMException {
        ArrayList<Element> otherDBList;
        CVMapEntry CVMapped;
        ArrayList<Element> tempList;
        String refTypeAccn;
        String refType;
        CVMapEntry CVMapped2;
        if (BINDNameE == null || BINDNameE.getText().trim().length() == 0 || BINDNameE.getText().trim().equalsIgnoreCase("Unknown") || BINDNameE.getText().trim().equalsIgnoreCase("NULL")) {
            return;
        }
        if (BINDInteractorTypeE == null) {
            System.err.println("Missing interactor type: PSI-MI interactor ID: " + interactorE.getAttributeValue("id") + " " + interactorSpeciesID);
            this.setXRef(interactorE, "primaryRef", "psimi", "MI:0329");
            return;
        }
        String BINDInteractorType = BINDInteractorTypeE.getName();
        if (BINDInteractorType.equals("BIND-object-type-id_not-specified") || BINDInteractorType.equals("BIND-object-type-id_photon")) {
            this.setXRef(interactorE, "primaryRef", "psimi", "MI:0329");
            return;
        }
        boolean pRefSetFlag = false;
        String interactorType = null;
        if (BINDInteractorType.equals("BIND-object-type-id_protein") || BINDInteractorType.equals("BIND-object-type-id_dna") || BINDInteractorType.equals("BIND-object-type-id_rna") || BINDInteractorType.equals("BIND-object-type-id_gene")) {
            if (BINDInteractorType.equals("BIND-object-type-id_protein")) {
                interactorType = "protein";
            } else if (BINDInteractorType.equals("BIND-object-type-id_dna")) {
                interactorType = "dna";
            } else if (BINDInteractorType.equals("BIND-object-type-id_rna")) {
                interactorType = "rna";
            } else if (BINDInteractorType.equals("BIND-object-type-id_gene")) {
                interactorType = "gene";
            }
            ArrayList<Element> giList = new ArrayList<Element>();
            ArrayList<Element> domainIDList = new ArrayList<Element>();
            Element BINDObjectID = BINDInteractorTypeE.getChild("BIND-id");
            if (BINDObjectID.getChild("BIND-id_gi") != null) {
                giList.addAll(BINDObjectID.getChild("BIND-id_gi").getChildren("Geninfo-id"));
            }
            if (BINDObjectID.getChild("BIND-id_di") != null) {
                domainIDList.addAll(BINDObjectID.getChild("BIND-id_di").getChildren("Domain-id"));
            }
            if (XMLUtil.validateSingle("Geninfo-id", giList) && XMLUtil.validateInt(giList.get(0))) {
                this.mapXref(interactorE, interactorType, "GI", giList.get(0).getTextTrim(), interactorSpeciesID);
                pRefSetFlag = true;
            }
            if (XMLUtil.validateSingle("Domain-id", domainIDList) && XMLUtil.validateInt(domainIDList.get(0))) {
                CVMapped2 = CVMapEntry.getMappedEntry("Entrez Gene");
                refType = CVMapped2.getAddInfo(interactorType, domainIDList.get(0).getTextTrim());
                refTypeAccn = PSIMITags.getRefTypeAccn(refType);
                if (!pRefSetFlag) {
                    this.setXRef(interactorE, "primaryRef", CVMapped2.getPSIMITerm_SL(), CVMapped2.getPSIMITermID(), domainIDList.get(0).getTextTrim(), refTypeAccn, refType);
                    this.mapXref(interactorE, interactorType, "ExtID", domainIDList.get(0).getTextTrim(), interactorSpeciesID);
                    pRefSetFlag = true;
                } else {
                    this.setXRef(interactorE, "secondaryRef", CVMapped2.getPSIMITerm_SL(), CVMapped2.getPSIMITermID(), domainIDList.get(0).getTextTrim(), refTypeAccn, refType);
                    this.mapXref(interactorE, interactorType, "ExtID", domainIDList.get(0).getTextTrim(), interactorSpeciesID);
                }
            }
        } else if (BINDInteractorType.equals("BIND-object-type-id_small-molecule")) {
            interactorType = "small molecule";
            tempList = XMLUtil.getElement("Internal-small-molecule-id", BINDInteractorE, XMLUtil.getDepth(BINDInteractorE.getName()));
            if (XMLUtil.validateSingle("Internal-small-molecule-id", tempList) && XMLUtil.validateInt(tempList.get(0))) {
                CVMapped = CVMapEntry.getMappedEntry("bind");
                refType = CVMapped.getAddInfo(interactorType, tempList.get(0).getTextTrim());
                refTypeAccn = PSIMITags.getRefTypeAccn(refType);
                this.setXRef(interactorE, "primaryRef", CVMapped.getPSIMITerm_SL(), CVMapped.getPSIMITermID(), tempList.get(0).getTextTrim(), refTypeAccn, refType);
                pRefSetFlag = true;
            }
        } else if (BINDInteractorType.equals("BIND-object-type-id_complex")) {
            interactorType = "complex";
            tempList = XMLUtil.getElement("Molecular-Complex-id", BINDInteractorE, XMLUtil.getDepth(BINDInteractorE.getName()));
            if (XMLUtil.validateSingle("Molecular-Complex-id", tempList) && XMLUtil.validateInt(tempList.get(0))) {
                CVMapped = CVMapEntry.getMappedEntry("BIND_COMPLEXID");
                refType = CVMapped.getAddInfo(interactorType, tempList.get(0).getTextTrim());
                refTypeAccn = PSIMITags.getRefTypeAccn(refType);
                this.setXRef(interactorE, "primaryRef", CVMapped.getPSIMITerm_SL(), CVMapped.getPSIMITermID(), tempList.get(0).getTextTrim(), refTypeAccn, refType);
                pRefSetFlag = true;
            }
        }
        if (BINDExtRefE != null && XMLUtil.validateExists("BIND-other-db", otherDBList = XMLUtil.getElement("BIND-other-db", BINDInteractorE, XMLUtil.getDepth(BINDInteractorE.getName())))) {
            for (int i = 0; i < otherDBList.size(); ++i) {
                String otherDBName = otherDBList.get(i).getChildText("BIND-other-db_dbname");
                String otherDBID = null;
                if (otherDBList.get(i).getChild("BIND-other-db_strp") != null && (otherDBID = this.getDefText(otherDBList.get(i).getChild("BIND-other-db_strp"), "NO_VALUE")).equals("NO_VALUE")) {
                    otherDBID = null;
                }
                if (otherDBList.get(i).getChild("BIND-other-db_intp") != null && XMLUtil.validateInt(otherDBList.get(i).getChild("BIND-other-db_intp"))) {
                    if (otherDBID != null) {
                        otherDBID = otherDBID + "(" + otherDBList.get(i).getChildText("BIND-other-db_intp") + ")";
                        System.err.println("Bad xref format: " + otherDBName + " " + otherDBID);
                    } else {
                        otherDBID = otherDBList.get(i).getChildText("BIND-other-db_intp");
                    }
                }
                if (otherDBID == null) continue;
                CVMapped2 = CVMapEntry.getMappedEntry(otherDBName);
                refType = CVMapped2.getAddInfo(interactorType, otherDBID);
                refTypeAccn = PSIMITags.getRefTypeAccn(refType);
                if (!pRefSetFlag) {
                    this.setXRef(interactorE, "primaryRef", CVMapped2.getPSIMITerm_SL(), CVMapped2.getPSIMITermID(), otherDBID, refTypeAccn, refType);
                    pRefSetFlag = true;
                    continue;
                }
                this.setXRef(interactorE, "secondaryRef", CVMapped2.getPSIMITerm_SL(), CVMapped2.getPSIMITermID(), otherDBID, refTypeAccn, refType);
            }
        }
        if (!pRefSetFlag) {
            this.setXRef(interactorE, "primaryRef", "psimi", "MI:0329");
            return;
        }
    }

    protected void addAttribute(Element parent, String attName, String attValue) {
        if (attValue.length() == 0) {
            System.err.println("Warning: Dummy attribute value for: " + attName);
            return;
        }
        Element attListE = parent.getChild("attributeList", this.psins);
        if (attListE == null) {
            attListE = new Element("attributeList", this.psins);
            parent.addContent((Content)attListE);
        }
        Element attE = new Element("attribute", this.psins);
        attE.setAttribute("name", attName);
        attE.setText(attValue);
        attListE.addContent((Content)attE);
    }

    protected void mapXref(Element parent, String interactorType, String sourceType, String sourceID, int interactorSpeciesID) {
        CVMapEntry CVMapped = null;
        if (!this.isMapIDs()) {
            if (sourceType.equals("GI")) {
                CVMapped = CVMapEntry.getMappedEntry("Entrez GI");
                String refType = CVMapped.getAddInfo(interactorType, sourceID);
                String refTypeAccn = PSIMITags.getRefTypeAccn(refType);
                this.setXRef(parent, "primaryRef", CVMapped.getPSIMITerm_SL(), CVMapped.getPSIMITermID(), sourceID, refTypeAccn, refType);
            }
            return;
        }
        ArrayList supUniprotList = new ArrayList();
        ArrayList refSeqProList = new ArrayList();
        ArrayList refSeqNucList = new ArrayList();
        ArrayList genProList = new ArrayList();
        ArrayList uniprotList = interactorSpeciesID != Integer.parseInt("32644") ? IdentifierMapperService.getUniprotIDByXref((String)sourceType, (String)sourceID, (int)interactorSpeciesID) : IdentifierMapperService.getUniprotIDByXref((String)sourceType, (String)sourceID);
        String sourceTerm = null;
        if (sourceType.equals("GI")) {
            refSeqProList = IdentifierMapperService.getXrefLO((String)sourceType, (String)sourceID, (String)"RefSeqPro");
            refSeqNucList = IdentifierMapperService.getXrefLO((String)sourceType, (String)sourceID, (String)"RefSeqRNA");
            genProList = IdentifierMapperService.getXrefLO((String)sourceType, (String)sourceID, (String)"LO_PROTEIN");
            supUniprotList = IdentifierMapperService.getXrefLO((String)sourceType, (String)sourceID, (String)"LO_GI_UNI");
            sourceTerm = uniprotList.size() > 0 || refSeqProList.size() > 0 || genProList.size() > 0 ? "Entrez_GI_PRO_IDMAP" : (refSeqNucList.size() > 0 ? "Entrez_GI_NUC_IDMAP" : "Entrez GI");
            CVMapped = CVMapEntry.getMappedEntry(sourceTerm);
            String refType = CVMapped.getAddInfo(interactorType, sourceID);
            String refTypeAccn = PSIMITags.getRefTypeAccn(refType);
            this.setXRef(parent, "primaryRef", CVMapped.getPSIMITerm_SL(), CVMapped.getPSIMITermID(), sourceID, refTypeAccn, refType);
        }
        if (uniprotList.size() > 0) {
            this.addMappedRefList(parent, interactorType, sourceID, "SWISSPROT_IDMAP", uniprotList);
        }
        if (supUniprotList.size() > 0) {
            this.addMappedRefList(parent, interactorType, sourceID, "SWISSPROT_IDMAP", supUniprotList);
        }
        if (refSeqProList.size() > 0) {
            this.addMappedRefList(parent, interactorType, sourceID, "REFSEQ_P_IDMAP", refSeqProList);
        }
        if (refSeqNucList.size() > 0) {
            this.addMappedRefList(parent, interactorType, sourceID, "REFSEQ_M_IDMAP", refSeqNucList);
        }
        if (genProList.size() > 0) {
            this.addMappedRefList(parent, interactorType, sourceID, "PROTEIN_IDMAP", genProList);
        }
    }

    protected void addMappedRefList(Element parent, String interactorType, String sourceID, String listType, ArrayList<String> mappedList) {
        CVMapEntry CVMapped = CVMapEntry.getMappedEntry(listType);
        String refType = CVMapped.getAddInfo(interactorType, sourceID);
        String refTypeAccn = PSIMITags.getRefTypeAccn(refType);
        for (int i = 0; i < mappedList.size(); ++i) {
            this.setXRef(parent, "secondaryRef", CVMapped.getPSIMITerm_SL(), CVMapped.getPSIMITermID(), mappedList.get(i), refTypeAccn, refType);
        }
    }

    protected String getDefText(Element element, String defValue) {
        if (!(element.getText().trim().length() <= 0 || element.getText().trim().equalsIgnoreCase("NULL") || element.getText().trim().equals("0") || element.getText().trim().equals("NULL.") || element.getText().trim().contains("WP:NULL") || element.getText().trim().equalsIgnoreCase("unknown") || element.getText().trim().equalsIgnoreCase("unknown."))) {
            return element.getText().trim();
        }
        return defValue;
    }

    protected void addSpecies(int speciesID) {
        if (speciesID > 0 && !this.BINDSpeciesList.contains(String.valueOf(speciesID))) {
            this.BINDSpeciesList.add(String.valueOf(speciesID));
        }
    }

    private void dumpBINDSpecies() throws Exception {
        for (int i = 0; i < this.BINDSpeciesList.size(); ++i) {
            String speciesIDStr = this.BINDSpeciesList.get(i);
            String speciesStr = DWUtil.dumpSpeciesNames((int)Integer.parseInt(speciesIDStr));
            log.println(speciesIDStr + "\t" + speciesStr);
        }
    }
}

