/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.tools.ontology_manager;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.tools.ontologyCfgReader.mapping.jaxb.CvSource;
import psidev.psi.tools.ontologyCfgReader.mapping.jaxb.CvSourceList;
import psidev.psi.tools.ontologyConfigReader.OntologyConfigReader;
import psidev.psi.tools.ontologyConfigReader.OntologyConfigReaderException;
import psidev.psi.tools.ontology_manager.impl.local.LocalOntology;
import psidev.psi.tools.ontology_manager.impl.local.OntologyLoaderException;
import psidev.psi.tools.ontology_manager.impl.ols.OlsOntology;
import psidev.psi.tools.ontology_manager.interfaces.OntologyAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OntologyManager {
    public static final Log log = LogFactory.getLog(OntologyManager.class);
    private Map<String, OntologyAccess> ontologies = new HashMap<String, OntologyAccess>();
    private File ontologyDirectory = null;
    public static final String CLASSPATH_PREFIX = "classpath:";
    private static final Map<String, Class> keyword2class = new HashMap<String, Class>();

    public OntologyManager() {
        if (log.isDebugEnabled()) {
            log.info((Object)"Created new unconfigured OntologyManager.");
        }
    }

    public OntologyManager(InputStream configFile) throws OntologyLoaderException {
        this.loadOntologies(configFile);
        if (log.isDebugEnabled()) {
            log.info((Object)"Successfully created and configured new OntologyManager.");
        }
    }

    public OntologyAccess putOntology(String ontologyID, OntologyAccess ontology) {
        if (this.ontologies.containsKey(ontologyID)) {
            log.warn((Object)("Ontology with the ID '" + ontologyID + "' already exists. Overwriting!"));
        }
        return this.ontologies.put(ontologyID, ontology);
    }

    public Set<String> getOntologyIDs() {
        return this.ontologies.keySet();
    }

    public OntologyAccess getOntologyAccess(String ontologyID) {
        return this.ontologies.get(ontologyID);
    }

    public void setOntologyDirectory(File ontologyDirectory) {
        this.ontologyDirectory = ontologyDirectory;
    }

    public boolean containsOntology(String ontologyID) {
        return this.ontologies.containsKey(ontologyID);
    }

    public void loadOntologies(InputStream configFile) throws OntologyLoaderException {
        CvSourceList cvSourceList;
        OntologyConfigReader ocr = new OntologyConfigReader();
        try {
            cvSourceList = ocr.read(configFile);
        }
        catch (OntologyConfigReaderException e) {
            throw new OntologyLoaderException("Error while reading ontology config file", e);
        }
        if (cvSourceList != null) {
            for (CvSource cvSource : cvSourceList.getCvSource()) {
                URI uri;
                String sourceUri = cvSource.getUri();
                String id = cvSource.getIdentifier();
                String name = cvSource.getName();
                String version = cvSource.getVersion();
                String format = cvSource.getFormat();
                String loaderClass = cvSource.getSource();
                try {
                    if (sourceUri != null && sourceUri.toLowerCase().startsWith(CLASSPATH_PREFIX)) {
                        URL url;
                        sourceUri = sourceUri.substring(CLASSPATH_PREFIX.length());
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Loading ontology from classpath: " + sourceUri));
                        }
                        if ((url = OntologyManager.class.getClassLoader().getResource(sourceUri)) == null) {
                            throw new OntologyLoaderException("Unable to load from classpath: " + sourceUri);
                        }
                        uri = url.toURI();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("URI=" + uri.toASCIIString()));
                        }
                    } else {
                        uri = new URI(sourceUri);
                    }
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("The specified uri '" + sourceUri + "' " + "for ontology '" + id + "' has an invalid syntax.", e);
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("Loading ontology: name=" + name + ", ID= " + id + ", format=" + format + ", version=" + version + ", uri=" + uri + " using source: " + loaderClass));
                }
                try {
                    Class loader;
                    String lcLoaderClass = loaderClass.toLowerCase();
                    if (keyword2class.containsKey(lcLoaderClass)) {
                        loader = keyword2class.get(lcLoaderClass);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("the source '" + loaderClass + "' was converted to Class: " + loader));
                        }
                    } else {
                        loader = Class.forName(loaderClass);
                    }
                    Constructor c = loader.getConstructor(new Class[0]);
                    OntologyAccess oa = (OntologyAccess)c.newInstance(new Object[0]);
                    oa.setOntologyDirectory(this.ontologyDirectory);
                    oa.loadOntology(id, name, version, format, uri);
                    this.ontologies.put(id, oa);
                }
                catch (Exception e) {
                    throw new OntologyLoaderException("Failed loading ontology source: " + loaderClass, e);
                }
            }
        }
    }

    static {
        keyword2class.put("ols", OlsOntology.class);
        keyword2class.put("file", LocalOntology.class);
    }
}

