/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ook.persistence.query;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.TransactionAbortedException;
import org.apache.ojb.broker.TransactionInProgressException;
import org.apache.ojb.broker.TransactionNotInProgressException;
import org.apache.ojb.broker.accesslayer.LookupException;
import org.apache.ojb.broker.accesslayer.StatementManagerIF;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.query.Query;
import uk.ac.ebi.ook.config.ConfigurationManager;
import uk.ac.ebi.ook.persistence.exceptions.PersistenceException;
import uk.ac.ebi.ook.persistence.interfaces.Persistable;

public abstract class AbstractQueryHandler {
    private PersistenceBroker broker;
    private static Logger logger = Logger.getLogger((Class)(class$uk$ac$ebi$ook$persistence$query$AbstractQueryHandler == null ? (class$uk$ac$ebi$ook$persistence$query$AbstractQueryHandler = AbstractQueryHandler.class$("uk.ac.ebi.ook.persistence.query.AbstractQueryHandler")) : class$uk$ac$ebi$ook$persistence$query$AbstractQueryHandler));
    private String dbAlias = null;
    static /* synthetic */ Class class$uk$ac$ebi$ook$persistence$query$AbstractQueryHandler;
    static /* synthetic */ Class class$uk$ac$ebi$ook$persistence$interfaces$Persistable;

    protected AbstractQueryHandler() {
    }

    protected AbstractQueryHandler(String dbAlias) {
        this.dbAlias = dbAlias;
    }

    protected Object objectQuery(Query query) throws PersistenceException {
        if (query != null) {
            if (this.broker != null) {
                try {
                    return this.broker.getObjectByQuery(query);
                }
                catch (PersistenceBrokerException pbe) {
                    throw new PersistenceException("objectQuery caught a low-level PB exception: " + pbe.getMessage(), pbe);
                }
            }
            throw new PersistenceException("Query called on uninitialized PersistenceBroker");
        }
        throw new PersistenceException("No query specified!");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object strictObjectQuery(Query query) throws PersistenceException {
        if (query == null) throw new PersistenceException("No query specified!");
        if (this.broker == null) throw new PersistenceException("Query called on uninitialized PersistenceBroker");
        Collection tmpColl = null;
        try {
            tmpColl = this.broker.getCollectionByQuery(query);
        }
        catch (PersistenceBrokerException e) {
            throw new PersistenceException("strictObjectQuery caught a low-level PB exception: " + e.getMessage(), e);
        }
        if (tmpColl == null) return null;
        if (tmpColl.size() == 1) {
            Iterator i = tmpColl.iterator();
            if (!i.hasNext()) return null;
            return i.next();
        }
        if (tmpColl.size() <= 1) return null;
        logger.error((Object)("StrictObjectQuery was called and returned more than one object. Query was :" + query.toString()));
        return null;
    }

    protected int countQuery(Query query) throws PersistenceException {
        if (query != null) {
            if (this.broker != null) {
                try {
                    return this.broker.getCount(query);
                }
                catch (PersistenceBrokerException e) {
                    throw new PersistenceException("countQuery caught a low-level PB exception: " + e.getMessage(), e);
                }
            }
            throw new PersistenceException("Query called on uninitialized PersistenceBroker");
        }
        throw new PersistenceException("No query specified!");
    }

    protected Collection collectionQuery(Query query) throws PersistenceException {
        if (query != null) {
            if (this.broker != null) {
                try {
                    return this.broker.getCollectionByQuery(query);
                }
                catch (PersistenceBrokerException e) {
                    throw new PersistenceException("collectionQuery caught a low-level PB exception: " + e.getMessage(), e);
                }
            }
            throw new PersistenceException("Query called on uninitialized PersistenceBroker");
        }
        throw new PersistenceException("No query specified!");
    }

    protected Iterator reportQuery(Query query) throws PersistenceException {
        if (query != null) {
            if (this.broker != null) {
                try {
                    return this.broker.getReportQueryIteratorByQuery(query);
                }
                catch (PersistenceBrokerException e) {
                    throw new PersistenceException("reportQuery caught a low-level PB exception: " + e.getMessage(), e);
                }
            }
            throw new PersistenceException("Query called on uninitialized PersistenceBroker");
        }
        throw new PersistenceException("No query specified!");
    }

    public void updateBeanFieldsOnly(Persistable beanToUpdate) throws PersistenceException {
        try {
            this.beginTransaction();
            ClassDescriptor classDescriptor = this.broker.getClassDescriptor(beanToUpdate.getClass());
            StatementManagerIF statementManager = this.broker.serviceStatementManager();
            PreparedStatement preparedUpdateStatement = statementManager.getUpdateStatement(classDescriptor);
            statementManager.bindUpdate(preparedUpdateStatement, classDescriptor, (Object)beanToUpdate);
            preparedUpdateStatement.execute();
            this.commitTransaction();
        }
        catch (PersistenceBrokerException pbe) {
            logger.error((Object)"Failed to shallow update the Bean.", (Throwable)pbe);
            this.rollbackTransaction();
            throw new PersistenceException("Failed to shallow update bean: " + pbe.getMessage(), pbe);
        }
        catch (SQLException sqle) {
            logger.error((Object)"Failed to shallow update the Bean", (Throwable)sqle);
            this.rollbackTransaction();
            throw new PersistenceException("Failed to shallow update bean: " + sqle.getMessage(), sqle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void persistObject(Object objectToPersist) throws PersistenceException, IllegalArgumentException {
        if (this.broker != null) {
            try {
                if (!(objectToPersist instanceof Persistable)) {
                    logger.error((Object)"Attempt to store non-Persistable instance from RDBMS!");
                    throw new IllegalArgumentException("Only Persistable instances can be stored, since these are the only implementations that are persistence-aware!");
                }
                this.beginTransaction();
                this.broker.store(objectToPersist);
                this.commitTransaction();
            }
            catch (PersistenceBrokerException pbe) {
                try {
                    this.rollbackTransaction();
                    Object var4_3 = null;
                    logger.error((Object)("Unable to store instance '" + (class$uk$ac$ebi$ook$persistence$interfaces$Persistable == null ? (class$uk$ac$ebi$ook$persistence$interfaces$Persistable = AbstractQueryHandler.class$("uk.ac.ebi.ook.persistence.interfaces.Persistable")) : class$uk$ac$ebi$ook$persistence$interfaces$Persistable).getName() + "' from RDBMS: " + pbe.getMessage()), (Throwable)pbe);
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    logger.error((Object)("Unable to store instance '" + (class$uk$ac$ebi$ook$persistence$interfaces$Persistable == null ? (class$uk$ac$ebi$ook$persistence$interfaces$Persistable = AbstractQueryHandler.class$("uk.ac.ebi.ook.persistence.interfaces.Persistable")) : class$uk$ac$ebi$ook$persistence$interfaces$Persistable).getName() + "' from RDBMS: " + pbe.getMessage()), (Throwable)pbe);
                    throw new PersistenceException("Unable to store instance '" + (class$uk$ac$ebi$ook$persistence$interfaces$Persistable == null ? (class$uk$ac$ebi$ook$persistence$interfaces$Persistable = AbstractQueryHandler.class$("uk.ac.ebi.ook.persistence.interfaces.Persistable")) : class$uk$ac$ebi$ook$persistence$interfaces$Persistable).getName() + "' from RDBMS: " + pbe.getMessage(), pbe);
                }
                throw new PersistenceException("Unable to store instance '" + (class$uk$ac$ebi$ook$persistence$interfaces$Persistable == null ? (class$uk$ac$ebi$ook$persistence$interfaces$Persistable = AbstractQueryHandler.class$("uk.ac.ebi.ook.persistence.interfaces.Persistable")) : class$uk$ac$ebi$ook$persistence$interfaces$Persistable).getName() + "' from RDBMS: " + pbe.getMessage(), pbe);
            }
        } else {
            throw new PersistenceException("PersistObject called on null broker");
        }
    }

    protected void persistCollection(Collection collectionToPersist) throws IllegalArgumentException, PersistenceException {
        Iterator iter = collectionToPersist.iterator();
        try {
            this.beginTransaction();
            while (iter.hasNext()) {
                Object tmpObj = iter.next();
                if (tmpObj instanceof Persistable) {
                    this.broker.store(tmpObj);
                    continue;
                }
                logger.error((Object)"Attempt to store non-Persistable object instance from RDBMS!");
                throw new IllegalArgumentException("Only Persistable instances can be stored, since these are the only implementations that are persistence-aware!");
            }
            this.commitTransaction();
        }
        catch (PersistenceBrokerException pbe) {
            logger.error((Object)("Unable to store collection to RDBMS: " + pbe.getMessage()), (Throwable)pbe);
            this.rollbackTransaction();
            throw new PersistenceException("Unable to store instance '" + (class$uk$ac$ebi$ook$persistence$interfaces$Persistable == null ? (class$uk$ac$ebi$ook$persistence$interfaces$Persistable = AbstractQueryHandler.class$("uk.ac.ebi.ook.persistence.interfaces.Persistable")) : class$uk$ac$ebi$ook$persistence$interfaces$Persistable).getName() + "' from RDBMS: " + pbe.getMessage(), pbe);
        }
    }

    protected void deleteObject(Object objectToDelete) throws PersistenceException, IllegalArgumentException {
        if (this.broker != null) {
            try {
                if (!(objectToDelete instanceof Persistable)) {
                    logger.error((Object)"Attempt to delete non-Persistable bean instance from RDBMS!");
                    throw new IllegalArgumentException("Only Persistable instances can be deleted, since these are the only implementations that are persistence-aware!");
                }
                this.beginTransaction();
                this.broker.delete(objectToDelete);
                this.commitTransaction();
            }
            catch (PersistenceBrokerException pbe) {
                logger.error((Object)("Unable to delete instance '" + (class$uk$ac$ebi$ook$persistence$interfaces$Persistable == null ? (class$uk$ac$ebi$ook$persistence$interfaces$Persistable = AbstractQueryHandler.class$("uk.ac.ebi.ook.persistence.interfaces.Persistable")) : class$uk$ac$ebi$ook$persistence$interfaces$Persistable).getName() + "' from RDBMS: " + pbe.getMessage()), (Throwable)pbe);
                this.rollbackTransaction();
                throw new PersistenceException("Unable to delete instance '" + (class$uk$ac$ebi$ook$persistence$interfaces$Persistable == null ? (class$uk$ac$ebi$ook$persistence$interfaces$Persistable = AbstractQueryHandler.class$("uk.ac.ebi.ook.persistence.interfaces.Persistable")) : class$uk$ac$ebi$ook$persistence$interfaces$Persistable).getName() + "' from RDBMS: " + pbe.getMessage(), pbe);
            }
        } else {
            throw new PersistenceException("DeleteObject called on null broker");
        }
    }

    protected void deleteCollection(Collection collectionToDelete) throws IllegalArgumentException, PersistenceException {
        Iterator iter = collectionToDelete.iterator();
        try {
            this.beginTransaction();
            while (iter.hasNext()) {
                Object tmpObj = iter.next();
                if (tmpObj instanceof Persistable) {
                    this.broker.delete(tmpObj);
                    continue;
                }
                logger.error((Object)"Attempt to delete non-Persistable object instance from RDBMS!");
                throw new IllegalArgumentException("Only Persistable instances can be deleted, since these are the only implementations that are persistence-aware!");
            }
            this.commitTransaction();
        }
        catch (PersistenceBrokerException pbe) {
            logger.error((Object)("Unable to delete collection to RDBMS: " + pbe.getMessage()), (Throwable)pbe);
            this.rollbackTransaction();
            throw new PersistenceException("Unable to delete instance '" + (class$uk$ac$ebi$ook$persistence$interfaces$Persistable == null ? (class$uk$ac$ebi$ook$persistence$interfaces$Persistable = AbstractQueryHandler.class$("uk.ac.ebi.ook.persistence.interfaces.Persistable")) : class$uk$ac$ebi$ook$persistence$interfaces$Persistable).getName() + "' from RDBMS: " + pbe.getMessage(), pbe);
        }
        catch (IllegalArgumentException iae) {
            this.rollbackTransaction();
            throw iae;
        }
    }

    protected void initializeBroker() throws PersistenceException {
        this.initializeBroker(this.dbAlias);
    }

    private void initializeBroker(String alias) throws PersistenceException {
        try {
            if (alias != null) {
                this.broker = PersistenceBrokerFactory.createPersistenceBroker((PBKey)new PBKey(alias));
                logger.debug((Object)("Broker initialized to " + alias));
            } else {
                String configAlias = ConfigurationManager.getProperty("ols.dbalias");
                if (configAlias != null) {
                    this.broker = PersistenceBrokerFactory.createPersistenceBroker((PBKey)new PBKey(configAlias));
                    logger.debug((Object)("Broker initialized to " + configAlias + "."));
                } else {
                    this.broker = PersistenceBrokerFactory.defaultPersistenceBroker();
                    logger.debug((Object)"Broker initialized to default PB.");
                }
            }
        }
        catch (PBFactoryException pbf) {
            throw new PersistenceException("Could not initialize PB: " + pbf.getMessage(), pbf);
        }
    }

    protected void releaseBroker() throws PersistenceException {
        if (this.broker != null) {
            if (this.broker.close()) {
                logger.debug((Object)"Persistence Broker closed.");
                this.broker = null;
            } else {
                throw new PersistenceException("Could not close Persistence Broker");
            }
        }
    }

    protected void beginTransaction() throws PersistenceException, IllegalStateException {
        if (this.broker != null) {
            try {
                if (this.broker.isInTransaction()) {
                    throw new IllegalStateException("Called to begin transaction when one is already in progress");
                }
                this.broker.beginTransaction();
            }
            catch (TransactionInProgressException e) {
                throw new PersistenceException("Could not start transaction", e);
            }
            catch (TransactionAbortedException e) {
                throw new PersistenceException("Could not start transaction", e);
            }
        } else {
            throw new IllegalStateException("Called to begin transaction when broker not properly initialized!");
        }
    }

    protected PersistenceBroker getBroker() {
        return this.broker;
    }

    protected void commitTransaction() throws PersistenceException {
        if (this.broker != null) {
            try {
                if (!this.broker.isInTransaction()) {
                    throw new IllegalStateException("Called to commit a transaction when has not been started yet.");
                }
                this.broker.commitTransaction();
            }
            catch (TransactionNotInProgressException e) {
                throw new PersistenceException("Could not commit transaction", e);
            }
            catch (TransactionAbortedException e) {
                throw new PersistenceException("Could not commit transaction", e);
            }
        } else {
            throw new IllegalStateException("Called to commit transaction when broker not properly initialized!");
        }
    }

    protected void rollbackTransaction() throws PersistenceException {
        if (this.broker != null) {
            try {
                if (!this.broker.isInTransaction()) {
                    throw new IllegalStateException("Called to rollback a transaction when has not been started yet.");
                }
                this.broker.abortTransaction();
            }
            catch (PersistenceBrokerException e) {
                throw new PersistenceException("Could not rollback transaction", e);
            }
        } else {
            throw new IllegalStateException("Called to rollback transaction when broker not properly initialized!");
        }
    }

    public void clearCache() throws PersistenceException {
        if (this.broker != null) {
            try {
                this.broker.clearCache();
            }
            catch (PersistenceBrokerException e) {
                throw new PersistenceException("Could not clear broker cache", e);
            }
        } else {
            throw new IllegalStateException("Called to clear broker cache when broker not properly initialized!");
        }
    }

    protected Connection getConnection() throws LookupException {
        if (this.broker != null) {
            return this.broker.serviceConnectionManager().getConnection();
        }
        return null;
    }

    protected void setBatchMode(boolean mode) throws PersistenceException {
        if (this.broker != null) {
            try {
                this.broker.serviceConnectionManager().setBatchMode(mode);
            }
            catch (PersistenceBrokerException e) {
                throw new PersistenceException("Could not clear broker cache", e);
            }
        } else {
            throw new IllegalStateException("Called to set batch mode when broker not properly initialized!");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

