/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ook.web.ajax;

import java.util.Collection;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ajaxtags.helpers.AjaxXmlBuilder;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import uk.ac.ebi.ook.model.interfaces.Annotation;
import uk.ac.ebi.ook.model.interfaces.DbXref;
import uk.ac.ebi.ook.model.interfaces.Term;
import uk.ac.ebi.ook.model.interfaces.TermSynonym;
import uk.ac.ebi.ook.persistence.query.TermQueryHandler;
import uk.ac.ebi.ook.web.ajax.AjaxHandler;
import uk.ac.ebi.proteomics.common.StringUtilities;

public class TermMetadataAjaxServlet
implements AjaxHandler {
    private Logger logger = Logger.getLogger((Class)(class$uk$ac$ebi$ook$web$ajax$TermMetadataAjaxServlet == null ? (class$uk$ac$ebi$ook$web$ajax$TermMetadataAjaxServlet = TermMetadataAjaxServlet.class$("uk.ac.ebi.ook.web.ajax.TermMetadataAjaxServlet")) : class$uk$ac$ebi$ook$web$ajax$TermMetadataAjaxServlet));
    private static final String TERM_ID_PARAMETER = "termid";
    private static final String ONTOLOGY_NAME_PARAMETER = "ontologyname";
    private static final String TERM_DEFINITION = "definition";
    private static final String SYNONYM_KEYWORD = " synonym";
    private static final String FORM_ELEMENT_NAME = "metadata";
    static /* synthetic */ Class class$uk$ac$ebi$ook$web$ajax$TermMetadataAjaxServlet;

    public String getXmlContent(HttpServletRequest request, HttpServletResponse response) throws Exception {
        TermQueryHandler query = new TermQueryHandler();
        String termId = request.getParameter(TERM_ID_PARAMETER);
        String ontName = request.getParameter(ONTOLOGY_NAME_PARAMETER);
        if (ontName != null && (ontName.equals("null") || ontName.equals(""))) {
            ontName = null;
        }
        AjaxXmlBuilder ajax = new AjaxXmlBuilder();
        if (termId != null && termId.trim().length() > 0) {
            Term term = query.getTermById(termId, ontName);
            if (term != null) {
                Collection xrefs;
                Collection synonyms;
                Collection annotations;
                String def = term.getDefinition();
                if (def != null && def.trim().length() > 0 && !"null".equals(def.trim())) {
                    ajax.addItem(TERM_DEFINITION, StringEscapeUtils.escapeXml((String)def));
                }
                if ((annotations = query.getTermAnnotations(term.getTermId())) != null && !annotations.isEmpty()) {
                    Iterator iterator = annotations.iterator();
                    while (iterator.hasNext()) {
                        Annotation annot = (Annotation)iterator.next();
                        ajax.addItem(StringEscapeUtils.escapeXml((String)annot.getAnnotationType()), StringEscapeUtils.escapeXml((String)annot.getAnnotationCompleteValue()));
                    }
                }
                if ((synonyms = term.getSynonyms()) != null && !synonyms.isEmpty()) {
                    ajax.addItem(StringEscapeUtils.escapeXml((String)"preferred name"), StringEscapeUtils.escapeXml((String)term.getName()));
                    Iterator iterator = synonyms.iterator();
                    while (iterator.hasNext()) {
                        TermSynonym ts = (TermSynonym)iterator.next();
                        String synType = ts.getSynonymType().getName();
                        if (!"synonym".equals(synType)) {
                            synType = synType + SYNONYM_KEYWORD;
                        }
                        ajax.addItem(StringEscapeUtils.escapeXml((String)synType), StringEscapeUtils.escapeXml((String)ts.getSynonym()));
                    }
                }
                if ((xrefs = query.getTermXrefs(term.getTermId())) != null && !xrefs.isEmpty()) {
                    Iterator iterator = xrefs.iterator();
                    while (iterator.hasNext()) {
                        String type;
                        DbXref dbx = (DbXref)iterator.next();
                        switch (dbx.getXrefType()) {
                            case 3: {
                                type = "xref_analog";
                                break;
                            }
                            case 0: {
                                type = "xref_anatomical";
                                break;
                            }
                            case 2: {
                                type = "xref_definition";
                                break;
                            }
                            case 1: {
                                type = "xref_related_synonym";
                                break;
                            }
                            default: {
                                type = "xref_unknown";
                            }
                        }
                        StringBuffer value = new StringBuffer();
                        if (dbx.getDbName() != null) {
                            value.append(dbx.getDbName());
                        }
                        if (dbx.getAccession() != null) {
                            if (value.length() > 0) {
                                value.append(':');
                            }
                            value.append(dbx.getAccession());
                        }
                        if (dbx.getDescription() != null) {
                            value.append('\"').append(dbx.getDescription()).append('\"');
                        }
                        ajax.addItem(StringUtilities.checkNull((String)StringEscapeUtils.escapeXml((String)type)), StringUtilities.checkNull((String)StringEscapeUtils.escapeXml((String)value.toString())));
                    }
                }
            } else {
                ajax.addItem(FORM_ELEMENT_NAME, "Term not found: " + StringEscapeUtils.escapeXml((String)termId));
            }
        }
        this.logger.debug((Object)ajax.toString());
        return ajax.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

