/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ook.loader.impl;

import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.geneontology.oboedit.datamodel.Dbxref;
import org.geneontology.oboedit.datamodel.OBOClass;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.datamodel.impl.DbxrefImpl;
import uk.ac.ebi.ook.loader.impl.AbstractLoader;
import uk.ac.ebi.ook.loader.parser.OBOFormatParser;
import uk.ac.ebi.ook.loader.psiutils.Element;
import uk.ac.ebi.ook.loader.psiutils.ElementParser;
import uk.ac.ebi.proteomics.common.CommonUtilities;
import uk.ac.ebi.proteomics.common.log.LoggerFactory;

public class PSIModMassCalculator
extends AbstractLoader {
    public static final String DIFF_AVG = "DiffAvg";
    public static final String DIFF_MONO = "DiffMono";
    public static final String DIFF_FORMULA = "DiffFormula";
    public static final String FORMULA = "Formula";
    public static final String MASS_AVG = "MassAvg";
    public static final String MASS_MONO = "MassMono";
    private static final String OPEN_PARENTHESIS = "(";
    private static final String CLOSED_PARENTHESIS = ")";
    private static HashMap elements = null;
    static /* synthetic */ Class class$uk$ac$ebi$ook$loader$impl$PSIModMassCalculator;

    public PSIModMassCalculator(String atomFile) {
        elements = ElementParser.getInstance(atomFile).getElements();
    }

    protected void configure() {
        logger = LoggerFactory.getLogger((Class)(class$uk$ac$ebi$ook$loader$impl$PSIModMassCalculator == null ? (class$uk$ac$ebi$ook$loader$impl$PSIModMassCalculator = PSIModMassCalculator.class$("uk.ac.ebi.ook.loader.impl.PSIModMassCalculator")) : class$uk$ac$ebi$ook$loader$impl$PSIModMassCalculator), (URL)CommonUtilities.getResource((String)"ols-config.properties"));
        this.parser = new OBOFormatParser();
        this.ONTOLOGY_DEFINITION = "PSI MOD";
        this.FULL_NAME = "PSI PTM";
        this.SHORT_NAME = "MOD";
    }

    protected void parse(Object params) throws IOException {
        Vector<String> v = new Vector<String>();
        v.add((String)params);
        ((OBOFormatParser)this.parser).configure(v);
        this.parser.parseFile();
    }

    protected void process() {
        OBOSession session = this.parser.getSession();
        Iterator i = session.getTerms().iterator();
        while (i.hasNext()) {
            OBOClass term = (OBOClass)i.next();
            this.updateMassXrefs(term);
        }
    }

    public void writeFile(String path) throws IOException {
        ((OBOFormatParser)this.parser).writeFile(path);
    }

    private void updateMassXrefs(OBOClass term) {
        HashSet<Dbxref> updates = new HashSet<Dbxref>();
        Set xrefs = term.getDbxrefs();
        Iterator i = xrefs.iterator();
        while (i.hasNext()) {
            Dbxref dbxref = (Dbxref)i.next();
            if (FORMULA.equals(dbxref.getDatabase())) {
                updates.add(this.updateFormulaXrefs(dbxref.getID(), false, true));
                updates.add(this.updateFormulaXrefs(dbxref.getID(), false, false));
            }
            if (!DIFF_FORMULA.equals(dbxref.getDatabase())) continue;
            updates.add(this.updateFormulaXrefs(dbxref.getID(), true, true));
            updates.add(this.updateFormulaXrefs(dbxref.getID(), true, false));
        }
        Iterator i2 = updates.iterator();
        while (i2.hasNext()) {
            Dbxref dbxref = (Dbxref)i2.next();
            Dbxref old = this.findXref(term.getDbxrefs(), dbxref.getDatabase());
            if (old != null) {
                term.removeDbxref(old);
            }
            term.addDbxref(dbxref);
        }
    }

    private Dbxref findXref(Set xrefs, String db) {
        Iterator i = xrefs.iterator();
        while (i.hasNext()) {
            Dbxref dbxref = (Dbxref)i.next();
            if (!db.equals(dbxref.getDatabase())) continue;
            return dbxref;
        }
        return null;
    }

    private Dbxref updateFormulaXrefs(String formula, boolean isDiff, boolean useMono) {
        DbxrefImpl retval = new DbxrefImpl();
        if (isDiff) {
            if (useMono) {
                retval.setDatabase(DIFF_MONO);
            } else {
                retval.setDatabase(DIFF_AVG);
            }
        } else if (useMono) {
            retval.setDatabase(MASS_MONO);
        } else {
            retval.setDatabase(MASS_AVG);
        }
        retval.setID(this.computeMass(formula, useMono));
        return retval;
    }

    private String computeMass(String formula, boolean useMono) {
        try {
            if (elements != null) {
                logger.debug((Object)("Formula is: " + formula));
                double elementMass = 0.0;
                double totalMass = 0.0;
                String isotope = null;
                String element = null;
                String number = null;
                StringTokenizer st = new StringTokenizer(formula);
                while (st.hasMoreTokens()) {
                    String aToken = st.nextToken();
                    if ("+".equals(aToken)) {
                        logger.warn((Object)("Improper character in formula: " + formula));
                        continue;
                    }
                    if (aToken.startsWith(OPEN_PARENTHESIS)) {
                        int ndx = aToken.indexOf(CLOSED_PARENTHESIS);
                        isotope = aToken.substring(1, ndx);
                        element = aToken.substring(ndx + 1);
                    } else {
                        element = aToken;
                    }
                    number = st.nextToken();
                    Element refElement = (Element)elements.get(element);
                    if (refElement != null) {
                        if (useMono) {
                            if (isotope != null) {
                                elementMass = refElement.getIsotopeMass(isotope);
                                isotope = null;
                            } else {
                                elementMass = refElement.getMonoMass();
                            }
                            if (elementMass == 0.0) {
                                elementMass = refElement.getAvgMass();
                            }
                        } else {
                            elementMass = refElement.getAvgMass();
                        }
                        int mult = Integer.parseInt(number);
                        totalMass += (double)mult * elementMass;
                        continue;
                    }
                    throw new RuntimeException("Could not find element: " + element);
                }
                logger.debug((Object)("Mass is: " + totalMass));
                return this.checkStrLen(totalMass, useMono);
            }
            logger.warn((Object)"Atom database not properly loaded!");
            return null;
        }
        catch (Exception e) {
            logger.error((Object)(e.getMessage() + " Invalid formula: " + formula));
            return null;
        }
    }

    private String checkStrLen(double totalMass, boolean useMono) {
        String retval = "0";
        if (totalMass != 0.0) {
            BigDecimal mass = new BigDecimal(totalMass);
            retval = useMono ? mass.setScale(6, 4).toString() : mass.setScale(2, 4).toString();
        }
        return retval;
    }

    public static void main(String[] args) {
        PSIModMassCalculator psi = new PSIModMassCalculator(args[2]);
        try {
            psi.configure();
            psi.parse(args[0]);
            psi.process();
            psi.writeFile(args[1]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

