/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ook.loader.cvsutils;

import com.ice.cvsc.CVSArgumentVector;
import com.ice.cvsc.CVSBufferedUI;
import com.ice.cvsc.CVSClient;
import com.ice.cvsc.CVSEntry;
import com.ice.cvsc.CVSEntryVector;
import com.ice.cvsc.CVSProject;
import com.ice.cvsc.CVSRequest;
import com.ice.cvsc.CVSResponse;
import com.ice.cvsc.CVSScramble;
import com.ice.cvsc.CVSUserInterface;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;
import uk.ac.ebi.ook.loader.cvsutils.CVSException;

public class CVSUpdater {
    private HashMap oldVersionTracker = new HashMap();
    private HashMap newVersionTracker = new HashMap();
    private boolean enableSSH = false;
    private boolean errorsDetected = false;
    private String errorMessage = null;
    private static Logger logger = Logger.getLogger((Class)(class$uk$ac$ebi$ook$loader$cvsutils$CVSUpdater == null ? (class$uk$ac$ebi$ook$loader$cvsutils$CVSUpdater = CVSUpdater.class$("uk.ac.ebi.ook.loader.cvsutils.CVSUpdater")) : class$uk$ac$ebi$ook$loader$cvsutils$CVSUpdater));
    static /* synthetic */ Class class$uk$ac$ebi$ook$loader$cvsutils$CVSUpdater;

    public HashMap getAllOBOFiles(String basePath) throws CVSException {
        try {
            File cvsLocalRep = new File(basePath);
            CVSClient client = new CVSClient();
            CVSProject project = new CVSProject(client);
            project.openProject(cvsLocalRep);
            CVSEntry rootEntry = project.getRootEntry();
            CVSEntryVector entries = new CVSEntryVector();
            this.addProjectEntries(entries, rootEntry);
            return this.oldVersionTracker;
        }
        catch (IOException e) {
            throw new CVSException("CVSUpdater.getAllOBOFiles caught error: " + e.getMessage(), e);
        }
    }

    public HashSet updateOBOFiles(String basePath, String username, String password) throws CVSException {
        try {
            File cvsLocalRep = new File(basePath);
            CVSClient client = new CVSClient();
            if (this.enableSSH) {
                client.setPort(22);
            }
            CVSProject project = new CVSProject(client);
            if (this.enableSSH) {
                project.setConnectionPort(22);
                project.setConnectionMethod(3);
                project.setPServer(false);
            }
            project.openProject(cvsLocalRep);
            logger.warn((Object)("Performing CVS updates on: " + basePath));
            project.setUserName(username);
            if (this.enableSSH) {
                project.setPassword(password);
            } else {
                project.setPassword(CVSScramble.scramblePassword((String)password, (char)'A'));
            }
            CVSRequest request = new CVSRequest();
            request.setPServer(this.enableSSH);
            if (this.enableSSH) {
                request.setConnectionMethod(3);
                request.setPort(22);
                request.setPServer(false);
            }
            request.setUserInterface((CVSUserInterface)new CVSBufferedUI());
            String statusCommand = "update:a:EAUFP:deout:";
            if (!request.parseControlString(statusCommand)) {
                throw new CVSException("CVSUpdater.updateOBOFiles Could not parse command specification: " + statusCommand);
            }
            CVSEntry rootEntry = project.getRootEntry();
            logger.debug((Object)("ROOT: " + rootEntry));
            CVSEntryVector entries = new CVSEntryVector();
            this.addProjectEntries(entries, rootEntry);
            request.setEntries(entries);
            request.setArguments(new CVSArgumentVector());
            request.traceRequest = true;
            request.traceResponse = true;
            request.traceTCPData = true;
            request.traceProcessing = true;
            CVSResponse response = new CVSResponse();
            boolean reqOk = project.performCVSRequest(request, response);
            if (reqOk) {
                project.processCVSResponse(request, response);
                logger.debug((Object)response.getResultText());
                logger.debug((Object)response.toString());
            } else {
                logger.error((Object)"FAILED to perform cvs request.");
                StringBuffer errMsg = new StringBuffer();
                errMsg.append("Error Code: ").append(response.getErrorCode()).append('\n');
                errMsg.append("Error Message; ").append(response.getErrorText()).append('\n');
                errMsg.append("Result Status: ").append(response.getResultStatus()).append('\n');
                errMsg.append("Result Message: ").append(response.getResultText()).append('\n');
                logger.error((Object)errMsg.toString());
                this.errorsDetected = true;
                this.errorMessage = errMsg.toString();
            }
            project.writeAdminFiles();
            this.postScanEntries(rootEntry);
            return this.computeUpdatedFiles();
        }
        catch (IOException e) {
            throw new CVSException("CVSUpdater.updateOBOFiles caught error: " + e.getMessage(), e);
        }
    }

    private HashSet computeUpdatedFiles() {
        HashSet retval = new HashSet();
        Iterator newCo = this.newVersionTracker.keySet().iterator();
        while (newCo.hasNext()) {
            String oldVersion;
            Object key = newCo.next();
            String newVersion = (String)this.newVersionTracker.get(key);
            if (newVersion.equals(oldVersion = (String)this.oldVersionTracker.get(key))) continue;
            retval.add(key);
        }
        return retval;
    }

    protected void addProjectEntries(CVSEntryVector entries, CVSEntry parent) {
        CVSEntryVector children = parent.getEntryList();
        Enumeration chEnum = children.elements();
        while (chEnum.hasMoreElements()) {
            CVSEntry child = (CVSEntry)chEnum.nextElement();
            if (child.isDirectory()) {
                this.addProjectEntries(entries, child);
                continue;
            }
            entries.addElement((Object)child);
            this.oldVersionTracker.put(child.getFullPathName(), child.getVersion());
            logger.debug((Object)("CVSEntry: " + child.getFullPathName() + " ver: " + child.getVersion()));
        }
    }

    protected void postScanEntries(CVSEntry parent) {
        CVSEntryVector children = parent.getEntryList();
        Enumeration chEnum = children.elements();
        while (chEnum.hasMoreElements()) {
            CVSEntry child = (CVSEntry)chEnum.nextElement();
            if (child.isDirectory()) {
                this.postScanEntries(child);
                continue;
            }
            this.newVersionTracker.put(child.getFullPathName(), child.getVersion());
            logger.debug((Object)("CVSEntry: " + child.getFullPathName() + " ver: " + child.getVersion()));
        }
    }

    public void enableSSH() {
        this.enableSSH = true;
    }

    public void disableSSH() {
        this.enableSSH = false;
    }

    public boolean errorsDetected() {
        return this.errorsDetected;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

