/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.verify.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.geneontology.oboedit.datamodel.DefinedObject;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.datamodel.history.DefinitionChangeHistoryItem;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.verify.CheckWarning;
import org.geneontology.oboedit.verify.VerificationEngine;
import org.geneontology.oboedit.verify.impl.AbstractTextCheck;

public class DefinitionCheck
extends AbstractTextCheck {
    public DefinitionCheck() {
        this.setAllowNewlines(true);
        this.setAllowBlank(true);
        this.setSentenceStructureChecks(true);
        this.setAllowExtended(Controller.getController().getPreferences().getAllowExtendedCharacters());
    }

    protected void appendAdditionalWarnings(Collection out, OBOSession session, IdentifiedObject currentObject, byte condition) {
        if (currentObject instanceof DefinedObject) {
            DefinedObject dfo = (DefinedObject)currentObject;
            if ((dfo.getDefinition() == null || dfo.getDefinition().length() == 0) && dfo.getDefDbxrefs().size() > 0) {
                out.add(new CheckWarning(this.getWarningLabel(currentObject, condition, 0) + " has definition references, " + "but no definition.", true, this, currentObject));
            }
            if (Controller.getController().getPreferences().getUsePersonalDefinition() && dfo.getDefinition().equals(Controller.getController().getPreferences().getPersonalDefinition())) {
                out.add(new CheckWarning(this.getWarningLabel(currentObject, condition, 0) + " seems to have an " + "auto-generated defintion " + "that was never edited.", false, this, currentObject));
            }
            if (dfo.getDefDbxrefs().size() == 0 && dfo.getDefinition() != null && dfo.getDefinition().length() > 0) {
                out.add(new CheckWarning(this.getWarningLabel(currentObject, condition, 0) + " has a definition with " + "no references.", true, this, currentObject));
            }
        }
    }

    public String getID() {
        return "DEFINITION_CHECK";
    }

    public String getDescription() {
        return "Definition checks";
    }

    public HistoryItem getFieldChangeHistoryItem(IdentifiedObject currentObject, String newText) {
        return new DefinitionChangeHistoryItem((DefinedObject)currentObject, newText);
    }

    public String getWarningLabel(IdentifiedObject io, byte condition, int index) {
        if (VerificationEngine.isTextCommitCondition(condition)) {
            return "Definition";
        }
        return "Definition of <a href='file:" + io.getID() + "'>" + io.getID() + "</a>";
    }

    public Collection getStrings(IdentifiedObject io) {
        if (io instanceof DefinedObject) {
            LinkedList<String> out = new LinkedList<String>();
            out.add(((DefinedObject)io).getDefinition());
            return out;
        }
        return Collections.EMPTY_LIST;
    }
}

