/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.test;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.geneontology.dataadapter.AdapterConfiguration;
import org.geneontology.dataadapter.IOOperation;
import org.geneontology.oboedit.dataadapter.OBOFileAdapter;
import org.geneontology.oboedit.datamodel.Explanation;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.oboedit.datamodel.OBORestriction;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.datamodel.ReasonedLinkDatabase;
import org.geneontology.oboedit.datamodel.history.CompletesHistoryItem;
import org.geneontology.oboedit.datamodel.history.DeleteLinkHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermCopyHistoryItem;
import org.geneontology.oboedit.datamodel.impl.DefaultLinkDatabase;
import org.geneontology.oboedit.datamodel.impl.DefaultOperationModel;
import org.geneontology.oboedit.datamodel.impl.FilteredReasonedLinkDatabase;
import org.geneontology.oboedit.datamodel.impl.OBORestrictionImpl;
import org.geneontology.oboedit.gui.Controller;

public class ReasonerTest
extends TestCase {
    protected OBOSession session;
    protected Controller controller;

    public ReasonerTest(String name) {
        super(name);
    }

    public static Test suite() {
        int i;
        TestSuite suite = new TestSuite();
        for (i = 0; i < 25; ++i) {
            suite.addTest((Test)new ReasonerTest("testCompleteLinkDel"));
        }
        for (i = 0; i < 25; ++i) {
            suite.addTest((Test)new ReasonerTest("testAddNewLink"));
        }
        for (i = 0; i < 25; ++i) {
            suite.addTest((Test)new ReasonerTest("testLinkDel"));
        }
        for (i = 0; i < 25; ++i) {
            suite.addTest((Test)new ReasonerTest("testCompleteLinkChange"));
        }
        return suite;
    }

    public void setUp() throws Exception {
        OBOFileAdapter adapter = new OBOFileAdapter();
        OBOFileAdapter.OBOAdapterConfiguration config = new OBOFileAdapter.OBOAdapterConfiguration();
        config.getReadPaths().add("lib/resources/testfile.reasoner.1.0.obo");
        this.session = (OBOSession)adapter.doOperation(IOOperation.READ, (AdapterConfiguration)config, null);
        this.controller = Controller.getController();
        this.controller.setHistory(this.session);
    }

    public void tearDown() throws Exception {
        this.session = null;
        this.controller = null;
    }

    public void testCompleteLinkDel() throws Exception {
        LinkedList<DeleteLinkHistoryItem> items = new LinkedList<DeleteLinkHistoryItem>();
        for (int i = 0; i < 1; ++i) {
            Link link = this.getRandomCompleteLink();
            items.add(new DeleteLinkHistoryItem(link));
        }
        this.doLinkTest(items);
    }

    public void testLinkDel() throws Exception {
        LinkedList<DeleteLinkHistoryItem> items = new LinkedList<DeleteLinkHistoryItem>();
        for (int i = 0; i < 5; ++i) {
            Link link = this.getRandomLink();
            items.add(new DeleteLinkHistoryItem(link));
        }
        this.doLinkTest(items);
    }

    public void testBrokenCompleteChange() throws Exception {
        HistoryItem.StringRelationship sr = new HistoryItem.StringRelationship("GO:0005819", "GO:0000922", "part_of");
        CompletesHistoryItem item = new CompletesHistoryItem(sr, false);
        LinkedList<CompletesHistoryItem> items = new LinkedList<CompletesHistoryItem>();
        items.add(item);
        this.doLinkTest(items);
    }

    public void testBrokenLinkDel() throws Exception {
        LinkedList<DeleteLinkHistoryItem> items = new LinkedList<DeleteLinkHistoryItem>();
        items.add(new DeleteLinkHistoryItem(new HistoryItem.StringRelationship("GO:0043226", "GO:0043229", "is_a")));
        this.doLinkTest(items);
    }

    public void testCompleteLinkChange() throws Exception {
        Link link = this.getRandomLink();
        this.doLinkTest(link, new CompletesHistoryItem((OBORestriction)link));
    }

    public void testAddNewLink() throws Exception {
        LinkedList<TermCopyHistoryItem> items = new LinkedList<TermCopyHistoryItem>();
        for (int i = 0; i < 5; ++i) {
            Link link = this.getRandomLink();
            Link link2 = this.getRandomLink();
            OBORestrictionImpl newLink = new OBORestrictionImpl(link.getChild(), OBOProperty.IS_A, link.getParent());
            items.add(new TermCopyHistoryItem(link2.getChild(), link));
        }
        this.doLinkTest(items);
    }

    public void doLinkTest(Link link) throws Exception {
        this.doLinkTest(link, new DeleteLinkHistoryItem(link));
    }

    public void doLinkTest(Link link, HistoryItem item) throws Exception {
        this.doLinkTest(item);
    }

    public void doLinkTest(HistoryItem item) throws Exception {
        this.doLinkTest(Collections.singleton(item));
    }

    public void doLinkTest(Collection items) throws Exception {
        DefaultLinkDatabase linkDatabase = new DefaultLinkDatabase(this.session);
        FilteredReasonedLinkDatabase dynamicDB = new FilteredReasonedLinkDatabase();
        ReasonedLinkDatabase reasonedDB = Controller.createReasoner();
        reasonedDB.setLinkDatabase(linkDatabase);
        dynamicDB.setLinkDatabase(reasonedDB);
        DefaultOperationModel model = new DefaultOperationModel();
        model.setHistory(this.session);
        Iterator it = items.iterator();
        int i = 0;
        while (it.hasNext()) {
            HistoryItem item = (HistoryItem)it.next();
            model.apply(item);
            dynamicDB.apply(item);
            ++i;
        }
        LinkedHashMap objCache = new LinkedHashMap();
        it = this.session.getObjects().iterator();
        while (it.hasNext()) {
            IdentifiedObject io = (IdentifiedObject)it.next();
            if (!(io instanceof LinkedObject)) continue;
            LinkedObject lo = (LinkedObject)io;
            LinkedHashSet dynamicParents = new LinkedHashSet();
            dynamicParents.addAll(dynamicDB.getLinkDatabase().getParents(lo));
            objCache.put(lo, dynamicParents);
        }
        dynamicDB.recache();
        String failureMessage = "";
        it = this.session.getObjects().iterator();
        int i2 = 0;
        while (it.hasNext()) {
            IdentifiedObject io = (IdentifiedObject)it.next();
            if (io instanceof LinkedObject) {
                LinkedObject lo = (LinkedObject)io;
                Set dynamicParents = (Set)objCache.get(lo);
                LinkedHashSet cacheParents = new LinkedHashSet();
                cacheParents.addAll(dynamicDB.getLinkDatabase().getParents(lo));
                cacheParents.removeAll(dynamicParents);
                if (cacheParents.size() > 0) {
                    failureMessage = failureMessage.length() > 0 ? failureMessage + "\n" : "On application of history items " + items + "...\n";
                    String parentsMessage = "";
                    Iterator it2 = cacheParents.iterator();
                    boolean first = true;
                    while (it2.hasNext()) {
                        Link parent = (Link)it2.next();
                        if (first) {
                            first = false;
                        } else {
                            parentsMessage = parentsMessage + ", ";
                        }
                        parentsMessage = parentsMessage + parent.toString();
                        Iterator it3 = dynamicDB.getExplanations(parent).iterator();
                        while (it3.hasNext()) {
                            Explanation exp = (Explanation)it3.next();
                            parentsMessage = parentsMessage + "\n         exp = " + exp;
                        }
                    }
                    it2 = dynamicParents.iterator();
                    int j = 0;
                    while (it2.hasNext()) {
                        Link parent = (Link)it2.next();
                        parentsMessage = parentsMessage + "\n         parent " + (j + 1) + ") = " + parent;
                        ++j;
                    }
                    failureMessage = failureMessage + "    dynamic run unable to generate " + parentsMessage;
                }
            }
            ++i2;
        }
        if (failureMessage.length() > 0) {
            ReasonerTest.fail((String)failureMessage);
        }
    }

    protected Link getRandomCompleteLink() {
        LinkedHashSet<OBORestriction> completeLinks = new LinkedHashSet<OBORestriction>();
        Iterator it = this.session.getObjects().iterator();
        while (it.hasNext()) {
            IdentifiedObject io = (IdentifiedObject)it.next();
            if (!(io instanceof LinkedObject)) continue;
            LinkedObject lo = (LinkedObject)io;
            Iterator it2 = lo.getParents().iterator();
            while (it2.hasNext()) {
                OBORestriction or;
                Link link = (Link)it2.next();
                if (!(link instanceof OBORestriction) || !(or = (OBORestriction)link).completes()) continue;
                completeLinks.add(or);
            }
        }
        System.err.println("completeLinks = " + completeLinks);
        int index = (int)(Math.random() * (double)completeLinks.size());
        it = completeLinks.iterator();
        Link cl = null;
        for (int i = 0; i < index + 1; ++i) {
            cl = (Link)it.next();
        }
        ReasonerTest.assertNotNull((String)("null random complete link, index = " + index), (Object)cl);
        return cl;
    }

    protected Link getRandomLink() {
        Link link;
        Iterator it2;
        int count = 0;
        Iterator it = this.session.getObjects().iterator();
        while (it.hasNext()) {
            IdentifiedObject io = (IdentifiedObject)it.next();
            if (!(io instanceof LinkedObject)) continue;
            LinkedObject lo = (LinkedObject)io;
            it2 = lo.getParents().iterator();
            while (it2.hasNext()) {
                link = (Link)it2.next();
                if (link instanceof OBORestriction) {
                    OBORestriction or = (OBORestriction)link;
                    if (or.completes()) continue;
                    ++count;
                    continue;
                }
                ++count;
            }
        }
        int index = (int)(Math.random() * (double)count);
        it = this.session.getObjects().iterator();
        while (it.hasNext()) {
            IdentifiedObject io = (IdentifiedObject)it.next();
            if (!(io instanceof LinkedObject)) continue;
            it2 = ((LinkedObject)io).getParents().iterator();
            while (it2.hasNext()) {
                link = (Link)it2.next();
                if (index == 0) {
                    return link;
                }
                if (link instanceof OBORestriction) {
                    if (((OBORestriction)link).completes()) continue;
                    --index;
                    continue;
                }
                --index;
            }
        }
        return null;
    }
}

