/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.plugin;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Scrollable;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.tree.TreePath;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkHistoryItem;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.Namespace;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.oboedit.datamodel.OBORestriction;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.history.CardinalityHistoryItem;
import org.geneontology.oboedit.datamodel.history.CompletesHistoryItem;
import org.geneontology.oboedit.datamodel.history.DeleteLinkHistoryItem;
import org.geneontology.oboedit.datamodel.history.InverseNecHistoryItem;
import org.geneontology.oboedit.datamodel.history.LinkTypeHistoryItem;
import org.geneontology.oboedit.datamodel.history.MaxCardinalityHistoryItem;
import org.geneontology.oboedit.datamodel.history.MinCardinalityHistoryItem;
import org.geneontology.oboedit.datamodel.history.NecessarilyTrueHistoryItem;
import org.geneontology.oboedit.datamodel.history.TRNamespaceHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermCopyHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermMacroHistoryItem;
import org.geneontology.oboedit.gui.ComponentPlugin;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.Preferences;
import org.geneontology.oboedit.gui.event.HistoryAppliedEvent;
import org.geneontology.oboedit.gui.event.HistoryListener;
import org.geneontology.oboedit.gui.event.SubSelectEvent;
import org.geneontology.oboedit.gui.event.SubSelectListener;
import org.geneontology.swing.DropTarget;
import org.geneontology.swing.event.DragEvent;
import org.geneontology.swing.event.DropListener;
import org.geneontology.util.ObjectUtil;

public class ParentPlugin
extends ComponentPlugin {
    private static final long serialVersionUID = 1L;
    SubSelectListener selectListener = new SubSelectListener(){

        public void selectObject(SubSelectEvent e) {
            if (ParentPlugin.this.controller.getSubSelection() instanceof LinkedObject) {
                ParentPlugin.this.loadTerm((LinkedObject)ParentPlugin.this.controller.getSubSelection());
            }
        }
    };
    HistoryListener historyListener = new HistoryListener(){

        public void applied(HistoryAppliedEvent e) {
            if (ParentPlugin.this.controller.getSubSelection() instanceof LinkedObject) {
                ParentPlugin.this.loadTerm((LinkedObject)ParentPlugin.this.controller.getSubSelection());
            }
        }

        public void reversed(HistoryAppliedEvent e) {
            if (ParentPlugin.this.controller.getSubSelection() instanceof LinkedObject) {
                ParentPlugin.this.loadTerm((LinkedObject)ParentPlugin.this.controller.getSubSelection());
            }
        }
    };
    protected LinkedObject currentObject;
    protected JLabel label = new JLabel("<no selection>");
    protected JPanel outerPanel = new RowScrollPanel();
    protected JPanel panel = new JPanel();
    protected JPanel buttonPanel = new JPanel();
    protected JButton dropButton = new JButton("Drop terms here to add new parents");
    protected EmptyBorder emptyBorder = new EmptyBorder(2, 2, 2, 2);
    protected Icon nec_icon;
    protected Icon completes_icon;
    protected Icon inv_icon;
    protected static final String[] cardinalityChoices = new String[]{"Single value", "Range"};
    protected JTextField cardinalityField = new JTextField(3);
    protected JTextField minCardinalityField = new JTextField(3);
    protected JTextField maxCardinalityField = new JTextField(3);
    protected JLabel cardinalityLabel = new JLabel("Cardinality");
    protected JLabel cardinalityRangeLabel = new JLabel("Cardinality range");
    protected JPanel cardinalityPanel = new JPanel();
    protected JButton cardinalityCommitButton = new JButton("Commit");
    protected JCheckBox showImpliedCheckbox = new JCheckBox("Show implied");
    protected DropListener dropListener = new DropListener(){
        LineBorder border = new LineBorder(Color.black, 2);

        public boolean allowDrop(DragEvent e) {
            if (e.getData() instanceof TreePath[] && ((TreePath[])e.getData()).length > 0) {
                TreePath[] paths = (TreePath[])e.getData();
                for (int i = 0; i < paths.length; ++i) {
                    if (paths[i].getLastPathComponent() instanceof OBORestriction) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public void dragEnter(DragEvent e) {
            if (this.allowDrop(e)) {
                ParentPlugin.this.setBorder(this.border);
            }
        }

        public void dragExit(DragEvent e) {
            ParentPlugin.this.setBorder(ParentPlugin.this.emptyBorder);
        }

        public void drop(DragEvent e) {
            IdentifiedObject io = ParentPlugin.this.controller.getSubSelection();
            if (!(io instanceof LinkedObject)) {
                return;
            }
            LinkedObject lo = (LinkedObject)io;
            TreePath[] paths = (TreePath[])e.getData();
            TermMacroHistoryItem item = new TermMacroHistoryItem("Added parents");
            TreePath[] tpaths = new TreePath[paths.length];
            for (int i = 0; i < paths.length; ++i) {
                TreePath path;
                OBORestriction tr = (OBORestriction)paths[i].getLastPathComponent();
                TermCopyHistoryItem citem = new TermCopyHistoryItem(tr.getChild(), lo, OBOProperty.IS_A);
                item.addHistoryItem(citem);
                OBORestriction tr2 = ParentPlugin.this.controller.getSession().getObjectFactory().createOBORestriction(lo, OBOProperty.IS_A, tr.getChild(), false, null);
                tpaths[i] = path = paths[i].pathByAddingChild(tr2);
            }
            item.setPreSelection(TermUtil.convertPathsToIDs(paths));
            item.setPostSelection(TermUtil.convertPathsToIDs(tpaths));
            ParentPlugin.this.controller.apply(item);
            ParentPlugin.this.setBorder(ParentPlugin.this.emptyBorder);
        }

        public void draggedOver(DragEvent e) {
        }
    };
    protected DropTarget dropTarget = new DropTarget((Component)this.dropButton, this.dropListener);
    protected Comparator parentComparator = new Comparator(){

        public int compare(Object a, Object b) {
            Link tr = (Link)a;
            Link tr2 = (Link)b;
            int compVal = tr.getParent().getName().compareTo(tr2.getParent().getName());
            if (compVal < 0) {
                return -1;
            }
            if (compVal > 0) {
                return 1;
            }
            return 0;
        }
    };

    public ParentPlugin() {
        this.buttonPanel.setLayout(new BorderLayout());
        this.buttonPanel.add((Component)this.dropButton, "Center");
        this.buttonPanel.add((Component)this.showImpliedCheckbox, "East");
        this.showImpliedCheckbox.setOpaque(false);
        this.showImpliedCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ParentPlugin.this.reload();
            }
        });
    }

    public String getName() {
        return "Parent Plugin";
    }

    public void reload() {
        System.err.println("RELOADING");
        this.loadTerm(this.currentObject);
    }

    public void loadTerm(LinkedObject t) {
        this.currentObject = t;
        this.outerPanel.removeAll();
        if (t == null) {
            this.outerPanel.add(this.label);
            this.panel.remove(this.buttonPanel);
        } else {
            this.panel.add((Component)this.buttonPanel, "Center");
            final TreePath[] oldpaths = Controller.getController().getSelectedPaths();
            Vector v = new Vector();
            if (this.showImpliedCheckbox.isSelected() && Controller.getController().getUseReasoner()) {
                v.addAll(Controller.getController().getFullReasoner().getParents(t));
            }
            v.addAll(t.getParents());
            Collections.sort(v, this.parentComparator);
            for (int i = 0; i < v.size(); ++i) {
                final OBORestriction tr = (OBORestriction)v.get(i);
                Font font = this.controller.getDefaultFont();
                boolean enabled = true;
                if (TermUtil.isImplied(tr)) {
                    enabled = false;
                    font = !font.isItalic() ? font.deriveFont(2) : font.deriveFont(0);
                }
                JPanel panel = new JPanel();
                panel.setLayout(new BoxLayout(panel, 0));
                final JComboBox<OBOProperty> typeBox = new JComboBox<OBOProperty>();
                typeBox.setFont(font);
                typeBox.setBackground(Preferences.defaultButtonColor());
                typeBox.setEnabled(enabled);
                Iterator it = this.controller.getSession().getRelationshipTypes().iterator();
                while (it.hasNext()) {
                    OBOProperty type = (OBOProperty)it.next();
                    if (!TermUtil.isLegalRelationship(tr.getChild(), type, tr.getParent())) continue;
                    typeBox.addItem(type);
                }
                typeBox.setSelectedItem(tr.getType());
                typeBox.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        OBOProperty type = (OBOProperty)typeBox.getSelectedItem();
                        LinkTypeHistoryItem item = new LinkTypeHistoryItem(tr, type);
                        TreePath[] paths = ParentPlugin.this.controller.getSelectedPaths();
                        item.setPreSelection(TermUtil.convertPathsToIDs(paths));
                        TreePath[] outpaths = new TreePath[paths.length];
                        for (int i = 0; i < outpaths.length; ++i) {
                            OBORestriction tr2 = ParentPlugin.this.controller.getSession().getObjectFactory().createOBORestriction(tr.getChild(), type, tr.getParent(), false, null);
                            outpaths[i] = paths[i].getParentPath().pathByAddingChild(tr2);
                        }
                        item.setPostSelection(TermUtil.convertPathsToIDs(outpaths));
                        ParentPlugin.this.controller.apply(item);
                    }
                });
                JButton idButton = new JButton(tr.getParent().getID());
                idButton.setBorder(null);
                if (TermUtil.isDangling(tr.getParent())) {
                    idButton.setForeground(Color.red);
                } else {
                    idButton.setForeground(Color.blue);
                    idButton.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            ParentPlugin.this.controller.select(tr.getParent());
                        }
                    });
                }
                idButton.setFont(font);
                idButton.setOpaque(false);
                JTextField field = new JTextField();
                field.setOpaque(false);
                field.setBorder(null);
                field.setText(tr.getParent().getName());
                field.setCaretPosition(0);
                field.setToolTipText(tr.getParent().getName());
                field.setEditable(false);
                field.setFont(font);
                JButton trashButton = new JButton(Preferences.loadLibraryIcon("trashcan.gif"));
                trashButton.setBackground(Preferences.defaultButtonColor());
                trashButton.setPreferredSize(new Dimension(20, 18));
                trashButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        DeleteLinkHistoryItem ditem = new DeleteLinkHistoryItem(tr);
                        ditem.setPreSelection(TermUtil.convertPathsToIDs(ParentPlugin.this.controller.getSelectedPaths()));
                        Vector<TreePath> temp = new Vector<TreePath>();
                        for (int i = 0; i < oldpaths.length; ++i) {
                            if (oldpaths[i].getLastPathComponent().equals(tr)) continue;
                            temp.add(oldpaths[i]);
                        }
                        Object[] paths = new TreePath[temp.size()];
                        temp.copyInto(paths);
                        ditem.setPostSelection(TermUtil.convertPathsToIDs((TreePath[])paths));
                        ParentPlugin.this.controller.apply(ditem);
                    }
                });
                trashButton.setEnabled(enabled && tr.getChild().getParents().size() > 1);
                panel.add(trashButton);
                panel.add(Box.createHorizontalStrut(5));
                panel.add(typeBox);
                panel.add(Box.createHorizontalStrut(5));
                panel.add(idButton);
                panel.add(Box.createHorizontalStrut(5));
                panel.add(field);
                panel.add(Box.createHorizontalGlue());
                if (!TermUtil.isProperty(tr.getParent())) {
                    JLabel completesLabel = new JLabel(this.completes_icon);
                    JCheckBox completesBox = new JCheckBox("");
                    completesBox.setSelected(tr.completes());
                    completesBox.setFont(font);
                    completesBox.setToolTipText("Completes");
                    completesBox.setEnabled(enabled);
                    panel.add(completesLabel);
                    panel.add(completesBox);
                    panel.add(Box.createHorizontalStrut(5));
                    completesBox.setOpaque(false);
                    completesBox.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            CompletesHistoryItem item = new CompletesHistoryItem(tr);
                            item.setPreSelection(TermUtil.convertPathsToIDs(ParentPlugin.this.controller.getSelectedPaths()));
                            item.setPostSelection(TermUtil.convertPathsToIDs(ParentPlugin.this.controller.getSelectedPaths()));
                            ParentPlugin.this.controller.apply(item);
                        }
                    });
                    JLabel necLabel = new JLabel(this.nec_icon);
                    JCheckBox necessaryBox = new JCheckBox("");
                    necessaryBox.setSelected(tr.isNecessarilyTrue());
                    necessaryBox.setFont(font);
                    necessaryBox.setToolTipText("Necessarily true");
                    necessaryBox.setEnabled(enabled);
                    panel.add(necLabel);
                    panel.add(necessaryBox);
                    panel.add(Box.createHorizontalStrut(5));
                    necessaryBox.setOpaque(false);
                    necessaryBox.setEnabled(enabled);
                    necessaryBox.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            NecessarilyTrueHistoryItem item = new NecessarilyTrueHistoryItem(tr);
                            item.setPreSelection(TermUtil.convertPathsToIDs(ParentPlugin.this.controller.getSelectedPaths()));
                            item.setPostSelection(TermUtil.convertPathsToIDs(ParentPlugin.this.controller.getSelectedPaths()));
                            ParentPlugin.this.controller.apply(item);
                        }
                    });
                    JLabel invLabel = new JLabel(this.inv_icon);
                    JCheckBox invNecessaryBox = new JCheckBox("");
                    invNecessaryBox.setSelected(tr.isInverseNecessarilyTrue());
                    invNecessaryBox.setFont(font);
                    invNecessaryBox.setToolTipText("Inverse necessarily true");
                    invNecessaryBox.setEnabled(enabled);
                    panel.add(invLabel);
                    panel.add(invNecessaryBox);
                    panel.add(Box.createHorizontalStrut(5));
                    invNecessaryBox.setOpaque(false);
                    invNecessaryBox.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            InverseNecHistoryItem item = new InverseNecHistoryItem(tr);
                            item.setPreSelection(TermUtil.convertPathsToIDs(ParentPlugin.this.controller.getSelectedPaths()));
                            item.setPostSelection(TermUtil.convertPathsToIDs(ParentPlugin.this.controller.getSelectedPaths()));
                            ParentPlugin.this.controller.apply(item);
                        }
                    });
                    JButton cardinalityButton = new JButton();
                    cardinalityButton.setFont(font);
                    cardinalityButton.setBackground(Preferences.defaultButtonColor());
                    cardinalityButton.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            ParentPlugin.this.editCardinality(tr);
                        }
                    });
                    cardinalityButton.setEnabled(enabled);
                    String label = null;
                    if (tr.getCardinality() != null) {
                        label = tr.getCardinality() + "";
                    } else if (tr.getMinCardinality() == null && tr.getMaxCardinality() == null) {
                        label = "[*,*]";
                    } else {
                        if (tr.getMinCardinality() != null) {
                            label = "[" + tr.getMinCardinality() + ",";
                        }
                        if (tr.getMaxCardinality() != null) {
                            label = label == null ? "[*," + tr.getMaxCardinality() + "]" : label + tr.getMaxCardinality() + "]";
                        } else if (label != null) {
                            label = label + "*]";
                        }
                    }
                    cardinalityButton.setLabel(label);
                    panel.add(cardinalityButton);
                    panel.add(Box.createHorizontalStrut(5));
                }
                final JComboBox<Object> namespaceBox = new JComboBox<Object>();
                namespaceBox.setFont(font);
                namespaceBox.setEnabled(enabled);
                namespaceBox.setBackground(Preferences.defaultButtonColor());
                it = this.controller.getSession().getNamespaces().iterator();
                namespaceBox.addItem("<no namespace>");
                while (it.hasNext()) {
                    Namespace ns = (Namespace)it.next();
                    namespaceBox.addItem(ns);
                }
                if (tr.getNamespace() == null) {
                    namespaceBox.setSelectedIndex(0);
                } else {
                    namespaceBox.setSelectedItem(tr.getNamespace());
                }
                namespaceBox.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        Namespace ns = null;
                        if (namespaceBox.getSelectedIndex() > 0) {
                            ns = (Namespace)namespaceBox.getSelectedItem();
                        }
                        TRNamespaceHistoryItem item = new TRNamespaceHistoryItem(tr, ns);
                        item.setPreSelection(TermUtil.convertPathsToIDs(ParentPlugin.this.controller.getSelectedPaths()));
                        item.setPostSelection(TermUtil.convertPathsToIDs(ParentPlugin.this.controller.getSelectedPaths()));
                        ParentPlugin.this.controller.apply(item);
                    }
                });
                panel.add(namespaceBox);
                panel.add(Box.createHorizontalStrut(5));
                panel.setOpaque(false);
                this.outerPanel.add(panel);
            }
            this.outerPanel.add(Box.createVerticalStrut(10));
            this.outerPanel.setBackground(Preferences.defaultBackgroundColor());
        }
        this.validate();
        this.repaint();
    }

    protected void changeCardinalitySetting(int index) {
        this.cardinalityPanel.removeAll();
        if (index == 0) {
            this.cardinalityPanel.add(this.cardinalityLabel);
            this.cardinalityPanel.add(Box.createHorizontalStrut(5));
            this.cardinalityPanel.add(this.cardinalityField);
        } else {
            this.cardinalityPanel.add(this.cardinalityRangeLabel);
            this.cardinalityPanel.add(Box.createHorizontalStrut(5));
            this.cardinalityPanel.add(this.minCardinalityField);
            this.cardinalityPanel.add(Box.createHorizontalStrut(5));
            this.cardinalityPanel.add(this.maxCardinalityField);
        }
        this.cardinalityPanel.validate();
    }

    protected String toString(Integer a) {
        if (a == null) {
            return "";
        }
        return a.toString();
    }

    protected void editCardinality(final OBORestriction tr) {
        final JComboBox<String> cardinalityChooser = new JComboBox<String>(cardinalityChoices);
        cardinalityChooser.setFont(this.controller.getDefaultFont());
        cardinalityChooser.setBackground(Preferences.defaultButtonColor());
        final JDialog dialog = new JDialog((Frame)null, "Cardinality settings", true);
        JPanel panel = new JPanel();
        panel.setBackground(Preferences.defaultBackgroundColor());
        panel.setLayout(new BoxLayout(panel, 1));
        TitledBorder border = new TitledBorder("");
        border.setTitleFont(this.controller.getDefaultFont());
        this.cardinalityPanel.setBorder(border);
        this.cardinalityPanel.setLayout(new BoxLayout(this.cardinalityPanel, 0));
        cardinalityChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ParentPlugin.this.changeCardinalitySetting(cardinalityChooser.getSelectedIndex());
            }
        });
        this.minCardinalityField.setText(this.toString(tr.getMinCardinality()));
        this.maxCardinalityField.setText(this.toString(tr.getMaxCardinality()));
        this.cardinalityField.setText(this.toString(tr.getCardinality()));
        if (tr.getCardinality() != null) {
            cardinalityChooser.setSelectedIndex(0);
        } else {
            cardinalityChooser.setSelectedIndex(1);
        }
        JButton commit = new JButton("Commit");
        commit.setFont(this.controller.getDefaultFont());
        commit.setBackground(Preferences.defaultButtonColor());
        commit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Vector<LinkHistoryItem> changes = new Vector<LinkHistoryItem>();
                if (cardinalityChooser.getSelectedIndex() == 0) {
                    Integer cardinality = null;
                    try {
                        cardinality = new Integer(ParentPlugin.this.cardinalityField.getText());
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                    if (!ObjectUtil.equals(cardinality, (Object)tr.getCardinality())) {
                        changes.add(new CardinalityHistoryItem(tr, cardinality));
                    }
                    if (tr.getMinCardinality() != null) {
                        changes.add(new MinCardinalityHistoryItem(tr, null));
                    }
                    if (tr.getMaxCardinality() != null) {
                        changes.add(new MaxCardinalityHistoryItem(tr, null));
                    }
                } else {
                    Integer maxCardinality = null;
                    Integer minCardinality = null;
                    try {
                        minCardinality = new Integer(ParentPlugin.this.minCardinalityField.getText());
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                    try {
                        maxCardinality = new Integer(ParentPlugin.this.maxCardinalityField.getText());
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                    if (!ObjectUtil.equals((Object)minCardinality, (Object)tr.getMinCardinality())) {
                        changes.add(new MinCardinalityHistoryItem(tr, minCardinality));
                    }
                    if (!ObjectUtil.equals((Object)maxCardinality, (Object)tr.getMaxCardinality())) {
                        changes.add(new MaxCardinalityHistoryItem(tr, maxCardinality));
                    }
                    if (tr.getCardinality() != null) {
                        changes.add(new CardinalityHistoryItem(tr, null));
                    }
                }
                HistoryItem item = null;
                if (changes.size() == 1) {
                    item = (HistoryItem)changes.get(0);
                } else if (changes.size() > 0) {
                    item = new TermMacroHistoryItem("Cardinality change");
                    for (int i = 0; i < changes.size(); ++i) {
                        ((TermMacroHistoryItem)item).addHistoryItem((HistoryItem)changes.get(i));
                    }
                }
                if (item != null) {
                    item.setPreSelection(ParentPlugin.this.controller.getSelectedPaths());
                    item.setPostSelection(ParentPlugin.this.controller.getSelectedPaths());
                    ParentPlugin.this.controller.apply(item);
                }
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        Box commitBox = new Box(0);
        commitBox.add(Box.createHorizontalGlue());
        commitBox.add(commit);
        commitBox.add(Box.createHorizontalGlue());
        panel.add(Box.createVerticalStrut(10));
        panel.add(cardinalityChooser);
        panel.add(this.cardinalityPanel);
        panel.add(commitBox);
        panel.add(Box.createVerticalGlue());
        panel.validate();
        dialog.setContentPane(panel);
        dialog.pack();
        dialog.show();
    }

    public void init() {
        this.buttonPanel.setBackground(Controller.getController().getPreferences().getBackgroundColor());
        this.cardinalityField.setFont(this.controller.getDefaultFont());
        this.minCardinalityField.setFont(this.controller.getDefaultFont());
        this.maxCardinalityField.setFont(this.controller.getDefaultFont());
        this.cardinalityCommitButton.setFont(this.controller.getDefaultFont());
        this.cardinalityPanel.setBackground(Preferences.defaultBackgroundColor());
        this.cardinalityLabel.setFont(this.controller.getDefaultFont());
        this.cardinalityRangeLabel.setFont(this.controller.getDefaultFont());
        URL url = Controller.getController().getExtensionLoader().getResource("org/geneontology/oboedit/gui/resources/icons/inv_icon.gif");
        this.inv_icon = new ImageIcon(url);
        url = Controller.getController().getExtensionLoader().getResource("org/geneontology/oboedit/gui/resources/icons/nec_icon.gif");
        this.nec_icon = new ImageIcon(url);
        url = Controller.getController().getExtensionLoader().getResource("org/geneontology/oboedit/gui/resources/icons/completes.gif");
        this.completes_icon = new ImageIcon(url);
        this.setLayout(new BorderLayout());
        this.attachListeners();
        this.setBorder(this.emptyBorder);
        this.label.setFont(this.controller.getDefaultFont());
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        if (this.controller.getSubSelection() instanceof LinkedObject) {
            this.loadTerm((LinkedObject)this.controller.getSubSelection());
        }
        this.outerPanel.setBackground(Preferences.defaultBackgroundColor());
        this.outerPanel.setLayout(new BoxLayout(this.outerPanel, 1));
        this.dropButton.setBorder(null);
        this.dropButton.setBackground(Preferences.defaultButtonColor());
        this.dropButton.setFont(this.controller.getDefaultFont());
        this.showImpliedCheckbox.setFont(this.controller.getDefaultFont());
        this.panel.setOpaque(true);
        this.panel.setBackground(Preferences.defaultBackgroundColor());
        this.panel.setLayout(new BorderLayout());
        JScrollPane pane = new JScrollPane(this.panel, 20, 31);
        pane.setBackground(Preferences.defaultBackgroundColor());
        this.panel.removeAll();
        this.removeAll();
        this.panel.add((Component)this.outerPanel, "North");
        this.panel.add((Component)this.buttonPanel, "Center");
        this.add(pane, "Center");
    }

    protected void attachListeners() {
        this.controller.getDragController().registerDropTarget(this.dropTarget);
        this.controller.addListener(this.selectListener);
        this.controller.addListener(this.historyListener);
    }

    protected void removeListeners() {
        this.controller.getDragController().unregisterDropTarget(this.dropTarget);
        this.controller.removeListener(this.selectListener);
        this.controller.removeListener(this.historyListener);
    }

    public void cleanup() {
        this.removeListeners();
    }

    protected class RowScrollPanel
    extends JPanel
    implements Scrollable {
        private static final long serialVersionUID = 1L;

        protected RowScrollPanel() {
        }

        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return ParentPlugin.this.controller.getDefaultFont().getSize();
        }

        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return ParentPlugin.this.controller.getDefaultFont().getSize() * 4;
        }

        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }
}

