/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.plugin;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.CubicCurve2D;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.Namespace;
import org.geneontology.oboedit.datamodel.OBOClass;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.oboedit.datamodel.OBORestriction;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.history.CompletesHistoryItem;
import org.geneontology.oboedit.datamodel.history.CreateObjectHistoryItem;
import org.geneontology.oboedit.datamodel.history.NameChangeHistoryItem;
import org.geneontology.oboedit.datamodel.history.NamespaceHistoryItem;
import org.geneontology.oboedit.datamodel.history.TRNamespaceHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermCopyHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermMacroHistoryItem;
import org.geneontology.oboedit.datamodel.impl.DefaultTermModel;
import org.geneontology.oboedit.datamodel.impl.OBORestrictionWrapper;
import org.geneontology.oboedit.gui.ComponentPlugin;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.OBOCellRenderer;
import org.geneontology.oboedit.gui.Preferences;
import org.geneontology.oboedit.gui.event.HistoryAppliedEvent;
import org.geneontology.oboedit.gui.event.HistoryListener;
import org.geneontology.oboedit.gui.event.RefreshEvent;
import org.geneontology.oboedit.gui.event.RefreshListener;
import org.geneontology.oboedit.gui.event.RootChangeEvent;
import org.geneontology.oboedit.gui.event.RootChangeListener;
import org.geneontology.swing.DropTarget;
import org.geneontology.swing.event.DragEvent;
import org.geneontology.swing.event.DropListener;
import org.geneontology.util.ObjectUtil;

public class CrossProductPlugin
extends ComponentPlugin {
    private static final long serialVersionUID = 1L;
    protected List rpanels = new Vector();
    protected JButton executeButton = new JButton("Execute");
    protected JTextField nameField = new JTextField();
    protected JComboBox nsComboBox = new JComboBox();
    protected HistoryListener nsHistoryListener = new HistoryListener(){

        public void applied(HistoryAppliedEvent e) {
            CrossProductPlugin.this.configureNamespaces(CrossProductPlugin.this.nsComboBox);
        }

        public void reversed(HistoryAppliedEvent e) {
            CrossProductPlugin.this.configureNamespaces(CrossProductPlugin.this.nsComboBox);
        }
    };
    protected RootChangeListener nsRootListener = new RootChangeListener(){

        public void changeRoot(RootChangeEvent e) {
            CrossProductPlugin.this.configureNamespaces(CrossProductPlugin.this.nsComboBox);
        }
    };

    protected void configureNamespaces(JComboBox box) {
        Iterator it = this.controller.getSession().getNamespaces().iterator();
        box.removeAllItems();
        box.addItem("<default namespace>");
        while (it.hasNext()) {
            Namespace ns = (Namespace)it.next();
            box.addItem(ns);
        }
    }

    public void init() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.nsComboBox.setBackground(Preferences.defaultButtonColor());
        this.controller.addListener(this.nsRootListener);
        this.controller.addListener(this.nsHistoryListener);
        Iterator it = this.rpanels.iterator();
        while (it.hasNext()) {
            RelationshipPanel rp = (RelationshipPanel)it.next();
            rp.cleanup();
            it.remove();
        }
        RelationshipPanel primary = new RelationshipPanel(OBOProperty.IS_A);
        if (this.controller.getSubSelection() instanceof LinkedObject) {
            primary.populateTree((LinkedObject)this.controller.getSubSelection());
        }
        this.rpanels.add(primary);
        this.rpanels.add(new RelationshipPanel());
        this.executeButton.setBackground(Preferences.defaultButtonColor());
        this.executeButton.setFont(this.controller.getDefaultFont());
        this.nsComboBox.setFont(this.controller.getDefaultFont());
        this.nameField.setFont(this.controller.getDefaultFont());
        JLabel nameLabel = new JLabel("Name rule");
        nameLabel.setFont(this.controller.getDefaultFont());
        final JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1, this.rpanels.size()));
        it = this.rpanels.iterator();
        while (it.hasNext()) {
            RelationshipPanel rp = (RelationshipPanel)it.next();
            rp.setPreferredSize(new Dimension(200, 300));
            panel.add(rp);
        }
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new BorderLayout());
        namePanel.add((Component)nameLabel, "West");
        namePanel.add((Component)this.nameField, "Center");
        namePanel.add((Component)this.nsComboBox, "East");
        namePanel.setBackground(Preferences.defaultBackgroundColor());
        JPanel bottomSubPanel = new JPanel();
        bottomSubPanel.setLayout(new BorderLayout());
        bottomSubPanel.add((Component)namePanel, "North");
        bottomSubPanel.add((Component)this.executeButton, "South");
        final GraphicalDealy gd = new GraphicalDealy();
        gd.setBackground(Preferences.defaultBackgroundColor());
        gd.setForeground(Color.black);
        gd.setPreferredSize(new Dimension(400, 40));
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        bottomPanel.add((Component)bottomSubPanel, "South");
        this.configureNamespaces(this.nsComboBox);
        JButton addPanelButton = new JButton("+");
        final JButton removePanelButton = new JButton("-");
        removePanelButton.setEnabled(false);
        addPanelButton.setBackground(Preferences.defaultButtonColor());
        removePanelButton.setBackground(Preferences.defaultButtonColor());
        addPanelButton.setFont(this.controller.getDefaultFont());
        removePanelButton.setFont(this.controller.getDefaultFont());
        JPanel addRemoveButtonPanel = new JPanel();
        addRemoveButtonPanel.setLayout(new GridLayout(2, 1));
        addRemoveButtonPanel.setPreferredSize(new Dimension(50, 50));
        addRemoveButtonPanel.add(addPanelButton);
        addRemoveButtonPanel.add(removePanelButton);
        JPanel dealyWrapper = new JPanel();
        dealyWrapper.setLayout(new BorderLayout());
        dealyWrapper.add((Component)panel, "Center");
        dealyWrapper.add((Component)gd, "South");
        addPanelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RelationshipPanel rp = new RelationshipPanel();
                rp.setPreferredSize(new Dimension(200, 300));
                panel.add(rp);
                CrossProductPlugin.this.rpanels.add(rp);
                removePanelButton.setEnabled(true);
                panel.revalidate();
                gd.repaint();
            }
        });
        removePanelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                panel.remove(CrossProductPlugin.this.rpanels.size() - 1);
                CrossProductPlugin.this.rpanels.remove(CrossProductPlugin.this.rpanels.size() - 1);
                if (CrossProductPlugin.this.rpanels.size() <= 2) {
                    removePanelButton.setEnabled(false);
                }
                panel.revalidate();
                gd.repaint();
            }
        });
        JPanel centerWrapper = new JPanel();
        centerWrapper.setLayout(new BorderLayout());
        centerWrapper.add((Component)dealyWrapper, "Center");
        centerWrapper.add((Component)addRemoveButtonPanel, "East");
        this.add(centerWrapper, "Center");
        this.add(bottomPanel, "South");
    }

    public List getCrossProduct(List a, List b) {
        Vector out = new Vector();
        if (a == null || a.size() == 0) {
            a = new Vector();
            a.add(new Vector());
        }
        Iterator it = a.iterator();
        while (it.hasNext()) {
            List s = (List)it.next();
            Iterator it2 = b.iterator();
            while (it2.hasNext()) {
                Vector s2 = new Vector(s);
                s2.add(it2.next());
                out.add(s2);
            }
        }
        return out;
    }

    protected String getNewTermName(String template, List l) {
        StringBuffer out = new StringBuffer();
        String numeral = null;
        boolean inNumeral = false;
        for (int i = 0; i < template.length(); ++i) {
            char c = template.charAt(i);
            if (inNumeral) {
                if (Character.isWhitespace(c)) {
                    inNumeral = false;
                    int index = -1;
                    try {
                        index = Integer.parseInt(numeral) - 1;
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                    if (index < l.size() && index >= 0) {
                        ClassPropStruct cps = (ClassPropStruct)l.get(index);
                        out.append(cps.getOBOClass().getName());
                    } else {
                        out.append("$" + numeral);
                    }
                    out.append(c);
                    numeral = null;
                    continue;
                }
                numeral = numeral + c;
                continue;
            }
            if (c == '\\') {
                if (++i < template.length()) {
                    c = template.charAt(i);
                }
                out.append(c);
                continue;
            }
            if (c == '$') {
                inNumeral = true;
                numeral = "";
                continue;
            }
            out.append(c);
        }
        if (inNumeral) {
            int index = -1;
            try {
                index = Integer.parseInt(numeral) - 1;
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            if (index < l.size() && index >= 0) {
                ClassPropStruct cps = (ClassPropStruct)l.get(index);
                out.append(cps.getOBOClass().getName());
            } else {
                out.append("$" + numeral);
            }
        }
        return out.toString();
    }

    public CrossProductPlugin() {
        this.executeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CrossProductPlugin.this.execute();
            }
        });
    }

    public void execute() {
        Iterator it = this.rpanels.iterator();
        while (it.hasNext()) {
            RelationshipPanel rp = (RelationshipPanel)it.next();
            if (rp.getType() == null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Every relationship panel must have a relationship set.");
                return;
            }
            if (rp.getParentObj() == null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Every relationship panel must have a term set.");
                return;
            }
            if (rp.getSelection().size() != 0) continue;
            JOptionPane.showMessageDialog((Component)((Object)this), "Every relationship panel must have some selected terms.");
            return;
        }
        if (this.nameField.getText().length() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "A naming rule must be defined.");
            return;
        }
        Namespace ns = null;
        if (this.nsComboBox.getSelectedIndex() > 0) {
            ns = (Namespace)this.nsComboBox.getSelectedItem();
        }
        it = this.rpanels.iterator();
        List crossProducts = new Vector();
        while (it.hasNext()) {
            RelationshipPanel rp = (RelationshipPanel)it.next();
            crossProducts = this.getCrossProduct(crossProducts, rp.getSelection());
        }
        TermMacroHistoryItem m = new TermMacroHistoryItem("Created cross products");
        String[] ids = TermUtil.fetchIDs(this.controller, null, crossProducts.size());
        it = crossProducts.iterator();
        int i = 0;
        while (it.hasNext()) {
            List l = (List)it.next();
            String id = ids[i];
            String name = this.getNewTermName(this.nameField.getText(), l);
            CreateObjectHistoryItem item = new CreateObjectHistoryItem(id, OBOClass.OBO_CLASS.getID());
            m.addHistoryItem(item);
            NameChangeHistoryItem nameItem = new NameChangeHistoryItem(name, "<new term>", id);
            m.addHistoryItem(nameItem);
            if (ns != null) {
                m.addHistoryItem(new NamespaceHistoryItem(null, ns, id));
            }
            Iterator it2 = l.iterator();
            while (it2.hasNext()) {
                ClassPropStruct cps = (ClassPropStruct)it2.next();
                HistoryItem.StringRelationship sr = new HistoryItem.StringRelationship(cps.getOBOClass().getID(), id, cps.getProperty().getID());
                TermCopyHistoryItem copyitem = new TermCopyHistoryItem(cps.getOBOClass().getID(), sr);
                m.addHistoryItem(copyitem);
                CompletesHistoryItem compItem = new CompletesHistoryItem(sr, false);
                m.addHistoryItem(compItem);
                if (cps.getNamespace() == null) continue;
                m.addHistoryItem(new TRNamespaceHistoryItem(sr, cps.getNamespace().getID(), null));
            }
            ++i;
        }
        this.controller.apply(m);
    }

    public void cleanup() {
        Iterator it = this.rpanels.iterator();
        while (it.hasNext()) {
            RelationshipPanel rp = (RelationshipPanel)it.next();
            rp.cleanup();
            it.remove();
        }
        this.controller.removeListener(this.nsRootListener);
        this.controller.removeListener(this.nsHistoryListener);
    }

    public String getName() {
        return "Cross Product Plugin";
    }

    static /* synthetic */ Controller access$000(CrossProductPlugin x0) {
        return x0.controller;
    }

    static /* synthetic */ Controller access$100(CrossProductPlugin x0) {
        return x0.controller;
    }

    protected class GraphicalDealy
    extends JComponent {
        private static final long serialVersionUID = 1L;

        protected GraphicalDealy() {
        }

        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(this.getBackground());
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2.setColor(this.getForeground());
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setStroke(new BasicStroke(2.0f));
            int margin = 10;
            int arrowHeight = 10;
            int arrowWidth = 10;
            int arrowLineLength = this.getHeight() - arrowHeight;
            int rpanelwidth = ((Component)CrossProductPlugin.this.rpanels.get(0)).getWidth();
            int lineMargin = rpanelwidth / 2;
            g2.drawLine(lineMargin, 0, this.getWidth() - lineMargin, 0);
            g2.drawLine(this.getWidth() / 2, 0, this.getWidth() / 2, arrowLineLength);
            Polygon p = new Polygon();
            p.addPoint(this.getWidth() / 2 - arrowWidth / 2, arrowLineLength);
            p.addPoint(this.getWidth() / 2 + arrowWidth / 2, arrowLineLength);
            p.addPoint(this.getWidth() / 2, arrowLineLength + arrowHeight);
            g2.fill(p);
        }
    }

    protected class SquiggleDealy
    extends JComponent {
        private static final long serialVersionUID = 1L;

        protected SquiggleDealy() {
        }

        protected Shape getShape(int x, int y, int width, int height, boolean flip) {
            if (flip) {
                return new CubicCurve2D.Float(x, y + height, x, y, x + width, y + height, x + width, y);
            }
            return new CubicCurve2D.Float(x, y, x, y + height, x + width, y, x + width, y + height);
        }

        protected void paintSquiggle(Graphics2D g2, int x, int y, int width, int height) {
            g2.draw(this.getShape(x, y, width / 2, height, false));
            g2.draw(this.getShape(x + width / 2, y, width / 2, height, true));
        }

        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(this.getBackground());
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2.setColor(this.getForeground());
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setStroke(new BasicStroke(2.0f));
            int margin = 10;
            int lineDepth = this.getHeight() / 5;
            int squiggleHeight = this.getHeight() - lineDepth;
            int squiggleWidth = this.getWidth();
            this.paintSquiggle(g2, margin, 0, squiggleWidth - margin * 2, squiggleHeight);
            g2.drawLine(squiggleWidth / 2, squiggleHeight, squiggleWidth / 2, squiggleHeight + lineDepth);
        }
    }

    protected static class TermBrowser
    extends JDialog {
        private static final long serialVersionUID = 1L;
        protected JTree tree;
        protected JButton okButton = new JButton("Ok");

        public TermBrowser(Controller controller, boolean showTerms, boolean showTypes, boolean showObsoletes) {
            super((Frame)null, "Select a term", true);
            this.tree = new JTree();
            DefaultTermModel model = new DefaultTermModel(controller);
            model.setShowTerms(showTerms);
            model.setShowTypes(showTypes);
            model.setShowObsoletes(false);
            model.setShowInstances(false);
            model.reload(null);
            this.tree.setModel(model);
            this.tree.setCellRenderer(new OBOCellRenderer(controller));
            this.tree.setRootVisible(false);
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TermBrowser.this.dispose();
                }
            });
            this.tree.getSelectionModel().setSelectionMode(1);
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            JScrollPane pane = new JScrollPane(this.tree);
            panel.add((Component)pane, "Center");
            this.okButton.setFont(controller.getDefaultFont());
            this.okButton.setBackground(Preferences.defaultButtonColor());
            panel.add((Component)this.okButton, "South");
            panel.setBackground(Color.white);
            this.setContentPane(panel);
            this.tree.expandRow(0);
        }

        public LinkedObject getSelectedTerm() {
            TreePath selected = this.tree.getSelectionPath();
            if (selected == null) {
                return null;
            }
            return ((Link)selected.getLastPathComponent()).getChild();
        }
    }

    protected class RelationshipPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        protected LinkedObject parent;
        protected OBOProperty type;
        protected Namespace namespace;
        protected Set additionalParents = new HashSet();
        protected Map selectionMap;
        protected Set selectionSet;
        protected JButton parentButton = new JButton("<term>");
        protected JButton typeButton = new JButton("<type>");
        protected JComboBox nsBox = new JComboBox();
        protected JTree parentTree = new JTree();
        protected JScrollPane scrollPane = new JScrollPane(this.parentTree, 20, 30);
        protected TreeSelectionModel selectionModel = new DefaultTreeSelectionModel();
        protected DropListener termDropListener = new DropListener(){
            LineBorder border = new LineBorder(Color.black, 2);
            CompoundBorder compoundBorder;
            Border oldBorder;

            public boolean allowDrop(DragEvent e) {
                if (e.getData() instanceof TreePath[] && ((TreePath[])e.getData()).length == 1) {
                    TreePath path = ((TreePath[])e.getData())[0];
                    return path.getLastPathComponent() instanceof Link && ((Link)path.getLastPathComponent()).getChild() instanceof OBOClass;
                }
                return false;
            }

            public void dragEnter(DragEvent e) {
                if (this.allowDrop(e)) {
                    this.oldBorder = RelationshipPanel.this.parentButton.getBorder();
                    this.compoundBorder = new CompoundBorder(this.border, this.oldBorder);
                    RelationshipPanel.this.parentButton.setBorder(this.compoundBorder);
                }
            }

            public void dragExit(DragEvent e) {
                RelationshipPanel.this.parentButton.setBorder(this.oldBorder);
            }

            public void drop(DragEvent e) {
                TreePath[] paths = (TreePath[])e.getData();
                OBOClass oboClass = (OBOClass)((Link)paths[0].getLastPathComponent()).getChild();
                RelationshipPanel.this.parent = oboClass;
                RelationshipPanel.this.populateTree(RelationshipPanel.this.parent);
                RelationshipPanel.this.parentButton.setBorder(this.oldBorder);
            }

            public void draggedOver(DragEvent e) {
            }
        };
        protected DropListener propDropListener = new DropListener(){
            LineBorder border = new LineBorder(Color.black, 2);
            CompoundBorder compoundBorder;
            Border oldBorder;

            public boolean allowDrop(DragEvent e) {
                if (RelationshipPanel.this.typeButton.isEnabled() && e.getData() instanceof TreePath[] && ((TreePath[])e.getData()).length == 1) {
                    TreePath path = ((TreePath[])e.getData())[0];
                    return path.getLastPathComponent() instanceof Link && ((Link)path.getLastPathComponent()).getChild() instanceof OBOProperty;
                }
                return false;
            }

            public void dragEnter(DragEvent e) {
                if (this.allowDrop(e)) {
                    this.oldBorder = RelationshipPanel.this.typeButton.getBorder();
                    this.compoundBorder = new CompoundBorder(this.border, this.oldBorder);
                    RelationshipPanel.this.typeButton.setBorder(this.compoundBorder);
                }
            }

            public void dragExit(DragEvent e) {
                RelationshipPanel.this.typeButton.setBorder(this.oldBorder);
            }

            public void drop(DragEvent e) {
                OBOProperty prop;
                TreePath[] paths = (TreePath[])e.getData();
                Link link = (Link)paths[0].getLastPathComponent();
                RelationshipPanel.this.type = prop = (OBOProperty)link.getChild();
                RelationshipPanel.this.typeButton.setLabel(RelationshipPanel.this.type.getName());
                RelationshipPanel.this.typeButton.setBorder(this.oldBorder);
            }

            public void draggedOver(DragEvent e) {
            }
        };
        protected DropTarget termDropTarget;
        protected DropTarget propDropTarget;
        protected RefreshListener reloadListener = new RefreshListener(){

            public void reload(RefreshEvent e) {
                CrossProductPlugin.this.configureNamespaces(RelationshipPanel.this.nsBox);
            }
        };
        protected HistoryListener historyListener = new HistoryListener(){

            public void applied(HistoryAppliedEvent e) {
                CrossProductPlugin.this.configureNamespaces(((RelationshipPanel)RelationshipPanel.this).CrossProductPlugin.this.nsComboBox);
            }

            public void reversed(HistoryAppliedEvent e) {
                CrossProductPlugin.this.configureNamespaces(((RelationshipPanel)RelationshipPanel.this).CrossProductPlugin.this.nsComboBox);
            }
        };
        protected RootChangeListener rootListener = new RootChangeListener(){

            public void changeRoot(RootChangeEvent e) {
                CrossProductPlugin.this.configureNamespaces(((RelationshipPanel)RelationshipPanel.this).CrossProductPlugin.this.nsComboBox);
            }
        };

        public boolean isSelected(IdentifiedObject o) {
            return this.selectionSet.contains(o);
        }

        public void select(IdentifiedObject o) {
            this.selectionSet.add(o);
        }

        public void unselect(IdentifiedObject o) {
            this.selectionSet.remove(o);
        }

        public LinkedObject getParentObj() {
            return this.parent;
        }

        public OBOProperty getType() {
            return this.type;
        }

        protected void cleanup() {
            CrossProductPlugin.this.controller.removeListener(this.historyListener);
            CrossProductPlugin.this.controller.removeListener(this.rootListener);
            CrossProductPlugin.this.controller.getDragController().unregisterDropTarget(this.termDropTarget);
            CrossProductPlugin.this.controller.getDragController().unregisterDropTarget(this.propDropTarget);
        }

        protected void populateTree(LinkedObject term) {
            this.parent = term;
            if (term == null) {
                this.parentTree.setModel(new EmptyTreeModel());
                this.parentButton.setLabel("<term>");
                this.validate();
                return;
            }
            this.parentButton.setLabel(term.getName());
            TreePath[] paths = TermUtil.getPaths(term);
            this.selectionMap = new HashMap();
            this.selectionSet = new HashSet();
            this.select(term);
            DefaultTermModel model = new DefaultTermModel(Controller.getController());
            model.setShowTerms(true);
            model.setShowTypes(false);
            model.setShowObsoletes(false);
            model.setShowInstances(false);
            this.parentTree.setModel(model);
            this.parentTree.setSelectionModel(null);
            model.reload(null);
            for (int i = 0; i < paths.length; ++i) {
                this.parentTree.makeVisible(paths[i]);
            }
            this.validate();
        }

        protected void expandPath(TreePath path) {
            if (path.getPathCount() > 1) {
                this.expandPath(path.getParentPath());
            }
            this.parentTree.makeVisible(path);
        }

        protected void expandPaths() {
            Object root = this.parentTree.getModel().getRoot();
            Set seenem = TermUtil.mallocSet();
            this.expandPaths(null, root, seenem);
            TermUtil.freeSet(seenem);
        }

        protected void expandPaths(TreePath parentPath, Object o, Set seenem) {
            if (seenem.contains(o)) {
                return;
            }
            seenem.add(o);
            TreePath path = parentPath == null ? new TreePath(o) : parentPath.pathByAddingChild(o);
            if (path.getPathCount() > 6) {
                return;
            }
            this.parentTree.makeVisible(path);
            int childCount = this.parentTree.getModel().getChildCount(o);
            for (int i = 0; i < childCount; ++i) {
                this.expandPaths(path, this.parentTree.getModel().getChild(o, i), seenem);
            }
        }

        public List getSelection() {
            Namespace ns = null;
            if (this.nsBox.getSelectedIndex() > 0) {
                ns = (Namespace)this.nsBox.getSelectedItem();
            }
            Vector<ClassPropStruct> out = new Vector<ClassPropStruct>();
            Iterator it = this.selectionSet.iterator();
            while (it.hasNext()) {
                OBOClass oboClass = (OBOClass)it.next();
                out.add(new ClassPropStruct(oboClass, this.type, ns));
            }
            return out;
        }

        public RelationshipPanel() {
            this(null);
        }

        public RelationshipPanel(OBOProperty intype) {
            this.setLayout(new BorderLayout());
            EditorRenderer er = new EditorRenderer(this);
            this.parentTree.setCellRenderer(er);
            this.parentTree.setCellEditor(new SpecialEditor(this, this.parentTree));
            this.parentTree.setEditable(true);
            this.parentTree.setRootVisible(false);
            this.parentTree.setModel(new EmptyTreeModel());
            CrossProductPlugin.this.controller.addListener(this.historyListener);
            CrossProductPlugin.this.controller.addListener(this.rootListener);
            this.typeButton.setFont(CrossProductPlugin.this.controller.getDefaultFont());
            this.parentButton.setFont(CrossProductPlugin.this.controller.getDefaultFont());
            this.nsBox.setFont(CrossProductPlugin.this.controller.getDefaultFont());
            this.typeButton.setBackground(Preferences.defaultButtonColor());
            this.parentButton.setBackground(Preferences.defaultButtonColor());
            this.nsBox.setBackground(Preferences.defaultButtonColor());
            JPanel leftPanel = new JPanel();
            leftPanel.setLayout(new BoxLayout(leftPanel, 1));
            this.termDropTarget = new DropTarget((Component)this.parentButton, this.termDropListener);
            this.propDropTarget = new DropTarget((Component)this.typeButton, this.propDropListener);
            CrossProductPlugin.this.controller.getDragController().registerDropTarget(this.termDropTarget);
            CrossProductPlugin.this.controller.getDragController().registerDropTarget(this.propDropTarget);
            this.parentButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TermBrowser browser = new TermBrowser(CrossProductPlugin.this.controller, true, false, false);
                    browser.setSize(300, 300);
                    browser.show();
                    RelationshipPanel.this.parent = browser.getSelectedTerm();
                    RelationshipPanel.this.populateTree(RelationshipPanel.this.parent);
                    if (RelationshipPanel.this.parent != null) {
                        RelationshipPanel.this.parentButton.setLabel(RelationshipPanel.this.parent.getName());
                    } else {
                        RelationshipPanel.this.parentButton.setLabel("<term>");
                    }
                }
            });
            if (intype == null) {
                this.typeButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        TermBrowser browser = new TermBrowser(CrossProductPlugin.this.controller, false, true, false);
                        browser.setSize(300, 300);
                        browser.show();
                        RelationshipPanel.this.type = (OBOProperty)browser.getSelectedTerm();
                        if (RelationshipPanel.this.type != null) {
                            RelationshipPanel.this.typeButton.setLabel(RelationshipPanel.this.type.getName());
                        } else {
                            RelationshipPanel.this.typeButton.setLabel("<type>");
                        }
                    }
                });
            } else {
                this.type = intype;
                this.typeButton.setEnabled(false);
                this.typeButton.setLabel(this.type.getName());
            }
            JPanel typePanel = new JPanel();
            typePanel.setLayout(new BorderLayout());
            typePanel.add((Component)this.typeButton, "Center");
            JPanel northPanel = new JPanel();
            northPanel.setLayout(new BorderLayout());
            northPanel.add((Component)this.parentButton, "North");
            northPanel.add((Component)typePanel, "South");
            this.selectionModel.setSelectionMode(1);
            CrossProductPlugin.this.configureNamespaces(this.nsBox);
            SquiggleDealy squiggle = new SquiggleDealy();
            squiggle.setBackground(Preferences.defaultBackgroundColor());
            squiggle.setPreferredSize(new Dimension(100, 20));
            Box southPanel = new Box(1);
            southPanel.add(this.nsBox);
            southPanel.add(squiggle);
            this.add((Component)northPanel, "North");
            this.add((Component)this.scrollPane, "Center");
            this.add((Component)southPanel, "South");
        }
    }

    protected class ClassPropStruct {
        protected OBOClass oboClass;
        protected OBOProperty prop;
        protected Namespace ns;

        public ClassPropStruct(OBOClass oboClass, OBOProperty prop, Namespace ns) {
            this.prop = prop;
            this.oboClass = oboClass;
            this.ns = ns;
        }

        public Namespace getNamespace() {
            return this.ns;
        }

        public OBOClass getOBOClass() {
            return this.oboClass;
        }

        public OBOProperty getProperty() {
            return this.prop;
        }

        public int hashCode() {
            return this.prop.hashCode() + this.oboClass.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof ClassPropStruct) {
                ClassPropStruct cps = (ClassPropStruct)o;
                return ObjectUtil.equals((Object)this.oboClass, (Object)cps.getOBOClass()) && ObjectUtil.equals((Object)this.prop, (Object)cps.getProperty());
            }
            return false;
        }

        public String toString() {
            return this.prop.getID() + ": " + this.oboClass;
        }
    }

    protected class TermSelection {
        protected LinkedObject term;
        protected boolean selected;

        public TermSelection(LinkedObject t) {
            this(t, false);
        }

        public TermSelection(LinkedObject t, boolean selected) {
            this.term = t;
            this.selected = selected;
        }

        public LinkedObject getTerm() {
            return this.term;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        public int hashCode() {
            return this.term.hashCode();
        }

        public boolean equals(Object o) {
            TermSelection ts = (TermSelection)o;
            return ts.getTerm().equals(this.term);
        }
    }

    protected class EditorRenderer
    extends JPanel
    implements TreeCellRenderer {
        private static final long serialVersionUID = 1L;
        protected JCheckBox checkbox = new JCheckBox();
        protected OBOCellRenderer renderer = new OBOCellRenderer(CrossProductPlugin.access$100(CrossProductPlugin.this));
        protected RelationshipPanel relationshipPanel;

        public EditorRenderer(RelationshipPanel relationshipPanel) {
            this.relationshipPanel = relationshipPanel;
            this.checkbox.setFont(CrossProductPlugin.this.controller.getDefaultFont());
            this.checkbox.setOpaque(false);
            this.setLayout(new BorderLayout());
        }

        protected void configureComponent(JTree tree, Object value, boolean isSelected, int row) {
            this.removeAll();
            this.add((Component)this.checkbox, "West");
            if (value instanceof SelectionRestrictionWrapper) {
                TermSelection ts = ((SelectionRestrictionWrapper)value).getSelection();
                Component c = this.renderer.getTreeCellRendererComponent(tree, value, isSelected, false, false, row, false);
                this.add(c, "Center");
                if (isSelected) {
                    this.setBackground(Preferences.defaultSelectionColor());
                } else {
                    this.setBackground(Color.white);
                }
                LinkedObject term = ts.getTerm();
                this.checkbox.setSelected(ts.isSelected());
            } else if (value instanceof Link) {
                Component c = this.renderer.getTreeCellRendererComponent(tree, value, isSelected, false, false, row, false);
                this.add(c, "Center");
                if (isSelected) {
                    this.setBackground(Preferences.defaultSelectionColor());
                } else {
                    this.setBackground(Color.white);
                }
                this.checkbox.setSelected(this.relationshipPanel.isSelected(((Link)value).getChild()));
            }
            this.validate();
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.configureComponent(tree, value, selected, row);
            return this;
        }
    }

    protected class EmptyTreeModel
    implements TreeModel {
        protected EmptyTreeModel() {
        }

        public void addTreeModelListener(TreeModelListener l) {
        }

        public Object getChild(Object parent, int index) {
            return null;
        }

        public int getChildCount(Object parent) {
            return 0;
        }

        public int getIndexOfChild(Object parent, Object child) {
            return -1;
        }

        public Object getRoot() {
            return new Object();
        }

        public boolean isLeaf(Object node) {
            return false;
        }

        public void removeTreeModelListener(TreeModelListener l) {
        }

        public void valueForPathChanged(TreePath path, Object newValue) {
        }
    }

    protected class SpecialEditor
    extends AbstractCellEditor
    implements TreeCellEditor {
        private static final long serialVersionUID = 1L;
        protected Object selected;
        protected JCheckBox checkbox = new JCheckBox();
        protected JPanel panel = new JPanel();
        protected OBOCellRenderer renderer = new OBOCellRenderer(CrossProductPlugin.access$000(CrossProductPlugin.this));
        protected RelationshipPanel relationshipPanel;

        public SpecialEditor(RelationshipPanel relationshipPanel, final JTree parentTree) {
            this.checkbox.setOpaque(false);
            this.checkbox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    parentTree.repaint();
                    SpecialEditor.this.stopCellEditing();
                }
            });
            this.relationshipPanel = relationshipPanel;
            this.panel.setLayout(new BorderLayout());
        }

        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            this.panel.removeAll();
            this.panel.add((Component)this.checkbox, "West");
            this.selected = value;
            if (value instanceof SelectionRestrictionWrapper) {
                TermSelection ts = ((SelectionRestrictionWrapper)value).getSelection();
                Component c = this.renderer.getTreeCellRendererComponent(tree, value, isSelected, false, false, row, false);
                this.panel.add(c, "Center");
                if (isSelected) {
                    this.panel.setBackground(Preferences.defaultSelectionColor());
                } else {
                    this.panel.setBackground(Color.white);
                }
                this.checkbox.setSelected(ts.isSelected());
            } else if (value instanceof Link) {
                Component c = this.renderer.getTreeCellRendererComponent(tree, value, isSelected, false, false, row, false);
                this.panel.add(c, "Center");
                if (isSelected) {
                    this.panel.setBackground(Preferences.defaultSelectionColor());
                } else {
                    this.panel.setBackground(Color.white);
                }
                this.checkbox.setSelected(this.relationshipPanel.isSelected(((Link)value).getChild()));
            }
            return this.panel;
        }

        public Object getCellEditorValue() {
            return this.selected;
        }

        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        public boolean shouldSelectCell(EventObject anEvent) {
            this.panel.requestFocus();
            return false;
        }

        public boolean stopCellEditing() {
            if (!(this.selected instanceof Link)) {
                return true;
            }
            Link link = (Link)this.selected;
            if (this.checkbox.isSelected()) {
                this.relationshipPanel.select(link.getChild());
            } else {
                this.relationshipPanel.unselect(link.getChild());
            }
            this.fireEditingStopped();
            return true;
        }

        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }
    }

    protected class SelectionRestrictionWrapper
    extends OBORestrictionWrapper {
        private static final long serialVersionUID = 1L;
        protected TermSelection ts;

        public SelectionRestrictionWrapper(OBORestriction link, TermSelection ts) {
            super(link);
            this.ts = ts;
        }

        public TermSelection getSelection() {
            return this.ts;
        }
    }
}

