/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.CubicCurve2D;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.border.LineBorder;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.OBORestriction;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.datamodel.Relationship;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.FilteredRenderable;
import org.geneontology.oboedit.gui.LineRenderer;
import org.geneontology.oboedit.gui.OBOTermPanel;
import org.geneontology.oboedit.gui.Preferences;
import org.geneontology.oboedit.gui.filters.FilterPair;
import org.geneontology.oboedit.gui.filters.LinkRenderSpec;
import org.geneontology.oboedit.gui.filters.ObjectRenderSpec;
import org.geneontology.oboedit.gui.filters.RenderSpec;
import org.geneontology.swing.MultiIcon;

public class OBOCellRenderer
extends JLabel
implements TreeCellRenderer,
ListCellRenderer,
LineRenderer {
    private static final long serialVersionUID = 1L;
    protected static final Color ignoreSelectionColor = new Color(204, 255, 204);
    protected static final Color highlightColor = Color.yellow;
    protected static final Color clickBorderColor = Color.black;
    protected static final Color tabBorderColor = Color.blue;
    protected static LineBorder clickBorder = new LineBorder(clickBorderColor);
    protected static LineBorder tabBorder = new LineBorder(tabBorderColor);
    protected ObjectRenderSpec objectSpec = new ObjectRenderSpec();
    protected LinkRenderSpec linkSpec = new LinkRenderSpec();
    protected static HashMap fontHash = new HashMap();
    protected static HashMap strokeHash = new HashMap();
    protected List defaultSpecs = new ArrayList();
    protected MultiIcon multiIcon = new MultiIcon();
    protected Icon nec_inv_icon;
    protected Icon nec_icon;
    protected Icon inv_icon;
    protected Icon completes_icon;
    protected Controller controller;
    protected JComponent renderComponent = this;
    protected final int[] triangleXBuffer = new int[3];
    protected final int[] triangleYBuffer = new int[3];
    protected final int triangleYSize = 4;
    protected final int triangleXSize = 4;
    protected final int triangleOffset = 2;
    protected final boolean arrowheadLeft = true;
    protected final int controlWidth = 8;

    protected void createDefaultSpecs() {
    }

    protected void mergeRenderers(RenderSpec targetSpec, Object o, Collection specs) {
        Iterator it = specs.iterator();
        while (it.hasNext()) {
            FilterPair pair = (FilterPair)it.next();
            if (o instanceof IdentifiedObject && pair.getObjectFilter() != null && pair.getObjectFilter().satisfies(o)) {
                targetSpec.merge(pair.getObjectRenderSpec());
            }
            if (!(o instanceof Link) || pair.getLinkFilter() == null || !pair.getLinkFilter().satisfies(o)) continue;
            targetSpec.merge(pair.getLinkRenderSpec());
        }
    }

    public OBOCellRenderer(Controller controller) {
        this.controller = controller;
        this.createDefaultSpecs();
        Font defaultFont = controller.getDefaultFont();
        URL url = Controller.getController().getExtensionLoader().getResource("org/geneontology/oboedit/gui/resources/icons/inv_and_nec_icon.gif");
        this.nec_inv_icon = new ImageIcon(url);
        url = Controller.getController().getExtensionLoader().getResource("org/geneontology/oboedit/gui/resources/icons/inv_icon.gif");
        this.inv_icon = new ImageIcon(url);
        url = Controller.getController().getExtensionLoader().getResource("org/geneontology/oboedit/gui/resources/icons/nec_icon.gif");
        this.nec_icon = new ImageIcon(url);
        url = Controller.getController().getExtensionLoader().getResource("org/geneontology/oboedit/gui/resources/icons/completes.gif");
        this.completes_icon = new ImageIcon(url);
        this.setIcon((Icon)this.multiIcon);
    }

    public boolean isShowing() {
        return true;
    }

    public Dimension getSize() {
        Dimension d = super.getSize();
        d.height += 4;
        return d;
    }

    public void paintLine(Graphics g, Component c, int y, int left, int right, boolean isLeaf, TreePath path) {
        String hashVal;
        Stroke stroke;
        Object value = path.getLastPathComponent();
        Color lineColor = Color.black;
        int lineWidth = 1;
        int lineStyle = 0;
        if (value instanceof Link) {
            Link link = (Link)path.getLastPathComponent();
            this.linkSpec.clear();
            this.mergeRenderers(this.linkSpec, link, Controller.getController().getGlobalLinkRenderers());
            if (c instanceof FilteredRenderable) {
                this.mergeRenderers(this.linkSpec, link, ((FilteredRenderable)((Object)c)).getRenderers());
            }
            if (this.linkSpec.getLinkColor() != null) {
                lineColor = this.linkSpec.getLinkColor();
            }
            if (this.linkSpec.getLineWidth() != -1) {
                lineWidth = this.linkSpec.getLineWidth();
            }
            if (this.linkSpec.getLineType() != -1) {
                lineStyle = this.linkSpec.getLineType();
            }
        }
        if ((stroke = (Stroke)strokeHash.get(hashVal = lineWidth + "-" + lineStyle)) == null) {
            float[] dash_pattern = null;
            if (lineStyle == 2) {
                dash_pattern = new float[]{lineWidth, lineWidth};
            }
            stroke = new BasicStroke(lineWidth, 0, 2, 1.0f, dash_pattern, 0.0f);
            strokeHash.put(hashVal, stroke);
        }
        int xoffset = 2;
        if (!isLeaf) {
            xoffset += 6;
        }
        boolean drawArrow = path.getPathCount() > 3;
        int modifiedLeft = drawArrow ? left + xoffset + 4 - 1 : left;
        Stroke oldStroke = ((Graphics2D)g).getStroke();
        g.setColor(lineColor);
        ((Graphics2D)g).setStroke(stroke);
        if (lineStyle == 1) {
            int length = right - modifiedLeft;
            CubicCurve2D.Float curve = new CubicCurve2D.Float(modifiedLeft, y, modifiedLeft, y - 2, modifiedLeft + length / 2, y - 2, modifiedLeft + length / 2, y);
            ((Graphics2D)g).draw(curve);
            curve = new CubicCurve2D.Float(modifiedLeft + length / 2, y, modifiedLeft + length / 2, y + 2, right, y + 2, right, y);
            ((Graphics2D)g).draw(curve);
        } else {
            g.drawLine(modifiedLeft, y, right, y);
        }
        ((Graphics2D)g).setStroke(oldStroke);
        if (drawArrow) {
            this.triangleYBuffer[0] = y - 4;
            this.triangleYBuffer[1] = y + 4;
            this.triangleYBuffer[2] = y;
            this.triangleXBuffer[0] = left + xoffset + 4;
            this.triangleXBuffer[1] = left + xoffset + 4;
            this.triangleXBuffer[2] = left + xoffset;
            g.fillPolygon(this.triangleXBuffer, this.triangleYBuffer, 3);
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (isSelected) {
            this.setOpaque(true);
            this.setBackground(Preferences.defaultSelectionColor());
        } else {
            this.setOpaque(false);
            this.setBackground(null);
        }
        this.setBorder(null);
        this.setFont(this.controller.getDefaultFont());
        IdentifiedObject term = (IdentifiedObject)value;
        String text = term.toString();
        if (TermUtil.isObsolete(term)) {
            this.setForeground(Color.red);
        } else {
            this.setForeground(Color.black);
        }
        this.setText(text);
        return this;
    }

    protected Font getFont(ObjectRenderSpec spec) {
        String hashval;
        Font font;
        String fontName = this.controller.getDefaultFont().getFontName();
        int size = this.controller.getDefaultFont().getSize();
        int style = 0;
        if (spec.getBold() && spec.getItalic()) {
            style = 3;
        } else if (spec.getBold()) {
            style = 1;
        } else if (spec.getItalic()) {
            style = 2;
        }
        if (spec.getFontName() != null) {
            fontName = spec.getFontName();
        }
        if (spec.getFontSize() > 0) {
            size = spec.getFontSize();
        }
        if ((font = (Font)fontHash.get(hashval = fontName + "-" + size + "-" + style)) == null) {
            font = new Font(fontName, style, size);
            fontHash.put(hashval, font);
        }
        return font;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        boolean highlighted = false;
        boolean clickTarget = false;
        boolean tabRow = false;
        boolean ignoreSelection = false;
        if (tree instanceof OBOTermPanel) {
            OBOTermPanel ot = (OBOTermPanel)tree;
            highlighted = row == ot.getHighlightRow();
            clickTarget = row == ot.getClickTarget();
            tabRow = row == ot.getTabRow();
            ignoreSelection = ot.ignoreSelection();
        }
        return this.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, highlighted, clickTarget, tabRow, ignoreSelection, row, hasFocus);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, boolean highlighted, boolean clickTarget, boolean tabRow, boolean ignoreSelection, int row, boolean hasFocus) {
        TreePath path;
        this.multiIcon.clearIcons();
        if (value.equals(OBOSession.OBSOLETE)) {
            this.setText("Obsolete");
            this.setFont(this.controller.getDefaultFont());
            this.setForeground(Color.red);
            this.setBorder(null);
            this.setOpaque(false);
            this.setBackground(null);
            return this;
        }
        if (value.equals(OBOSession.TYPES)) {
            this.setText("Relations");
            this.setFont(this.controller.getDefaultFont());
            this.setForeground(Color.blue);
            this.setBorder(null);
            this.setOpaque(false);
            this.setBackground(null);
            return this;
        }
        if (value.equals(OBOSession.INSTANCES)) {
            this.setText("Instances");
            this.setFont(this.controller.getDefaultFont());
            this.setForeground(Color.green);
            this.setBorder(null);
            this.setOpaque(false);
            this.setBackground(null);
            return this;
        }
        if (value.equals(OBOSession.CLASSES)) {
            this.setText("Classes");
            this.setFont(this.controller.getDefaultFont());
            this.setForeground(Color.black);
            this.setBorder(null);
            this.setOpaque(false);
            this.setBackground(null);
            return this;
        }
        if (!(value instanceof Relationship)) {
            this.setText("Some unknown item " + value);
            return this;
        }
        this.objectSpec.clear();
        Relationship link = (Relationship)value;
        String text = link.getChild().getName();
        Icon icon = null;
        if (link.getType() != null) {
            icon = this.controller.getIconForRelationshipType(link.getType());
        }
        if (icon != null) {
            this.multiIcon.addIcon(icon);
        }
        if (link instanceof OBORestriction) {
            OBORestriction tr = (OBORestriction)link;
            if (!tr.isNecessarilyTrue() && tr.isInverseNecessarilyTrue()) {
                this.multiIcon.addIcon(this.nec_inv_icon);
            } else if (!tr.isNecessarilyTrue()) {
                this.multiIcon.addIcon(this.nec_icon);
            } else if (tr.isInverseNecessarilyTrue()) {
                this.multiIcon.addIcon(this.inv_icon);
            }
            if (tr.completes()) {
                this.multiIcon.addIcon(this.completes_icon);
            }
        }
        if ((path = tree.getPathForRow(row)) != null && TermUtil.pathIsCircular(path)) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
        if (highlighted) {
            this.setOpaque(true);
            this.setBackground(highlightColor);
        } else if (selected) {
            this.setOpaque(true);
            if (ignoreSelection) {
                this.setBackground(ignoreSelectionColor);
            } else if (link.getChild().equals(this.controller.getSubSelection())) {
                this.setBackground(Preferences.defaultSelectionColor());
            } else {
                this.setBackground(Preferences.lightSelectionColor());
            }
        } else {
            this.setOpaque(false);
            this.setBackground(null);
        }
        if (clickTarget) {
            this.setBorder(clickBorder);
        } else if (tabRow) {
            this.setBorder(tabBorder);
        } else {
            this.setBorder(null);
        }
        boolean didMerge = false;
        this.mergeRenderers(this.objectSpec, link.getChild(), Controller.getController().getGlobalTermRenderers());
        if (tree instanceof FilteredRenderable) {
            this.mergeRenderers(this.objectSpec, link.getChild(), ((FilteredRenderable)((Object)tree)).getRenderers());
        }
        Font font = this.getFont(this.objectSpec);
        this.setFont(font);
        Color color = Color.black;
        if (this.objectSpec.getForegroundColor() != null) {
            color = this.objectSpec.getForegroundColor();
        }
        this.setForeground(color);
        if (this.objectSpec.getUnderlined()) {
            this.setText("<html><u>" + text + "</u></html>");
        } else {
            this.setText(text);
        }
        return this;
    }
}

