/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.datamodel.impl;

import java.awt.Frame;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.geneontology.oboedit.datamodel.DanglingObject;
import org.geneontology.oboedit.datamodel.Explanation;
import org.geneontology.oboedit.datamodel.ExplanationType;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Instance;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkDatabase;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.OBOClass;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.oboedit.datamodel.OBORestriction;
import org.geneontology.oboedit.datamodel.ReasonedLinkDatabase;
import org.geneontology.oboedit.datamodel.Relationship;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.impl.CompletenessExplanation;
import org.geneontology.oboedit.datamodel.impl.CompletenessMatch;
import org.geneontology.oboedit.datamodel.impl.LinkExplanation;
import org.geneontology.oboedit.datamodel.impl.OBORestrictionImpl;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.util.ProgressEvent;
import org.geneontology.util.ProgressListener;
import org.geneontology.util.ReusableProgressEvent;
import org.geneontology.util.TinySet;

public class PushAndBubbleReasoner
implements ReasonedLinkDatabase {
    private static final long serialVersionUID = -5046369728943561325L;
    protected LinkDatabase linkDatabase;
    protected Collection progressListeners = new LinkedList();
    protected Map childMap = new LinkedHashMap();
    protected Map parentMap = new LinkedHashMap();
    protected Map completeDefs = new LinkedHashMap();
    protected Map explanationMap = new HashMap();
    protected Map explanationDeps = new HashMap();
    protected ReusableProgressEvent progressEvent = new ReusableProgressEvent((Object)this);
    private OBORestrictionImpl lookupRel = new OBORestrictionImpl((LinkedObject)null);
    boolean debugMode = false;
    protected int newLinks = 0;
    protected OBORestriction tempLink = new OBORestrictionImpl((LinkedObject)null, null, (LinkedObject)null);
    protected ProgressRunnable progressRunnable = new ProgressRunnable();

    public void addActionListener(ActionListener listener) {
    }

    public void removeActionListener(ActionListener listener) {
    }

    protected Link findLink(LinkedObject child, OBOProperty type, LinkedObject parent) {
        return this.findLink(child, type, parent, false);
    }

    protected Link findLink(LinkedObject child, OBOProperty type, LinkedObject parent, boolean completes) {
        this.lookupRel.setChild(child);
        this.lookupRel.setType(type);
        this.lookupRel.setParent(parent);
        this.lookupRel.setCompletes(completes);
        Map parents = (Map)this.parentMap.get(child);
        if (parents == null) {
            return null;
        }
        Link out = (Link)parents.get(this.lookupRel);
        return (Link)parents.get(this.lookupRel);
    }

    protected Link findLink(Link link) {
        Map parents = (Map)this.parentMap.get(link.getChild());
        if (parents == null) {
            return null;
        }
        return (Link)parents.get(link);
    }

    protected Link findOrCreateLink(LinkedObject child, OBOProperty type, LinkedObject parent) {
        Link out = this.findLink(child, type, parent);
        if (out == null) {
            out = new OBORestrictionImpl(child, type, parent, true, null);
        }
        return out;
    }

    protected void internalAddLink(Link link) {
        ++this.newLinks;
        LinkedHashMap<Link, Link> children = (LinkedHashMap<Link, Link>)this.childMap.get(link.getParent());
        if (children == null) {
            children = new LinkedHashMap<Link, Link>();
            this.childMap.put(link.getParent(), children);
        }
        children.put(link, link);
        LinkedHashMap<Link, Link> parents = (LinkedHashMap<Link, Link>)this.parentMap.get(link.getChild());
        if (parents == null) {
            parents = new LinkedHashMap<Link, Link>();
            this.parentMap.put(link.getChild(), parents);
        }
        parents.put(link, link);
    }

    protected void internalRemoveLink(Link link) {
        Set completeParents;
        Map parents;
        Map children = (Map)this.childMap.get(link.getParent());
        if (children != null) {
            children.remove(link);
        }
        if ((parents = (Map)this.parentMap.get(link.getChild())) != null) {
            parents.remove(link);
        }
        if (link instanceof OBORestriction && ((OBORestriction)link).completes() && (completeParents = (Set)this.completeDefs.get(link.getChild())) != null) {
            completeParents.remove(link);
            if (completeParents.size() == 0) {
                this.completeDefs.remove(link.getChild());
            }
        }
    }

    public void setLinkDatabase(LinkDatabase linkDatabase) {
        this.linkDatabase = linkDatabase;
    }

    public LinkDatabase getLinkDatabase() {
        return this.linkDatabase;
    }

    public Collection getObjects() {
        return this.linkDatabase.getObjects();
    }

    public Collection getChildren(LinkedObject lo) {
        Map children = (Map)this.childMap.get(lo);
        if (children == null) {
            return Collections.EMPTY_SET;
        }
        return children.keySet();
    }

    public Collection getParents(LinkedObject lo) {
        Map parents = (Map)this.parentMap.get(lo);
        if (parents == null) {
            return Collections.EMPTY_SET;
        }
        return parents.keySet();
    }

    public boolean isSubclass(LinkedObject a, LinkedObject b) {
        if (a.equals(b)) {
            return true;
        }
        Iterator it = this.getParents(a).iterator();
        while (it.hasNext()) {
            Link link = (Link)it.next();
            if (!link.getType().equals(OBOProperty.IS_A) || !link.getParent().equals(b)) continue;
            return true;
        }
        return false;
    }

    public boolean hasTransitiveRelationship(LinkedObject a, OBOProperty b, LinkedObject c) {
        Iterator it = this.getParents(a).iterator();
        while (it.hasNext()) {
            Link link = (Link)it.next();
            if (!this.isSubProperty(link.getType(), b) || !link.getParent().equals(c)) continue;
            return true;
        }
        return false;
    }

    public Set getParentsOfType(LinkedObject a, OBOProperty b) {
        TinySet out = new TinySet();
        Iterator it = this.getParents(a).iterator();
        while (it.hasNext()) {
            Link link = (Link)it.next();
            if (!this.isSubProperty(link.getType(), b)) continue;
            out.add(link.getParent());
        }
        return out;
    }

    public boolean isInstance(Instance a, OBOClass b) {
        return false;
    }

    public boolean isSubProperty(OBOProperty a, OBOProperty b) {
        return this.isSubclass(a, b);
    }

    public boolean isSubclass(OBOClass a, OBOClass b) {
        return this.isSubclass((LinkedObject)a, (LinkedObject)b);
    }

    public boolean isRedundant(Link link) {
        if (link instanceof OBORestriction && ((OBORestriction)link).completes()) {
            return false;
        }
        Collection exps = this.getExplanations(link);
        if (exps.size() == 1) {
            return false;
        }
        Iterator it2 = exps.iterator();
        boolean hasGiven = false;
        boolean nonGenus = false;
        int i = 0;
        while (it2.hasNext()) {
            Explanation exp = (Explanation)it2.next();
            if (exp.getExplanationType().equals(ExplanationType.GIVEN)) {
                hasGiven = true;
            } else if (!exp.getExplanationType().equals(ExplanationType.GENUS)) {
                nonGenus = true;
            }
            if (hasGiven && nonGenus) break;
            ++i;
        }
        return hasGiven && nonGenus;
    }

    public void addLink(Link link) {
        if (link instanceof OBORestriction && ((OBORestriction)link).completes()) {
            LinkedList<Explanation> completeExplanations = new LinkedList<Explanation>();
            Iterator it = this.getChildren(link.getChild()).iterator();
            while (it.hasNext()) {
                Link childLink = (Link)it.next();
                Collection explanations = this.getExplanations(childLink);
                Iterator it2 = explanations.iterator();
                while (it2.hasNext()) {
                    Explanation exp = (Explanation)it2.next();
                    if (!exp.getExplanationType().equals(ExplanationType.COMPLETENESS)) continue;
                    completeExplanations.add(exp);
                }
            }
            it = completeExplanations.iterator();
            while (it.hasNext()) {
                LinkExplanation exp = (LinkExplanation)it.next();
                this.reasonRemoval(exp);
            }
        } else {
            this.internalAddLink(link);
            this.explain(link, Explanation.GIVEN_EXPLANATION);
            this.pushNewLink(link);
        }
        this.doCompleteChecks();
        this.debugMode = false;
    }

    public void removeLink(Link link) {
        this.reasonRemoval(link, Explanation.GIVEN_EXPLANATION);
        this.doCompleteChecks();
    }

    protected void reasonRemoval(LinkExplanation exp) {
        this.reasonRemoval(exp.getExplainedLink(), exp);
    }

    protected void reasonRemoval(Link link, Explanation exp) {
        Collection explanations = this.getExplanations(link);
        explanations.remove(exp);
        Set s = (Set)this.explanationDeps.get(link);
        if (s != null) {
            Explanation texp;
            LinkedList<Explanation> completeExps = new LinkedList<Explanation>();
            Iterator it2 = s.iterator();
            while (it2.hasNext()) {
                texp = (Explanation)it2.next();
                if (!texp.getExplanationType().equals(ExplanationType.COMPLETENESS)) continue;
                completeExps.add(texp);
            }
            it2 = completeExps.iterator();
            while (it2.hasNext()) {
                texp = (LinkExplanation)it2.next();
                this.reasonRemoval((LinkExplanation)texp);
            }
        }
        if (explanations.size() == 0) {
            this.internalRemoveLink(link);
            s = (Set)this.explanationDeps.get(link);
            if (s == null) {
                return;
            }
            this.explanationDeps.remove(link);
            Iterator it = s.iterator();
            while (it.hasNext()) {
                Explanation explanation = (Explanation)it.next();
                if (explanation instanceof LinkExplanation) {
                    LinkExplanation linkExplanation = (LinkExplanation)explanation;
                    this.reasonRemoval(linkExplanation.getExplainedLink(), explanation);
                    continue;
                }
                System.err.println("!!!!!!!!!!! FOUND GIVEN EXPLANATION IN LINK DEPS");
            }
        }
    }

    public long recache() {
        long time = System.currentTimeMillis();
        JDialog guiDialog = null;
        ProgressListener listener = null;
        if (Controller.getController() != null) {
            final JProgressBar progressBar = new JProgressBar();
            progressBar.setStringPainted(true);
            progressBar.setFont(Controller.getController().getDefaultFont());
            listener = new ProgressListener(){

                public void progressMade(final ProgressEvent e) {
                    final int val = e.getValue().intValue();
                    Runnable r = new Runnable(){

                        public void run() {
                            progressBar.setValue(val);
                            progressBar.setString(e.getDescription());
                        }
                    };
                    SwingUtilities.invokeLater(r);
                }
            };
            final JDialog finalGUI = guiDialog = new JDialog((Frame)null, "", false);
            this.addProgressListener(listener);
            Runnable r = new Runnable(){

                public void run() {
                    JPanel panel = new JPanel();
                    panel.setLayout(new BoxLayout(panel, 1));
                    panel.add(Box.createVerticalGlue());
                    panel.add(progressBar);
                    panel.add(Box.createVerticalGlue());
                    finalGUI.setContentPane(panel);
                    finalGUI.pack();
                    finalGUI.setVisible(true);
                }
            };
            SwingUtilities.invokeLater(r);
        }
        this.childMap.clear();
        this.parentMap.clear();
        this.completeDefs.clear();
        this.explanationMap.clear();
        this.newLinks = 0;
        LinkedList<IdentifiedObject> classes = new LinkedList<IdentifiedObject>();
        LinkedList<IdentifiedObject> properties = new LinkedList<IdentifiedObject>();
        int objCount = TermUtil.getObjectCount(this.linkDatabase);
        Iterator<Object> it = this.linkDatabase.getObjects().iterator();
        int i = 0;
        while (it.hasNext()) {
            IdentifiedObject io = (IdentifiedObject)it.next();
            if (io instanceof OBOProperty) {
                properties.add(io);
            } else if (io instanceof OBOClass) {
                classes.add(io);
            }
            if (io instanceof LinkedObject) {
                LinkedObject lo = (LinkedObject)io;
                Iterator it2 = this.linkDatabase.getParents(lo).iterator();
                while (it2.hasNext()) {
                    Relationship rel = (Relationship)it2.next();
                    if (!(rel instanceof Link)) continue;
                    Link link = (Link)rel;
                    if (!TermUtil.isIntersection(link)) {
                        this.internalAddLink(link);
                        this.explain(link, Explanation.GIVEN_EXPLANATION);
                        continue;
                    }
                    Set completeParents = (Set)this.completeDefs.get(link.getChild());
                    if (completeParents == null) {
                        completeParents = new TinySet();
                        this.completeDefs.put(link.getChild(), completeParents);
                    }
                    completeParents.add(link);
                }
            }
            this.showProgress(100 * i / objCount, "Initializing database...");
            ++i;
        }
        it = this.completeDefs.keySet().iterator();
        block2: while (it.hasNext()) {
            LinkedObject lo = (LinkedObject)it.next();
            Collection parents = (Collection)this.completeDefs.get(lo);
            Iterator it2 = parents.iterator();
            while (it2.hasNext()) {
                Link link = (Link)it2.next();
                if (!(link.getParent() instanceof DanglingObject)) continue;
                it.remove();
                continue block2;
            }
        }
        this.showProgress(0, "Discovering genus/diff implications...");
        this.doGenusDifferentiaImplications();
        this.showProgress(0, "Calculating transitive closure: properties...");
        this.doTransitiveClosure(properties);
        this.showProgress(0, "Calculating transitive closure: classes...");
        this.doTransitiveClosure(classes);
        this.doCompleteChecks();
        if (Controller.getController() != null) {
            this.removeProgressListener(listener);
            final JDialog finalGUI = guiDialog;
            Runnable r = new Runnable(){

                public void run() {
                    finalGUI.dispose();
                }
            };
            SwingUtilities.invokeLater(r);
        }
        return System.currentTimeMillis() - time;
    }

    protected void doGenusDifferentiaImplications() {
        Iterator it = this.completeDefs.keySet().iterator();
        while (it.hasNext()) {
            LinkedObject lo = (LinkedObject)it.next();
            Collection c = (Collection)this.completeDefs.get(lo);
            Iterator it2 = c.iterator();
            while (it2.hasNext()) {
                LinkExplanation explanation;
                Link link;
                OBORestriction or = (OBORestriction)it2.next();
                if (this.isSubclass(or.getType(), OBOProperty.IS_A)) {
                    link = this.findOrCreateLink(or.getChild(), OBOProperty.IS_A, or.getParent());
                    this.internalAddLink(link);
                    explanation = new GenusExplanation(or);
                    this.explain(link, explanation);
                    continue;
                }
                link = this.findOrCreateLink(or.getChild(), or.getType(), or.getParent());
                this.internalAddLink(link);
                explanation = new DifferentiaExplanation(or);
                this.explain(link, explanation);
            }
        }
    }

    protected void doCompleteChecks() {
        int index = 1;
        do {
            this.newLinks = 0;
            this.showProgress(-1, "Calculating completeness: pass " + index + "...");
            this.checkCompleteDefs();
            ++index;
        } while (this.newLinks > 0);
    }

    protected void checkCompleteDefs() {
        Iterator it = this.completeDefs.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            LinkedObject candidate;
            Link completeLink;
            LinkedHashMap<LinkedObject, Set> candidates = new LinkedHashMap<LinkedObject, Set>();
            this.showProgress(i * 100 / this.completeDefs.keySet().size());
            LinkedObject lo = (LinkedObject)it.next();
            LinkedObject genus = null;
            LinkedList completeLinks = new LinkedList();
            completeLinks.addAll((Collection)this.completeDefs.get(lo));
            Link starterLink = null;
            int minSetSize = Integer.MAX_VALUE;
            Iterator<Object> it2 = completeLinks.iterator();
            while (it2.hasNext()) {
                int childCount;
                completeLink = (Link)it2.next();
                if (this.isSubclass(completeLink.getType(), OBOProperty.IS_A)) {
                    genus = completeLink.getParent();
                }
                if ((childCount = TermUtil.getChildCount(this, completeLink.getParent())) >= minSetSize) continue;
                starterLink = completeLink;
                minSetSize = childCount;
            }
            completeLinks.remove(starterLink);
            if (starterLink == null) {
                System.err.println("UNEXPECTED CONDITION: EMPTY COMPLETE DEF!");
            } else {
                completeLink = starterLink;
                Iterator it3 = this.getChildren(completeLink.getParent()).iterator();
                while (it3.hasNext()) {
                    Link candidateLink = (Link)it3.next();
                    if (candidateLink.getChild().equals(lo) || this.findLink(candidateLink.getChild(), completeLink.getType(), completeLink.getParent()) == null) continue;
                    Set evidence = (Set)candidates.get(candidateLink.getChild());
                    if (evidence == null) {
                        evidence = new TinySet();
                        candidates.put(candidateLink.getChild(), evidence);
                    }
                    evidence.add(new CompletenessMatch(candidateLink, completeLink));
                }
            }
            it2 = candidates.keySet().iterator();
            block3: while (it2.hasNext()) {
                candidate = (LinkedObject)it2.next();
                Iterator it3 = completeLinks.iterator();
                while (it3.hasNext()) {
                    Link completeLink2 = (Link)it3.next();
                    Link candidateLink = this.findLink(candidate, completeLink2.getType(), completeLink2.getParent());
                    if (candidateLink != null) {
                        Set evidence = (Set)candidates.get(candidate);
                        if (evidence == null) {
                            evidence = new TinySet();
                            candidates.put(candidate, evidence);
                        }
                        evidence.add(new CompletenessMatch(candidateLink, completeLink2));
                        continue;
                    }
                    it2.remove();
                    continue block3;
                }
            }
            it2 = candidates.keySet().iterator();
            while (it2.hasNext()) {
                candidate = (LinkedObject)it2.next();
                Collection matches = (Collection)candidates.get(candidate);
                LinkedObject matchParent = null;
                CompletenessExplanation exp = new CompletenessExplanation();
                Iterator it3 = matches.iterator();
                while (it3.hasNext()) {
                    CompletenessMatch cm = (CompletenessMatch)it3.next();
                    matchParent = cm.getCompletenessLink().getChild();
                    exp.addMatch(cm);
                }
                LinkedObject candidateGenus = this.getGenus(candidate);
                if (candidateGenus != null && matchParent.equals(candidateGenus)) {
                    System.err.println("%%%%% CUT REDUNDANT COMPLETENESS EXPLANATION FOR " + candidate);
                    continue;
                }
                Link newRel = this.findOrCreateLink(candidate, OBOProperty.IS_A, matchParent);
                if (this.findLink(newRel) == null) {
                    this.internalAddLink(newRel);
                    this.pushNewLink(newRel);
                }
                this.explain(newRel, exp);
            }
            ++i;
        }
    }

    public LinkedObject getGenus(LinkedObject candidate) {
        Iterator it = candidate.getParents().iterator();
        while (it.hasNext()) {
            Link link = (Link)it.next();
            if (!TermUtil.isIntersection(link) || !this.isSubclass(link.getType(), OBOProperty.IS_A)) continue;
            return link.getParent();
        }
        return null;
    }

    protected void cacheAllParents(LinkedObject lo, Collection cached) {
        if (cached.contains(lo)) {
            return;
        }
        cached.add(lo);
        Iterator it = this.getParents(lo).iterator();
        while (it.hasNext()) {
            Link link = (Link)it.next();
            this.cacheAllParents(link.getParent(), cached);
        }
        LinkedList temp = new LinkedList();
        temp.addAll(this.getParents(lo));
        it = temp.iterator();
        while (it.hasNext()) {
            Link link = (Link)it.next();
            Iterator it2 = this.getParents(link.getParent()).iterator();
            while (it2.hasNext()) {
                Link gpLink = (Link)it2.next();
                Link newRel = this.reasonLink(link, gpLink);
                if (newRel == null || newRel.getParent().equals(newRel.getChild()) && this.isSubProperty(newRel.getType(), OBOProperty.IS_A)) continue;
                if (this.findLink(newRel) == null) {
                    this.internalAddLink(newRel);
                }
                TransitivityExplanation explanation = new TransitivityExplanation(link, gpLink);
                this.explain(newRel, explanation);
            }
        }
    }

    protected Link reasonLink(Link link, Link gpLink) {
        Link newRel = null;
        if (TermUtil.generateTransitiveImplication(this, this.tempLink, link, gpLink)) {
            newRel = this.findOrCreateLink(this.tempLink.getChild(), this.tempLink.getType(), this.tempLink.getParent());
        }
        return newRel;
    }

    protected void doTransitiveClosure(Collection objects) {
        HashSet seenem = new HashSet();
        Iterator it = objects.iterator();
        int i = 0;
        while (it.hasNext()) {
            LinkedObject lo = (LinkedObject)it.next();
            this.cacheAllParents(lo, seenem);
            this.showProgress(100 * i / objects.size());
            ++i;
        }
    }

    public void pushLinksDown(Collection links, Link throughLink) {
        Iterator it = links.iterator();
        while (it.hasNext()) {
            OBORestriction newRel;
            Link link = (Link)it.next();
            if (link.equals(throughLink) || (newRel = (OBORestriction)this.reasonLink(throughLink, link)) == null) continue;
            if (this.findLink(newRel) == null) {
                this.internalAddLink(newRel);
            }
            TransitivityExplanation explanation = new TransitivityExplanation(throughLink, link);
            this.explain(newRel, explanation);
            this.pushLink(newRel, new HashSet());
        }
    }

    protected void pushNewLink(Link link) {
        this.pushLink(link, new HashSet());
        LinkedList parents = new LinkedList();
        parents.addAll(this.getParents(link.getParent()));
        this.pushLinksDown(parents, link);
    }

    public void pushLink(Link link, Collection seenem) {
        if (seenem.contains(link)) {
            return;
        }
        seenem.add(link);
        LinkedObject target = link.getChild();
        LinkedList children = new LinkedList();
        children.addAll(this.getChildren(target));
        Iterator it = children.iterator();
        while (it.hasNext()) {
            boolean foundLink;
            Link childLink = (Link)it.next();
            OBORestriction newRel = (OBORestriction)this.reasonLink(childLink, link);
            if (newRel == null) continue;
            boolean bl = foundLink = this.findLink(newRel) != null;
            if (!foundLink) {
                this.internalAddLink(newRel);
            }
            TransitivityExplanation explanation = new TransitivityExplanation(childLink, link);
            this.explain(newRel, explanation);
            if (foundLink) continue;
            this.pushLink(newRel, seenem);
        }
    }

    public Collection getExplanations(Link link) {
        Set explanations = (Set)this.explanationMap.get(link);
        if (explanations == null) {
            return Collections.EMPTY_SET;
        }
        return explanations;
    }

    public Collection getAllSupportingLinks(Link link) {
        TinySet set = new TinySet();
        this.fillAllSupportingLinks(link, (Set)set, new HashSet());
        return set;
    }

    protected void fillAllSupportingLinks(Link link, Set set, Set lookedAt) {
        if (lookedAt.contains(link)) {
            return;
        }
        lookedAt.add(link);
        Set explanations = (Set)this.explanationMap.get(link);
        if (explanations == null) {
            return;
        }
        Iterator it = explanations.iterator();
        while (it.hasNext()) {
            Explanation e = (Explanation)it.next();
            if (!(e instanceof LinkExplanation)) continue;
            LinkExplanation le = (LinkExplanation)e;
            Iterator it2 = le.getSupportingLinks().iterator();
            while (it2.hasNext()) {
                Link supportingLink = (Link)it2.next();
                set.add(supportingLink);
                this.fillAllSupportingLinks(supportingLink, set, lookedAt);
            }
        }
    }

    protected void explain(Link link, Explanation explanation) {
        Set explanations = (Set)this.explanationMap.get(link);
        if (explanations == null) {
            explanations = new TinySet();
            this.explanationMap.put(link, explanations);
        }
        explanations.add(explanation);
        if (explanation instanceof LinkExplanation) {
            LinkExplanation linkExplanation = (LinkExplanation)explanation;
            linkExplanation.setExplainedLink(link);
            Collection deps = linkExplanation.getSupportingLinks();
            if (deps != null) {
                Iterator it2 = deps.iterator();
                while (it2.hasNext()) {
                    Link depLink = (Link)it2.next();
                    Collection s = (Collection)this.explanationDeps.get(depLink);
                    if (s == null) {
                        s = new TinySet();
                        this.explanationDeps.put(depLink, s);
                    }
                    s.add(explanation);
                }
            }
        }
    }

    protected void fireProgressEvent(ProgressEvent event) {
        Iterator it = this.progressListeners.iterator();
        while (it.hasNext()) {
            ProgressListener progressListener = (ProgressListener)it.next();
            this.progressRunnable.set(progressListener, event);
            SwingUtilities.invokeLater(this.progressRunnable);
        }
    }

    protected void showProgress(int percent, String message) {
        this.progressEvent.setDescription(message);
        this.progressEvent.setFastVal(percent);
        this.fireProgressEvent((ProgressEvent)this.progressEvent);
    }

    protected void showProgress(int percent) {
        this.progressEvent.setFastVal(percent);
        this.fireProgressEvent((ProgressEvent)this.progressEvent);
    }

    public void addProgressListener(ProgressListener listener) {
        this.progressListeners.add(listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        this.progressListeners.remove(listener);
    }

    public IdentifiedObject getObject(String id) {
        return this.linkDatabase.getObject(id);
    }

    protected class ProgressRunnable
    implements Runnable {
        protected ProgressEvent e;
        protected ProgressListener listener;

        protected ProgressRunnable() {
        }

        public void set(ProgressListener listener, ProgressEvent e) {
            this.e = e;
            this.listener = listener;
        }

        public void run() {
            this.listener.progressMade(this.e);
        }
    }

    public class TransitivityExplanation
    extends LinkExplanation {
        private static final long serialVersionUID = -4952593548062292144L;
        protected Link directLink;
        protected Link extensionLink;

        public TransitivityExplanation(Link directLink, Link extensionLink) {
            this.directLink = directLink;
            this.extensionLink = extensionLink;
            this.supportingLinks.add(directLink);
            this.supportingLinks.add(extensionLink);
        }

        public ExplanationType getExplanationType() {
            return ExplanationType.TRANSITIVITY;
        }

        public String toString() {
            return "TRANSITIVITY: " + this.explainedLink + " from " + this.extensionLink + " over " + this.directLink;
        }
    }

    public class DifferentiaExplanation
    extends LinkExplanation {
        private static final long serialVersionUID = 6029631779179877969L;
        protected Link link;

        public DifferentiaExplanation(Link link) {
            this.link = link;
            this.supportingLinks.add(link);
        }

        public ExplanationType getExplanationType() {
            return ExplanationType.DIFFERENTIA;
        }

        public String toString() {
            return "DIFFERENTIA: from intersection link " + this.link;
        }
    }

    public class GenusExplanation
    extends LinkExplanation {
        private static final long serialVersionUID = -795084980001820300L;
        protected Link link;

        public GenusExplanation(Link link) {
            this.link = link;
            this.supportingLinks.add(link);
        }

        public ExplanationType getExplanationType() {
            return ExplanationType.GENUS;
        }

        public String toString() {
            return "GENUS: from intersection link " + this.link;
        }
    }
}

