/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.datamodel.impl;

import java.util.Collection;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkDatabase;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.gui.filters.Filter;
import org.geneontology.oboedit.gui.filters.FilterPair;
import org.geneontology.util.Subset;
import org.geneontology.util.VectorFilter;

public class FilteredLinkDatabase
implements LinkDatabase {
    private static final long serialVersionUID = 8789956339731954652L;
    protected Filter termFilter;
    protected Filter linkFilter;
    protected LinkDatabase linkDatabase;
    protected boolean allowDangling = false;
    protected final VectorFilter childFilter = new VectorFilter(){
        private static final long serialVersionUID = -4341033786269422197L;

        public boolean satisfies(Object o) {
            if (o instanceof Link) {
                return FilteredLinkDatabase.this.satisfiesChild((Link)o);
            }
            return false;
        }
    };
    protected final VectorFilter parentFilter = new VectorFilter(){
        private static final long serialVersionUID = 8146325578230708703L;

        public boolean satisfies(Object o) {
            if (o instanceof Link) {
                return FilteredLinkDatabase.this.satisfiesParent((Link)o);
            }
            return false;
        }
    };
    protected Subset reusableSet;
    public static final int LOCAL_CACHE = 0;
    public static final int REUSABLE_ITERATOR = 4;
    protected int filterMethod;
    protected Subset reusableSubset = new Subset();

    public FilteredLinkDatabase(LinkDatabase linkDatabase) {
        this.setFilterMethod(0);
        this.linkDatabase = linkDatabase;
    }

    public void setAllowDangling(boolean allowDangling) {
        this.allowDangling = allowDangling;
    }

    public boolean getAllowDangling() {
        return this.allowDangling;
    }

    protected boolean isPassThrough() {
        return this.linkFilter == null && this.termFilter == null;
    }

    public void setFilterMethod(int filterMethod) {
        this.reusableSet = filterMethod == 4 ? new Subset() : null;
        this.filterMethod = filterMethod;
    }

    public Collection getChildren(LinkedObject lo) {
        if (this.isPassThrough()) {
            return this.linkDatabase.getChildren(lo);
        }
        if (this.filterMethod == 0) {
            return new Subset(this.childFilter, this.linkDatabase.getChildren(lo));
        }
        if (this.filterMethod == 4) {
            this.reusableSubset.setFilter(this.childFilter);
            this.reusableSubset.setData(this.linkDatabase.getChildren(lo));
            return this.reusableSubset;
        }
        return null;
    }

    public Collection getParents(LinkedObject lo) {
        if (this.isPassThrough()) {
            return this.linkDatabase.getParents(lo);
        }
        if (this.filterMethod == 0) {
            return new Subset(this.parentFilter, this.linkDatabase.getParents(lo));
        }
        if (this.filterMethod == 4) {
            this.reusableSubset.setFilter(this.parentFilter);
            this.reusableSubset.setData(this.linkDatabase.getParents(lo));
            return this.reusableSubset;
        }
        return null;
    }

    public Collection getObjects() {
        if (this.termFilter == null) {
            return this.linkDatabase.getObjects();
        }
        return new Subset((VectorFilter)this.termFilter, this.linkDatabase.getObjects());
    }

    protected boolean satisfiesChild(Link link) {
        if (this.linkFilter == null) {
            return this.allowDangling || this.satisfies(link.getChild());
        }
        return this.linkFilter.satisfies(link) && (this.allowDangling || this.satisfies(link.getChild()));
    }

    protected boolean satisfiesParent(Link link) {
        if (this.linkFilter == null) {
            return this.satisfies(link.getChild()) && (this.allowDangling || this.satisfies(link.getParent()));
        }
        return this.linkFilter.satisfies(link) && (this.allowDangling || this.satisfies(link.getParent()));
    }

    protected boolean satisfies(LinkedObject lo) {
        return this.termFilter == null || this.termFilter.satisfies(lo);
    }

    public void setFilterPair(FilterPair filterPair) {
        if (filterPair != null) {
            this.setTermFilter(filterPair.getObjectFilter());
            this.setLinkFilter(filterPair.getLinkFilter());
        }
    }

    public void setTermFilter(Filter termFilter, Filter linkFilter) {
        this.termFilter = termFilter;
        this.linkFilter = linkFilter;
    }

    public void setLinkFilter(Filter linkFilter) {
        this.linkFilter = linkFilter;
    }

    public void setTermFilter(Filter termFilter) {
        this.termFilter = termFilter;
    }

    public IdentifiedObject getObject(String id) {
        IdentifiedObject out = this.linkDatabase.getObject(id);
        if (this.termFilter == null || this.termFilter.satisfies(out)) {
            return out;
        }
        return null;
    }
}

