/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.datamodel.impl;

import org.geneontology.oboedit.datamodel.Dbxref;
import org.geneontology.oboedit.datamodel.NestedValue;
import org.geneontology.oboedit.datamodel.Synonym;
import org.geneontology.util.ObjectUtil;

public class DbxrefImpl
implements Dbxref {
    private static final long serialVersionUID = 7781970775816178223L;
    protected String id;
    protected String database;
    protected String desc;
    protected int type;
    protected Synonym targetSynonym;
    protected NestedValue nestedValue;

    public DbxrefImpl() {
        this(null, null);
    }

    public DbxrefImpl(String database, String id) {
        this(database, id, null, 3, null);
    }

    public DbxrefImpl(String database, String id, int type) {
        this(database, id, null, type, null);
    }

    public void setNestedValue(NestedValue nestedValue) {
        this.nestedValue = nestedValue;
    }

    public NestedValue getNestedValue() {
        return this.nestedValue;
    }

    public static String getTypeStringFromInt(int type) {
        if (type == 0) {
            return "anatomical";
        }
        if (type == 1) {
            return "synonym";
        }
        if (type == 2) {
            return "definition";
        }
        if (type == 3) {
            return "analog";
        }
        return null;
    }

    public DbxrefImpl(String database, String id, String desc, int type) {
        this(database, id, desc, type, null);
    }

    public DbxrefImpl(String database, String id, String desc, int type, Synonym targetSynonym) {
        this.id = id;
        this.database = database;
        this.type = type;
        this.desc = desc;
        this.targetSynonym = targetSynonym;
    }

    public boolean isDefRef() {
        return this.type == 2;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void setSynonym(Synonym syn) {
        this.targetSynonym = syn;
    }

    public Synonym getSynonym() {
        return this.targetSynonym;
    }

    public String getID() {
        return this.id;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setID(String id) {
        this.id = id;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String toString() {
        if (this.desc == null || this.desc.length() == 0) {
            return this.database + ":" + this.id;
        }
        return this.desc + " (" + this.database + ":" + this.id + ")";
    }

    public int compareTo(Object o) {
        return COMPARATOR.compare(this, o);
    }

    public boolean equals(Object in) {
        if (in instanceof Dbxref) {
            return ((Dbxref)in).getDatabase().equals(this.database) && ((Dbxref)in).getID().equals(this.id) && ((Dbxref)in).getType() == this.type && ObjectUtil.equals((Object)((Dbxref)in).getSynonym(), (Object)this.targetSynonym) && ObjectUtil.equals((Object)((Dbxref)in).getDesc(), (Object)this.desc);
        }
        return false;
    }

    public int hashCode() {
        return (this.database + ":" + this.id + "|" + this.type + "|" + this.targetSynonym + "|" + this.desc).hashCode();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

