/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.datamodel.history;

import java.util.Iterator;
import java.util.Vector;
import org.geneontology.oboedit.datamodel.Dbxref;
import org.geneontology.oboedit.datamodel.HistoryItem;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.OBOClass;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.datamodel.OperationWarning;
import org.geneontology.oboedit.datamodel.Synonym;
import org.geneontology.oboedit.datamodel.history.AddDbxrefHistoryItem;
import org.geneontology.oboedit.datamodel.history.AddSynonymHistoryItem;
import org.geneontology.oboedit.datamodel.history.ChangeSynCategoryHistoryItem;
import org.geneontology.oboedit.datamodel.history.ChangeSynScopeHistoryItem;
import org.geneontology.oboedit.datamodel.history.CreateObjectHistoryItem;
import org.geneontology.oboedit.datamodel.history.NameChangeHistoryItem;
import org.geneontology.oboedit.datamodel.history.SubclassedMacroHistoryItem;
import org.geneontology.oboedit.datamodel.history.TermCopyHistoryItem;
import org.geneontology.util.ObjectUtil;

public class TermSplitHistoryItem
extends SubclassedMacroHistoryItem {
    private static final long serialVersionUID = -3983637863915469299L;
    protected String result;
    protected boolean addType;

    public TermSplitHistoryItem() {
        this((String)null, null, false);
    }

    public TermSplitHistoryItem(OBOClass target, String result, boolean addType) {
        this(target.getID(), result, addType);
    }

    public TermSplitHistoryItem(String target, String result, boolean addType) {
        super("split");
        this.setTarget(target);
        this.result = result;
        this.type = 2;
        this.addType = addType;
    }

    public int hashCode() {
        return TermSplitHistoryItem.getHash(this.target) ^ TermSplitHistoryItem.getHash(this.result) ^ TermSplitHistoryItem.getHash(this.addType);
    }

    public boolean equals(Object o) {
        if (!(o instanceof TermSplitHistoryItem)) {
            return false;
        }
        TermSplitHistoryItem item = (TermSplitHistoryItem)o;
        return ObjectUtil.equals((Object)this.target, (Object)item.getTarget()) && ObjectUtil.equals((Object)this.result, (Object)item.getResult()) && this.addType == item.addType();
    }

    public void setResult(String result) {
        this.result = result;
    }

    public void setAddType(boolean addType) {
        this.addType = addType;
    }

    public boolean addType() {
        return this.addType;
    }

    public void addHistoryItem(HistoryItem item) {
    }

    public void removeHistoryItem(HistoryItem item) {
    }

    public void setHistoryItems(Vector v) {
    }

    public OperationWarning lock(OBOSession history) {
        this.historyItems = new Vector();
        OperationWarning ow = this.getItems(history, this.historyItems);
        OperationWarning ow2 = super.lock(history);
        if (ow == null) {
            return ow2;
        }
        if (ow2 != null) {
            ow.addWarning(ow2);
        }
        return ow;
    }

    protected OperationWarning getItems(OBOSession history, Vector out) {
        Link tr;
        OBOClass targetClass = (OBOClass)history.getObject(this.target);
        if (targetClass == null) {
            return new OperationWarning("Could not split with unrecognized target " + targetClass);
        }
        out.add(new CreateObjectHistoryItem(this.result, this.addType ? OBOClass.OBO_PROPERTY.getID() : OBOClass.OBO_CLASS.getID()));
        Iterator it = targetClass.getParents().iterator();
        while (it.hasNext()) {
            tr = (Link)it.next();
            LinkedObject parent = tr.getParent();
            out.add(new TermCopyHistoryItem(parent.getID(), this.result, tr.getType().getID()));
        }
        it = targetClass.getChildren().iterator();
        while (it.hasNext()) {
            tr = (Link)it.next();
            LinkedObject child = tr.getChild();
            out.add(new TermCopyHistoryItem(this.result, child.getID(), tr.getType().getID()));
        }
        out.add(new NameChangeHistoryItem("", targetClass.getName(), this.result));
        it = targetClass.getDbxrefs().iterator();
        while (it.hasNext()) {
            Dbxref ref = (Dbxref)it.next();
            out.add(new AddDbxrefHistoryItem(this.result, ref, false, null));
        }
        it = targetClass.getSynonyms().iterator();
        while (it.hasNext()) {
            Synonym syn = (Synonym)it.next();
            out.add(new AddSynonymHistoryItem(this.result, syn.getText()));
            if (syn.getSynonymCategory() != null) {
                out.add(new ChangeSynCategoryHistoryItem(this.result, syn.getText(), null, syn.getSynonymCategory().getID()));
            }
            if (syn.getScope() == 0) {
                out.add(new ChangeSynScopeHistoryItem(this.result, syn.getText(), 0, syn.getScope()));
            }
            Iterator it2 = syn.getDbxrefs().iterator();
            while (it2.hasNext()) {
                Dbxref ref = (Dbxref)it2.next();
                out.add(new AddDbxrefHistoryItem(this.result, ref, false, syn.getText()));
            }
        }
        return null;
    }

    public String getShortName() {
        return "split";
    }

    public String getResult() {
        return this.result;
    }

    public String toString() {
        return "Split " + this.target + " to create " + this.result;
    }
}

