/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.oboedit.dataadapter;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import org.geneontology.dataadapter.CancelledAdapterException;
import org.geneontology.dataadapter.DataAdapterException;
import org.geneontology.expression.JexlContext;
import org.geneontology.io.SafeFileOutputStream;
import org.geneontology.oboedit.dataadapter.DefaultIDGenerator;
import org.geneontology.oboedit.dataadapter.OBOConstants;
import org.geneontology.oboedit.dataadapter.OBOSerializer;
import org.geneontology.oboedit.datamodel.CategorizedObject;
import org.geneontology.oboedit.datamodel.CommentedObject;
import org.geneontology.oboedit.datamodel.DanglingObject;
import org.geneontology.oboedit.datamodel.Dbxref;
import org.geneontology.oboedit.datamodel.DbxrefedObject;
import org.geneontology.oboedit.datamodel.DefinedObject;
import org.geneontology.oboedit.datamodel.IDProfile;
import org.geneontology.oboedit.datamodel.IDRule;
import org.geneontology.oboedit.datamodel.IdentifiedObject;
import org.geneontology.oboedit.datamodel.Instance;
import org.geneontology.oboedit.datamodel.Link;
import org.geneontology.oboedit.datamodel.LinkDatabase;
import org.geneontology.oboedit.datamodel.LinkedObject;
import org.geneontology.oboedit.datamodel.MultiIDObject;
import org.geneontology.oboedit.datamodel.NestedValue;
import org.geneontology.oboedit.datamodel.OBOProperty;
import org.geneontology.oboedit.datamodel.OBORestriction;
import org.geneontology.oboedit.datamodel.OBOSession;
import org.geneontology.oboedit.datamodel.ObsoletableObject;
import org.geneontology.oboedit.datamodel.PropertyValue;
import org.geneontology.oboedit.datamodel.ReasonedLinkDatabase;
import org.geneontology.oboedit.datamodel.RootAlgorithm;
import org.geneontology.oboedit.datamodel.Synonym;
import org.geneontology.oboedit.datamodel.SynonymCategory;
import org.geneontology.oboedit.datamodel.SynonymedObject;
import org.geneontology.oboedit.datamodel.TermCategory;
import org.geneontology.oboedit.datamodel.TermUtil;
import org.geneontology.oboedit.datamodel.impl.DefaultLinkDatabase;
import org.geneontology.oboedit.datamodel.impl.FilteredLinkDatabase;
import org.geneontology.oboedit.datamodel.impl.FilteredReasonedLinkDatabase;
import org.geneontology.oboedit.datamodel.impl.NestedValueImpl;
import org.geneontology.oboedit.datamodel.impl.OBORestrictionImpl;
import org.geneontology.oboedit.datamodel.impl.PushAndBubbleReasoner;
import org.geneontology.oboedit.datamodel.impl.RootAlgorithmModeratedLinkDatabase;
import org.geneontology.oboedit.gui.Controller;
import org.geneontology.oboedit.gui.filters.CompoundFilter;
import org.geneontology.oboedit.gui.filters.CompoundFilterImpl;
import org.geneontology.oboedit.gui.filters.EqualsComparison;
import org.geneontology.oboedit.gui.filters.Filter;
import org.geneontology.oboedit.gui.filters.FilterPair;
import org.geneontology.oboedit.gui.filters.FilterPairImpl;
import org.geneontology.oboedit.gui.filters.IDSearchCriterion;
import org.geneontology.oboedit.gui.filters.IsPropertyCriterion;
import org.geneontology.oboedit.gui.filters.LinkFilter;
import org.geneontology.oboedit.gui.filters.LinkFilterImpl;
import org.geneontology.oboedit.gui.filters.NamespaceSearchCriterion;
import org.geneontology.oboedit.gui.filters.ObjectFilter;
import org.geneontology.oboedit.gui.filters.ObjectFilterImpl;
import org.geneontology.oboedit.gui.filters.SelfSearchAspect;
import org.geneontology.util.ProgressEvent;
import org.geneontology.util.ProgressListener;
import org.geneontology.util.ReusableProgressEvent;

public class OBOSerializationEngine {
    protected static int DONT_WRITE_ID_RULES = 0;
    protected static int WRITE_STORED_ID_RULES = 1;
    protected static int WRITE_CURRENT_ID_RULES = 2;
    public static final String SAVE_FOR_PRESENTATION = "Save for presentation";
    public static final String SAVE_ALL = "Save all links";
    protected boolean cancelled = false;
    protected List streams = new LinkedList();
    protected List closingStreams = new LinkedList();
    protected List progressListeners = new LinkedList();
    protected ReusableProgressEvent progressEvent = new ReusableProgressEvent((Object)this);
    protected static final char[] generic_escapes = new char[]{'{', '!'};
    protected static final char[] blocktext_escapes = new char[]{'{', '\n', '!'};
    protected static final char[] space_escapes = new char[]{'{', '\"', ' ', '\t', '!'};
    protected static final char[] single_quote_escapes = new char[]{'\'', '\n'};
    protected static final char[] double_quote_escapes = new char[]{'\"', '\n'};
    protected static final char[] before_quote_escapes = new char[]{'\"', '{', '!'};
    protected static final char[] pv_name_escapes = new char[]{'=', ' ', '\t', '!'};
    protected static final char[] pv_value_escapes = new char[]{',', '}', ' ', '\t', '!'};
    protected static final char[] dbxref_escapes = new char[]{'{', ':', '\t', ',', '\"', ']', '!'};

    public static String escapeSpaces(String s) {
        return OBOSerializationEngine.escape(s, space_escapes);
    }

    public static String escapeQuoted(String s, char quoteChar) {
        char[] escapes = quoteChar == '\'' ? single_quote_escapes : (quoteChar == '\"' ? double_quote_escapes : new char[]{quoteChar, '\n'});
        return OBOSerializationEngine.escape(s, escapes);
    }

    public static String escapeBeforeQuotes(String s) {
        return OBOSerializationEngine.escape(s, before_quote_escapes);
    }

    public static String escapePVName(String s) {
        return OBOSerializationEngine.escape(s, pv_name_escapes);
    }

    public static String escapePVValue(String s) {
        return OBOSerializationEngine.escape(s, pv_value_escapes);
    }

    public static String escapeDbxref(String s) {
        return OBOSerializationEngine.escape(s, dbxref_escapes);
    }

    public static String escapeBlocktext(String s) {
        return OBOSerializationEngine.escape(s, blocktext_escapes);
    }

    public static String escape(String s) {
        return OBOSerializationEngine.escape(s, generic_escapes);
    }

    public static String escape(String s, char[] charsToEscape) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            boolean found = false;
            if (c == '\\') {
                found = true;
            } else {
                for (int j = 0; j < charsToEscape.length; ++j) {
                    if (charsToEscape[j] != c) continue;
                    found = true;
                    break;
                }
            }
            if (found) {
                out.append('\\');
                if (c == '\n') {
                    out.append('n');
                    continue;
                }
                if (c == '\\') {
                    out.append('\\');
                    continue;
                }
                if (c == ' ') {
                    out.append('W');
                    continue;
                }
                out.append(c);
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    public void addProgressListener(ProgressListener progressListener) {
        this.progressListeners.add(progressListener);
    }

    public void removeProgressListener(ProgressListener progressListener) {
        this.progressListeners.remove(progressListener);
    }

    protected void fireProgressEvent(int percent, String message) {
        this.progressEvent.setFastVal(percent);
        this.progressEvent.setDescription(message);
        Iterator it = this.progressListeners.iterator();
        while (it.hasNext()) {
            ProgressListener listener = (ProgressListener)it.next();
            listener.progressMade((ProgressEvent)this.progressEvent);
        }
    }

    public void cancel() {
        this.cancelled = true;
        Iterator it = this.streams.iterator();
        while (it.hasNext()) {
            SafeFileOutputStream sfos = (SafeFileOutputStream)it.next();
            try {
                sfos.fail();
            }
            catch (IOException iOException) {}
        }
    }

    public void serialize(OBOSession session, OBOSerializer serializer, String path) throws DataAdapterException {
        this.serialize(session, serializer, Collections.singleton(new FilteredPath(null, path)));
    }

    public void serialize(OBOSession session, OBOSerializer serializer, Collection filteredPaths) throws DataAdapterException {
        this.streams.clear();
        this.cancelled = false;
        Iterator it = filteredPaths.iterator();
        while (it.hasNext()) {
            FilteredPath filteredPath = (FilteredPath)it.next();
            try {
                SafeFileOutputStream sfos = new SafeFileOutputStream(filteredPath.getPath());
                this.streams.add(sfos);
                BufferedOutputStream stream = new BufferedOutputStream((OutputStream)sfos);
                this.closingStreams.add(stream);
                FilterPair pair = filteredPath.getFilterPair();
                if (!filteredPath.getDoFilter() && !filteredPath.getDoLinkFilter()) {
                    pair = null;
                } else if (filteredPath.getDoFilter() && filteredPath.getSaveTypes()) {
                    FilterPairImpl newPair = new FilterPairImpl();
                    CompoundFilterImpl cf = new CompoundFilterImpl();
                    ObjectFilterImpl propCriterion = new ObjectFilterImpl();
                    propCriterion.setNegate(false);
                    propCriterion.setCriterion(new IsPropertyCriterion());
                    cf.setBooleanOperation(1);
                    cf.addFilter(pair.getObjectFilter());
                    cf.addFilter(propCriterion);
                    newPair.setLinkFilter(pair.getLinkFilter());
                    newPair.setObjectFilter(cf);
                    pair = newPair;
                }
                this.writeFile(session, pair, serializer, stream, filteredPath);
            }
            catch (IOException ex) {
                throw new DataAdapterException("Write error", (Throwable)ex);
            }
        }
        it = this.closingStreams.iterator();
        while (it.hasNext()) {
            OutputStream os = (OutputStream)it.next();
            try {
                os.close();
            }
            catch (IOException ex) {
                throw new DataAdapterException("Could not commit changes to " + os);
            }
        }
        this.closingStreams.clear();
        this.streams.clear();
    }

    public void writeHeader(OBOSession session, LinkDatabase linkDatabase, OBOSerializer serializer, FilteredPath filteredPath) throws IOException, CancelledAdapterException {
        serializer.startHeader();
        String remark = filteredPath.getRemark();
        if (remark == null) {
            remark = session.getCurrentHistory().getComment();
        }
        ArrayList scratchList = new ArrayList();
        List headerTagOrdering = serializer.getHeaderTagOrdering();
        if (headerTagOrdering == null) {
            headerTagOrdering = OBOConstants.DEFAULT_HEADER_TAG_ORDER;
        }
        Iterator it = headerTagOrdering.iterator();
        while (it.hasNext()) {
            Iterator it2;
            IdentifiedObject io;
            Iterator it22;
            HashSet<SynonymCategory> usedCategories;
            Comparator comparator;
            Object tagSpec = it.next();
            if (tagSpec.equals("format-version")) {
                serializer.writeFormatVersionHeaderTag();
                continue;
            }
            if (tagSpec.equals("data-version")) {
                if (session.getCurrentHistory().getVersion() == null) continue;
                serializer.writeDataVersionHeaderTag(session.getCurrentHistory().getVersion());
                continue;
            }
            if (tagSpec.equals("date")) {
                Date date = new GregorianCalendar(TimeZone.getTimeZone("GMT")).getTime();
                serializer.writeDateHeaderTag(date);
                continue;
            }
            if (tagSpec.equals("saved-by")) {
                String username = Controller.getController() != null ? Controller.getController().getUserName() : System.getProperty("user.name");
                serializer.writeSavedByHeaderTag(username);
                continue;
            }
            if (tagSpec.equals("autogenerated-by")) {
                serializer.writeAutoGeneratedByHeaderTag("OBO-Edit " + Controller.getVersion());
                continue;
            }
            if (tagSpec.equals("subsetdef")) {
                comparator = serializer.getCategoryComparator();
                if (comparator == null) {
                    comparator = OBOConstants.DEFAULT_CATEGORY_COMPARATOR;
                }
                scratchList.clear();
                if (filteredPath.getDiscardUnusedCategories()) {
                    usedCategories = new HashSet<SynonymCategory>();
                    it22 = linkDatabase.getObjects().iterator();
                    while (it22.hasNext()) {
                        io = (IdentifiedObject)it22.next();
                        if (!(io instanceof CategorizedObject)) continue;
                        CategorizedObject co = (CategorizedObject)io;
                        usedCategories.addAll(co.getCategories());
                    }
                    scratchList.addAll(usedCategories);
                } else {
                    scratchList.addAll(session.getCategories());
                }
                Collections.sort(scratchList, comparator);
                it2 = scratchList.iterator();
                while (it2.hasNext()) {
                    Object o = it2.next();
                    TermCategory cat = (TermCategory)o;
                    serializer.writeSubsetDefHeaderTag(cat);
                }
                continue;
            }
            if (tagSpec.equals("synonymtypedef")) {
                comparator = serializer.getSynonymCategoryComparator();
                if (comparator == null) {
                    comparator = OBOConstants.DEFAULT_RELATED_SYNONYM_CATEGORY_COMPARATOR;
                }
                scratchList.clear();
                if (filteredPath.getDiscardUnusedCategories()) {
                    usedCategories = new HashSet();
                    it22 = linkDatabase.getObjects().iterator();
                    while (it22.hasNext()) {
                        io = (IdentifiedObject)it22.next();
                        if (!(io instanceof SynonymedObject)) continue;
                        SynonymedObject so = (SynonymedObject)io;
                        Iterator it3 = so.getSynonyms().iterator();
                        while (it3.hasNext()) {
                            Synonym s = (Synonym)it3.next();
                            if (s.getSynonymCategory() == null) continue;
                            usedCategories.add(s.getSynonymCategory());
                        }
                    }
                    scratchList.addAll(usedCategories);
                } else {
                    scratchList.addAll(session.getSynonymCategories());
                }
                Collections.sort(scratchList, comparator);
                it2 = scratchList.iterator();
                while (it2.hasNext()) {
                    SynonymCategory cat = (SynonymCategory)it2.next();
                    serializer.writeSynonymTypeDefHeaderTag(cat);
                }
                continue;
            }
            if (tagSpec.equals("default-namespace")) {
                serializer.writeDefaultNamespaceHeaderTag(session.getDefaultNamespace());
                continue;
            }
            if (tagSpec.equals("namespace-id-rule")) {
                if (filteredPath.getIDRuleMode() != WRITE_STORED_ID_RULES && filteredPath.getIDRuleMode() != WRITE_CURRENT_ID_RULES) continue;
                IDProfile profile = null;
                if (filteredPath.getIDRuleMode() == WRITE_STORED_ID_RULES) {
                    profile = session.getIDProfile();
                }
                if (profile == null && Controller.getController() != null && Controller.getController().getIDAdapter() instanceof DefaultIDGenerator) {
                    DefaultIDGenerator idGen = (DefaultIDGenerator)Controller.getController().getIDAdapter();
                    profile = idGen.getProfile();
                }
                if (profile == null) continue;
                serializer.writeNamespaceIDRuleHeaderTag(null, profile.getDefaultRule());
                HashMap<String, String> nsMap = new HashMap<String, String>();
                ArrayList<String> nsList = new ArrayList<String>();
                Iterator it23 = profile.getRules().iterator();
                while (it23.hasNext()) {
                    ObjectFilter of;
                    CompoundFilter cf;
                    IDRule rule = (IDRule)it23.next();
                    Filter filter = rule.getFilter();
                    if (rule.getFilter() instanceof CompoundFilter && (cf = (CompoundFilter)rule.getFilter()).getFilters().size() == 1) {
                        filter = (Filter)cf.getFilters().get(0);
                    }
                    if (filter == null || !(filter instanceof ObjectFilter) || !((of = (ObjectFilter)filter).getCriterion() instanceof NamespaceSearchCriterion) || !(of.getAspect() instanceof SelfSearchAspect) || !(of.getComparison() instanceof EqualsComparison) || of.getNegate()) continue;
                    String ns = of.getValue();
                    nsMap.put(ns, rule.getRule());
                    nsList.add(ns);
                }
                Collections.sort(nsList);
                it23 = nsList.iterator();
                while (it23.hasNext()) {
                    String ns = (String)it23.next();
                    serializer.writeNamespaceIDRuleHeaderTag(ns, (String)nsMap.get(ns));
                }
                continue;
            }
            if (!tagSpec.equals("remark")) continue;
            serializer.writeRemarkHeaderTag(remark);
        }
        serializer.endHeader();
    }

    public void writeObject(IdentifiedObject obj, LinkDatabase linkDatabase, boolean allowDangling, boolean realizeImpliedLinks, OBOSerializer serializer) throws IOException, CancelledAdapterException {
        Comparator linkComparator;
        Comparator obsoleteComparator;
        Comparator synonymComparator;
        Comparator categoryComparator;
        Comparator dbxrefComparator;
        Comparator idComparator;
        List tagOrdering = serializer.getTagOrdering();
        if (tagOrdering == null) {
            tagOrdering = OBOConstants.DEFAULT_TAG_ORDER;
        }
        if ((idComparator = serializer.getIDComparator()) == null) {
            idComparator = OBOConstants.DEFAULT_ID_COMPARATOR;
        }
        if ((dbxrefComparator = serializer.getDbxrefComparator()) == null) {
            dbxrefComparator = OBOConstants.DEFAULT_DBXREF_COMPARATOR;
        }
        if ((categoryComparator = serializer.getCategoryComparator()) == null) {
            categoryComparator = OBOConstants.DEFAULT_CATEGORY_COMPARATOR;
        }
        if ((synonymComparator = serializer.getSynonymComparator()) == null) {
            synonymComparator = OBOConstants.DEFAULT_RELATED_SYNONYM_COMPARATOR;
        }
        if ((obsoleteComparator = serializer.getObsoleteComparator()) == null) {
            obsoleteComparator = OBOConstants.DEFAULT_OBSOLETE_COMPARATOR;
        }
        if ((linkComparator = serializer.getLinkComparator()) == null) {
            linkComparator = OBOConstants.DEFAULT_LINK_COMPARATOR;
        }
        boolean writeNonRels = linkDatabase.getObjects().contains(obj);
        List linkList = TermUtil.mallocList();
        ArrayList scratchList = new ArrayList();
        if (obj instanceof LinkedObject) {
            LinkedObject lo = (LinkedObject)obj;
            scratchList.clear();
            scratchList.addAll(linkDatabase.getParents(lo));
            Collections.sort(scratchList, linkComparator);
            linkList.addAll(scratchList);
        }
        if (!writeNonRels && linkList.size() == 0) {
            TermUtil.freeList(linkList);
            return;
        }
        serializer.startStanza(obj);
        Iterator it = tagOrdering.iterator();
        while (it.hasNext()) {
            ObsoletableObject replacement;
            Iterator it2;
            ObsoletableObject oo;
            OBOProperty property;
            NestedValue nv;
            Iterator it22;
            OBOConstants.TagMapping tagMapping = (OBOConstants.TagMapping)it.next();
            if (tagMapping.equals(OBOConstants.ID_TAG)) {
                serializer.writeIDTag(obj.getID(), obj.getIDExtension());
            } else if (tagMapping.equals(OBOConstants.IS_ANONYMOUS_TAG)) {
                serializer.writeIsAnonymousTag(obj.isAnonymous(), obj.getAnonymousExtension());
            }
            if (!writeNonRels) continue;
            if (tagMapping.equals(OBOConstants.NAME_TAG)) {
                serializer.writeNameTag(obj.getName(), obj.getNameExtension());
                continue;
            }
            if (tagMapping.equals(OBOConstants.NAMESPACE_TAG)) {
                serializer.writeNamespaceTag(obj.getNamespace(), obj.getNamespaceExtension());
                continue;
            }
            if (obj instanceof MultiIDObject && tagMapping.equals(OBOConstants.ALT_ID_TAG)) {
                scratchList.clear();
                scratchList.addAll(((MultiIDObject)obj).getSecondaryIDs());
                Collections.sort(scratchList, idComparator);
                it22 = scratchList.iterator();
                while (it22.hasNext()) {
                    String id = (String)it22.next();
                    nv = ((MultiIDObject)obj).getSecondaryIDExtension(id);
                    serializer.writeAltIDTag(id, nv);
                }
                continue;
            }
            if (obj instanceof DefinedObject && tagMapping.equals(OBOConstants.DEF_TAG)) {
                scratchList.clear();
                scratchList.addAll(((DefinedObject)obj).getDefDbxrefs());
                Collections.sort(scratchList, dbxrefComparator);
                serializer.writeDefTag(((DefinedObject)obj).getDefinition(), scratchList, ((DefinedObject)obj).getDefinitionExtension());
                continue;
            }
            if (obj instanceof CommentedObject && tagMapping.equals(OBOConstants.COMMENT_TAG)) {
                CommentedObject cobj = (CommentedObject)obj;
                if (cobj.getComment() == null) continue;
                serializer.writeCommentTag(cobj.getComment(), cobj.getCommentExtension());
                continue;
            }
            if (obj instanceof CategorizedObject && tagMapping.equals(OBOConstants.SUBSET_TAG)) {
                scratchList.clear();
                scratchList.addAll(((CategorizedObject)obj).getCategories());
                Collections.sort(scratchList, categoryComparator);
                it22 = scratchList.iterator();
                while (it22.hasNext()) {
                    TermCategory category = (TermCategory)it22.next();
                    nv = ((CategorizedObject)obj).getCategoryExtension(category);
                    serializer.writeSubsetTag(category, nv);
                }
                continue;
            }
            if (obj instanceof SynonymedObject && tagMapping.equals(OBOConstants.RELATED_SYNONYM_TAG)) {
                scratchList.clear();
                scratchList.addAll(((SynonymedObject)obj).getSynonyms());
                Collections.sort(scratchList, synonymComparator);
                it22 = scratchList.iterator();
                while (it22.hasNext()) {
                    Synonym synonym = (Synonym)it22.next();
                    serializer.writeSynonymTag(synonym, synonym.getNestedValue());
                }
                continue;
            }
            if (obj instanceof DbxrefedObject && tagMapping.equals(OBOConstants.XREF_TAG)) {
                scratchList.clear();
                scratchList.addAll(((DbxrefedObject)obj).getDbxrefs());
                Collections.sort(scratchList, dbxrefComparator);
                it22 = scratchList.iterator();
                while (it22.hasNext()) {
                    Dbxref dbxref = (Dbxref)it22.next();
                    serializer.writeXrefTag(dbxref);
                }
                continue;
            }
            if (obj instanceof Instance && tagMapping.equals(OBOConstants.INSTANCE_OF_TAG) || obj instanceof Instance && tagMapping.equals(OBOConstants.PROPERTY_VALUE_TAG)) continue;
            if (obj instanceof OBOProperty && tagMapping.equals(OBOConstants.DOMAIN_TAG)) {
                property = (OBOProperty)obj;
                if (property.getDomain() == null) continue;
                serializer.writeDomainTag(property.getDomain(), property.getDomainExtension());
                continue;
            }
            if (obj instanceof OBOProperty && tagMapping.equals(OBOConstants.RANGE_TAG)) {
                property = (OBOProperty)obj;
                if (property.getRange() == null) continue;
                serializer.writeRangeTag(property.getRange(), property.getRangeExtension());
                continue;
            }
            if (obj instanceof OBOProperty && tagMapping.equals(OBOConstants.IS_CYCLIC_TAG)) {
                property = (OBOProperty)obj;
                serializer.writeIsCyclicTag(property.isCyclic(), property.getCyclicExtension());
                continue;
            }
            if (obj instanceof OBOProperty && tagMapping.equals(OBOConstants.IS_REFLEXIVE_TAG)) {
                property = (OBOProperty)obj;
                serializer.writeIsReflexiveTag(property.isReflexive(), property.getReflexiveExtension());
                continue;
            }
            if (obj instanceof OBOProperty && tagMapping.equals(OBOConstants.IS_SYMMETRIC_TAG)) {
                property = (OBOProperty)obj;
                serializer.writeIsSymmetricTag(property.isSymmetric(), property.getSymmetricExtension());
                continue;
            }
            if (obj instanceof OBOProperty && tagMapping.equals(OBOConstants.IS_TRANSITIVE_TAG)) {
                property = (OBOProperty)obj;
                serializer.writeIsTransitiveTag(property.isTransitive(), property.getTransitiveExtension());
                continue;
            }
            if (obj instanceof LinkedObject && tagMapping.equals(OBOConstants.LINK_TAG)) {
                it22 = linkList.iterator();
                while (it22.hasNext()) {
                    OBORestriction link = (OBORestriction)it22.next();
                    if (!allowDangling && link.getParent() instanceof DanglingObject) continue;
                    if (realizeImpliedLinks && link.isImplied()) {
                        link = this.realizeLink(link);
                    }
                    serializer.writeLinkTag(link, link.getNestedValue());
                }
                continue;
            }
            if (obj instanceof ObsoletableObject && tagMapping.equals(OBOConstants.IS_OBSOLETE_TAG)) {
                oo = (ObsoletableObject)obj;
                serializer.writeIsObsoleteTag(oo.isObsolete(), oo.getObsoleteExtension());
                continue;
            }
            if (obj instanceof ObsoletableObject && tagMapping.equals(OBOConstants.REPLACED_BY_TAG)) {
                oo = (ObsoletableObject)obj;
                scratchList.clear();
                scratchList.addAll(oo.getReplacedBy());
                Collections.sort(scratchList, obsoleteComparator);
                it2 = scratchList.iterator();
                while (it2.hasNext()) {
                    replacement = (ObsoletableObject)it2.next();
                    serializer.writeReplacedByTag(replacement, oo.getReplacedByExtension(replacement));
                }
                continue;
            }
            if (obj instanceof ObsoletableObject && tagMapping.equals(OBOConstants.CONSIDER_TAG)) {
                oo = (ObsoletableObject)obj;
                scratchList.clear();
                scratchList.addAll(oo.getConsiderReplacements());
                Collections.sort(scratchList, obsoleteComparator);
                it2 = scratchList.iterator();
                while (it2.hasNext()) {
                    replacement = (ObsoletableObject)it2.next();
                    serializer.writeConsiderTag(replacement, oo.getConsiderExtension(replacement));
                }
                continue;
            }
            if (!tagMapping.equals(OBOConstants.UNRECOGNIZED_TAG)) continue;
            it22 = obj.getPropertyValues().iterator();
            while (it22.hasNext()) {
                PropertyValue pv = (PropertyValue)it22.next();
                serializer.writeUnrecognizedTag(pv);
            }
        }
        serializer.endStanza(obj);
        TermUtil.freeList(linkList);
    }

    protected OBORestriction realizeLink(OBORestriction link) {
        OBORestrictionImpl out = new OBORestrictionImpl(link);
        out.setCardinality(link.getCardinality());
        out.setMaxCardinality(link.getMaxCardinality());
        out.setMinCardinality(link.getMinCardinality());
        out.setCompletes(link.completes());
        out.setInverseCompletes(link.inverseCompletes());
        out.setNecessarilyTrue(link.isNecessarilyTrue());
        out.setInverseNecessarilyTrue(link.isInverseNecessarilyTrue());
        if (link.getNestedValue() != null) {
            out.setNestedValue((NestedValue)link.getNestedValue().clone());
        } else {
            out.setNestedValue(new NestedValueImpl());
        }
        out.getNestedValue().setSuggestedComment("implied link automatically realized");
        return out;
    }

    protected static LinkFilter getPropertyLinkFilter(OBOProperty filterProperty) {
        LinkFilterImpl basicLinkFilter = new LinkFilterImpl();
        basicLinkFilter.setAspect(2);
        ObjectFilterImpl idfilter = new ObjectFilterImpl();
        idfilter.setCriterion(new IDSearchCriterion());
        idfilter.setComparison(new EqualsComparison());
        idfilter.setValue(filterProperty.getID());
        basicLinkFilter.setFilter(idfilter);
        return basicLinkFilter;
    }

    public void writeFile(OBOSession session, FilterPair filterPair, OBOSerializer serializer, OutputStream stream, FilteredPath filteredPath) throws IOException, CancelledAdapterException {
        Comparator objectComparator;
        String path = filteredPath.getPath();
        boolean allowDangling = filteredPath.getAllowDangling();
        boolean saveImplied = filteredPath.getSaveImplied();
        String impliedType = filteredPath.getImpliedType();
        OBOProperty prefilterProperty = null;
        if (filteredPath.getPrefilterProperty() != null) {
            prefilterProperty = (OBOProperty)session.getObject(filteredPath.getPrefilterProperty());
        }
        String rootAlgorithm = filteredPath.getRootAlgorithm();
        serializer.setOutputStream(stream);
        serializer.startSerialize();
        boolean saveAll = impliedType.equals(SAVE_ALL);
        LinkDatabase database = new DefaultLinkDatabase(session);
        if (saveImplied || prefilterProperty != null) {
            ReasonedLinkDatabase fullReasoner;
            if (Controller.getController() != null && Controller.getController().getUseReasoner()) {
                fullReasoner = Controller.getController().getFullReasoner();
            } else {
                fullReasoner = new PushAndBubbleReasoner();
                fullReasoner.setLinkDatabase(new DefaultLinkDatabase(session));
                fullReasoner.recache();
            }
            if (prefilterProperty != null) {
                final FilteredLinkDatabase propertyFiltered = new FilteredLinkDatabase(fullReasoner);
                propertyFiltered.setFilterMethod(4);
                propertyFiltered.setLinkFilter(OBOSerializationEngine.getPropertyLinkFilter(prefilterProperty));
                if (saveAll) {
                    database = propertyFiltered;
                } else {
                    final ReasonedLinkDatabase rld = fullReasoner;
                    FilteredLinkDatabase trimFiltered = new FilteredLinkDatabase(propertyFiltered);
                    trimFiltered.setFilterMethod(4);
                    trimFiltered.setLinkFilter(new Filter(){
                        private static final long serialVersionUID = 1L;

                        public boolean satisfies(Object o) {
                            if (o instanceof Link) {
                                Link link = (Link)o;
                                return !FilteredReasonedLinkDatabase.shouldBeTrimmed(link, propertyFiltered, rld);
                            }
                            return false;
                        }

                        public void lock() {
                        }

                        public void setContext(JexlContext context) {
                        }

                        public Object clone() {
                            return this;
                        }
                    });
                    database = trimFiltered;
                }
            } else if (saveAll) {
                database = fullReasoner;
            } else {
                database = new FilteredReasonedLinkDatabase();
                ((FilteredReasonedLinkDatabase)database).setLinkDatabase(fullReasoner);
            }
            if (database instanceof ReasonedLinkDatabase) {
                ((ReasonedLinkDatabase)database).recache();
            }
        }
        if (filterPair != null) {
            database = new FilteredLinkDatabase(database);
            ((FilteredLinkDatabase)database).setFilterPair(filterPair);
            ((FilteredLinkDatabase)database).setAllowDangling(allowDangling);
        }
        if (rootAlgorithm.equals("STRICT")) {
            database = new RootAlgorithmModeratedLinkDatabase(database, RootAlgorithm.STRICT);
            ((RootAlgorithmModeratedLinkDatabase)database).recache();
        }
        this.fireProgressEvent(-1, "Writing header: " + path);
        this.writeHeader(session, database, serializer, filteredPath);
        this.fireProgressEvent(-1, "Setting up adapter: " + path);
        List stanzaOrdering = serializer.getStanzaOrdering();
        List headerTagOrdering = serializer.getHeaderTagOrdering();
        if (stanzaOrdering == null) {
            stanzaOrdering = OBOConstants.DEFAULT_STANZA_ORDER;
        }
        if (headerTagOrdering == null) {
            headerTagOrdering = OBOConstants.DEFAULT_HEADER_TAG_ORDER;
        }
        if ((objectComparator = serializer.getObjectComparator()) == null) {
            objectComparator = OBOConstants.DEFAULT_OBJECT_COMPARATOR;
        }
        Iterator it = stanzaOrdering.iterator();
        while (it.hasNext()) {
            OBOConstants.StanzaMapping stanzaMapping = (OBOConstants.StanzaMapping)it.next();
            ArrayList<IdentifiedObject> objectList = new ArrayList<IdentifiedObject>();
            Iterator it2 = database.getObjects().iterator();
            while (it2.hasNext()) {
                IdentifiedObject io = (IdentifiedObject)it2.next();
                if (!stanzaMapping.getStanzaClass().isInstance(io) || io.isBuiltIn()) continue;
                objectList.add(io);
            }
            this.fireProgressEvent(-1, "Sorting objects: " + path);
            Collections.sort(objectList, objectComparator);
            it2 = objectList.iterator();
            int i = 0;
            while (it2.hasNext()) {
                if (this.cancelled) {
                    this.doHalt();
                }
                IdentifiedObject io = (IdentifiedObject)it2.next();
                int percent = 100 * i / objectList.size();
                if (percent % 5 == 0) {
                    this.fireProgressEvent(percent, "Writing objects " + percent + "% :" + path);
                }
                this.writeObject(io, database, allowDangling, filteredPath.getRealizeImpliedLinks(), serializer);
                ++i;
            }
        }
        serializer.endSerialize();
    }

    public void doHalt() throws CancelledAdapterException {
        throw new CancelledAdapterException();
    }

    public static class FilteredPath {
        protected FilterPair filterPair;
        protected String prefilterProperty;
        protected boolean doFilter = false;
        protected boolean doLinkFilter = false;
        protected boolean allowDangling = false;
        protected boolean saveImplied = false;
        protected boolean discardUnusedCategories = false;
        protected int idRuleMode = DONT_WRITE_ID_RULES;
        protected String impliedType = "Save for presentation";
        protected String path;
        protected String remark;
        protected String rootAlgorithm = "GREEDY";
        protected boolean realizeImpliedLinks = false;
        protected boolean saveTypes;

        public FilteredPath() {
        }

        public FilteredPath(FilterPair filterPair, String path) {
            this.setFilterPair(filterPair);
            this.setPath(path);
        }

        public void setRootAlgorithm(String rootAlgorithm) {
            this.rootAlgorithm = rootAlgorithm;
        }

        public String getRootAlgorithm() {
            return this.rootAlgorithm;
        }

        public void setPrefilterProperty(String prefilterProperty) {
            this.prefilterProperty = prefilterProperty;
        }

        public String getPrefilterProperty() {
            return this.prefilterProperty;
        }

        public void setRemark(String remark) {
            this.remark = remark;
        }

        public String getRemark() {
            return this.remark;
        }

        public void setIDRuleMode(int idRuleWriteMode) {
            this.idRuleMode = idRuleWriteMode;
        }

        public int getIDRuleMode() {
            return this.idRuleMode;
        }

        public void setAllowDangling(boolean allowDangling) {
            this.allowDangling = allowDangling;
        }

        public boolean getAllowDangling() {
            return this.allowDangling;
        }

        public void setSaveImplied(boolean saveImplied) {
            this.saveImplied = saveImplied;
        }

        public boolean getSaveImplied() {
            return this.saveImplied;
        }

        public void setFilterPair(FilterPair filterPair) {
            this.filterPair = filterPair;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public void setImpliedType(String impliedType) {
            this.impliedType = impliedType;
        }

        public String getImpliedType() {
            return this.impliedType;
        }

        public FilterPair getFilterPair() {
            return this.filterPair;
        }

        public String getPath() {
            return this.path;
        }

        public boolean getDoLinkFilter() {
            return this.doLinkFilter;
        }

        public void setDoLinkFilter(boolean doLinkFilter) {
            this.doLinkFilter = doLinkFilter;
        }

        public boolean getDoFilter() {
            return this.doFilter;
        }

        public void setDoFilter(boolean doFilter) {
            this.doFilter = doFilter;
        }

        public String toString() {
            return this.path;
        }

        public boolean getRealizeImpliedLinks() {
            return this.realizeImpliedLinks;
        }

        public void setRealizeImpliedLinks(boolean realizeImpliedLinks) {
            this.realizeImpliedLinks = realizeImpliedLinks;
        }

        public boolean getSaveTypes() {
            return this.saveTypes;
        }

        public void setSaveTypes(boolean saveTypes) {
            this.saveTypes = saveTypes;
        }

        public boolean getDiscardUnusedCategories() {
            return this.discardUnusedCategories;
        }

        public void setDiscardUnusedCategories(boolean discardUnusedCategories) {
            this.discardUnusedCategories = discardUnusedCategories;
        }
    }
}

