/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml.converter;

import psidev.psi.mi.xml.converter.AttributeConverter;
import psidev.psi.mi.xml.converter.ConverterException;
import psidev.psi.mi.xml.converter.CvTypeConverter;
import psidev.psi.mi.xml.converter.NamesConverter;
import psidev.psi.mi.xml.converter.OrganismConverter;
import psidev.psi.mi.xml.converter.XrefConverter;
import psidev.psi.mi.xml.dao.DAOFactory;
import psidev.psi.mi.xml.dao.PsiDAO;
import psidev.psi.mi.xml.jaxb.AttributeListType;
import psidev.psi.mi.xml.jaxb.InteractorElementType;
import psidev.psi.mi.xml.model.Attribute;
import psidev.psi.mi.xml.model.Interactor;
import psidev.psi.mi.xml.model.InteractorType;

public class InteractorConverter {
    private CvTypeConverter cvTypeConverter = new CvTypeConverter();
    private NamesConverter namesConverter = new NamesConverter();
    private XrefConverter xrefConverter = new XrefConverter();
    private OrganismConverter organismConverter = new OrganismConverter();
    private AttributeConverter attributeConverter = new AttributeConverter();
    private DAOFactory factory;

    public void setDAOFactory(DAOFactory factory) {
        this.factory = factory;
    }

    private void checkDependencies() throws ConverterException {
        if (this.factory == null) {
            throw new ConverterException("Please set a DAO factory in order to resolve experiment's id.");
        }
    }

    public Interactor fromJaxb(InteractorElementType jInteractor) throws ConverterException {
        if (jInteractor == null) {
            throw new IllegalArgumentException("You must give a non null JAXB Interactor.");
        }
        this.checkDependencies();
        Interactor mInteractor = new Interactor();
        mInteractor.setId(jInteractor.getId());
        mInteractor.setInteractorType(this.cvTypeConverter.fromJaxb(jInteractor.getInteractorType(), InteractorType.class));
        mInteractor.setNames(this.namesConverter.fromJaxb(jInteractor.getNames()));
        mInteractor.setXref(this.xrefConverter.fromJaxb(jInteractor.getXref()));
        if (jInteractor.getOrganism() != null) {
            mInteractor.setOrganism(this.organismConverter.fromJaxb(jInteractor.getOrganism()));
        }
        mInteractor.setSequence(jInteractor.getSequence());
        if (jInteractor.getAttributeList() != null) {
            for (AttributeListType.Attribute attribute : jInteractor.getAttributeList().getAttribute()) {
                mInteractor.getAttributes().add(this.attributeConverter.fromJaxb(attribute));
            }
        }
        PsiDAO<Interactor> interactorDAO = this.factory.getInteractorDAO();
        interactorDAO.store(mInteractor);
        return mInteractor;
    }

    public InteractorElementType toJaxb(Interactor mInteractor) throws ConverterException {
        if (mInteractor == null) {
            throw new IllegalArgumentException("You must give a non null model Interactor.");
        }
        this.checkDependencies();
        InteractorElementType jInteractor = new InteractorElementType();
        jInteractor.setId(mInteractor.getId());
        jInteractor.setInteractorType(this.cvTypeConverter.toJaxb(mInteractor.getInteractorType()));
        jInteractor.setNames(this.namesConverter.toJaxb(mInteractor.getNames()));
        jInteractor.setXref(this.xrefConverter.toJaxb(mInteractor.getXref()));
        if (mInteractor.hasOrganism()) {
            jInteractor.setOrganism(this.organismConverter.toJaxb(mInteractor.getOrganism(), InteractorElementType.Organism.class));
        }
        jInteractor.setSequence(mInteractor.getSequence());
        if (mInteractor.hasAttributes()) {
            jInteractor.setAttributeList(new AttributeListType());
            for (Attribute attribute : mInteractor.getAttributes()) {
                jInteractor.getAttributeList().getAttribute().add(this.attributeConverter.toJaxb(attribute));
            }
        }
        return jInteractor;
    }
}

