/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml.converter;

import psidev.psi.mi.xml.converter.ConverterException;
import psidev.psi.mi.xml.converter.InferredInteractionParticipantConverter;
import psidev.psi.mi.xml.dao.DAOFactory;
import psidev.psi.mi.xml.dao.PsiDAO;
import psidev.psi.mi.xml.jaxb.ExperimentRefListType;
import psidev.psi.mi.xml.jaxb.InteractionElementType;
import psidev.psi.mi.xml.model.ExperimentDescription;
import psidev.psi.mi.xml.model.ExperimentRef;
import psidev.psi.mi.xml.model.InferredInteraction;
import psidev.psi.mi.xml.model.InferredInteractionParticipant;

public class InferredInteractionConverter {
    private InferredInteractionParticipantConverter participantConverter = new InferredInteractionParticipantConverter();
    private DAOFactory factory;

    public void setDAOFactory(DAOFactory factory) {
        this.factory = factory;
        this.participantConverter.setDAOFactory(factory);
    }

    private void checkDependencies() throws ConverterException {
        if (this.factory == null) {
            throw new ConverterException("Please set a DAO factory in order to resolve experiment's id.");
        }
    }

    public InferredInteraction fromJaxb(InteractionElementType.InferredInteractionList.InferredInteraction jInferredInteraction) throws ConverterException {
        if (jInferredInteraction == null) {
            throw new IllegalArgumentException("You must give a non null JAXB InferredInteraction.");
        }
        this.checkDependencies();
        InferredInteraction mInferredInteraction = new InferredInteraction();
        for (InteractionElementType.InferredInteractionList.InferredInteraction.Participant jParticipant : jInferredInteraction.getParticipant()) {
            mInferredInteraction.getParticipant().add(this.participantConverter.fromJaxb(jParticipant));
        }
        if (jInferredInteraction.getExperimentRefList() != null) {
            PsiDAO<ExperimentDescription> experimentDAO = this.factory.getExperimentDAO();
            for (Integer experimnetId : jInferredInteraction.getExperimentRefList().getExperimentRef()) {
                ExperimentDescription experimentDescription = experimentDAO.retreive(experimnetId);
                if (experimentDescription != null) {
                    mInferredInteraction.getExperiments().add(experimentDescription);
                    continue;
                }
                mInferredInteraction.getExperimentRefs().add(new ExperimentRef(experimnetId));
            }
        }
        return mInferredInteraction;
    }

    public InteractionElementType.InferredInteractionList.InferredInteraction toJaxb(InferredInteraction mInferredInteraction) throws ConverterException {
        InteractionElementType.InferredInteractionList.InferredInteraction jInferredInteraction;
        block6: {
            block5: {
                if (mInferredInteraction == null) {
                    throw new IllegalArgumentException("You must give a non null model InferredInteraction.");
                }
                this.checkDependencies();
                jInferredInteraction = new InteractionElementType.InferredInteractionList.InferredInteraction();
                for (InferredInteractionParticipant inferredInteractionParticipant : mInferredInteraction.getParticipant()) {
                    jInferredInteraction.getParticipant().add(this.participantConverter.toJaxb(inferredInteractionParticipant));
                }
                if (jInferredInteraction.getExperimentRefList() == null) {
                    jInferredInteraction.setExperimentRefList(new ExperimentRefListType());
                }
                if (!mInferredInteraction.hasExperiments()) break block5;
                for (ExperimentDescription experimentDescription : mInferredInteraction.getExperiments()) {
                    Integer experimentId = experimentDescription.getId();
                    jInferredInteraction.getExperimentRefList().getExperimentRef().add(experimentId);
                }
                break block6;
            }
            if (!mInferredInteraction.hasExperimentRefs()) break block6;
            for (ExperimentRef experimentRef : mInferredInteraction.getExperimentRefs()) {
                Integer experimentId = experimentRef.getRef();
                jInferredInteraction.getExperimentRefList().getExperimentRef().add(experimentId);
            }
        }
        return jInferredInteraction;
    }
}

