/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.DatatypeConverterInterface;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.xml.converter.ConverterException;
import psidev.psi.mi.xml.converter.EntrySetConverter;
import psidev.psi.mi.xml.dao.inMemory.InMemoryDAOFactory;
import psidev.psi.mi.xml.jaxb.EntrySet;
import psidev.psi.mi.xml.util.PsiJaxbConverter;

public class PsimiXmlWriter {
    public static final Log log = LogFactory.getLog(PsimiXmlWriter.class);

    private Marshaller getMarshaller(EntrySet jEntrySet) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((String)"psidev.psi.mi.xml.jaxb");
        DatatypeConverter.setDatatypeConverter((DatatypeConverterInterface)new PsiJaxbConverter());
        Marshaller marshaller = jc.createMarshaller();
        marshaller.setProperty("jaxb.schemaLocation", (Object)PsimiXmlWriter.calculateSchemaLocation(jEntrySet.getLevel(), jEntrySet.getVersion(), jEntrySet.getMinorVersion()));
        return marshaller;
    }

    private void marshall(EntrySet jEntrySet, OutputStream os) throws JAXBException {
        if (os == null) {
            throw new IllegalArgumentException("You must give a non null otuput stream.");
        }
        Marshaller m = this.getMarshaller(jEntrySet);
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.marshal((Object)jEntrySet, os);
    }

    private void marshall(EntrySet jEntrySet, Writer writer) throws JAXBException {
        if (writer == null) {
            throw new IllegalArgumentException("You must give a non null writer.");
        }
        Marshaller m = this.getMarshaller(jEntrySet);
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.marshal((Object)jEntrySet, writer);
    }

    private void marshall(EntrySet jEntrySet, File file) throws JAXBException, IOException {
        Marshaller m = this.getMarshaller(jEntrySet);
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.marshal((Object)jEntrySet, (Writer)new FileWriter(file));
    }

    private String marshall(EntrySet jEntrySet) throws JAXBException, IOException {
        StringWriter writer = new StringWriter(4096);
        Marshaller marshaller = this.getMarshaller(jEntrySet);
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal((Object)jEntrySet, (Writer)writer);
        ((Writer)writer).close();
        return ((Object)writer).toString();
    }

    private EntrySet convertInMemory(psidev.psi.mi.xml.model.EntrySet mEntrySet) throws ConverterException {
        EntrySetConverter converter = new EntrySetConverter();
        InMemoryDAOFactory dao = new InMemoryDAOFactory();
        converter.setDAOFactory(dao);
        EntrySet jEntrySet = converter.toJaxb(mEntrySet);
        return jEntrySet;
    }

    public void write(psidev.psi.mi.xml.model.EntrySet mEntrySet, File file) throws IOException, ConverterException, JAXBException {
        if (file == null) {
            throw new IllegalArgumentException("You must give a non null file.");
        }
        if (file.exists()) {
            log.warn((Object)(file.getAbsolutePath() + " is going to be overwritten"));
            if (!file.canWrite()) {
                throw new IllegalArgumentException("You must give a writeable file.");
            }
        } else if (!file.createNewFile()) {
            throw new IOException("Could not create file: " + file.getAbsolutePath());
        }
        EntrySet jEntrySet = this.convertInMemory(mEntrySet);
        this.marshall(jEntrySet, file);
    }

    public void write(psidev.psi.mi.xml.model.EntrySet mEntrySet, OutputStream os) throws IOException, ConverterException, JAXBException {
        EntrySet jEntrySet = this.convertInMemory(mEntrySet);
        this.marshall(jEntrySet, os);
    }

    public void write(psidev.psi.mi.xml.model.EntrySet mEntrySet, Writer writer) throws IOException, ConverterException, JAXBException {
        EntrySet jEntrySet = this.convertInMemory(mEntrySet);
        this.marshall(jEntrySet, writer);
    }

    public void write(psidev.psi.mi.xml.model.EntrySet mEntrySet, PrintStream ps) throws IOException, ConverterException, JAXBException {
        EntrySet jEntrySet = this.convertInMemory(mEntrySet);
        String xml = this.marshall(jEntrySet);
        ps.println(xml);
    }

    public String getAsString(psidev.psi.mi.xml.model.EntrySet mEntrySet) throws IOException, ConverterException, JAXBException {
        EntrySet jEntrySet = this.convertInMemory(mEntrySet);
        String xml = this.marshall(jEntrySet);
        return xml;
    }

    public static String calculateSchemaLocation(int majorVersion, int minorVersion, int bugfix) {
        String versionSuffix = majorVersion > 0 && minorVersion != 0 ? String.valueOf(majorVersion) + String.valueOf(minorVersion) + String.valueOf(bugfix) : "253";
        return "net:sf:psidev:mi http://psidev.sourceforge.net/mi/rel25/src/MIF" + versionSuffix + ".xsd";
    }
}

