/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class MultiProperties
extends Properties {
    private static final long serialVersionUID = 445024832917738700L;
    private static final String DELIM = "%";
    private MultiProperties parent = null;
    private String myKey = "";

    public MultiProperties getProperties(String key) {
        MultiProperties out = new MultiProperties();
        out.parent = this;
        out.myKey = key;
        Enumeration<?> e = this.propertyNames();
        while (e.hasMoreElements()) {
            String elt = (String)e.nextElement();
            String header = this.getKeyHead(elt);
            String tail = this.getKeyTail(elt);
            if (header == null || !header.equals(key)) continue;
            out.put(tail, this.getProperty(elt));
        }
        return out;
    }

    public Object setProperty(String key, String value) {
        Object out = super.put(key, value);
        if (this.parent != null) {
            this.parent.setProperty(String.valueOf(this.myKey) + DELIM + key, value);
        }
        return out;
    }

    public void setProperties(String key, Properties p) {
        this.removeProperties(key);
        this.addProperties(key, p);
    }

    public void addProperties(String key, Properties p) {
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String elt = (String)e.nextElement();
            this.setProperty(String.valueOf(key) + DELIM + elt, p.getProperty(elt));
        }
    }

    public void removeProperties(String key) {
        MultiProperties props = this.getProperties(key);
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String elt = (String)e.nextElement();
            this.remove(elt);
        }
    }

    public Enumeration multiPropertyNames() {
        Hashtable<String, String> out = new Hashtable<String, String>();
        Enumeration<?> e = this.propertyNames();
        while (e.hasMoreElements()) {
            String elt = (String)e.nextElement();
            StringTokenizer st = new StringTokenizer(elt, DELIM);
            if (!st.hasMoreTokens()) continue;
            out.put(elt, elt);
        }
        return out.elements();
    }

    protected String getKeyHead(String key) {
        StringTokenizer tokenizer = new StringTokenizer(key, DELIM);
        try {
            return tokenizer.nextToken();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected String getKeyTail(String key) {
        StringTokenizer tokenizer = new StringTokenizer(key, DELIM);
        try {
            tokenizer.nextToken();
            StringBuffer out = new StringBuffer();
            while (tokenizer.hasMoreTokens()) {
                if (out.length() != 0) {
                    out.append(DELIM);
                }
                out.append(tokenizer.nextToken());
            }
            return out.toString();
        }
        catch (Exception e) {
            return null;
        }
    }
}

