/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.swing;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ShapeUtil {
    protected static final float[] scratch = new float[6];

    private ShapeUtil() {
    }

    public static Shape createRoundRectangle(float x, float y, float width, float height) {
        return ShapeUtil.createRoundRectangle(50, x, y, width, height);
    }

    public static Shape createRoundRectangle(int roundingPercentage, float x, float y, float width, float height) {
        float roundingSize = Math.min(width, height) * (float)roundingPercentage / 100.0f;
        return ShapeUtil.createRoundRectangle(null, roundingSize, x, y, width, height);
    }

    public static Shape createRoundRectangle(GeneralPath out, float roundingSize, float x, float y, float width, float height) {
        if (out == null) {
            out = new GeneralPath();
        } else {
            out.reset();
        }
        out.moveTo(x, y + roundingSize);
        out.curveTo(x, y, x, y, x + roundingSize, y);
        out.lineTo(x + width - roundingSize, y);
        out.curveTo(x + width, y, x + width, y, x + width, y + roundingSize);
        out.lineTo(x + width, y + height - roundingSize);
        out.curveTo(x + width, y + height, x + width, y + height, x + width - roundingSize, y + height);
        out.lineTo(x + roundingSize, y + height);
        out.curveTo(x, y + height, x, y + height, x, y + height - roundingSize);
        out.lineTo(x, y + roundingSize);
        out.closePath();
        return out;
    }

    public static boolean hasSubpaths(Shape shape) {
        PathIterator iterator = shape.getPathIterator(null);
        while (!iterator.isDone()) {
            int type = iterator.currentSegment(scratch);
            if (type != 0) continue;
            return true;
        }
        return false;
    }

    public static Shape getMaximumOutline(Shape shape) {
        Area out = new Area();
        Iterator it = ShapeUtil.getSubpaths(shape, null).iterator();
        while (it.hasNext()) {
            Shape s = (Shape)it.next();
            out.add(new Area(s));
        }
        return out;
    }

    protected static double calculateLength(Shape shape, double flatness, int limit, double targetLength, Point2D out) {
        FlatteningPathIterator it = new FlatteningPathIterator(shape.getPathIterator(null), flatness, limit);
        double len = 0.0;
        double lastLen = 0.0;
        Point2D.Double lastPoint = new Point2D.Double();
        Point2D.Double endPoint = new Point2D.Double();
        Point2D.Double lastMoveTo = new Point2D.Double();
        double[] coords = new double[6];
        while (!it.isDone()) {
            lastLen = len;
            lastPoint.setLocation(endPoint);
            int op = it.currentSegment(coords);
            if (op == 0) {
                endPoint.setLocation(coords[0], coords[1]);
                lastMoveTo.setLocation(endPoint);
            } else if (op == 1) {
                len += Point2D.distance(endPoint.x, endPoint.y, coords[0], coords[1]);
                endPoint.setLocation(coords[0], coords[1]);
            } else if (op == 4) {
                len += Point2D.distance(endPoint.x, endPoint.y, lastMoveTo.x, lastMoveTo.y);
                endPoint.setLocation(lastMoveTo);
            }
            if (targetLength >= 0.0 && len > targetLength) {
                double currentSegLen = len - lastLen;
                double segRatio = (targetLength - lastLen) / currentSegLen;
                double xpos = lastPoint.x + segRatio * (endPoint.x - lastPoint.x);
                double ypos = lastPoint.y + segRatio * (endPoint.y - lastPoint.y);
                out.setLocation(xpos, ypos);
                return targetLength;
            }
            it.next();
        }
        return len;
    }

    public static Point2D getPointAtRatio(Shape shape, double ratio, double flatness, int limit) {
        double length = ShapeUtil.calculateLength(shape, flatness, limit, -1.0, null);
        Point2D.Double out = new Point2D.Double();
        ShapeUtil.calculateLength(shape, flatness, limit, length * ratio, out);
        return out;
    }

    public static Point2D normalize(Shape shape, GeneralPath out) {
        Rectangle2D b = shape.getBounds2D();
        out.reset();
        out.append(shape.getPathIterator(AffineTransform.getTranslateInstance(-b.getX(), -b.getY())), false);
        return new Point2D.Double(b.getX(), b.getY());
    }

    public static List getSubpaths(Shape shape, List out) {
        if (out == null) {
            out = new LinkedList<Shape>();
        }
        if (!ShapeUtil.hasSubpaths(shape)) {
            out.add(shape);
            return out;
        }
        Path2D currentPath = null;
        PathIterator iterator = shape.getPathIterator(null);
        while (!iterator.isDone()) {
            int type = iterator.currentSegment(scratch);
            if (type == 0) {
                if (currentPath != null) {
                    out.add(currentPath);
                }
                currentPath = new GeneralPath();
                ((Path2D.Float)currentPath).moveTo(scratch[0], scratch[1]);
            } else if (type == 4) {
                currentPath.closePath();
            } else if (type == 3) {
                ((Path2D.Float)currentPath).curveTo(scratch[0], scratch[1], scratch[2], scratch[3], scratch[4], scratch[5]);
            } else if (type == 1) {
                ((Path2D.Float)currentPath).lineTo(scratch[0], scratch[1]);
            } else if (type == 2) {
                ((Path2D.Float)currentPath).quadTo(scratch[0], scratch[1], scratch[2], scratch[3]);
            }
            iterator.next();
        }
        if (currentPath != null) {
            out.add(currentPath);
        }
        return out;
    }

    public static int getArrayUse(int op) {
        if (op == 4) {
            return 0;
        }
        if (op == 3) {
            return 6;
        }
        if (op == 1) {
            return 2;
        }
        if (op == 0) {
            return 2;
        }
        if (op == 2) {
            return 4;
        }
        return 0;
    }
}

