/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.swing;

import java.awt.Component;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class HotkeyedMenuItem
extends JMenuItem {
    private static final long serialVersionUID = 5832023922345037804L;
    protected String hotkeyDesc;

    public HotkeyedMenuItem(String name) {
        super(name);
    }

    public void setAccelerator(String key, String desc) {
        this.hotkeyDesc = desc;
        super.setAccelerator(KeyStroke.getKeyStroke(key));
    }

    public Component getComponent() {
        if (this.hotkeyDesc != null) {
            Box out = Box.createHorizontalBox();
            JLabel hotkeyLabel = new JLabel(this.hotkeyDesc);
            hotkeyLabel.setHorizontalAlignment(2);
            out.add(super.getComponent());
            out.add(Box.createHorizontalGlue());
            out.add(hotkeyLabel);
            return out;
        }
        return super.getComponent();
    }
}

