/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;

public class FileUtil {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static void ensureExists(File file, String resource) throws IOException {
        ClassLoader loader = FileUtil.getSystemClassLoader();
        FileUtil.ensureExists(file, loader, resource);
    }

    public static void ensureExists(File file, ClassLoader loader, String resource) throws IOException {
        if (!file.exists()) {
            if (loader == null) {
                throw new IOException("ClassLoader is null, can't load resource.");
            }
            InputStream is = loader.getResourceAsStream(resource);
            if (is == null) {
                throw new FileNotFoundException("Couldn't find resource " + resource);
            }
            new File(file.getParent()).mkdirs();
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
            int next = is.read();
            while (next != -1) {
                ((OutputStream)os).write(next);
                next = is.read();
            }
            ((OutputStream)os).flush();
            ((OutputStream)os).close();
        }
    }

    public static ClassLoader getSystemClassLoader() {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.ClassLoader");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Method loaderMethod = clazz.getMethod("getSystemClassLoader", new Class[0]);
            Object out = loaderMethod.invoke(null, new Object[0]);
            return (ClassLoader)out;
        }
        catch (Exception e) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.Class");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz.getClassLoader();
        }
    }
}

