/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.expression.parser;

import java.util.HashMap;
import java.util.Map;
import org.geneontology.expression.ExpressionException;
import org.geneontology.expression.FunctionDef;
import org.geneontology.expression.JexlContext;
import org.geneontology.expression.parser.BreakLoopException;
import org.geneontology.expression.parser.ParseException;
import org.geneontology.expression.parser.Parser;
import org.geneontology.expression.parser.ParserVisitor;
import org.geneontology.expression.parser.ReturnValueException;
import org.geneontology.expression.parser.SimpleNode;

public class ASTJexlScript
extends SimpleNode {
    protected Map localFunctions = new HashMap();

    public ASTJexlScript(int id) {
        super(id);
    }

    public void defineLocalFunction(JexlContext context, String name, FunctionDef def) throws Exception {
        this.localFunctions.put(name, def);
        context.setLocalVariable(name, def, false);
    }

    public FunctionDef getFunction(String name, JexlContext context) {
        FunctionDef out = (FunctionDef)this.localFunctions.get(name);
        if (out == null) {
            out = context.getFunction(name);
        }
        return out;
    }

    public ASTJexlScript(Parser p, int id) {
        super(p, id);
    }

    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object value(JexlContext jc) throws ExpressionException {
        int numChildren = this.jjtGetNumChildren();
        Object result = null;
        int i = 0;
        while (i < numChildren) {
            SimpleNode child = (SimpleNode)this.jjtGetChild(i);
            try {
                result = child.value(jc);
            }
            catch (ReturnValueException ex) {
                return ex.getValue();
            }
            catch (BreakLoopException ex) {
                throw new ParseException("Cannot call break outside of a loop");
            }
            catch (ExpressionException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new ExpressionException(ex);
            }
            ++i;
        }
        return result;
    }

    public void jjtClose() {
    }
}

