/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.expression;

import java.util.List;
import org.geneontology.expression.ExpressionException;
import org.geneontology.expression.JexlContext;
import org.geneontology.expression.JexlFunctionDef;
import org.geneontology.expression.parser.BindException;
import org.geneontology.expression.parser.SimpleNode;

public class JexlFunctionDefImpl
implements JexlFunctionDef {
    protected String name;
    protected List varNames;
    protected SimpleNode node;
    protected boolean isExtended;
    protected int lineNum;

    public JexlFunctionDefImpl(String name, SimpleNode node, List varNames, boolean isExtended) {
        this.name = name;
        this.node = node;
        this.varNames = varNames;
        this.isExtended = isExtended;
    }

    public SimpleNode getNode() {
        return this.node;
    }

    public List getVarNames() {
        return this.varNames;
    }

    public boolean isExtendedParam() {
        return this.isExtended;
    }

    public Object execute(JexlContext jc, Object[] params, SimpleNode callNode) throws Exception {
        JexlContext newFrame = jc.createNewFrame();
        if (this.isExtended) {
            try {
                newFrame.setLocalVariable((String)this.getVarNames().get(0), params, true);
            }
            catch (ExpressionException ex) {
                ex.decorateException(this.node);
            }
        } else {
            if (params.length > this.getVarNames().size()) {
                throw new BindException("Too many arguments for function " + this.name, callNode.getLineNum(), callNode.getCharNum());
            }
            int i = 0;
            while (i < this.getVarNames().size()) {
                newFrame.setLocalVariable((String)this.getVarNames().get(i), params[i], true);
                ++i;
            }
        }
        return this.getNode().value(newFrame);
    }
}

