/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.dataadapter;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.geneontology.dataadapter.DataAdapter;
import org.geneontology.dataadapter.DataAdapterRegistry;
import org.geneontology.dataadapter.DataAdapterUI;
import org.geneontology.dataadapter.IOOperation;

public class DataAdapterUtil {
    public static DataAdapterUI getUI(DataAdapter adapter, DataAdapterRegistry registry, Class[] uiClasses) {
        Collection c = registry.getUIFactory().getUIs(adapter);
        Iterator it = c.iterator();
        while (it.hasNext()) {
            DataAdapterUI ui = (DataAdapterUI)it.next();
            boolean match = true;
            int i = 0;
            while (i < uiClasses.length) {
                if (!uiClasses[i].isAssignableFrom(ui.getClass())) {
                    match = false;
                    break;
                }
                ++i;
            }
            if (!match) continue;
            return ui;
        }
        return null;
    }

    public static DataAdapter[] getAdapters(DataAdapterRegistry registry, IOOperation op, Class[] uiClasses) {
        HashSet<DataAdapter> out = new HashSet<DataAdapter>();
        Iterator it = registry.getAdapters().iterator();
        while (it.hasNext()) {
            DataAdapter adapter = (DataAdapter)it.next();
            boolean matched = false;
            IOOperation[] ops = adapter.getSupportedOperations();
            int i = 0;
            while (i < ops.length) {
                if (ops[i].equals(op)) {
                    matched = true;
                    break;
                }
                ++i;
            }
            if (matched && uiClasses != null) {
                Collection uis = registry.getUIFactory().getUIs(adapter);
                Iterator it2 = uis.iterator();
                matched = false;
                while (it2.hasNext()) {
                    DataAdapterUI ui = (DataAdapterUI)it2.next();
                    matched = true;
                    int i2 = 0;
                    while (i2 < uiClasses.length) {
                        if (!uiClasses[i2].isAssignableFrom(ui.getClass())) {
                            matched = false;
                            break;
                        }
                        ++i2;
                    }
                    if (matched) break;
                }
            }
            if (!matched) continue;
            out.add(adapter);
        }
        DataAdapter[] adapters = new DataAdapter[out.size()];
        it = out.iterator();
        int i = 0;
        while (i < adapters.length) {
            adapters[i] = (DataAdapter)it.next();
            ++i;
        }
        return adapters;
    }
}

