/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.commandline;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.geneontology.commandline.ArgumentSignature;
import org.geneontology.commandline.ArgumentValue;
import org.geneontology.commandline.EnumArgumentSignature;
import org.geneontology.commandline.OrderedArgumentSignature;
import org.geneontology.commandline.Tag;
import org.geneontology.commandline.UnfullfilledException;
import org.geneontology.commandline.ValueSpec;

public class TagSpec
extends OrderedArgumentSignature {
    protected EnumArgumentSignature nameSig = new EnumArgumentSignature();
    protected ArgumentSignature signature;
    protected String primaryName;

    protected TagSpec() {
    }

    public TagSpec(String name) {
        this(name, new ValueSpec());
    }

    public TagSpec(String name, ArgumentSignature signature) {
        this.primaryName = name;
        this.signature = signature;
        this.nameSig.addSignature(new ValueSpec(this.primaryName));
        this.addSignature(this.nameSig);
        this.addSignature(signature);
    }

    public String getShortDocumentation() {
        StringBuffer out = new StringBuffer();
        out.append(this.primaryName);
        String trailingDocs = this.signature.getShortDocumentation();
        if (trailingDocs.length() > 0) {
            out.append(" " + trailingDocs);
        }
        return out.toString();
    }

    public String toString() {
        return "TagSpec('" + this.primaryName + "'):" + this.id;
    }

    public void addName(String name) {
        this.nameSig.addSignature(new ValueSpec(name));
    }

    protected OrderedArgumentSignature createCopyObject() {
        return new TagSpec();
    }

    public ArgumentSignature copy() {
        TagSpec out = (TagSpec)super.copy();
        out.primaryName = this.primaryName;
        out.signature = this.signature.copy();
        out.nameSig = (EnumArgumentSignature)this.nameSig.copy();
        return out;
    }

    public List getValues() throws UnfullfilledException {
        Tag out = new Tag(this.primaryName);
        Iterator it = this.signature.getValues().iterator();
        while (it.hasNext()) {
            ArgumentValue av = (ArgumentValue)it.next();
            out.addValue(av);
        }
        return Collections.singletonList(out);
    }
}

