/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.commandline;

import java.util.ArrayList;
import java.util.List;
import org.geneontology.commandline.ArgumentSignature;
import org.geneontology.commandline.EnumArgumentSignature;
import org.geneontology.commandline.FailException;
import org.geneontology.commandline.OrderedArgumentSignature;
import org.geneontology.commandline.TagSpec;
import org.geneontology.commandline.UnfullfilledException;
import org.geneontology.commandline.UnorderedArgumentSignature;
import org.geneontology.commandline.ValueSpec;

public class CommandLineParser
implements Cloneable {
    protected List parseStack = new ArrayList();
    protected List stringList = new ArrayList();
    private boolean backtracking;
    protected List backtrackStack = new ArrayList();
    protected List failFrames = new ArrayList();
    protected static int idgen = 0;

    public static int getID() {
        return idgen++;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception ex) {
            return null;
        }
    }

    private CommandLineParser(List stringList, List parseStack, List failFrames) {
        this.stringList = new ArrayList();
        this.stringList.addAll(stringList);
        this.parseStack = new ArrayList();
        if (parseStack != null) {
            this.parseStack.addAll(parseStack);
        }
        this.failFrames = new ArrayList();
        if (failFrames != null) {
            this.failFrames.addAll(failFrames);
        }
        this.backtracking = false;
    }

    public boolean hasMoreStrings() {
        return this.stringList.size() > 0;
    }

    public String getNextString() throws FailException {
        if (this.hasMoreStrings()) {
            this.failFrames.clear();
            return (String)this.stringList.remove(0);
        }
        throw new FailException("Unexpected end of input!");
    }

    public String peekNextString() {
        if (this.stringList.size() == 0) {
            return null;
        }
        return (String)this.stringList.get(0);
    }

    public void doAccept(ArgumentSignature sig) throws FailException {
        this.doAccept(sig, false);
    }

    public void doAccept(ArgumentSignature sig, boolean defaultMode) throws FailException {
        if (this.failFrames.contains(sig)) {
            throw new FailException("Backtrack halted to prevent infinite loop");
        }
        if (defaultMode && this.backtracking) {
            throw new FailException("Default modes disabled while backtracking.");
        }
        this.parseStack.add(0, sig);
        ArrayList argCopy = new ArrayList();
        argCopy.addAll(this.stringList);
        while (true) {
            try {
                if (sig.onlyAcceptAsLastResort() && this.hasMoreStrings() && this.parseStack.size() > 0) {
                    ArrayList myParseStack = new ArrayList();
                    ArrayList<ArgumentSignature> myBacktrackStack = new ArrayList<ArgumentSignature>();
                    ArrayList<ArgumentSignature> myFailFrames = new ArrayList<ArgumentSignature>();
                    myParseStack.addAll(this.parseStack);
                    myFailFrames.add(sig);
                    myParseStack.remove(0);
                    while (myParseStack.size() > 0) {
                        boolean failed;
                        ArgumentSignature testSig = (ArgumentSignature)myParseStack.remove(0);
                        myBacktrackStack.add(testSig);
                        try {
                            CommandLineParser p = new CommandLineParser(this.stringList, myParseStack, myFailFrames);
                            p.backtracking = true;
                            p.doAccept(testSig.copy());
                            failed = false;
                        }
                        catch (FailException ex) {
                            failed = true;
                        }
                        if (!failed) {
                            throw new FallbackException(testSig, sig);
                        }
                        myFailFrames.add(testSig);
                    }
                }
                sig.accept(this);
                this.parseStack.remove(0);
            }
            catch (FailException ex) {
                this.stringList.clear();
                this.stringList.addAll(argCopy);
                this.parseStack.remove(0);
                throw ex;
            }
            catch (FallbackException ex) {
                if (ex.getTargetFrame() == sig) continue;
                this.parseStack.remove(0);
                throw ex;
            }
            break;
        }
    }

    public static ArgumentSignature getSig1() {
        OrderedArgumentSignature oArgSpec = new OrderedArgumentSignature();
        oArgSpec.addSignature(new ValueSpec());
        TagSpec oSpec = new TagSpec("-o", oArgSpec);
        oSpec.addName("-out");
        OrderedArgumentSignature nameTagSig = new OrderedArgumentSignature();
        nameTagSig.addSignature(new ValueSpec());
        nameTagSig.addSignature(oSpec);
        nameTagSig.addSignature(new ValueSpec());
        OrderedArgumentSignature sig = new OrderedArgumentSignature();
        sig.addSignature(new ValueSpec());
        sig.addSignature(new TagSpec("-name", nameTagSig));
        sig.addSignature(new TagSpec("-v", new OrderedArgumentSignature()));
        sig.addSignature(new ValueSpec());
        return sig;
    }

    public static ArgumentSignature getSig2() {
        EnumArgumentSignature enumsig = new EnumArgumentSignature();
        enumsig.addSignature(new TagSpec("cat", new OrderedArgumentSignature()));
        enumsig.addSignature(new TagSpec("dog", new OrderedArgumentSignature()));
        TagSpec animalTag = new TagSpec("-animal", enumsig);
        EnumArgumentSignature animaltags2 = new EnumArgumentSignature();
        animaltags2.addSignature(new ValueSpec("monkey"));
        animaltags2.addSignature(new ValueSpec("walrus"));
        TagSpec animalTag2 = new TagSpec("-animal", animaltags2);
        EnumArgumentSignature sig = new EnumArgumentSignature();
        sig.addSignature(animalTag);
        sig.addSignature(animalTag2);
        UnorderedArgumentSignature sig2 = new UnorderedArgumentSignature();
        sig2.addSignature(sig, 0, 2);
        return sig2;
    }

    public static ArgumentSignature getSig3() {
        TagSpec vTag = new TagSpec("-v", new OrderedArgumentSignature());
        TagSpec qTag = new TagSpec("-q", new OrderedArgumentSignature());
        UnorderedArgumentSignature longList = new UnorderedArgumentSignature();
        longList.addSignature(new ValueSpec(), 1, Integer.MAX_VALUE);
        OrderedArgumentSignature finiteList = new OrderedArgumentSignature();
        finiteList.addSignature(new ValueSpec());
        finiteList.addSignature(new ValueSpec());
        finiteList.addSignature(new ValueSpec());
        TagSpec mainTag = new TagSpec("-f", longList);
        TagSpec f2Tag = new TagSpec("-f2", finiteList.copy());
        UnorderedArgumentSignature mainList = new UnorderedArgumentSignature();
        mainList.addSignature(vTag, 0, Integer.MAX_VALUE);
        mainList.addSignature(qTag, 0, Integer.MAX_VALUE);
        mainList.addSignature(mainTag, 0, 1);
        mainList.addSignature(f2Tag, 0, Integer.MAX_VALUE);
        return mainList;
    }

    public static ArgumentSignature getSig4() {
        UnorderedArgumentSignature longList = new UnorderedArgumentSignature();
        longList.addSignature(new ValueSpec(".*\\..*", true), 1, Integer.MAX_VALUE);
        UnorderedArgumentSignature oneOrZero = new UnorderedArgumentSignature();
        oneOrZero.addSignature(new ValueSpec(".*\\..*", true), 0, 1);
        UnorderedArgumentSignature flatOptions = new UnorderedArgumentSignature("flat file adapter settings");
        flatOptions.addSignature(new TagSpec("-dangling", new OrderedArgumentSignature()), 0, 1);
        flatOptions.addSignature(new TagSpec("-f", longList), 1, 2);
        EnumArgumentSignature adapterNames = new EnumArgumentSignature();
        adapterNames.addSignature(new TagSpec("FLAT", flatOptions), true);
        adapterNames.addSignature(new TagSpec("OBO", new OrderedArgumentSignature()));
        adapterNames.addSignature(new TagSpec("SERIAL", new OrderedArgumentSignature()));
        TagSpec loadTag = new TagSpec("-load", adapterNames);
        UnorderedArgumentSignature main = new UnorderedArgumentSignature();
        main.addSignature(loadTag, 0, 1, true);
        return main;
    }

    public static void main(String[] args) throws Exception {
        ArgumentSignature sig;
        boolean foundIndicator = false;
        if (args[0].equals("1")) {
            sig = CommandLineParser.getSig1();
            foundIndicator = true;
        } else if (args[0].equals("2")) {
            sig = CommandLineParser.getSig2();
            foundIndicator = true;
        } else if (args[0].equals("3")) {
            sig = CommandLineParser.getSig3();
            foundIndicator = true;
        } else if (args[0].equals("4")) {
            sig = CommandLineParser.getSig4();
            foundIndicator = true;
        } else {
            sig = CommandLineParser.getSig4();
        }
        ArrayList<String> argList = new ArrayList<String>();
        int i = foundIndicator ? 1 : 0;
        while (i < args.length) {
            argList.add(args[i]);
            ++i;
        }
    }

    public static String getUsageString(ArgumentSignature as) {
        return as.getShortDocumentation();
    }

    public static List parse(ArgumentSignature as, String[] args) throws UnfullfilledException, FailException {
        ArrayList<String> argList = new ArrayList<String>();
        int i = 0;
        while (i < args.length) {
            argList.add(args[i]);
            ++i;
        }
        return CommandLineParser.parse(as, argList);
    }

    public static List parse(ArgumentSignature as, List args) throws UnfullfilledException, FailException {
        CommandLineParser p = new CommandLineParser(args, null, null);
        p.doAccept(as);
        if (p.hasMoreStrings()) {
            throw new FailException("Unexpected values " + p.stringList + " found");
        }
        return as.getValues();
    }

    protected class FallbackException
    extends RuntimeException {
        private static final long serialVersionUID = -3585860541324273480L;
        ArgumentSignature targetFrame;
        ArgumentSignature initiatorFrame;

        public FallbackException(ArgumentSignature targetFrame, ArgumentSignature initiatorFrame) {
            this.targetFrame = targetFrame;
            this.initiatorFrame = initiatorFrame;
        }

        public ArgumentSignature getInitiatorFrame() {
            return this.initiatorFrame;
        }

        public ArgumentSignature getTargetFrame() {
            return this.targetFrame;
        }
    }
}

