/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.tools.ontology_manager.impl.local;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.tools.ontology_manager.impl.local.Ontology;
import psidev.psi.tools.ontology_manager.interfaces.OntologyTermI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OntologyImpl
implements Ontology {
    public static final Log log = LogFactory.getLog(OntologyImpl.class);
    private Collection<OntologyTermI> ontologyTerms = new ArrayList<OntologyTermI>(1024);
    private final Map<OntologyTermI, Set<OntologyTermI>> parents = new HashMap<OntologyTermI, Set<OntologyTermI>>();
    private final Map<OntologyTermI, Set<OntologyTermI>> children = new HashMap<OntologyTermI, Set<OntologyTermI>>();
    private Map<String, OntologyTermI> id2ontologyTerm = new HashMap<String, OntologyTermI>(1024);
    private Collection<OntologyTermI> roots = null;
    private Collection<OntologyTermI> obsoleteTerms = new ArrayList<OntologyTermI>();

    public void addTerm(OntologyTermI term) {
        this.ontologyTerms.add(term);
        String id = term.getTermAccession();
        if (this.id2ontologyTerm.containsKey(id)) {
            OntologyTermI old = this.id2ontologyTerm.get(id);
            if (log.isWarnEnabled()) {
                log.error((Object)("WARNING: 2 Objects have the same ID (" + id + "), the old one is being replaced. old: " + old.getPreferredName() + " new: " + term.getPreferredName()));
            }
        }
        this.id2ontologyTerm.put(id, term);
        this.flushRootsCache();
    }

    public void addLink(String parentId, String childId) {
        OntologyTermI child = this.id2ontologyTerm.get(childId);
        OntologyTermI parent = this.id2ontologyTerm.get(parentId);
        if (child == null) {
            throw new NullPointerException("You must give a non null child");
        }
        if (parent == null) {
            throw new NullPointerException("You must give a non null parent");
        }
        if (!this.children.containsKey(parent)) {
            this.children.put(parent, new HashSet());
        }
        if (!this.parents.containsKey(child)) {
            this.parents.put(child, new HashSet());
        }
        this.children.get(parent).add(child);
        this.parents.get(child).add(parent);
        this.flushRootsCache();
    }

    private void flushRootsCache() {
        if (this.roots != null) {
            this.roots.clear();
            this.roots = null;
        }
    }

    @Override
    public boolean hasTerms() {
        return this.ontologyTerms.isEmpty();
    }

    @Override
    public OntologyTermI search(String id) {
        return this.id2ontologyTerm.get(id);
    }

    public boolean hasParent(OntologyTermI term) {
        return this.parents.containsKey(term);
    }

    @Override
    public Collection<OntologyTermI> getRoots() {
        if (this.roots != null) {
            return this.roots;
        }
        this.roots = new HashSet<OntologyTermI>();
        for (OntologyTermI ontologyTerm : this.ontologyTerms) {
            if (this.hasParent(ontologyTerm)) continue;
            this.roots.add(ontologyTerm);
        }
        if (this.roots.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return this.roots;
    }

    @Override
    public Collection<OntologyTermI> getOntologyTerms() {
        return Collections.unmodifiableCollection(this.ontologyTerms);
    }

    public void addObsoleteTerm(OntologyTermI term) {
        if (term == null) {
            throw new IllegalArgumentException("You must give a non null term");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding obsolete term: " + term.getTermAccession() + " " + term.getPreferredName()));
        }
        this.obsoleteTerms.add(term);
    }

    @Override
    public boolean isObsoleteTerm(OntologyTermI term) {
        return this.obsoleteTerms.contains(term);
    }

    @Override
    public Collection<OntologyTermI> getObsoleteTerms() {
        return Collections.unmodifiableCollection(this.obsoleteTerms);
    }

    @Override
    public Set<OntologyTermI> getDirectParents(OntologyTermI term) {
        Set<OntologyTermI> directParents = this.parents.get(term);
        if (directParents == null) {
            return Collections.EMPTY_SET;
        }
        return directParents;
    }

    @Override
    public Set<OntologyTermI> getDirectChildren(OntologyTermI term) {
        Set<OntologyTermI> directChildren = this.children.get(term);
        if (directChildren == null) {
            return Collections.EMPTY_SET;
        }
        return directChildren;
    }

    @Override
    public Set<OntologyTermI> getAllParents(OntologyTermI term) {
        HashSet<OntologyTermI> parents = new HashSet<OntologyTermI>();
        this.getAllParents(term, parents);
        return parents;
    }

    private void getAllParents(OntologyTermI term, Set<OntologyTermI> parents) {
        Set<OntologyTermI> directParents = this.getDirectParents(term);
        parents.addAll(directParents);
        for (OntologyTermI parent : directParents) {
            this.getAllParents(parent, parents);
        }
    }

    @Override
    public Set<OntologyTermI> getAllChildren(OntologyTermI term) {
        HashSet<OntologyTermI> children = new HashSet<OntologyTermI>();
        this.getAllChildren(term, children);
        return children;
    }

    private void getAllChildren(OntologyTermI term, Set<OntologyTermI> children) {
        Set<OntologyTermI> directChildren = this.getDirectChildren(term);
        children.addAll(directChildren);
        for (OntologyTermI child : directChildren) {
            this.getAllChildren(child, children);
        }
    }

    public void print() {
        log.info((Object)(this.ontologyTerms.size() + " terms to display."));
        Collection<OntologyTermI> roots = this.getRoots();
        if (log.isDebugEnabled()) {
            log.info((Object)(this.roots.size() + " root(s) found."));
        }
        for (OntologyTermI root : roots) {
            this.print(root);
        }
    }

    private void print(OntologyTermI term, String indent) {
        log.info((Object)(indent + term.getTermAccession() + "   " + term.getPreferredName()));
        for (OntologyTermI child : this.getDirectChildren(term)) {
            this.print(child, indent + "  ");
        }
    }

    public void print(OntologyTermI term) {
        this.print(term, "");
    }
}

